/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core;

import com.ericsson.cms.sites.core.IDistTemplateUpgrade;
import com.ericsson.cms.sites.distribution.DistributionManager;
import com.ericsson.cms.sites.distribution.jaxb.DistributionTemplates;
import com.ericsson.cms.sites.distribution.upgrade.TemplateUpgradeDBManager;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.DependsOn;
import javax.ejb.Singleton;
import org.apache.log4j.Logger;

@Singleton(name="Sites:service=com.ericsson.cms.sites.IDistTemplateUpgrade")
@DependsOn(value={"ContentManagement:service=com.tandbergtv.cms.contentmgmt.activation.IServiceActivator"})
public class DistTemplateUpgrade
implements IDistTemplateUpgrade {
    private static final Logger logger = Logger.getLogger(DistTemplateUpgrade.class);

    @Override
    @PostConstruct
    public void start() {
        logger.info((Object)"Starting distribution template upgrade process");
        DistributionManager manager = DistributionManager.getInstance();
        List<DistributionTemplates.DistributionTemplate> templateList = manager.readTemplateConfigurations();
        if (templateList != null) {
            for (DistributionTemplates.DistributionTemplate templateInfo : templateList) {
                String templateName = templateInfo.getTemplateName();
                String groupName = templateInfo.getAssociatedResourceGroupName();
                TemplateUpgradeDBManager dbManager = new TemplateUpgradeDBManager();
                dbManager.createDistirbutionAnnotation(templateName, groupName);
            }
        }
        manager.deleteConfigFile();
    }

    @Override
    @PreDestroy
    public void stop() {
    }
}

