/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core;

import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.sites.core.DistributionRetry;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.core.entities.DistributionStatusDetail;
import com.ericsson.cms.sites.core.entities.TrackingSite;
import com.ericsson.cms.sites.core.entities.TrackingSiteTitle;
import com.ericsson.cms.sites.core.entities.TrackingStatus;
import com.ericsson.cms.sites.core.proxy.DistributionSiteTitleProxy;
import com.ericsson.cms.sites.core.proxy.TrackingSiteTitleProxy;
import com.ericsson.cms.sites.util.SitesConfigurationUtil;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.hazelcast.core.HazelcastInstance;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;

public class DistTimeoutManager
implements Serializable {
    private static final long serialVersionUID = 7005953599128236728L;
    private static final Logger logger = Logger.getLogger(DistTimeoutManager.class);
    private static DistTimeoutManager _instance;
    private Timer timer;
    private Map<DistributionSiteTitleProxy, TimerTask> distributionTimerTaskMap = Collections.synchronizedMap(new HashMap());
    private Map<TrackingSiteTitleProxy, TimerTask> trackingTimerTaskMap = Collections.synchronizedMap(new HashMap());
    private HazelcastInstance haz;
    private IClusterService hzcs;
    private Map<DistributionSiteTitleProxy, String> distributionSiteTitleMapHaz;
    private Map<TrackingSiteTitleProxy, String> trackingSiteTitleMapHaz;

    private DistTimeoutManager() {
        this.timer = new Timer();
        this.hzcs = Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH);
        this.haz = this.hzcs.getInstance();
        this.distributionSiteTitleMapHaz = this.haz.getMap("distributionSiteTitleMapHaz");
        this.trackingSiteTitleMapHaz = this.haz.getMap("dsttrackingSiteTitleMapHaz");
    }

    public static synchronized DistTimeoutManager getInstance() {
        if (_instance == null) {
            _instance = new DistTimeoutManager();
        }
        return _instance;
    }

    public synchronized void cancelTimer(DistributionSiteTitle distributionSiteTitle) {
        DistributionSiteTitleProxy distributionSiteTitleProxy = new DistributionSiteTitleProxy(distributionSiteTitle);
        TimerTask task = this.distributionTimerTaskMap.get(distributionSiteTitleProxy);
        if (task != null) {
            task.cancel();
        }
        logger.debug((Object)("Removing Timer Task for Distribution Site Title Id: " + distributionSiteTitleProxy.getTitleId()));
        this.distributionTimerTaskMap.remove(distributionSiteTitleProxy);
        this.distributionSiteTitleMapHaz.remove(distributionSiteTitleProxy);
    }

    public synchronized void cancelTimer(TrackingSiteTitle trackingSiteTitle) {
        TrackingSiteTitleProxy trackingSiteTitleProxy = new TrackingSiteTitleProxy(trackingSiteTitle);
        TimerTask task = this.trackingTimerTaskMap.get(trackingSiteTitleProxy);
        if (task != null) {
            task.cancel();
        }
        logger.debug((Object)("Removing Timer Task for Tracking Site Title Id: " + trackingSiteTitleProxy.getTitleId()));
        this.trackingTimerTaskMap.remove(trackingSiteTitleProxy);
        this.trackingSiteTitleMapHaz.remove(trackingSiteTitleProxy);
    }

    public synchronized void rescheduleDistributionSiteTitles(String failedAddress) {
        if (this.distributionSiteTitleMapHaz != null) {
            for (Map.Entry<DistributionSiteTitleProxy, String> entry : this.distributionSiteTitleMapHaz.entrySet()) {
                String address = entry.getValue();
                if (!failedAddress.equalsIgnoreCase(address)) continue;
                DistributionSiteTitle distributionSiteTitle = this.getSiteManager().getDistributionSiteTitle(entry.getKey().getTitleId());
                DistributionSite distributionSite = (DistributionSite)this.getSiteManager().getSite(entry.getKey().getSiteId());
                distributionSiteTitle.setDistributionSite(distributionSite);
                if (distributionSiteTitle.getStatus() == DistributionStatus.WAITING_FOR_DEPENDENCY) {
                    this.scheduleTimer(distributionSiteTitle, SitesConfigurationUtil.getDistributionDependencyTimeOut());
                    continue;
                }
                this.scheduleTimer(distributionSiteTitle, (int)distributionSite.getAlertDelayPeriod());
            }
        }
    }

    public synchronized void rescheduleTrackingSiteTitles(String failedAddress) {
        if (this.trackingSiteTitleMapHaz != null) {
            for (Map.Entry<TrackingSiteTitleProxy, String> entry : this.trackingSiteTitleMapHaz.entrySet()) {
                String address = entry.getValue();
                if (!failedAddress.equalsIgnoreCase(address)) continue;
                TrackingSiteTitle trackingSiteTitle = this.getSiteManager().getTrackingSiteTitle(entry.getKey().getTitleId(), entry.getKey().getSiteId());
                TrackingSite trackingSite = (TrackingSite)this.getSiteManager().getSite(entry.getKey().getSiteId());
                trackingSiteTitle.setTrackingSite(trackingSite);
                this.scheduleTimer(trackingSiteTitle, (int)trackingSite.getAlertDelayPeriod());
            }
        }
    }

    public synchronized void scheduleTimer(final DistributionSiteTitle distributionSiteTitle, int timeoutMinutes) {
        final DistributionSiteTitleProxy distributionSiteTitleProxy = new DistributionSiteTitleProxy(distributionSiteTitle);
        TimerTask task = this.distributionTimerTaskMap.get(distributionSiteTitleProxy);
        if (task != null) {
            task.cancel();
        }
        task = new TimerTask(){

            @Override
            public void run() {
                String hostAddress = (String)DistTimeoutManager.this.distributionSiteTitleMapHaz.get(distributionSiteTitleProxy);
                if (hostAddress != null && hostAddress.equals(DistTimeoutManager.this.getLocalHostAddress())) {
                    TransactionManager transactionManager = null;
                    try {
                        transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
                        transactionManager.begin();
                        DistTimeoutManager.this.updateDistributionSiteTitleForExpiredTimer(distributionSiteTitleProxy);
                        transactionManager.commit();
                    }
                    catch (Throwable t) {
                        logger.error((Object)("Unable to set the status for Distribution Status Title: " + distributionSiteTitle.getTitle().getId() + " to: " + DistributionStatus.FAILED), t);
                        try {
                            transactionManager.rollback();
                        }
                        catch (Exception e1) {
                            logger.error((Object)"Could not rollback transaction: ", (Throwable)e1);
                        }
                    }
                }
            }
        };
        this.distributionTimerTaskMap.put(distributionSiteTitleProxy, task);
        this.distributionSiteTitleMapHaz.put(distributionSiteTitleProxy, this.getLocalHostAddress());
        this.timer.schedule(task, (long)(timeoutMinutes * 60) * 1000L);
        logger.info((Object)("Scheduling timer for distribution site title : " + distributionSiteTitle.getTitle().getId() + " on server: " + this.getLocalHostAddress()));
    }

    public synchronized void scheduleTimer(final TrackingSiteTitle trackingSiteTitle, int timeoutMinutes) {
        final TrackingSiteTitleProxy trackingSiteTitleProxy = new TrackingSiteTitleProxy(trackingSiteTitle);
        TimerTask task = this.trackingTimerTaskMap.get(trackingSiteTitleProxy);
        if (task != null) {
            task.cancel();
        }
        task = new TimerTask(){

            @Override
            public void run() {
                String hostAddress = (String)DistTimeoutManager.this.trackingSiteTitleMapHaz.get(trackingSiteTitleProxy);
                if (hostAddress != null && hostAddress.equals(DistTimeoutManager.this.getLocalHostAddress())) {
                    TransactionManager transactionManager = null;
                    try {
                        transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
                        transactionManager.begin();
                        DistTimeoutManager.this.updateTrackingSiteTitleForExpiredTimer(trackingSiteTitleProxy);
                        transactionManager.commit();
                    }
                    catch (Throwable t) {
                        logger.error((Object)("Unable to set the Tracking Status for title: " + trackingSiteTitle.getTitle().getId() + " in tracking site: " + trackingSiteTitle.getTrackingSite().getId() + " to: " + TrackingStatus.DEPLOYMENT_FAILED), t);
                        try {
                            transactionManager.rollback();
                        }
                        catch (Exception e1) {
                            logger.error((Object)"Could not rollback transaction: ", (Throwable)e1);
                        }
                    }
                }
            }
        };
        this.trackingTimerTaskMap.put(trackingSiteTitleProxy, task);
        this.trackingSiteTitleMapHaz.put(trackingSiteTitleProxy, this.getLocalHostAddress());
        this.timer.schedule(task, (long)(timeoutMinutes * 60) * 1000L);
        logger.info((Object)("Scheduling timer for tracking site title : " + trackingSiteTitle.getTitle().getId() + " on server: " + this.getLocalHostAddress()));
    }

    private String getLocalHostAddress() {
        InetSocketAddress address = this.haz.getCluster().getLocalMember().getInetSocketAddress();
        return address.getAddress().getHostAddress();
    }

    private ISiteManager getSiteManager() {
        return (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
    }

    private void updateDistributionSiteTitleForExpiredTimer(DistributionSiteTitleProxy distributionSiteTitleProxy) {
        this.distributionTimerTaskMap.remove(distributionSiteTitleProxy);
        this.distributionSiteTitleMapHaz.remove(distributionSiteTitleProxy);
        ISiteManager siteManager = this.getSiteManager();
        DistributionSiteTitle distributionSiteTitle = siteManager.getDistributionSiteTitle(distributionSiteTitleProxy.getTitleId());
        if (distributionSiteTitle == null) {
            logger.debug((Object)("Unable to set the Distribution Status | Reason: No DistributionStatusTitle found with id: " + distributionSiteTitleProxy.getTitleId()));
        } else if (distributionSiteTitle.getStatus() != DistributionStatus.IN_PROGRESS && distributionSiteTitle.getStatus() != DistributionStatus.WAITING_FOR_DEPENDENCY) {
            logger.debug((Object)("Not setting the Distribution Status for title: " + distributionSiteTitle.getTitle().getId() + " in distribution site: " + distributionSiteTitle.getDistributionSite().getId() + " to: " + DistributionStatus.FAILED + " | Reason: It is in status: " + distributionSiteTitle.getStatus()));
        } else {
            if (distributionSiteTitle.getStatus() == DistributionStatus.WAITING_FOR_DEPENDENCY) {
                distributionSiteTitle.setStatusDetail(DistributionStatusDetail.DEPENDENCY_TIMEOUT.ordinal());
            } else {
                distributionSiteTitle.setStatusDetail(DistributionStatusDetail.DISTRIBUTION_TIMEOUT.ordinal());
            }
            DistributionRetry.getInstance().removeSiteTitleAttempts(distributionSiteTitle.getTitle().getId());
            siteManager.updateDistributionStatus(distributionSiteTitle.getTitle().getId().longValue(), DistributionStatus.FAILED);
        }
    }

    private void updateTrackingSiteTitleForExpiredTimer(TrackingSiteTitleProxy trackingSiteTitleProxy) {
        this.trackingTimerTaskMap.remove(trackingSiteTitleProxy);
        this.trackingSiteTitleMapHaz.remove(trackingSiteTitleProxy);
        ISiteManager siteManager = this.getSiteManager();
        TrackingSiteTitle trackingSiteTitle = siteManager.getTrackingSiteTitle(trackingSiteTitleProxy.getTitleId(), trackingSiteTitleProxy.getSiteId());
        if (trackingSiteTitle == null) {
            logger.debug((Object)("Unable to set the Tracking Status | Reason: No TrackingStatusTitle found for titleId: " + trackingSiteTitleProxy.getTitleId() + " and trackingSiteId: " + trackingSiteTitleProxy.getSiteId()));
        } else if (trackingSiteTitle.getStatus() != TrackingStatus.DEPLOYMENT_IN_PROGRESS) {
            logger.debug((Object)("Not setting the Tracking Status for title: " + trackingSiteTitle.getTitle().getId() + " in tracking site: " + trackingSiteTitle.getTrackingSite().getId() + " to: " + TrackingStatus.DEPLOYMENT_FAILED + " | Reason: It is in status: " + trackingSiteTitle.getStatus()));
        } else {
            siteManager.updateTrackingStatus(trackingSiteTitle.getTrackingSite().getId().intValue(), trackingSiteTitle.getTitle().getId().longValue(), TrackingStatus.DEPLOYMENT_FAILED);
        }
    }
}

