/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core;

import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.sites.core.IDistTimeoutManagerInitService;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import org.apache.log4j.Logger;

@Singleton(name="Sites:service=com.ericsson.cms.sites.IDistTimeoutManagerInitService")
@DependsOn(value={"ContentManagement:service=com.tandbergtv.cms.contentmgmt.activation.IServiceActivator"})
@Startup
public class DistTimeoutManagerInitService
implements IDistTimeoutManagerInitService {
    private static final Logger logger = Logger.getLogger(DistTimeoutManagerInitService.class);
    @EJB
    private ISiteManager siteManager;
    private IClusterService hzcs = Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH);
    private HazelcastInstance haz = this.hzcs.getInstance();

    @Override
    @PostConstruct
    public void start() {
        if (this.hzcs.isMaster()) {
            try {
                IMap dstSiteTitleMapHaz = this.haz.getMap("dstSiteTitleMapHaz");
                if (dstSiteTitleMapHaz == null || dstSiteTitleMapHaz.isEmpty()) {
                    logger.info((Object)"Crash Recovery: Setting all IN-PROGRESS titles to FAILED");
                    this.siteManager.updateTitlesStatusFromInProgressToFailed();
                    logger.info((Object)"Crash Recovery: Restart all distribution dependency Timeout for WAITNG FOR DEPENDENCY titles");
                    this.siteManager.restartTimerForWaitingForDependencyTitles();
                }
            }
            catch (Exception exception) {
                logger.error((Object)"Failed to crash recover the Distribution Timeout Manager");
            }
        }
    }

    @Override
    @PreDestroy
    public void stop() {
    }
}

