/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core;

import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.sites.core.DistTimeoutManager;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.SSLRestClient;
import com.ericsson.cms.sites.core.entities.ActionOnFailureOption;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.core.entities.DistributionStatusDetail;
import com.ericsson.cms.sites.util.RandomBackOff;
import com.ericsson.cms.sites.util.ServicesManager;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class DistributionRetry {
    HazelcastInstance haz;
    IClusterService hzcs = Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH);
    private static final Logger logger = Logger.getLogger(DistributionRetry.class);
    private static final String DST_SITE_TITLE_ATTEMPTS_MAP_HAZ = "dstSiteTitleAttemptsMapHaz";
    private static final String PROCESS_POST_PREFIX = "/workflow/process/";
    private static final String RETRY_ACTION = "Retry";
    private static DistributionRetry instance;
    private Map<Long, Integer> dstSiteTitleAttemptsMapHaz;
    ScheduledExecutorService service;

    private DistributionRetry() {
        this.haz = this.hzcs.getInstance();
        this.dstSiteTitleAttemptsMapHaz = this.haz.getMap(DST_SITE_TITLE_ATTEMPTS_MAP_HAZ);
        this.service = Executors.newSingleThreadScheduledExecutor();
    }

    public static synchronized DistributionRetry getInstance() {
        if (instance == null) {
            instance = new DistributionRetry();
        }
        return instance;
    }

    public void executeActionOnFailure(DistributionSiteTitle siteTitle, Long workOrderId) {
        if (this.timedOut(siteTitle)) {
            return;
        }
        Integer maxAttempts = siteTitle.getDistributionSite().getRetryAttempt();
        if (maxAttempts == null || maxAttempts == 0) {
            return;
        }
        ActionOnFailureOption actionOnFailure = siteTitle.getDistributionSite().getActionOnFailure();
        if (actionOnFailure == null) {
            return;
        }
        int actionOnFailureWatingTime = siteTitle.getDistributionSite().getRetryWaitTime();
        Long siteTitleId = siteTitle.getTitle().getId();
        if (actionOnFailure == ActionOnFailureOption.RETRY) {
            ILock lock = this.haz.getLock(siteTitleId.toString());
            try {
                lock.lock();
                this.doRetry(maxAttempts, actionOnFailureWatingTime, siteTitle, workOrderId);
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void updateStatus(DistributionSiteTitle siteTitle) {
        if (siteTitle.getStatus() == DistributionStatus.FAILED) {
            siteTitle.setStatus(DistributionStatus.IN_PROGRESS);
            ISiteManager siteManager = ServicesManager.getSiteManager();
            if (siteManager != null) {
                try {
                    siteManager.updateDistributionStatus(siteTitle, DistributionStatus.IN_PROGRESS);
                }
                catch (Exception ex) {
                    logger.error((Object)("Failed to update Distribution Status for SiteTitleId :" + siteTitle.getTitle().getId()), (Throwable)ex);
                }
            }
        }
    }

    private boolean timedOut(DistributionSiteTitle siteTitle) {
        return siteTitle.getStatusDetail() == DistributionStatusDetail.DEPENDENCY_TIMEOUT.ordinal() || siteTitle.getStatusDetail() == DistributionStatusDetail.DISTRIBUTION_TIMEOUT.ordinal();
    }

    private void doRetry(int maxAttempts, int actionOnFailureWatingTime, DistributionSiteTitle siteTitle, final Long workOrderId) {
        final Long siteTitleId = siteTitle.getTitle().getId();
        int currentAttempts = this.getSiteTitleAttempts(siteTitleId);
        final int actualAttempts = currentAttempts + 1;
        int randomBackOffWaitingTime = RandomBackOff.getWaitTimeInSeconds(actualAttempts, actionOnFailureWatingTime);
        int alertDelayPeriod = siteTitle.getDistributionSite().getAlertDelayPeriod();
        if (currentAttempts < maxAttempts) {
            this.updateStatus(siteTitle);
            DistTimeoutManager.getInstance().scheduleTimer(siteTitle, alertDelayPeriod);
            Runnable notifyWorkFlow = new Runnable(){

                @Override
                public void run() {
                    int responseCode = 0;
                    try {
                        responseCode = DistributionRetry.this.sendProcessAction(workOrderId.toString(), DistributionRetry.RETRY_ACTION);
                        logger.info((Object)("Retrying workOrderId: " + workOrderId + " for siteTitleId: " + siteTitleId + " currentAttempts: " + actualAttempts + " responseCode: " + responseCode));
                    }
                    catch (Exception e) {
                        logger.error((Object)("Retry failed for workOrderId: " + workOrderId + " for siteTitleId: " + siteTitleId + " currentAttempts: " + actualAttempts + " responseCode: " + responseCode), (Throwable)e);
                    }
                }
            };
            this.service.schedule(notifyWorkFlow, (long)randomBackOffWaitingTime, TimeUnit.SECONDS);
            this.incrementSiteTitleAttempts(siteTitleId);
        } else {
            logger.info((Object)("We have retried all the attempts & will not retry anymore for this workOrderId: " + workOrderId + " for siteTitleId: " + siteTitleId + " currentAttempts: " + actualAttempts));
            this.removeSiteTitleAttempts(siteTitleId);
        }
    }

    public int getSiteTitleAttempts(Long siteTitleId) {
        this.dstSiteTitleAttemptsMapHaz = this.haz.getMap(DST_SITE_TITLE_ATTEMPTS_MAP_HAZ);
        if (this.dstSiteTitleAttemptsMapHaz.containsKey(siteTitleId)) {
            return this.dstSiteTitleAttemptsMapHaz.get(siteTitleId);
        }
        return 0;
    }

    public void incrementSiteTitleAttempts(Long siteTitleId) {
        this.dstSiteTitleAttemptsMapHaz = this.haz.getMap(DST_SITE_TITLE_ATTEMPTS_MAP_HAZ);
        int currentAttempts = 0;
        if (this.dstSiteTitleAttemptsMapHaz.containsKey(siteTitleId)) {
            currentAttempts = this.dstSiteTitleAttemptsMapHaz.get(siteTitleId);
        }
        this.dstSiteTitleAttemptsMapHaz.put(siteTitleId, currentAttempts + 1);
    }

    public void removeSiteTitleAttempts(Long siteTitleId) {
        this.dstSiteTitleAttemptsMapHaz = this.haz.getMap(DST_SITE_TITLE_ATTEMPTS_MAP_HAZ);
        if (this.dstSiteTitleAttemptsMapHaz.containsKey(siteTitleId)) {
            this.dstSiteTitleAttemptsMapHaz.remove(siteTitleId);
        }
    }

    private int sendProcessAction(String workOrderId, String action) throws Exception {
        String urlStr = PROCESS_POST_PREFIX + workOrderId;
        String body = "{\"operation\" : \"" + action + "\"}";
        String contentType = "application/json";
        SSLRestClient rc = new SSLRestClient();
        rc.getResponse(urlStr, "POST", contentType, body);
        return rc.getResponseCode();
    }
}

