/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;

public class SSLRestClient {
    private static String baseURL = "https://app:7443";
    private static SSLSocketFactory socketFactory = null;
    private static final String SECURITY_DIR = "/var/lib/nobody";
    private static final String KEYSTORE_FILE = "/var/lib/nobody/client_auth_keystore.jks";
    private static final String TRUSTSTORE_FILE = "/var/lib/nobody/cms_truststore.jks";
    private static final String KEYSTORE_PASSWORD_FILE = "/var/lib/nobody/keystore.pass";
    private static final String TRUST_INSTANCE_SUN_X509 = "SunX509";
    private static final String SSL_INSTANCE_TLS = "TLS";
    private static final String STORE_FORMAT_JKS = "JKS";
    private int responseCode;
    private String password = "";
    private static final Logger logger = Logger.getLogger(SSLRestClient.class);

    public SSLRestClient() throws Exception {
        if (socketFactory == null) {
            socketFactory = this.createSocketFactory();
        }
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public static String getBaseURL() {
        return baseURL;
    }

    public static void setBaseURL(String baseURL) {
        SSLRestClient.baseURL = baseURL;
    }

    public String getResponse(String urlStr, String requestType, String contentType, String requestBody) throws IOException {
        URL url = new URL(String.valueOf(baseURL) + urlStr);
        HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
        con.setDoOutput(true);
        con.setSSLSocketFactory(socketFactory);
        if (requestType != null) {
            con.setRequestMethod(requestType);
        }
        if (contentType != null) {
            con.setRequestProperty("Content-Type", contentType);
        }
        if (requestType.equals("POST") || requestType.equals("PUT")) {
            int bytesRead;
            ByteArrayInputStream is = new ByteArrayInputStream(requestBody.getBytes());
            OutputStream output = con.getOutputStream();
            byte[] buffer = new byte[4096];
            while ((bytesRead = is.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
            output.flush();
            ((InputStream)is).close();
        }
        StringBuilder sb = new StringBuilder();
        InputStream is = null;
        try {
            is = con.getInputStream();
        }
        catch (IOException iOException) {
            return String.valueOf(con.getResponseCode());
        }
        this.responseCode = con.getResponseCode();
        if (is != null) {
            String line;
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            while ((line = rd.readLine()) != null) {
                sb.append(line);
            }
        }
        return sb.toString();
    }

    private SSLSocketFactory createSocketFactory() throws Exception {
        KeyManagerFactory kmf = this.createKeyManagerFactory(STORE_FORMAT_JKS, KEYSTORE_FILE, this.getKeystorePassword());
        TrustManagerFactory tmf = this.createTrustManagerFactory(STORE_FORMAT_JKS, TRUSTSTORE_FILE, this.getKeystorePassword());
        SSLContext context = SSLContext.getInstance(SSL_INSTANCE_TLS);
        context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
        return context.getSocketFactory();
    }

    private TrustManagerFactory createTrustManagerFactory(String storeFormat, String filePath, String password) throws Exception {
        KeyStore keyStore = this.loadKeyStore(storeFormat, filePath, password);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TRUST_INSTANCE_SUN_X509);
        trustManagerFactory.init(keyStore);
        return trustManagerFactory;
    }

    private String getKeystorePassword() {
        if (this.password.isEmpty()) {
            try {
                this.password = new Scanner(new File(KEYSTORE_PASSWORD_FILE)).useDelimiter("\\Z").next().trim();
            }
            catch (IOException iOException) {
                logger.warn((Object)"Cannot find password for keystore on the system");
            }
        }
        return this.password;
    }

    private KeyManagerFactory createKeyManagerFactory(String storeFormat, String filePath, String password) throws Exception {
        KeyStore keyStore = this.loadKeyStore(storeFormat, filePath, password);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(TRUST_INSTANCE_SUN_X509);
        keyManagerFactory.init(keyStore, password.toCharArray());
        return keyManagerFactory;
    }

    private KeyStore loadKeyStore(String storeFormat, String filePath, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(storeFormat);
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(filePath);
            keyStore.load(fs, password.toCharArray());
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to load keyStore : ", (Throwable)ex);
                }
            }
        }
        return keyStore;
    }
}

