/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.PagingInfo;
import com.ericsson.cms.criteria.info.SortOrder;
import com.ericsson.cms.criteria.info.SortingInfo;
import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.scheduler.IScheduler;
import com.ericsson.cms.scheduler.entities.Job;
import com.ericsson.cms.search.IElasticSearchService;
import com.ericsson.cms.search.SearchParametersBuilder;
import com.ericsson.cms.search.TitleSearchResult;
import com.ericsson.cms.search.util.SiteStatusCollection;
import com.ericsson.cms.search.util.UpdateSiteStatusInfo;
import com.ericsson.cms.sites.core.CISPersistenceException;
import com.ericsson.cms.sites.core.DistTimeoutManager;
import com.ericsson.cms.sites.core.DistributionRetry;
import com.ericsson.cms.sites.core.EntitiesAssociatedException;
import com.ericsson.cms.sites.core.ICISPersistenceManager;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.ISitePartnerManager;
import com.ericsson.cms.sites.core.InactiveSiteException;
import com.ericsson.cms.sites.core.LicenseException;
import com.ericsson.cms.sites.core.SiteListComparator;
import com.ericsson.cms.sites.core.SiteManagementException;
import com.ericsson.cms.sites.core.entities.DistributionOption;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.core.entities.DistributionStatusDetail;
import com.ericsson.cms.sites.core.entities.LogicalSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SitePartner;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.ericsson.cms.sites.core.entities.TargetResult;
import com.ericsson.cms.sites.core.entities.TrackingSite;
import com.ericsson.cms.sites.core.entities.TrackingSiteTitle;
import com.ericsson.cms.sites.core.entities.TrackingStatus;
import com.ericsson.cms.sites.core.entities.mediapath.MediapathDistributionSite;
import com.ericsson.cms.sites.dependency.ISitesDepCacheService;
import com.ericsson.cms.sites.dependency.SitesDependencyDao;
import com.ericsson.cms.sites.distribution.DistributionManager;
import com.ericsson.cms.sites.distribution.TemplateInfo;
import com.ericsson.cms.sites.monitoring.ISiteChangeListener;
import com.ericsson.cms.sites.scheduling.SiteTimerSchedulerCallback;
import com.ericsson.cms.sites.util.SitesConfigurationUtil;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.tandbergtv.cms.rules.service.category.IRuleExecutionHandler;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.marvin.udt.ShallowRuleSet;
import com.tandbergtv.marvin.udt.TreEvent;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.core.ProgressManager;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.ITitleCopyService;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.TitleCopyException;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseFilter;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseManager;
import com.tandbergtv.watchpoint.pmm.util.ProgressStatusHelper;
import com.tandbergtv.watchpoint.pmm.util.RulesEngineFacade;
import com.tandbergtv.watchpoint.routing.SoapRouter;
import com.tandbergtv.workflow.api.API;
import com.tandbergtv.workflow.api.Resources;
import com.tandbergtv.workflow.api.Templates;
import com.tandbergtv.workflow.api.model.process.Template;
import com.tandbergtv.workflow.api.model.process.TemplateListResponse;
import com.tandbergtv.workflow.api.model.resource.Resource;
import com.tandbergtv.workflow.api.model.resource.ResourceGroup;
import com.tandbergtv.workflow.api.model.resource.ResourceListResponse;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.transaction.annotation.Transactional;

@Stateless
@TransactionAttribute
public class SiteManager
implements ISiteManager {
    private static final Logger logger = Logger.getLogger(SiteManager.class);
    private static final String LIC_DISTSITE_MAX_COUNT = "Sites.DistributionSite.MaxCount";
    private static final String LIC_TRACKSITE_MAX_COUNT = "Sites.TrackingSite.MaxCount";
    private static final String ASSOCIATED_ENTITY_TYPE_SITE_TIMER = "sitetimer";
    private static final String ASSOCIATION_DESCRIPTION_PREFIX_SITE_TIMER = "Site: ";
    private static final String ASSOCIATION_DESCRIPTION_SUFFIX_SITE_TIMER = " [DIST. TIMER]";
    private static final String JOB_PREFIX_SITE_TIMER = "Timer Job for Site ";
    private static final String ASSOCIATED_ENTITY_TYPE_SITE = "Sites";
    private static final int DISTSITETITLE_PAGESIZE = 1000;
    private static final String DISTRIBUTION_FAILED = "Distribution Failed";
    private static final String DISTRIBUTION_SUCCESS = "Distribution Successful";
    private static final String DISTRIBUTION_TIMEOUT = " due to Timeout";
    private static final String DISTRIBUTION_SITE_ID = "distributionSiteId";
    private static final String SITE_ID = "siteId";
    private static final String MASTER_TITLE_ID = "masterTitleId";
    private IClusterService hzcs = Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH);
    private HazelcastInstance haz = this.hzcs.getInstance();
    @EJB
    private ITitleCopyService titleCopyService;
    @EJB
    private ITitleManager titleManager;
    @EJB
    private ITitleSearchService searchService;
    @EJB
    private IRuleExecutionHandler ruleExecHandler;
    @EJB
    private IRuleManager ruleManager;
    @EJB
    private ISiteChangeListener siteChangeListener;
    @EJB
    private ILicenseManager licenseManager;
    @EJB
    private IScheduler scheduler;
    private static final String TITLES_DISTRIBUTED_BY_SITE = "application-metrics.cms-web.titles_distributed_site";
    private static final Logger METRICS_LOGGER = Logger.getLogger(SiteManager.class);

    public Site getSite(int siteId) {
        String queryStr = "from Site where id_ = :siteId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter(SITE_ID, (Object)siteId);
        return (Site)query.uniqueResult();
    }

    public Site getSiteByName(String siteName) {
        String queryStr = "from Site where name = :siteName";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("siteName", (Object)siteName);
        return (Site)query.uniqueResult();
    }

    public List<String> getSiteNamesBySiteIds(List<Integer> siteIds) {
        ArrayList<String> siteNames = new ArrayList<String>();
        for (Integer siteId : siteIds) {
            siteNames.add(this.getSite(siteId).getName());
        }
        return siteNames;
    }

    public List<Site> getSitesByExternalId(String externalId) {
        String queryStr = "from Site where externalId = :externalId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("externalId", (Object)externalId);
        return query.list();
    }

    public List<Site> getAllSites() {
        Session session = this.getSession();
        String queryStr = "FROM Site ORDER BY LOWER(name)";
        Query query = session.createQuery(queryStr);
        return query.list();
    }

    public List<Site> getTopLevelSites() {
        Session session = this.getSession();
        String queryStr1 = "SELECT ds FROM DistributionSite ds WHERE ds.parent is null ";
        Query query1 = session.createQuery(queryStr1);
        List result = query1.list();
        String queryStr2 = "SELECT ls FROM LogicalSite ls";
        Query query2 = session.createQuery(queryStr2);
        result.addAll(query2.list());
        this.sortResultAsc(result);
        return result;
    }

    private void sortResultAsc(List<Site> result) {
        Collections.sort(result, new SiteListComparator());
    }

    public List<DistributionSite> getAllDistributionSites() {
        String queryStr = "FROM DistributionSite";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        return query.list();
    }

    public List<DistributionSite> getActiveDistributionSites() {
        String queryStr = "FROM DistributionSite WHERE active = true";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        return query.list();
    }

    public List<TrackingSite> getAllTrackingSites(Integer parentDistSiteId) {
        List queryResult;
        Session session = this.getSession();
        if (parentDistSiteId != null) {
            String quesryStr = "SELECT ds.children FROM DistributionSite ds WHERE ds.id = :distributionSiteId";
            Query query = session.createQuery(quesryStr);
            query.setParameter(DISTRIBUTION_SITE_ID, (Object)parentDistSiteId);
            queryResult = query.list();
        } else {
            String queryStr = "FROM TrackingSite ts";
            Query query = session.createQuery(queryStr);
            queryResult = query.list();
        }
        if (queryResult != null) {
            Collections.sort(queryResult, new SiteListComparator());
        }
        return queryResult;
    }

    public List<TrackingSite> getShareableTrackingSites(int distributionSiteId) {
        Session session = this.getSession();
        String queryStr1 = "FROM TrackingSite ts";
        Query query1 = session.createQuery(queryStr1);
        List result = query1.list();
        String quesryStr2 = "SELECT ds.children FROM DistributionSite ds WHERE ds.id = :distributionSiteId";
        Query query2 = session.createQuery(quesryStr2);
        query2.setParameter(DISTRIBUTION_SITE_ID, (Object)distributionSiteId);
        result.removeAll(query2.list());
        return result;
    }

    public List<Long> getSiteCopyIds(long masterTitleId) {
        String queryStr = "SELECT dst.title.id FROM DistributionSiteTitle dst WHERE dst.title.originalId = :masterTitleId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter(MASTER_TITLE_ID, (Object)masterTitleId);
        return query.list();
    }

    public List<Title> getSiteCopies(long masterTitleId) {
        String queryStr = "SELECT dst.title FROM DistributionSiteTitle dst WHERE dst.title.originalId = :masterTitleId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter(MASTER_TITLE_ID, (Object)masterTitleId);
        return query.list();
    }

    public DistributionSite getAssociatedDistributionSite(long localTitleId) {
        String queryStr = "SELECT distSite FROM DistributionSite distSite JOIN distSite.distributionSiteTitles dst WHERE dst.title.id = :localTitleId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("localTitleId", (Object)localTitleId);
        return (DistributionSite)query.uniqueResult();
    }

    public DistributionSiteTitle getDistributionSiteTitleById(long dstId) {
        return (DistributionSiteTitle)this.getSession().load(DistributionSiteTitle.class, (Serializable)Long.valueOf(dstId));
    }

    public DistributionSiteTitle getDistributionSiteTitle(long localTitleId) {
        String queryStr = "FROM DistributionSiteTitle WHERE title.id = :localTitleId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("localTitleId", (Object)localTitleId);
        return (DistributionSiteTitle)query.uniqueResult();
    }

    private DistributionSiteTitle getDistributionSiteTitle(int distSiteId, long localTitleId) {
        String queryStr = "FROM DistributionSiteTitle WHERE distributionSite.id = :distSiteId AND title.id = :localTitleId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("distSiteId", (Object)distSiteId);
        query.setParameter("localTitleId", (Object)localTitleId);
        return (DistributionSiteTitle)query.uniqueResult();
    }

    private TrackingSiteTitle getTrackingSiteTitle(int trackSiteId, long localTitleId) {
        String queryStr = "FROM TrackingSiteTitle WHERE trackingSite.id = :trackSiteId AND title.id = :localTitleId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("trackSiteId", (Object)trackSiteId);
        query.setParameter("localTitleId", (Object)localTitleId);
        return (TrackingSiteTitle)query.uniqueResult();
    }

    public List<DistributionSiteTitle> getDistributionSiteTitles(long masterTitleId) {
        String queryStr = "FROM DistributionSiteTitle WHERE title.originalId = :masterTitleId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter(MASTER_TITLE_ID, (Object)masterTitleId);
        return query.list();
    }

    public List<DistributionSiteTitle> getDistributionSiteTitles(int siteId, List<Long> partnerIds) {
        StringBuilder queryStr = new StringBuilder("SELECT dst FROM DistributionSiteTitle dst ");
        if (!partnerIds.isEmpty()) {
            queryStr.append("JOIN dst.title t WHERE t.partnerId in (:partners) AND ");
        } else {
            queryStr.append("WHERE ");
        }
        queryStr.append("dst.distributionSite.id = :siteId ");
        Session session = this.getSession();
        Query query = session.createQuery(queryStr.toString());
        query.setParameter(SITE_ID, (Object)siteId);
        if (!partnerIds.isEmpty()) {
            query.setParameterList("partners", partnerIds);
        }
        return query.list();
    }

    public List<DistributionSiteTitle> getDistributionSiteTitlesByStatus(DistributionStatus status) {
        String queryStr = "FROM DistributionSiteTitle WHERE status = :status";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("status", (Object)status);
        return query.list();
    }

    public List<DistributionSiteTitle> getDistributionSiteTitlesBySiteAndStatus(int siteId, DistributionStatus status) {
        String queryStr = "FROM DistributionSiteTitle WHERE distributionSite.id = :siteId AND status = :status";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter(SITE_ID, (Object)siteId);
        query.setParameter("status", (Object)status);
        return query.list();
    }

    public List<Long> getDistributionSiteTitleIdsBySiteAndStatus(int siteId, DistributionStatus status) {
        String queryStr = "SELECT id FROM DistributionSiteTitle WHERE distributionSite.id = :siteId AND status = :status";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter(SITE_ID, (Object)siteId);
        query.setParameter("status", (Object)status);
        return query.list();
    }

    public List<TrackingSiteTitle> getTrackingSiteTitlesByStatus(TrackingStatus status) {
        String queryStr = "FROM TrackingSiteTitle WHERE status = :status";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("status", (Object)status);
        return query.list();
    }

    public List<DistributionSiteTitle> getDistributionSiteTitlesOfLogicalSite(int logicalSiteId, List<Long> partnerIds) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("SELECT DST.* FROM SITES_DISTSITETITLE DST ");
        queryStr.append("JOIN SITES_SITE S ON(DST.SITEID = S.id_) ");
        queryStr.append("JOIN SITES_SITELINK SL ON( S.ID_ = SL.CHILD) ");
        if (!partnerIds.isEmpty()) {
            queryStr.append("JOIN PMM_TITLE T ON(t.id_ = DST.TITLEID) ");
        }
        queryStr.append("WHERE SL.PARENT = ? ");
        if (!partnerIds.isEmpty()) {
            queryStr.append("AND t.partner_Id in (?");
            int i = 1;
            while (i < partnerIds.size()) {
                queryStr.append(", ?");
                ++i;
            }
            queryStr.append(")");
        }
        Session session = this.getSession();
        SQLQuery query = session.createSQLQuery(queryStr.toString()).addEntity(DistributionSiteTitle.class);
        int index = 0;
        query = query.setInteger(index++, logicalSiteId);
        for (Long partnerId : partnerIds) {
            query.setLong(index++, partnerId.longValue());
        }
        List list = query.list();
        return list;
    }

    private Title getLocalTitle(long masterTitleId, int distSiteId) {
        String queryStr = "SELECT dst.title FROM DistributionSiteTitle dst WHERE dst.distributionSite.id = :distSiteId AND dst.title.originalId = :masterTitleId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("distSiteId", (Object)distSiteId);
        query.setParameter(MASTER_TITLE_ID, (Object)masterTitleId);
        return (Title)query.uniqueResult();
    }

    public List<TrackingSiteTitle> getTrackingSiteTitles(long localTitleId) {
        String queryStr = "FROM TrackingSiteTitle WHERE title.id = :localTitleId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("localTitleId", (Object)localTitleId);
        return query.list();
    }

    public TrackingSiteTitle getTrackingSiteTitle(long localTitleId, int trackingSiteId) {
        String queryStr = "FROM TrackingSiteTitle WHERE title.id = :localTitleId and trackingSite.id = :trackingSiteId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("localTitleId", (Object)localTitleId);
        query.setParameter("trackingSiteId", (Object)trackingSiteId);
        return (TrackingSiteTitle)query.uniqueResult();
    }

    public LogicalSite createLogicalSite(LogicalSite site) {
        LogicalSite logicalSite = (LogicalSite)this.save((Site)site);
        ISitePartnerManager sitePartnerManager = (ISitePartnerManager)InjectionUtil.injectInstance((String)"/cms/SitePartnerManager/local", ISitePartnerManager.class);
        sitePartnerManager.createPartnerForSite(site.getId().intValue());
        return logicalSite;
    }

    public LogicalSite createLogicalSite(LogicalSite site, SitePartner sitePartner) {
        LogicalSite logicalSite = (LogicalSite)this.save((Site)site);
        ISitePartnerManager sitePartnerManager = (ISitePartnerManager)InjectionUtil.injectInstance((String)"/cms/SitePartnerManager/local", ISitePartnerManager.class);
        sitePartnerManager.createPartnerForSite(site.getId().intValue(), sitePartner);
        return logicalSite;
    }

    public boolean hasReachedMaxLicensedDistributionSites() {
        String maxAllowedStr = null;
        try {
            maxAllowedStr = this.licenseManager.getProperty(LIC_DISTSITE_MAX_COUNT);
        }
        catch (InvalidLicenseException e) {
            throw new SiteManagementException((Throwable)e);
        }
        if (maxAllowedStr != null && maxAllowedStr.trim().length() != 0) {
            int maxAllowed = Integer.parseInt(maxAllowedStr);
            if (this.getDistSitesCount() >= maxAllowed) {
                return true;
            }
        }
        return false;
    }

    private int getDistSitesCount() {
        Query query = this.getSession().createQuery("SELECT count(*) FROM DistributionSite");
        return ((Long)query.uniqueResult()).intValue();
    }

    public synchronized DistributionSite createDistributionSite(DistributionSite site, Integer parentSiteId) {
        if (this.hasReachedMaxLicensedDistributionSites()) {
            throw new LicenseException("Reached maximum allowed Distribution Sites as per license.");
        }
        if (parentSiteId != null) {
            LogicalSite parentSite = this.getLogicalSite(parentSiteId);
            site.setParent(parentSite);
        }
        DistributionSite savedSite = (DistributionSite)this.save((Site)site);
        if (DistributionOption.TIMED.equals((Object)site.getDistributionOption())) {
            this.scheduleTimerJob(site);
        }
        ISitePartnerManager sitePartnerManager = (ISitePartnerManager)InjectionUtil.injectInstance((String)"/cms/SitePartnerManager/local", ISitePartnerManager.class);
        sitePartnerManager.createPartnerForSite(site.getId().intValue());
        this.updateSitesGraph(site, false);
        return savedSite;
    }

    public synchronized DistributionSite createDistributionSite(DistributionSite site, Integer parentSiteId, SitePartner sitePartner) {
        if (this.hasReachedMaxLicensedDistributionSites()) {
            throw new LicenseException("Reached maximum allowed Distribution Sites as per license.");
        }
        if (parentSiteId != null) {
            LogicalSite parentSite = this.getLogicalSite(parentSiteId);
            site.setParent(parentSite);
        }
        DistributionSite savedSite = (DistributionSite)this.save((Site)site);
        if (DistributionOption.TIMED.equals((Object)site.getDistributionOption())) {
            this.scheduleTimerJob(site);
        }
        ISitePartnerManager sitePartnerManager = (ISitePartnerManager)InjectionUtil.injectInstance((String)"/cms/SitePartnerManager/local", ISitePartnerManager.class);
        sitePartnerManager.createPartnerForSite(site.getId().intValue(), sitePartner);
        this.updateSitesGraph(site, false);
        return savedSite;
    }

    public void updateSitesGraph(DistributionSite site, boolean deleteAction) {
        ISitesDepCacheService sitesDepSvc = (ISitesDepCacheService)InjectionUtil.injectInstance((String)"cms/SitesDepCacheService/local", ISitesDepCacheService.class);
        Long version = 0L;
        String rollbackJSON = null;
        boolean exceptionFromCacheUpdate = false;
        try {
            version = sitesDepSvc.getVersion();
            rollbackJSON = sitesDepSvc.toJSON();
            String sitesGraphJSON = sitesDepSvc.getJSON(site.getId(), site.getDependsOnSites(), deleteAction);
            SitesDependencyDao.update(sitesGraphJSON, version);
            exceptionFromCacheUpdate = true;
            if (deleteAction) {
                sitesDepSvc.delete(site.getId());
            } else {
                sitesDepSvc.update(site.getId(), site.getDependsOnSites());
            }
        }
        catch (Exception ex) {
            if (exceptionFromCacheUpdate) {
                sitesDepSvc.refresh(rollbackJSON, version);
            }
            logger.error((Object)"Error updating the sites graph cache", (Throwable)ex);
            throw new SiteManagementException((Throwable)ex);
        }
    }

    public boolean hasReachedMaxLicensedTrackingSites() {
        String maxAllowedStr = null;
        try {
            maxAllowedStr = this.licenseManager.getProperty(LIC_TRACKSITE_MAX_COUNT);
        }
        catch (InvalidLicenseException e) {
            throw new SiteManagementException((Throwable)e);
        }
        if (maxAllowedStr != null && maxAllowedStr.trim().length() != 0) {
            int maxAllowed = Integer.parseInt(maxAllowedStr);
            if (this.getTrackSitesCount() >= maxAllowed) {
                return true;
            }
        }
        return false;
    }

    private void checkLicense(Long contentClassId) {
        LicenseManager.getInstance().canCreateSiteTitles(LicenseFilter.newBuilder().setContentClassId(contentClassId).build());
    }

    private int getTrackSitesCount() {
        Query query = this.getSession().createQuery("SELECT count(*) FROM TrackingSite");
        return ((Long)query.uniqueResult()).intValue();
    }

    public List<TrackingSite> getAllTrackingSites() {
        ArrayList<TrackingSite> trackList = new ArrayList();
        Session session = this.getSession();
        String queryStr1 = "FROM TrackingSite ts order by ts.name";
        Query query1 = session.createQuery(queryStr1);
        trackList = query1.list();
        return trackList;
    }

    public synchronized TrackingSite createTrackingSite(TrackingSite site, Integer parentSiteId) {
        if (this.hasReachedMaxLicensedTrackingSites()) {
            throw new LicenseException("Reached maximum allowed Tracking Sites as per license.");
        }
        if (parentSiteId == null) {
            throw new RuntimeException("parentSiteId cannot be null. Tracking Site must be associated with a parent.");
        }
        DistributionSite parentSite = this.getDistributionSite(parentSiteId);
        site.addParent(parentSite);
        TrackingSite savedTrackingSite = (TrackingSite)this.save((Site)site);
        this.getSession().flush();
        int numTitles = this.associateTitles(savedTrackingSite.getId(), parentSite.getId());
        logger.info((Object)(String.valueOf(numTitles) + " titles has been associated to [" + savedTrackingSite + "] from [" + parentSite + "]"));
        return savedTrackingSite;
    }

    public void associateTrackingSites(Set<Integer> trackingSiteIds, int distributionSiteId) {
        DistributionSite ds = this.getDistributionSite(distributionSiteId);
        if (trackingSiteIds != null) {
            for (Integer tsId : trackingSiteIds) {
                TrackingSite ts = this.getTrackingSite(tsId);
                ds.addChild(ts);
                this.getSession().flush();
                int numTitles = this.associateTitles(ts.getId(), ds.getId());
                logger.info((Object)(String.valueOf(numTitles) + " titles has been associated to [" + ts + "] from [" + ds + "]"));
                this.siteChangeListener.trackingSiteShared(ds, ts);
            }
        }
        this.save((Site)ds);
    }

    private int associateTitles(int trackSiteId, int distSiteId) {
        SQLQuery q = this.getSession().createSQLQuery("insert into sites_tracksitetitle (siteid, titleid, status, status_updated_time) select :tsId, titleid, " + TrackingStatus.TARGETED.ordinal() + ", transaction_timestamp() " + " from sites_distsitetitle where siteid = :dsId");
        q.setInteger("tsId", trackSiteId);
        q.setInteger("dsId", distSiteId);
        int sqlUpdateCount = q.executeUpdate();
        try {
            ServiceRegistry registry = ServiceRegistry.getDefault();
            IElasticSearchService esService = (IElasticSearchService)registry.lookup(IElasticSearchService.class);
            esService.associateTrackingSiteTitles(trackSiteId, distSiteId, new Date());
        }
        catch (Exception ex) {
            logger.error((Object)"Could not associate titles", (Throwable)ex);
        }
        return sqlUpdateCount;
    }

    private int dissociateTitles(int trackSiteId, int distSiteId) {
        SQLQuery q = this.getSession().createSQLQuery("delete from sites_tracksitetitle where siteid = :tsId and titleid in (select titleid from sites_distsitetitle where siteid = :dsId)");
        q.setInteger("tsId", trackSiteId);
        q.setInteger("dsId", distSiteId);
        int sqlUpdateCount = q.executeUpdate();
        try {
            ServiceRegistry registry = ServiceRegistry.getDefault();
            IElasticSearchService esService = (IElasticSearchService)registry.lookup(IElasticSearchService.class);
            esService.dissociateTrackingSiteTitles(trackSiteId, distSiteId);
        }
        catch (Exception ex) {
            logger.error((Object)"Could not associate titles", (Throwable)ex);
        }
        return sqlUpdateCount;
    }

    public void dissociateTrackingSite(int trackingSiteId, int distributionSiteId) {
        DistributionSite ds = this.getDistributionSite(distributionSiteId);
        TrackingSite ts = this.getTrackingSite(trackingSiteId);
        ds.removeChild(ts);
        ts.getParents().remove(ds);
        int numTitles = this.dissociateTitles(ts.getId(), ds.getId());
        logger.info((Object)(String.valueOf(numTitles) + " titles of [" + ds + "] has been dissociated from [" + ts + "]"));
        this.siteChangeListener.trackingSiteDetached(ds, ts);
        this.save((Site)ds);
    }

    public Site save(Site site) {
        Long timerJobId;
        Job timerJob;
        DistributionSite distSite;
        if (site.getType() == SiteType.DISTRIBUTION && (distSite = (DistributionSite)site).getDistributionOption() != DistributionOption.TIMED && (timerJob = distSite.getTimerJob()) != null && (timerJobId = timerJob.getId()) != null) {
            this.scheduler.delete(timerJobId.longValue());
        }
        this.getSession().saveOrUpdate((Object)site);
        return site;
    }

    public SitePartner save(Site site, SitePartner sitePartner) {
        SitePartner savedSitePartner = null;
        if (site != null && sitePartner != null && sitePartner.getContextId() > 0L) {
            ISitePartnerManager sitePartnerManager = (ISitePartnerManager)InjectionUtil.injectInstance((String)"/cms/SitePartnerManager/local", ISitePartnerManager.class);
            sitePartnerManager.update(sitePartner);
            savedSitePartner = sitePartnerManager.get(site.getId().intValue());
        }
        return savedSitePartner;
    }

    public Site updateSiteProperties(Site site) {
        Site dbSite = this.internalGetSite(site.getId());
        if (site.getType() != dbSite.getType()) {
            throw new RuntimeException("Cannot change the Site Type");
        }
        dbSite.setName(site.getName());
        dbSite.setExternalId(site.getExternalId());
        dbSite.setDescription(site.getDescription());
        switch (site.getType()) {
            case LOGICAL: {
                break;
            }
            case DISTRIBUTION: {
                List timerJobs;
                DistributionSite dbDistSite = (DistributionSite)dbSite;
                DistributionSite distSite = (DistributionSite)site;
                dbDistSite.setFileLookupKeys(distSite.getFileLookupKeys());
                dbDistSite.setMetadataFormat(distSite.getMetadataFormat());
                dbDistSite.setAlertDelayPeriod(distSite.getAlertDelayPeriod());
                dbDistSite.setCisMode(distSite.getCisMode());
                boolean wasTimed = dbDistSite.getDistributionOption() == DistributionOption.TIMED;
                boolean isTimed = distSite.getDistributionOption() == DistributionOption.TIMED;
                boolean wasImmediate = dbDistSite.getDistributionOption() == DistributionOption.IMMEDIATE;
                boolean isImmediate = distSite.getDistributionOption() == DistributionOption.IMMEDIATE;
                boolean wasDependsOn = dbDistSite.getDistributionOption() == DistributionOption.DEPENDSON;
                boolean isDependsOn = distSite.getDistributionOption() == DistributionOption.DEPENDSON;
                List<Long> waitingList = null;
                dbDistSite.setDistributionOption(distSite.getDistributionOption());
                if (!wasDependsOn) {
                    // empty if block
                }
                if (wasDependsOn && !isDependsOn) {
                    waitingList = this.updateDistributionStatusFromWaitingToReady(dbDistSite.getId());
                }
                if (wasDependsOn) {
                    // empty if block
                }
                if (wasTimed && !isTimed && (timerJobs = this.scheduler.getJobsByAssociatedEntity(ASSOCIATED_ENTITY_TYPE_SITE_TIMER, (long)distSite.getId().intValue())) != null) {
                    for (Job timerJob : timerJobs) {
                        this.scheduler.delete(timerJob.getId().longValue());
                    }
                }
                if (!wasTimed && isTimed) {
                    distSite.setActive(dbDistSite.isActive());
                    this.scheduleTimerJob(distSite);
                }
                if (wasTimed && isTimed) {
                    Job timerJob = distSite.getTimerJob();
                    String jobName = JOB_PREFIX_SITE_TIMER + distSite.getName();
                    String associationDescription = ASSOCIATION_DESCRIPTION_PREFIX_SITE_TIMER + distSite.getName() + ASSOCIATION_DESCRIPTION_SUFFIX_SITE_TIMER;
                    timerJob.setName(jobName);
                    timerJob.setAssociationDescription(associationDescription);
                    timerJob.setCallbackClass(SiteTimerSchedulerCallback.class);
                    Job job = this.scheduler.schedule(timerJob);
                    if (job.isActive() != dbDistSite.isActive()) {
                        this.scheduler.setActive(job.getId().longValue(), dbDistSite.isActive());
                    }
                }
                if (!wasImmediate && isImmediate && dbDistSite.isActive()) {
                    this.distributeReadyTitlesImmediately(dbDistSite.getId(), waitingList);
                }
                dbDistSite.setDistTemplateName(distSite.getDistTemplateName());
                dbDistSite.setAssociatedGroupName(distSite.getAssociatedGroupName());
                dbDistSite.setDistConfParams(distSite.getDistConfParams());
                dbDistSite.setAssociatedResourceId(distSite.getAssociatedResourceId());
                dbDistSite.setExportPluginName(distSite.getExportPluginName());
                dbDistSite.setExportConfParams(distSite.getExportConfParams());
                dbDistSite.setDependsOnSites(distSite.getDependsOnSites());
                dbDistSite.setActionOnFailure(distSite.getActionOnFailure());
                dbDistSite.setRetryAttempt(distSite.getRetryAttempt());
                dbDistSite.setRetryWaitTime(distSite.getRetryWaitTime());
                break;
            }
            case TRACKING: {
                ((TrackingSite)dbSite).setAlertDelayPeriod(((TrackingSite)site).getAlertDelayPeriod());
            }
        }
        Site savedSite = this.save(dbSite);
        if (site.getType() == SiteType.DISTRIBUTION) {
            this.updateSitesGraph((DistributionSite)dbSite, false);
        }
        return savedSite;
    }

    public List<Long> updateDistributionStatusFromWaitingToReady(int siteId) {
        List<Long> dstIds = null;
        try {
            dstIds = this.getDistributionSiteTitleIdsBySiteAndStatus(siteId, DistributionStatus.WAITING_FOR_DEPENDENCY);
            Iterator ite = dstIds.iterator();
            while (ite.hasNext()) {
                Long dstId = (Long)ite.next();
                try {
                    boolean isOffer;
                    DistributionSiteTitle dst = this.getDistributionSiteTitleById(dstId);
                    try {
                        isOffer = this.titleManager.isOffer(dst.getTitle().getId());
                    }
                    catch (TitleValidationException e) {
                        throw new SiteManagementException(e.getMessage());
                    }
                    if (isOffer) {
                        if (this.isWaitingForReferencedSiteTitles(dst.getTitle().getId())) {
                            ite.remove();
                            continue;
                        }
                        this.changeDistributionStatus(dst, DistributionStatus.READY_FOR_DISTRIBUTION);
                        continue;
                    }
                    this.changeDistributionStatus(dst, DistributionStatus.READY_FOR_DISTRIBUTION);
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to update distribution status to ready_for_distribution of site title: " + dstId), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failure in update distribution status to ready_for_distribution of site: " + siteId), (Throwable)e);
        }
        return dstIds;
    }

    public SitePartner updateSitePartnerProperties(Site site, SitePartner sitePartner) {
        return this.save(site, sitePartner);
    }

    public void delete(int siteId) throws EntitiesAssociatedException {
        this.delete(this.internalGetSite(siteId), null);
    }

    private void delete(Site site, Site parentSite) throws EntitiesAssociatedException {
        ISitePartnerManager sitePartnerManager;
        List nonTimerJobs;
        List ruleSets;
        EntitiesAssociatedException eaException = new EntitiesAssociatedException(site);
        ISitesDepCacheService sitesDepSvc = (ISitesDepCacheService)InjectionUtil.injectInstance((String)"cms/SitesDepCacheService/local", ISitesDepCacheService.class);
        if (site instanceof MediapathDistributionSite && ((MediapathDistributionSite)site).getMsos() != null && !((MediapathDistributionSite)site).getMsos().isEmpty()) {
            ((MediapathDistributionSite)site).setMsos(null);
            this.deleteMsoAssociation(site);
        }
        if ((ruleSets = this.ruleManager.getAllRuleSetsBySite(site.getId())) != null && !ruleSets.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (ShallowRuleSet rs : ruleSets) {
                if (!rs.packageName.equals("TARGETING")) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(rs.getRuleSetId());
            }
            if (!sb.toString().isEmpty()) {
                sb.insert(0, "Including targeting rule set(s): ");
            }
            eaException.addAssociatedEntity(EntitiesAssociatedException.EntityType.RULES, sb.toString());
        }
        if ((nonTimerJobs = this.scheduler.getJobsByAssociatedEntity(ASSOCIATED_ENTITY_TYPE_SITE, (long)site.getId().intValue())) != null && nonTimerJobs.size() > 0) {
            eaException.addAssociatedEntity(EntitiesAssociatedException.EntityType.JOBS);
        }
        if (site.getType() != SiteType.TRACKING && (sitePartnerManager = (ISitePartnerManager)InjectionUtil.injectInstance((String)"/cms/SitePartnerManager/local", ISitePartnerManager.class)).getSchedulesCountForSite(site.getId().intValue()) > 0) {
            eaException.addAssociatedEntity(EntitiesAssociatedException.EntityType.SCHEDULES);
        }
        if (eaException.hasEntities()) {
            throw eaException;
        }
        List timerJobs = this.scheduler.getJobsByAssociatedEntity(ASSOCIATED_ENTITY_TYPE_SITE_TIMER, (long)site.getId().intValue());
        if (timerJobs != null) {
            for (Job timerJob : timerJobs) {
                this.scheduler.delete(timerJob.getId().longValue());
            }
        }
        this.haz = this.hzcs.getInstance();
        IMap elaticSearchSiteMapHaz = this.haz.getMap("elaticSearchSiteMapHaz");
        Boolean status = (Boolean)elaticSearchSiteMapHaz.get(String.valueOf(site.getId()));
        if (status != null && status.booleanValue()) {
            logger.error((Object)("ElasticSearch sync is in progress for siteId: " + site.getId()));
            throw new SiteManagementException("ElasticSearch sync is in progress for siteId: " + site.getId());
        }
        if (site.getType() == SiteType.DISTRIBUTION) {
            if (!sitesDepSvc.getImmediateDependentSites(site.getId()).isEmpty()) {
                throw new SiteManagementException("This site is a prerequisite site of site " + this.getSiteNamesByIds(sitesDepSvc.getImmediateDependentSites(site.getId())) + ". Please remove the dependency from the dependent site and try again.");
            }
            this.deleteDistributionSiteTitles(site.getId());
        }
        if (site.getSiteChildren() != null) {
            for (Site childSite : site.getSiteChildren()) {
                this.delete(childSite, site);
            }
        }
        if (site.getType() == SiteType.TRACKING) {
            TrackingSite ts = (TrackingSite)site;
            if (parentSite != null && ts.getParents().size() > 1) {
                logger.info((Object)("Dissociating tracking site: [" + site + "]" + " from site[" + parentSite.getId() + "]"));
                this.dissociateTrackingSite(site.getId(), parentSite.getId());
                return;
            }
            DistributionSite ds = (DistributionSite)ts.getParents().iterator().next();
            this.deleteTrackingSiteTitles(site.getId(), ds.getId());
        } else {
            ISitePartnerManager sitePartnerManager2 = (ISitePartnerManager)InjectionUtil.injectInstance((String)"/cms/SitePartnerManager/local", ISitePartnerManager.class);
            sitePartnerManager2.deletePartnerForSite(site.getId().intValue());
        }
        if (site.getType() == SiteType.DISTRIBUTION) {
            try {
                this.deleteCISNotificationData(site.getId());
            }
            catch (CISPersistenceException e) {
                logger.error((Object)("Faile to delete CIS Notification Data siteId :" + site.getId()), (Throwable)e);
                throw new SiteManagementException((Throwable)e);
            }
            this.updateSitesGraph((DistributionSite)site, true);
        }
        this.siteChangeListener.siteDeleted(site);
        logger.info((Object)("Deleting site: [" + site + "]"));
        this.getSession().delete((Object)site);
    }

    private void deleteCISNotificationData(Integer siteId) throws CISPersistenceException {
        ICISPersistenceManager cisManager = (ICISPersistenceManager)InjectionUtil.injectInstance((String)"/cms/CISPersistenceManager/local", ICISPersistenceManager.class);
        cisManager.delete(siteId);
    }

    private List<String> getSiteNamesByIds(List<Integer> siteIds) {
        ArrayList<String> siteNames = new ArrayList<String>();
        if (siteIds != null && !siteIds.isEmpty()) {
            for (Integer siteId : siteIds) {
                siteNames.add(this.getSite(siteId).getName());
            }
        }
        return siteNames;
    }

    @Transactional
    private void deleteMsoAssociation(Site site) {
        Session session = this.getSession();
        try {
            Query query = session.createSQLQuery("delete from sites_mso_site where site_id = ?").addEntity(MediapathDistributionSite.class).setInteger(0, site.getId().intValue());
            query.executeUpdate();
        }
        catch (Exception e) {
            logger.error((Object)("Could not delete mediapath site association: " + e));
        }
    }

    public void activate(int siteId) {
        Site site = this.getSite(siteId);
        this.setSiteActive(site, true, false);
    }

    public void inactivate(int siteId) {
        Site site = this.getSite(siteId);
        this.setSiteActive(site, false, false);
    }

    private void setSiteActive(Site site, boolean isActive, boolean noCascade) {
        if (site.isActive() != isActive) {
            site.setActive(isActive);
            this.save(site);
            if (site.getType() == SiteType.DISTRIBUTION) {
                DistributionSite distSite = (DistributionSite)site;
                if (distSite.getDistributionOption() == DistributionOption.TIMED) {
                    List siteTimerJobs = this.scheduler.getJobsByAssociatedEntity(ASSOCIATED_ENTITY_TYPE_SITE_TIMER, (long)distSite.getId().intValue());
                    if (siteTimerJobs != null) {
                        for (Job siteTimerJob : siteTimerJobs) {
                            this.scheduler.setActive(siteTimerJob.getId().longValue(), isActive);
                        }
                    }
                } else if (distSite.getDistributionOption() == DistributionOption.IMMEDIATE && isActive) {
                    this.distributeReadyTitlesImmediately(distSite.getId());
                }
            }
            if (isActive) {
                this.siteChangeListener.siteActivated(site);
            } else {
                this.siteChangeListener.siteInactivated(site);
            }
        }
        if (!noCascade && site.getSiteChildren() != null) {
            for (Site child : site.getSiteChildren()) {
                this.setSiteActive(child, isActive, false);
            }
        }
    }

    public Set<TemplateInfo> getDistributionTemplatesInfo() {
        return DistributionManager.getInstance().getDistributionTemplateInfos();
    }

    public Set<String> getDistributionTemplateNames() {
        return DistributionManager.getInstance().getDistributionTemplateNames();
    }

    public Title createSiteCopy(long masterTitleId, int distributionSiteId) throws SiteManagementException {
        boolean isOffer = false;
        try {
            isOffer = this.titleManager.isOffer(Long.valueOf(masterTitleId));
        }
        catch (TitleValidationException tex) {
            throw new SiteManagementException((Throwable)tex);
        }
        try {
            if (isOffer) {
                Title siteOfferTitle = null;
                siteOfferTitle = this.createSiteOfferTitleCopy(masterTitleId, distributionSiteId);
                return siteOfferTitle;
            }
            return this.createMasterTitleSiteCopy(masterTitleId, distributionSiteId);
        }
        catch (Exception ex) {
            throw new SiteManagementException(ex.getMessage());
        }
    }

    private List<Long> getReferencedTitleIdsCopied(long offerTitleId, int distributionSiteId) throws SiteManagementException, TitleValidationException {
        ArrayList<Long> siteOfferRefrencedSiteTitleIds = new ArrayList<Long>();
        List referencedTitleIds = this.titleManager.getReferencedTitleIdsFromOffer(Long.valueOf(offerTitleId));
        if (referencedTitleIds.size() == 0) {
            return new ArrayList<Long>();
        }
        ArrayList<String> referencedTitleIdsValue = new ArrayList<String>();
        for (Long referencedTitleId : referencedTitleIds) {
            referencedTitleIdsValue.add(referencedTitleId.toString());
        }
        HashSet referencedTitleIdsValueSet = new HashSet(referencedTitleIds);
        HashSet<Integer> distributionSiteIdsSet = new HashSet<Integer>(Arrays.asList(distributionSiteId));
        HashMap<Long, Long> siteTitleIdsMap = new HashMap<Long, Long>();
        for (Long referencedTitleId : referencedTitleIdsValueSet) {
            List<Long> siteTitleIds = this.getSiteTitleIdsForMasterTitleAndSiteIds(referencedTitleId, distributionSiteIdsSet);
            if (siteTitleIds.size() == 0) {
                String errMsg = "Cannot create site Offer for Offer with offerTitleId: [" + offerTitleId + "], not all referenced titles have a site copy. [" + referencedTitleId + "] does not have a site copy";
                throw new SiteManagementException(errMsg);
            }
            siteTitleIdsMap.put(referencedTitleId, siteTitleIds.get(0));
        }
        for (Long refTitleId : referencedTitleIds) {
            siteOfferRefrencedSiteTitleIds.add((Long)siteTitleIdsMap.get(refTitleId));
        }
        return siteOfferRefrencedSiteTitleIds;
    }

    private Title createSiteOfferTitleCopy(long offerTitleId, int distributionSiteId) throws SiteManagementException, TitleValidationException {
        Group asset2;
        String assetType;
        boolean newTarget;
        List<Long> siteOfferRefrencedSiteTitleIds = this.getReferencedTitleIdsCopied(offerTitleId, distributionSiteId);
        DistributionSite distSite = this.getDistributionSite(distributionSiteId);
        if (!distSite.isActive()) {
            throw new InactiveSiteException((Site)distSite);
        }
        Title offerTitle = this.getMasterTitle(offerTitleId, true);
        if (offerTitle.getStatus() == TitleStatus.DRAFT) {
            throw new SiteManagementException("Cannot target. Can target only an Offer title that is not in DRAFT status.");
        }
        Title copyOfferTitle = this.getLocalTitle(offerTitleId, distSite.getId());
        boolean bl = newTarget = copyOfferTitle == null;
        if (newTarget) {
            this.checkLicense(offerTitle.getContentClassId());
            try {
                copyOfferTitle = this.titleCopyService.createTitleCopy(offerTitleId, true);
            }
            catch (TitleCopyException e) {
                throw new SiteManagementException((Throwable)e);
            }
        }
        try {
            copyOfferTitle = this.titleCopyService.overwriteTitleCopy(copyOfferTitle.getId().longValue());
        }
        catch (TitleCopyException e) {
            throw new SiteManagementException((Throwable)e);
        }
        HashMap<String, HashSet<String>> siteAssetTypeFLKsMap = new HashMap<String, HashSet<String>>();
        List fileLookupKeysList = distSite.getFileLookupKeys();
        if (fileLookupKeysList != null) {
            for (String fileLookupKey : fileLookupKeysList) {
                String[] flkSplitArray = fileLookupKey.split("-");
                assetType = flkSplitArray[0].trim();
                HashSet<String> fileLookupKeys = (HashSet<String>)siteAssetTypeFLKsMap.get(assetType);
                if (fileLookupKeys == null) {
                    fileLookupKeys = new HashSet<String>();
                    siteAssetTypeFLKsMap.put(assetType, fileLookupKeys);
                }
                fileLookupKeys.add(flkSplitArray[1].trim());
            }
        }
        Collection assets = copyOfferTitle.getAllAssets(false);
        for (Group asset2 : assets) {
            assetType = asset2.getAssetType();
            String lookupKey = null;
            Set chosenFLKs = (Set)siteAssetTypeFLKsMap.get(assetType);
            if (chosenFLKs != null) {
                Set availableFLKs = this.titleManager.getFileLookupKeys((Asset)asset2);
                HashSet matchingFLKs = new HashSet();
                matchingFLKs.addAll(chosenFLKs);
                matchingFLKs.retainAll(availableFLKs);
                if (matchingFLKs.size() > 1) {
                    throw new SiteManagementException("More than one file matched to be copied for the asset: " + asset2 + ". Matched lookup keys: " + matchingFLKs);
                }
                if (matchingFLKs.size() == 1) {
                    lookupKey = (String)matchingFLKs.iterator().next();
                }
            }
            this.titleManager.filterFiles((Asset)asset2, lookupKey);
            try {
                this.titleManager.updateWithFileMetadata((Asset)asset2, lookupKey);
            }
            catch (Exception e) {
                throw new SiteManagementException("Failed to update asset with file metadata.", (Throwable)e);
            }
        }
        asset2 = (Group)copyOfferTitle.getAsset();
        asset2.setReferencedTitleIds(siteOfferRefrencedSiteTitleIds);
        Title savedTitle = null;
        DistributionSiteTitle dst = null;
        TitleActionSource source = new TitleActionSource(ASSOCIATED_ENTITY_TYPE_SITE, "", Integer.toString(distSite.getId()));
        if (newTarget) {
            try {
                savedTitle = this.titleManager.create(copyOfferTitle, false, (ITitleActionSource)source).getTitle();
            }
            catch (TitleValidationException e) {
                logger.error((Object)"Create error. Saving as draft. ", (Throwable)e);
                try {
                    savedTitle = this.titleManager.update(copyOfferTitle, true, (ITitleActionSource)source).getTitle();
                }
                catch (TitleValidationException e1) {
                    throw new SiteManagementException((Throwable)e1);
                }
            }
            dst = new DistributionSiteTitle(distSite, copyOfferTitle, DistributionStatus.TARGETED);
            this.getSession().saveOrUpdate((Object)dst);
            Set trackingSites = distSite.getChildren();
            if (trackingSites != null) {
                for (TrackingSite trackingSite : trackingSites) {
                    this.getSession().saveOrUpdate((Object)new TrackingSiteTitle(trackingSite, copyOfferTitle, TrackingStatus.TARGETED));
                }
            }
        } else {
            try {
                savedTitle = this.titleManager.update(copyOfferTitle, false, (ITitleActionSource)source).getTitle();
            }
            catch (TitleValidationException e) {
                logger.error((Object)"Update error. Saving as draft. ", (Throwable)e);
                try {
                    savedTitle = this.titleManager.update(copyOfferTitle, true, (ITitleActionSource)source).getTitle();
                }
                catch (TitleValidationException e1) {
                    throw new SiteManagementException((Throwable)e1);
                }
            }
            dst = this.getDistributionSiteTitle(copyOfferTitle.getId());
            if (dst.getStatus() == DistributionStatus.IN_PROGRESS) {
                logger.warn((Object)("Retargeting a title whose distribution is in progress. Distribution Site: " + dst.getDistributionSite().getId() + " | Local Title Id: " + copyOfferTitle.getId()));
            }
            dst.setStatus(DistributionStatus.TARGETED);
            this.getSession().saveOrUpdate((Object)dst);
        }
        this.updateAggregatedDistributionStatus(dst);
        this.saveSiteTitleInElasticSearch(savedTitle);
        return copyOfferTitle;
    }

    private Title createMasterTitleSiteCopy(long masterTitleId, int distributionSiteId) throws SiteManagementException {
        DistributionSiteTitle dst;
        String assetType;
        boolean newTarget;
        DistributionSite distSite = this.getDistributionSite(distributionSiteId);
        if (!distSite.isActive()) {
            throw new InactiveSiteException((Site)distSite);
        }
        Title masterTitle = this.getMasterTitle(masterTitleId, true);
        if (masterTitle.getStatus() == TitleStatus.DRAFT || masterTitle.getStatus() == TitleStatus.PLANNED) {
            throw new SiteManagementException("Cannot target. Can target only a title that is not in DRAFT or PLANNED status.");
        }
        Title copyTitle = this.getLocalTitle(masterTitleId, distSite.getId());
        boolean bl = newTarget = copyTitle == null;
        if (newTarget) {
            this.checkLicense(masterTitle.getContentClassId());
            try {
                copyTitle = this.titleCopyService.createTitleCopy(masterTitleId, true);
            }
            catch (TitleCopyException e) {
                throw new SiteManagementException((Throwable)e);
            }
        }
        try {
            copyTitle = this.titleCopyService.overwriteTitleCopy(copyTitle.getId().longValue());
        }
        catch (TitleCopyException e) {
            throw new SiteManagementException((Throwable)e);
        }
        HashMap<String, HashSet<String>> siteAssetTypeFLKsMap = new HashMap<String, HashSet<String>>();
        List fileLookupKeysList = distSite.getFileLookupKeys();
        if (fileLookupKeysList != null) {
            for (String fileLookupKey : fileLookupKeysList) {
                String[] flkSplitArray = fileLookupKey.split("-");
                assetType = flkSplitArray[0].trim();
                HashSet<String> fileLookupKeys = (HashSet<String>)siteAssetTypeFLKsMap.get(assetType);
                if (fileLookupKeys == null) {
                    fileLookupKeys = new HashSet<String>();
                    siteAssetTypeFLKsMap.put(assetType, fileLookupKeys);
                }
                fileLookupKeys.add(flkSplitArray[1].trim());
            }
        }
        Collection assets = copyTitle.getAllAssets(false);
        for (Asset asset : assets) {
            assetType = asset.getAssetType();
            String lookupKey = null;
            Set chosenFLKs = (Set)siteAssetTypeFLKsMap.get(assetType);
            if (chosenFLKs != null) {
                Set availableFLKs = this.titleManager.getFileLookupKeys(asset);
                HashSet matchingFLKs = new HashSet();
                matchingFLKs.addAll(chosenFLKs);
                matchingFLKs.retainAll(availableFLKs);
                if (matchingFLKs.size() > 1) {
                    throw new SiteManagementException("More than one file matched to be copied for the asset: " + asset + ". Matched lookup keys: " + matchingFLKs);
                }
                if (matchingFLKs.size() == 1) {
                    lookupKey = (String)matchingFLKs.iterator().next();
                }
            }
            this.titleManager.filterFiles(asset, lookupKey);
            try {
                this.titleManager.updateWithFileMetadata(asset, lookupKey);
            }
            catch (Exception e) {
                throw new SiteManagementException("Failed to update asset with file metadata.", (Throwable)e);
            }
        }
        Title savedTitle = null;
        TitleActionSource source = new TitleActionSource(ASSOCIATED_ENTITY_TYPE_SITE, "", Integer.toString(distSite.getId()));
        if (newTarget) {
            try {
                savedTitle = this.titleManager.create(copyTitle, true, (ITitleActionSource)source).getTitle();
            }
            catch (TitleValidationException titleValidationException) {}
            dst = new DistributionSiteTitle(distSite, copyTitle, DistributionStatus.TARGETED);
            this.getSession().saveOrUpdate((Object)dst);
            Set trackingSites = distSite.getChildren();
            if (trackingSites != null) {
                for (TrackingSite trackingSite : trackingSites) {
                    this.getSession().saveOrUpdate((Object)new TrackingSiteTitle(trackingSite, copyTitle, TrackingStatus.TARGETED));
                }
            }
        } else {
            dst = this.getDistributionSiteTitle(copyTitle.getId());
            if (dst.getStatus() == DistributionStatus.IN_PROGRESS) {
                logger.warn((Object)("Retargeting a title whose distribution is in progress. Distribution Site: " + dst.getDistributionSite().getId() + " | Local Title Id: " + copyTitle.getId()));
            }
            dst.setStatus(DistributionStatus.TARGETED);
            dst.setStatusDetail(DistributionStatusDetail.NONE.ordinal());
            this.getSession().saveOrUpdate((Object)dst);
        }
        try {
            savedTitle = this.titleManager.update(copyTitle, (ITitleActionSource)source).getTitle();
        }
        catch (TitleValidationException titleValidationException) {}
        this.updateAggregatedDistributionStatus(dst);
        this.saveSiteTitleInElasticSearch(savedTitle);
        return copyTitle;
    }

    private void saveSiteTitleInElasticSearch(Title title) {
        try {
            ServiceRegistry registry = ServiceRegistry.getDefault();
            IElasticSearchService esService = (IElasticSearchService)registry.lookup(IElasticSearchService.class);
            esService.saveTitle(title);
        }
        catch (Exception ex) {
            logger.error((Object)"Could not save site title", (Throwable)ex);
        }
    }

    private Set<Integer> getSitesInDependencyOrder(List<Integer> siteIds) {
        ISitesDepCacheService sitesDepSvc = (ISitesDepCacheService)InjectionUtil.injectInstance((String)"cms/SitesDepCacheService/local", ISitesDepCacheService.class);
        LinkedHashSet<Integer> targetedDistSiteIds = new LinkedHashSet<Integer>(siteIds);
        List allDependencySites = sitesDepSvc.getAllSitesFromReverseBFSOrder();
        LinkedHashSet<Integer> orderedTargetingSiteIds = new LinkedHashSet<Integer>();
        if (allDependencySites != null && !allDependencySites.isEmpty()) {
            for (Integer siteId : allDependencySites) {
                if (!targetedDistSiteIds.contains(siteId)) continue;
                orderedTargetingSiteIds.add(siteId);
                targetedDistSiteIds.remove(siteId);
            }
        }
        orderedTargetingSiteIds.addAll(targetedDistSiteIds);
        return orderedTargetingSiteIds;
    }

    public Set<Site> target(long masterTitleId, List<Integer> siteIds) throws SiteManagementException {
        if (siteIds == null || siteIds.isEmpty()) {
            throw new IllegalArgumentException("siteIds list is null or empty");
        }
        Title masterTitle = this.getMasterTitle(masterTitleId, false);
        ArrayList<Integer> parentDistSiteIds = new ArrayList<Integer>(siteIds);
        List<Integer> allDistSiteIdsToBeTargeted = this.getParentAndChildSites(parentDistSiteIds);
        Set<Integer> orderedTargetingSiteIds = this.getSitesInDependencyOrder(allDistSiteIdsToBeTargeted);
        LinkedHashSet<Site> targetedDistSites = new LinkedHashSet<Site>();
        for (Integer siteId : orderedTargetingSiteIds) {
            Site site = this.internalGetSite(siteId);
            if (!site.isActive()) {
                throw new InactiveSiteException(site);
            }
            if (site.getType() == SiteType.DISTRIBUTION) {
                targetedDistSites.add(site);
                continue;
            }
            throw new SiteManagementException("Can target only to Distribution or Logical site. Given site: " + siteId + " is of type: " + site.getType());
        }
        if (!targetedDistSites.isEmpty()) {
            this.target(masterTitle, targetedDistSites);
        }
        return targetedDistSites;
    }

    public TargetResult targetWithRules(long masterTitleId) {
        Title masterTitle = this.getMasterTitle(masterTitleId, false);
        Set siteIds = this.ruleExecHandler.getTargetedSites(masterTitle);
        LinkedHashSet<Site> activeDistSites = new LinkedHashSet<Site>();
        LinkedHashSet<Site> inactiveSites = new LinkedHashSet<Site>();
        if (siteIds != null) {
            ArrayList<Integer> parentDistSiteIds = new ArrayList<Integer>(siteIds);
            List<Integer> allDistSiteIdsToBeTargeted = this.getParentAndChildSites(parentDistSiteIds);
            Set<Integer> orderedTargetingSiteIds = this.getSitesInDependencyOrder(allDistSiteIdsToBeTargeted);
            for (Integer siteId : orderedTargetingSiteIds) {
                Site site = this.internalGetSite(siteId);
                if (site.isActive()) {
                    activeDistSites.add(site);
                    continue;
                }
                inactiveSites.add(site);
            }
        }
        if (!activeDistSites.isEmpty()) {
            this.target(masterTitle, activeDistSites);
        }
        return new TargetResult(activeDistSites, inactiveSites);
    }

    private List<Integer> getParentAndChildSites(List<Integer> parentDistSiteIds) {
        ArrayList<Integer> allSitesToBeTargeted = new ArrayList<Integer>(parentDistSiteIds);
        for (Integer siteId : parentDistSiteIds) {
            Site site = this.internalGetSite(siteId);
            if (site.getType() != SiteType.LOGICAL) continue;
            allSitesToBeTargeted.remove(site.getId());
            if (site.getSiteChildren() == null || site.getSiteChildren().isEmpty()) continue;
            for (Site child : site.getSiteChildren()) {
                allSitesToBeTargeted.add(child.getId());
            }
        }
        return allSitesToBeTargeted;
    }

    protected void target(Title masterTitle, Collection<Site> sites) {
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)"SM0103");
        message.setCommand(new WPCLCommand("create"));
        message.getPayload().putValue("titleId", String.valueOf(masterTitle.getId()));
        message.getPayload().putValue("siteIds", this.convertToCommaSeparatedListOfSiteIds(sites));
        SoapRouter router = new SoapRouter();
        try {
            router.send(new WPCLConverter().convert(message));
            logger.debug((Object)("Sent WPCL message to create targeting WO: " + message.toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String convertToCommaSeparatedListOfSiteIds(Collection<Site> sites) {
        StringBuffer sb = new StringBuffer();
        boolean firstTime = true;
        for (Site site : sites) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(",");
            }
            sb.append(site.getId());
        }
        return sb.toString();
    }

    public void distribute(long localTitleId) throws SiteManagementException {
        DistributionSite distSite = this.getAssociatedDistributionSite(localTitleId);
        if (distSite == null) {
            throw new SiteManagementException("Title with the given id: " + localTitleId + " is not associated with any Distribution Site");
        }
        this.distribute(distSite, localTitleId);
    }

    public void distributeImmediately(long localTitleId) throws SiteManagementException {
        try {
            DistributionSiteTitle dst = this.getDistributionSiteTitle(localTitleId);
            if (dst == null) {
                logger.error((Object)("No DistributionSiteTitle found by localTitleId : " + localTitleId));
                throw new SiteManagementException("No title exist with the given titleId: " + localTitleId);
            }
            this.distributeImmediately(dst);
            logger.info((Object)("Finished immediate distribution of localTitleId: " + localTitleId));
        }
        catch (SiteManagementException sme) {
            throw sme;
        }
        catch (Exception e) {
            logger.error((Object)("Failure in immediate distribution of localTitleId " + localTitleId), (Throwable)e);
            throw new RuntimeException("Failure in immediate distribution of localTitleId " + localTitleId, e);
        }
    }

    @Deprecated
    public void distribute(int siteId, List<Long> localTitleIds) throws SiteManagementException {
        if (localTitleIds == null) {
            throw new IllegalArgumentException("localTitleIds cannot be null");
        }
        DistributionSite distSite = this.getDistributionSite(siteId);
        for (Long localTitleId : localTitleIds) {
            this.distribute(distSite, localTitleId);
        }
    }

    private void hasExceededLicensedDistributionLimit(Long contentClassId) throws InvalidLicenseException {
        LicenseManager.getInstance().canDistributeTitle(new LicenseFilter.LicenseFilterBuilder().setContentClassId(contentClassId).build());
    }

    protected void distribute(DistributionSite distSite, long localTitleId) throws SiteManagementException {
        boolean isOffer;
        logger.debug((Object)("Distributing site title " + localTitleId + " for site " + distSite.getName()));
        if (!distSite.isActive()) {
            throw new InactiveSiteException((Site)distSite);
        }
        DistributionSiteTitle dst = this.getDistributionSiteTitle(distSite.getId(), localTitleId);
        if (dst == null) {
            throw new SiteManagementException("No title exist with the given titleId: " + localTitleId + " in the given site: " + distSite.getId());
        }
        if (dst.getStatus() != DistributionStatus.TARGETED && dst.getStatus() != DistributionStatus.WAITING_FOR_DEPENDENCY) {
            logger.debug((Object)("Distributing site title " + localTitleId + " status is " + dst.getStatus()));
            throw new SiteManagementException("Title must be in " + DistributionStatus.TARGETED + " or " + DistributionStatus.WAITING_FOR_DEPENDENCY + " status.");
        }
        try {
            isOffer = this.titleManager.isOffer(Long.valueOf(localTitleId));
        }
        catch (TitleValidationException e) {
            throw new SiteManagementException(e.getMessage());
        }
        long t1 = System.currentTimeMillis();
        if (isOffer) {
            logger.debug((Object)("It is an offer site title " + localTitleId));
            if (dst.getStatus() == DistributionStatus.TARGETED) {
                logger.debug((Object)("Updating the status of site title " + localTitleId + " to " + DistributionStatus.WAITING_FOR_DEPENDENCY));
                this.changeDistributionStatus(dst, DistributionStatus.WAITING_FOR_DEPENDENCY);
                DistTimeoutManager.getInstance().scheduleTimer(dst, SitesConfigurationUtil.getDistributionDependencyTimeOut());
            }
            if (dst.getStatus() == DistributionStatus.WAITING_FOR_DEPENDENCY && !this.isWaitingForReferencedSiteTitles(localTitleId)) {
                logger.debug((Object)("Site title " + localTitleId + " is not waiting for reference titles distribution."));
                if (distSite.getDistributionOption() == DistributionOption.DEPENDSON) {
                    if (!this.isWaitingForDependency(dst, distSite)) {
                        logger.debug((Object)("Site title " + localTitleId + " is not waiting for dependent site titles distribution."));
                        this.changeDistributionStatus(dst, DistributionStatus.READY_FOR_DISTRIBUTION);
                        this.distributeImmediately(dst);
                    }
                } else {
                    logger.debug((Object)"Distribution option is not depends-on, setting the status to Ready for Distribtuion.");
                    this.changeDistributionStatus(dst, DistributionStatus.READY_FOR_DISTRIBUTION);
                    if (distSite.getDistributionOption() == DistributionOption.IMMEDIATE) {
                        this.distributeImmediately(dst);
                    }
                }
            }
            long t2 = System.currentTimeMillis();
            logger.debug((Object)("Time to distribute offer - time:" + (t2 - t1)));
        } else {
            if (distSite.getDistributionOption() == DistributionOption.DEPENDSON) {
                if (dst.getStatus() == DistributionStatus.TARGETED) {
                    logger.debug((Object)("Changing the status of title " + localTitleId + " to Waiting for Dependency."));
                    this.changeDistributionStatus(dst, DistributionStatus.WAITING_FOR_DEPENDENCY);
                    DistTimeoutManager.getInstance().scheduleTimer(dst, SitesConfigurationUtil.getDistributionDependencyTimeOut());
                }
                if (dst.getStatus() == DistributionStatus.WAITING_FOR_DEPENDENCY && !this.isWaitingForDependency(dst, distSite)) {
                    logger.debug((Object)("Site title " + localTitleId + " is not Waiting for Dependency, distributing it now."));
                    this.changeDistributionStatus(dst, DistributionStatus.READY_FOR_DISTRIBUTION);
                    this.distributeImmediately(dst);
                }
            } else {
                logger.debug((Object)("Changing the status of title " + localTitleId + " to Ready for Distribution."));
                dst.setStatus(DistributionStatus.READY_FOR_DISTRIBUTION);
                this.getSession().saveOrUpdate((Object)dst);
                if (distSite.getDistributionOption() == DistributionOption.IMMEDIATE) {
                    this.distributeImmediately(dst);
                } else {
                    this.updateDistributionSiteTitleStatusInElasticSearch(localTitleId, dst.getDistributionSite().getId(), dst.getStatus().toString(), dst.getStatusUpdatedTime(), dst.getStatusDetail());
                }
            }
            long t3 = System.currentTimeMillis();
            logger.debug((Object)("Time to distribute title - time:" + (t3 - t1)));
        }
        this.updateAggregatedDistributionStatus(dst);
    }

    @Transactional
    private void changeDistributionStatus(DistributionSiteTitle dst, DistributionStatus distStatus) {
        dst.setStatus(distStatus);
        this.getSession().saveOrUpdate((Object)dst);
        this.updateAggregatedDistributionStatus(dst);
        this.updateDistributionSiteTitleStatusInElasticSearch(dst.getTitle().getId(), dst.getDistributionSite().getId(), dst.getStatus().toString(), dst.getStatusUpdatedTime(), dst.getStatusDetail());
    }

    private boolean isWaitingForReferencedSiteTitles(Long offerTitleId) throws SiteManagementException {
        List referencedSiteTitleIds;
        logger.debug((Object)("Checking for Reference Site Titles status for offer title " + offerTitleId));
        boolean isWaitingForReferencedSiteTitles = false;
        try {
            referencedSiteTitleIds = this.titleManager.getReferencedTitleIdsFromOffer(offerTitleId);
        }
        catch (TitleValidationException e) {
            throw new SiteManagementException(e.getMessage());
        }
        if (referencedSiteTitleIds != null && !referencedSiteTitleIds.isEmpty()) {
            logger.debug((Object)("List of reference titles " + referencedSiteTitleIds));
            for (Long refSiteTitleId : referencedSiteTitleIds) {
                DistributionSiteTitle siteTitle = this.getDistributionSiteTitle(refSiteTitleId);
                if (siteTitle.getStatus() == DistributionStatus.DISTRIBUTED) continue;
                logger.debug((Object)("Status of Reference title " + refSiteTitleId + " is " + siteTitle.getStatus()));
                isWaitingForReferencedSiteTitles = true;
                break;
            }
        }
        return isWaitingForReferencedSiteTitles;
    }

    private List<Long> getListOfWaitingReferencedTitles(Long offerTitleId) {
        List referencedSiteTitleIds;
        ArrayList<Long> waitingReferencedTitles = new ArrayList<Long>();
        try {
            referencedSiteTitleIds = this.titleManager.getReferencedTitleIdsFromOffer(offerTitleId);
        }
        catch (TitleValidationException e) {
            throw new SiteManagementException(e.getMessage());
        }
        for (Long refSiteTitleId : referencedSiteTitleIds) {
            DistributionSiteTitle siteTitle = this.getDistributionSiteTitle(refSiteTitleId);
            if (siteTitle.getStatus() == DistributionStatus.DISTRIBUTED) continue;
            waitingReferencedTitles.add(siteTitle.getTitle().getId());
        }
        return waitingReferencedTitles;
    }

    private boolean isWaitingForDependency(DistributionSiteTitle dst, DistributionSite distSite) {
        logger.debug((Object)"Check : Waiting for Dependency");
        boolean isWaiting = false;
        Long masterTitleId = dst.getTitle().getOriginalId();
        logger.debug((Object)("master title Id =" + masterTitleId));
        if (distSite.getDistributionOption() != DistributionOption.DEPENDSON) {
            logger.debug((Object)("return with isWaiting =" + isWaiting));
            return isWaiting;
        }
        logger.debug((Object)"ingestInstance SiteDepCacheService/local");
        ISitesDepCacheService sitesDepSvc = (ISitesDepCacheService)InjectionUtil.injectInstance((String)"cms/SitesDepCacheService/local", ISitesDepCacheService.class);
        logger.debug((Object)"get list of depedendent sites");
        List siteIds = sitesDepSvc.getImmediateDependOnSites(distSite.getId(), Boolean.valueOf(true));
        if (siteIds == null || siteIds.isEmpty()) {
            logger.debug((Object)"return as dependt site list is empty");
            return isWaiting;
        }
        List<Long> siteTitleIds = this.getSiteTitlesByMasterTitleId(masterTitleId, siteIds);
        logger.debug((Object)("Site Title:" + dst.getTitle().getId() + " , child title Ids:" + siteTitleIds));
        if (siteTitleIds == null || siteTitleIds.isEmpty()) {
            return isWaiting;
        }
        logger.debug((Object)("Child site titles for  site title " + dst.getTitle().getId() + " are " + siteTitleIds));
        try (Session sess = this.getNewSession();){
            DistributionSiteTitle curDst = (DistributionSiteTitle)sess.load(DistributionSiteTitle.class, (Serializable)dst.getId(), LockMode.UPGRADE);
            if (curDst.getStatus() != DistributionStatus.WAITING_FOR_DEPENDENCY) {
                boolean bl = isWaiting;
                return bl;
            }
            String siteTitleOriginalVersion = dst.getTitle().getOriginalVersion();
            logger.debug((Object)("Master Title version for parent site's site title " + dst.getTitle().getId() + " is " + siteTitleOriginalVersion));
            for (Long siteTitleId : siteTitleIds) {
                DistributionSiteTitle dependOnSiteTitle = this.getDistributionSiteTitle(siteTitleId);
                logger.debug((Object)("DistributionStatus: " + dependOnSiteTitle.getStatus() + " siteTitleOriginalVersion: " + siteTitleOriginalVersion + " OriginalVersion: " + dependOnSiteTitle.getTitle().getOriginalVersion()));
                if (dependOnSiteTitle.getStatus() == DistributionStatus.DISTRIBUTED && Integer.valueOf(siteTitleOriginalVersion) >= Integer.valueOf(dependOnSiteTitle.getTitle().getOriginalVersion())) continue;
                logger.debug((Object)("Condition for waiting for dependency satisfied, child site title " + dst.getTitle().getId() + "should continue waiting"));
                isWaiting = true;
                break;
            }
            logger.debug((Object)("IsWaiting is set to " + isWaiting));
            if (!isWaiting) {
                logger.debug((Object)("Changing from WAITING_FOR_DEPENDENCY to READY_FOR_DISTRIBUTION for site title:" + curDst.getTitle().getId()));
                curDst.setStatus(DistributionStatus.READY_FOR_DISTRIBUTION);
                sess.saveOrUpdate((Object)curDst);
            }
        }
        return isWaiting;
    }

    private List<Long> getSiteTitlesByMasterTitleId(Long masterTitleId, List<Integer> siteIds) {
        HashSet<Integer> siteIdsSet = new HashSet<Integer>(siteIds);
        List<Long> siteTitleIds = this.getSiteTitleIdsForMasterTitleAndSiteIds(masterTitleId, siteIdsSet);
        return siteTitleIds;
    }

    public void distributeReadyTitlesImmediately(int siteId) {
        this.distributeReadyTitlesImmediately(siteId, null);
    }

    private void distributeReadyTitlesImmediately(final int siteId, final List<Long> waitingList) throws SiteManagementException {
        DistributionSite distSite = this.getDistributionSite(siteId);
        if (!distSite.isActive()) {
            throw new InactiveSiteException((Site)distSite);
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                block12: {
                    logger.debug((Object)("Beginning asynchronous distribution of ready titles of site: " + siteId));
                    TransactionManager transactionManager = null;
                    try {
                        List<Long> dstIds;
                        transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
                        if (waitingList == null) {
                            transactionManager.begin();
                            dstIds = SiteManager.this.getDistributionSiteTitleIdsBySiteAndStatus(siteId, DistributionStatus.READY_FOR_DISTRIBUTION);
                            transactionManager.commit();
                        } else {
                            dstIds = waitingList;
                        }
                        for (Long dstId : dstIds) {
                            try {
                                transactionManager.begin();
                                DistributionSiteTitle dst = SiteManager.this.getDistributionSiteTitleById(dstId);
                                SiteManager.this.distributeImmediately(dst);
                                SiteManager.this.updateAggregatedDistributionStatus(dst);
                                transactionManager.commit();
                            }
                            catch (Exception e) {
                                logger.error((Object)("Failed to distribute distribution site title: " + dstId), (Throwable)e);
                                try {
                                    if (transactionManager.getTransaction() == null) continue;
                                    transactionManager.rollback();
                                }
                                catch (Exception e2) {
                                    logger.error((Object)"Unable to rollback the transaction", (Throwable)e2);
                                }
                            }
                        }
                        logger.debug((Object)("Finished asynchronous distribution of ready titles of site: " + siteId));
                    }
                    catch (Exception e) {
                        logger.error((Object)("Failure in asynchronous distribution of ready titles of site: " + siteId), (Throwable)e);
                        if (transactionManager == null) break block12;
                        try {
                            if (transactionManager.getTransaction() != null) {
                                transactionManager.rollback();
                            }
                        }
                        catch (Exception e2) {
                            logger.error((Object)"Unable to rollback the transaction", (Throwable)e2);
                        }
                    }
                }
            }
        });
        logger.info((Object)("Scheduled distribution of ready titles of site: " + siteId));
    }

    public void distributeImmediately(final int siteId, final List<Long> localTitleIds) throws InactiveSiteException {
        if (localTitleIds == null) {
            throw new IllegalArgumentException("localTitleIds cannot be null");
        }
        DistributionSite distSite = this.getDistributionSite(siteId);
        this.validateDistributionSiteforDistribution((Site)distSite);
        this.execute(new Runnable(){

            @Override
            public void run() {
                block10: {
                    logger.debug((Object)("Beginning asynchronous distribution of titles of site: " + siteId));
                    TransactionManager transactionManager = null;
                    try {
                        transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
                        for (Long localTitleId : localTitleIds) {
                            try {
                                transactionManager.begin();
                                DistributionSiteTitle dst = SiteManager.this.getDistributionSiteTitle(siteId, localTitleId);
                                SiteManager.this.validateTitleforDistribution(dst, localTitleId, siteId);
                                SiteManager.this.distributeImmediately(dst);
                                SiteManager.this.updateAggregatedDistributionStatus(dst);
                                transactionManager.commit();
                            }
                            catch (Exception e) {
                                logger.error((Object)("Exception occured distributing titleId : " + localTitleId + " of the given site : " + siteId + " : " + e), (Throwable)e);
                                try {
                                    if (transactionManager.getTransaction() == null) continue;
                                    transactionManager.rollback();
                                }
                                catch (Exception e2) {
                                    logger.error((Object)"Unable to rollback the transaction", (Throwable)e2);
                                }
                            }
                        }
                        logger.debug((Object)("Finished asynchronous distribution of titles of site: " + siteId));
                    }
                    catch (Exception e) {
                        logger.error((Object)("Failure in asynchronous distribution of ready titles of site: " + siteId), (Throwable)e);
                        if (transactionManager == null) break block10;
                        try {
                            if (transactionManager.getTransaction() != null) {
                                transactionManager.rollback();
                            }
                        }
                        catch (Exception e2) {
                            logger.error((Object)"Unable to rollback the transaction", (Throwable)e2);
                        }
                    }
                }
            }
        });
        logger.info((Object)("Scheduled distribution of titles of site: " + siteId));
    }

    public void validateDistributionSiteforDistribution(Site distSite) {
        if (distSite == null) {
            throw new RuntimeException("No distribution site with given id exists.");
        }
        if (distSite.getType() != SiteType.DISTRIBUTION) {
            throw new RuntimeException("Given siteId: " + distSite.getId() + " does not correspond to a Distribution Site");
        }
        if (!distSite.isActive()) {
            throw new InactiveSiteException(distSite);
        }
    }

    public void validateTitleforDistribution(DistributionSiteTitle dst, long localTitleId, int siteId) {
        boolean isOffer;
        if (dst == null) {
            throw new SiteManagementException("No title exist with the given titleId: " + localTitleId + " in the given site: " + siteId);
        }
        if (dst.getStatus() == DistributionStatus.TARGETED || dst.getStatus() == DistributionStatus.IN_PROGRESS) {
            throw new SiteManagementException("Cannot distribute title: " + localTitleId + ", status is: " + dst.getStatus());
        }
        try {
            isOffer = this.titleManager.isOffer(Long.valueOf(localTitleId));
        }
        catch (TitleValidationException e) {
            throw new SiteManagementException(e.getMessage());
        }
        if (isOffer && dst.getStatus() == DistributionStatus.WAITING_FOR_DEPENDENCY) {
            throw new SiteManagementException("Cannot distribute offer title: " + localTitleId + ", referenced site titles " + this.getListOfWaitingReferencedTitles(localTitleId) + " are not distributed successfully.");
        }
    }

    private void execute(Runnable r) {
        new Thread(r).start();
    }

    protected void distributeImmediately(DistributionSiteTitle dst) {
        SiteStatusCollection statuses = new SiteStatusCollection();
        dst.setStatus(DistributionStatus.IN_PROGRESS);
        Title title = dst.getTitle();
        dst.setDistributedVersion(title.getVersion());
        boolean limitExceeded = false;
        String error_string = null;
        try {
            this.hasExceededLicensedDistributionLimit(title.getContentClassId());
        }
        catch (Exception e) {
            limitExceeded = true;
            error_string = e.getMessage();
        }
        if (limitExceeded) {
            dst.setStatus(DistributionStatus.FAILED);
            if (error_string.contains("Cannot distribute")) {
                dst.setStatusDetail(DistributionStatusDetail.INVALID_LICENSE.ordinal());
            } else {
                dst.setStatusDetail(DistributionStatusDetail.DISTRIBUTION_LIMIT_EXCEEDED.ordinal());
            }
            logger.info((Object)("Distribution limit exceeded: " + dst));
            int distSiteId = dst.getDistributionSite().getId();
            statuses.setDistributionStatus(distSiteId, dst.getStatus().toString(), dst.getStatusUpdatedTime(), dst.getStatusDetail());
            this.updateSiteTitleStatusesInElasticSearch(dst.getTitle().getId(), statuses);
            this.updateAggregatedDistributionStatus(dst);
            return;
        }
        int distSiteId = dst.getDistributionSite().getId();
        statuses.setDistributionStatus(distSiteId, dst.getStatus().toString(), dst.getStatusUpdatedTime(), dst.getStatusDetail());
        DistTimeoutManager.getInstance().scheduleTimer(dst, (int)dst.getDistributionSite().getAlertDelayPeriod());
        DistributionSite distSite = dst.getDistributionSite();
        Set trackingSites = distSite.getChildren();
        if (trackingSites != null) {
            for (TrackingSite ts : trackingSites) {
                TrackingSiteTitle tst = this.getTrackingSiteTitle(ts.getId(), dst.getTitle().getId());
                if (tst != null) {
                    tst.setStatus(TrackingStatus.TARGETED);
                } else {
                    tst = new TrackingSiteTitle(ts, dst.getTitle(), TrackingStatus.TARGETED);
                    this.getSession().saveOrUpdate((Object)tst);
                }
                statuses.addTrackingSiteStatus(ts.getId().intValue(), TrackingStatus.TARGETED.toString(), tst.getStatusUpdatedTime());
            }
        }
        this.updateSiteTitleStatusesInElasticSearch(dst.getTitle().getId(), statuses);
        this.updateAggregatedDistributionStatus(dst);
        logger.info((Object)("Distributing Title: " + dst));
        String resourceConnectionString = distSite.getAssociatedResourceId() != null ? this.getResourceConnectionString(distSite.getAssociatedResourceId()) : null;
        DistributionManager.getInstance().distribute(distSite.getId(), dst.getTitle().getId(), distSite.getDistTemplateName(), resourceConnectionString, distSite.getDistConfParams());
    }

    private String getResourceConnectionString(Long resourceId) {
        try {
            Resource resource = this.getResource(resourceId);
            if (resource != null) {
                return resource.getUrl();
            }
        }
        catch (IOException e) {
            logger.warn((Object)("Failed to get Resource connection string for resource: " + resourceId), (Throwable)e);
        }
        return null;
    }

    public void updateDistributionStatus(DistributionSiteTitle siteTitle, DistributionStatus status) {
        logger.debug((Object)("Updating distribution status for retry for title " + siteTitle.getTitle().getId() + " with distribution status " + status));
        long t1 = System.currentTimeMillis();
        if (status != DistributionStatus.IN_PROGRESS) {
            throw new RuntimeException("Status cannot be requested to be set to anything other than: " + DistributionStatus.IN_PROGRESS + " | Requested to set to: " + status);
        }
        this.changeDistributionStatus(siteTitle, status);
        long t2 = System.currentTimeMillis();
        logger.debug((Object)("Time to update distribution status for retry - time:" + (t2 - t1)));
    }

    public void updateDistributionStatus(long localTitleId, DistributionStatus status) {
        this.updateDistributionStatus(localTitleId, status, null);
    }

    public void updateDistributionStatus(long localTitleId, DistributionStatus status, ITitleActionSource source) {
        logger.debug((Object)("Updating distribution status for title " + localTitleId + " with distribution status " + status));
        long t1 = System.currentTimeMillis();
        if (status != DistributionStatus.DISTRIBUTED && status != DistributionStatus.FAILED) {
            throw new RuntimeException("Status cannot be requested to be set to anything other than: " + DistributionStatus.DISTRIBUTED + " and " + DistributionStatus.FAILED + " | Requested to set to: " + status);
        }
        DistributionSiteTitle dst = this.getDistributionSiteTitle(localTitleId);
        if (dst == null) {
            throw new RuntimeException("No title found with id: " + localTitleId + " in any Distribution Site");
        }
        if (dst.getStatus() == DistributionStatus.TARGETED || dst.getStatus() == DistributionStatus.READY_FOR_DISTRIBUTION) {
            logger.info((Object)("Ignoring distribution status update for [local title id: " + localTitleId + " | site id: " + dst.getDistributionSite().getId() + " | status: " + status + "] Reason: Title must have got retargeted. Title is in status: " + dst.getStatus()));
            return;
        }
        this.changeDistributionStatus(dst, status);
        if (status == DistributionStatus.FAILED || status == DistributionStatus.DISTRIBUTED) {
            String description;
            DistTimeoutManager.getInstance().cancelTimer(dst);
            String string = description = status == DistributionStatus.DISTRIBUTED ? DISTRIBUTION_SUCCESS : DISTRIBUTION_FAILED;
            if (source == null) {
                source = new TitleActionSource(ASSOCIATED_ENTITY_TYPE_SITE, "", Integer.toString(dst.getDistributionSite().getId()));
                description = String.valueOf(description) + DISTRIBUTION_TIMEOUT;
            }
            ProgressManager.newInstance().updateStatus(dst.getTitle().getId().longValue(), null, ProgressStatusHelper.DISTRIBUTED, description, true, source.getComponentName(), source.getEntityName(), source.getID());
        }
        long t2 = System.currentTimeMillis();
        logger.debug((Object)("Time to update distribution status - time:" + (t2 - t1)));
        if (status == DistributionStatus.DISTRIBUTED) {
            DistributionRetry.getInstance().removeSiteTitleAttempts(dst.getTitle().getId());
            List siteOfferTitleIds = null;
            logger.debug((Object)"Checking dependency.");
            try {
                if (this.titleManager.isPackage(Long.valueOf(localTitleId))) {
                    siteOfferTitleIds = this.titleManager.getOfferIds(Long.valueOf(localTitleId));
                    logger.debug((Object)("Site Title Id " + localTitleId + " is associated with Offers: " + siteOfferTitleIds));
                }
            }
            catch (TitleValidationException e) {
                throw new RuntimeException(e.getMessage());
            }
            if (siteOfferTitleIds != null && !siteOfferTitleIds.isEmpty()) {
                for (Long siteOfferTitleId : siteOfferTitleIds) {
                    DistributionSiteTitle dsot = this.getDistributionSiteTitle(siteOfferTitleId);
                    if (!dsot.getStatus().equals((Object)DistributionStatus.WAITING_FOR_DEPENDENCY)) continue;
                    logger.debug((Object)("Calling distribute for siteOffer TitleId:" + siteOfferTitleId));
                    this.distribute(siteOfferTitleId);
                    logger.debug((Object)("Came out of distribute for" + siteOfferTitleId));
                }
            }
            DistributionSite distSite = this.getAssociatedDistributionSite(localTitleId);
            ISitesDepCacheService sitesDepSvc = (ISitesDepCacheService)InjectionUtil.injectInstance((String)"cms/SitesDepCacheService/local", ISitesDepCacheService.class);
            List parentSiteIds = sitesDepSvc.getImmediateDependentSites(distSite.getId());
            if (parentSiteIds != null && !parentSiteIds.isEmpty()) {
                Long masterTitleId = dst.getTitle().getOriginalId();
                this.distributeParentSiteTitlesOnWaitState(masterTitleId, parentSiteIds);
            }
            if (dst.getDistributionSite() != null && dst.getDistributionSite().getId() != null) {
                StringBuilder sb = new StringBuilder(TITLES_DISTRIBUTED_BY_SITE);
                sb.append(".").append(dst.getDistributionSite().getName()).append("_").append(dst.getDistributionSite().getId()).append(" 1 ").append(System.currentTimeMillis());
                METRICS_LOGGER.info((Object)sb.toString());
            }
        }
        long t3 = System.currentTimeMillis();
        logger.debug((Object)("Time to trigger dependency distribution - time:" + (t3 - t2)));
    }

    private void distributeParentSiteTitlesOnWaitState(final Long masterTitleId, final List<Integer> parentSiteIds) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                block7: {
                    TransactionManager transactionManager = null;
                    try {
                        transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
                        transactionManager.begin();
                        List siteTitleIds = SiteManager.this.getSiteTitlesByMasterTitleId(masterTitleId, parentSiteIds);
                        logger.debug((Object)("Trying to trigger distribution for site titles " + siteTitleIds + " associated with parent sites "));
                        if (siteTitleIds != null && !siteTitleIds.isEmpty()) {
                            for (Long siteTitleId : siteTitleIds) {
                                DistributionSiteTitle dspt = SiteManager.this.getDistributionSiteTitle(siteTitleId);
                                if (!dspt.getStatus().equals((Object)DistributionStatus.WAITING_FOR_DEPENDENCY)) continue;
                                logger.debug((Object)("Calling distribute for site TitleId:" + siteTitleId));
                                SiteManager.this.distribute(siteTitleId);
                                logger.debug((Object)("Came out of distribute for " + siteTitleId));
                            }
                        }
                        transactionManager.commit();
                    }
                    catch (Exception e) {
                        logger.error((Object)("Failure in trying to check and distribute parent site titles on wait state : masterTitleId=" + masterTitleId), (Throwable)e);
                        if (transactionManager == null) break block7;
                        try {
                            if (transactionManager.getTransaction() != null) {
                                transactionManager.rollback();
                            }
                        }
                        catch (Exception e2) {
                            logger.error((Object)"Unable to rollback the transaction", (Throwable)e2);
                        }
                    }
                }
            }
        });
    }

    public void updateTrackingStatus(int siteId, long localTitleId, TrackingStatus status) {
        if (status == TrackingStatus.TARGETED) {
            throw new RuntimeException("Status cannot be requested to be set to: " + status);
        }
        TrackingSite ts = this.getTrackingSite(siteId);
        TrackingSiteTitle tst = this.getTrackingSiteTitle(siteId, localTitleId);
        if (tst == null) {
            throw new RuntimeException("Title with given id: " + localTitleId + " is not found in site: " + siteId);
        }
        tst.setStatus(status);
        this.getSession().saveOrUpdate((Object)tst);
        this.updateTrackingSiteTitleStatusInElasticSearch(localTitleId, siteId, status.toString(), tst.getStatusUpdatedTime());
        if (status == TrackingStatus.DEPLOYMENT_IN_PROGRESS) {
            DistTimeoutManager.getInstance().scheduleTimer(tst, (int)ts.getAlertDelayPeriod());
        }
        if (status == TrackingStatus.DEPLOYED || status == TrackingStatus.DEPLOYMENT_FAILED) {
            DistTimeoutManager.getInstance().cancelTimer(tst);
        }
    }

    public void updateTitlesStatusFromInProgressToFailed() {
        List<DistributionSiteTitle> distributionSiteTitleList = this.getDistributionSiteTitlesByStatus(DistributionStatus.IN_PROGRESS);
        this.getSession().createQuery("Update DistributionSiteTitle set status = " + DistributionStatus.FAILED.ordinal() + " where status = " + DistributionStatus.IN_PROGRESS.ordinal()).executeUpdate();
        logger.info((Object)("Updated " + distributionSiteTitleList.size() + " distribution site titles status from " + DistributionStatus.IN_PROGRESS + " to " + DistributionStatus.FAILED));
        int updatedRecordsCount = this.getSession().createQuery("Update TrackingSiteTitle set status = " + TrackingStatus.DEPLOYMENT_FAILED.ordinal() + " where status = " + TrackingStatus.DEPLOYMENT_IN_PROGRESS.ordinal()).executeUpdate();
        logger.info((Object)("Updated " + updatedRecordsCount + " tracking site titles status from " + TrackingStatus.DEPLOYMENT_IN_PROGRESS + " to " + TrackingStatus.DEPLOYMENT_FAILED));
        this.updateStatusToFailed(distributionSiteTitleList);
    }

    public void restartTimerForWaitingForDependencyTitles() {
        List<DistributionSiteTitle> distributionSiteTitleList = this.getDistributionSiteTitlesByStatus(DistributionStatus.WAITING_FOR_DEPENDENCY);
        for (DistributionSiteTitle dst : distributionSiteTitleList) {
            DistTimeoutManager.getInstance().scheduleTimer(dst, SitesConfigurationUtil.getDistributionDependencyTimeOut());
        }
        logger.info((Object)("Restart Distribution Dependency Timeout for " + distributionSiteTitleList.size() + " distribution site titles status " + DistributionStatus.WAITING_FOR_DEPENDENCY));
    }

    private void updateStatusToFailed(List<DistributionSiteTitle> distributionSiteTitleList) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        IElasticSearchService elasticSearchService = (IElasticSearchService)registry.lookup(IElasticSearchService.class);
        Session session = this.getSession();
        Transaction tx = session.beginTransaction();
        int i = 0;
        HashSet<Long> updatedTitleIds = new HashSet<Long>();
        for (DistributionSiteTitle dst : distributionSiteTitleList) {
            Long masterTitleId = (dst = this.getDistributionSiteTitleById(dst.getId())).getTitle().getOriginalId();
            if (!updatedTitleIds.contains(masterTitleId)) {
                logger.debug((Object)("Saving aggregated distribution status for Master Title" + masterTitleId));
                this.titleManager.updateDistributionStatus(masterTitleId, DistributionStatus.FAILED.toString());
            }
            try {
                if (!updatedTitleIds.contains(masterTitleId)) {
                    logger.debug((Object)("ES:Saving aggregated distribution status for Master Title" + masterTitleId));
                    elasticSearchService.updateMasterTitleDistributionStatus(masterTitleId.longValue(), DistributionStatus.FAILED.toString());
                    updatedTitleIds.add(masterTitleId);
                }
                logger.debug((Object)("ES:Save Distribution Status for Site Title " + dst.getTitle().getId()));
                this.updateDistributionSiteTitleStatusInElasticSearch(dst.getTitle().getId(), dst.getDistributionSite().getId(), DistributionStatus.FAILED.toString(), new Date(), dst.getStatusDetail());
            }
            catch (Exception ex) {
                throw new TitlePersistenceException("Could not update ElasticSearch", (Throwable)ex);
            }
            if (i % 50 == 0) {
                session.flush();
                session.clear();
            }
            ++i;
        }
        tx.commit();
        logger.info((Object)("Number of distribution site titles updated to FAILED = " + distributionSiteTitleList.size()));
    }

    public Map<Title, Exception> purgeSiteTitles(long masterTitleId) {
        HashMap<Title, Exception> failedTitles = new HashMap<Title, Exception>();
        for (Title localTitle : this.getSiteCopies(masterTitleId)) {
            try {
                this.ruleExecHandler.runRuler(localTitle, TreEvent.PURGE, new TrePackage("PROCESSING"));
            }
            catch (Exception e) {
                failedTitles.put(localTitle, e);
            }
        }
        return failedTitles;
    }

    @Deprecated
    public void delete(long localTitleId) {
        this.deleteTitle(localTitleId);
    }

    private void checkReferencesForDelete(long localTitleId) {
        boolean isPackage;
        try {
            isPackage = this.titleManager.isPackage(Long.valueOf(localTitleId));
        }
        catch (TitleValidationException e) {
            throw new SiteManagementException((Throwable)e);
        }
        if (isPackage) {
            List siteOfferIds = null;
            try {
                siteOfferIds = this.titleManager.getOfferIds(Long.valueOf(localTitleId));
            }
            catch (TitleValidationException e) {
                throw new SiteManagementException((Throwable)e);
            }
            if (siteOfferIds != null && siteOfferIds.size() > 0) {
                String message = ". Cannot delete a site title that is referenced in site offers :" + siteOfferIds.toString();
                throw new SiteManagementException("SITE_OFFER_EX", message);
            }
        }
    }

    public void deleteTitle(long localTitleId) {
        this.checkReferencesForDelete(localTitleId);
        DistributionSiteTitle dst = this.getDistributionSiteTitle(localTitleId);
        if (dst == null) {
            throw new RuntimeException("No title found with id: " + localTitleId + " in any Distribution Site");
        }
        Set trackingSites = dst.getDistributionSite().getChildren();
        for (TrackingSite ts : trackingSites) {
            TrackingSiteTitle tst = this.getTrackingSiteTitle(ts.getId(), localTitleId);
            if (tst == null) continue;
            this.getSession().delete((Object)tst);
        }
        RulesEngineFacade.sendDeletedEvent((Long)localTitleId);
        this.getSession().delete((Object)dst);
        this.titleManager.delete(Long.valueOf(localTitleId));
        this.updateAggregatedDistributionStatus(dst);
    }

    public void deleteDistributionSiteTitles(int distributionSiteId) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE TrackingSiteTitle tst WHERE tst.title.id IN ");
        sb.append("(SELECT dst.title.id FROM DistributionSiteTitle dst ");
        sb.append("WHERE dst.distributionSite.id = :distributionSiteId)");
        Session session = this.getSession();
        Query query = session.createQuery(sb.toString());
        query.setParameter(DISTRIBUTION_SITE_ID, (Object)distributionSiteId);
        query.executeUpdate();
        StringBuilder sb2 = new StringBuilder();
        sb2.append("DELETE DistributionSiteTitle WHERE distributionSite.id = :distributionSiteId");
        Query query2 = this.getSession().createQuery(sb2.toString());
        query2.setParameter(DISTRIBUTION_SITE_ID, (Object)distributionSiteId);
        int updateSize = query2.executeUpdate();
        Thread thread = new Thread(new DistributionSiteTitleProcessor(distributionSiteId, updateSize));
        thread.start();
    }

    public void deleteTrackingSiteTitle(long localTitleId, int trackingSiteId) {
        TrackingSiteTitle tst = this.getTrackingSiteTitle(localTitleId, trackingSiteId);
        if (tst == null) {
            throw new RuntimeException("No title found with id: " + localTitleId + " in Tracking Site: " + trackingSiteId);
        }
        this.getSession().delete((Object)tst);
        try {
            ServiceRegistry registry = ServiceRegistry.getDefault();
            IElasticSearchService esService = (IElasticSearchService)registry.lookup(IElasticSearchService.class);
            esService.deleteTrackingSiteTitle(localTitleId, trackingSiteId);
        }
        catch (Exception ex) {
            logger.error((Object)"Could not delete tracking site title", (Throwable)ex);
        }
    }

    public void deleteTrackingSiteTitles(int trackingSiteId, int distributionSiteId) {
        String queryStr = "DELETE TrackingSiteTitle WHERE trackingSite.id = :trackingSiteId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("trackingSiteId", (Object)trackingSiteId);
        query.executeUpdate();
        try {
            ServiceRegistry registry = ServiceRegistry.getDefault();
            IElasticSearchService esService = (IElasticSearchService)registry.lookup(IElasticSearchService.class);
            esService.deleteTrackingSiteTitles(trackingSiteId, distributionSiteId);
        }
        catch (Exception ex) {
            logger.error((Object)"Could not delete tracking site title", (Throwable)ex);
        }
    }

    public Job getTimerJob(DistributionSite distSite) {
        Job timerJob = null;
        List jobs = this.scheduler.getJobsByAssociatedEntity(ASSOCIATED_ENTITY_TYPE_SITE_TIMER, (long)distSite.getId().intValue());
        if (jobs != null && jobs.size() > 0) {
            timerJob = (Job)jobs.get(0);
        }
        return timerJob;
    }

    protected LogicalSite getLogicalSite(int siteId) {
        Site site = this.internalGetSite(siteId);
        if (site.getType() != SiteType.LOGICAL) {
            throw new RuntimeException("Given siteId: " + siteId + " does not correspond to a Logical Site");
        }
        return (LogicalSite)site;
    }

    protected DistributionSite getDistributionSite(int siteId) {
        Site site = this.internalGetSite(siteId);
        if (site.getType() != SiteType.DISTRIBUTION) {
            throw new RuntimeException("Given siteId: " + siteId + " does not correspond to a Distribution Site");
        }
        return (DistributionSite)site;
    }

    protected TrackingSite getTrackingSite(int siteId) {
        Site site = this.internalGetSite(siteId);
        if (site.getType() != SiteType.TRACKING) {
            throw new RuntimeException("Given siteId: " + siteId + " does not correspond to a Tracking Site");
        }
        return (TrackingSite)site;
    }

    protected Site internalGetSite(int siteId) {
        Site site = this.getSite(siteId);
        if (site == null) {
            throw new RuntimeException("No site found for the given id: " + siteId);
        }
        return site;
    }

    protected Title getMasterTitle(long titleId, boolean lock) {
        Title title;
        Title title2 = title = lock ? this.titleManager.getForUpdate(Long.valueOf(titleId)) : this.titleManager.get(Long.valueOf(titleId));
        if (title == null) {
            throw new SiteManagementException("No master title found for the given id: " + titleId);
        }
        if (!title.getIsActive().booleanValue()) {
            throw new SiteManagementException("The master title for id: " + titleId + " is inactive.");
        }
        if (title.isCopy()) {
            throw new SiteManagementException("Failed to get master title for id: " + titleId + ", title with given id is not a master title.");
        }
        return title;
    }

    protected Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    protected Session getNewSession() {
        return HibernateContext.getContext().openSession();
    }

    public List<Long> getRecentDistributionActivity(int startIndex, int pageSize, boolean isAscending, List<Long> partnerIdsFilter) {
        SortOrder sortingOrder = isAscending ? SortOrder.ASCENDING : SortOrder.DESCENDING;
        SortingInfo sortingInfo = new SortingInfo("distributionStatusUpdatedTime", sortingOrder, null, FieldType.PMM_TITLE);
        TitleFilter tFilter = new TitleFilter(null, sortingInfo, new PagingInfo(startIndex, 1000));
        tFilter.setCriteriaMode(CriteriaMode.SITE);
        ArrayList<SearchColumn> searchColumns = new ArrayList<SearchColumn>();
        searchColumns.add(new SearchColumn(null, "originalId", FieldType.PMM_TITLE, "integer", false));
        TitleSearchResult result = this.searchService.getSearchResults(tFilter, partnerIdsFilter, searchColumns);
        List searchRows = result.getRows();
        if (searchRows.size() == 0) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> masterTitleIds = new ArrayList<Long>();
        for (TitleSearchResult.SearchRow searchRow : searchRows) {
            long masterTitleId = Long.parseLong(searchRow.getFirstValueAsString(0));
            if (masterTitleIds.contains(masterTitleId)) continue;
            masterTitleIds.add(masterTitleId);
        }
        int end = masterTitleIds.size() - startIndex < pageSize ? masterTitleIds.size() : startIndex + masterTitleIds.size();
        return masterTitleIds.subList(startIndex, end);
    }

    public List<DistributionSiteTitle> getDistributionSiteTitlesByMasterTitleId(long masterTitleId) {
        String queryStr = "FROM DistributionSiteTitle WHERE title.originalId = :masterTitleId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter(MASTER_TITLE_ID, (Object)masterTitleId);
        List siteTitles = query.list();
        return siteTitles;
    }

    public int getMasterTitleCountOfLogicalSite(int logicalSiteId, List<Long> partnerIds) {
        List res;
        String queryStr = "SELECT count(distinct dst.title.originalId) FROM DistributionSiteTitle dst WHERE dst.distributionSite.parent.id = :logicalSiteId";
        if (!partnerIds.isEmpty()) {
            queryStr = String.valueOf(queryStr) + " AND  dst.title.partnerId in (:partners) ";
        }
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("logicalSiteId", (Object)logicalSiteId);
        if (!partnerIds.isEmpty()) {
            query.setParameterList("partners", partnerIds);
        }
        if ((res = query.list()).size() > 0) {
            return ((Long)res.get(0)).intValue();
        }
        return 0;
    }

    public int getMasterTitleCountOfDistributionSite(int distSiteId, List<Long> partnerIds) {
        List res;
        StringBuilder queryStr = new StringBuilder("SELECT count(distinct dst.title.originalId) FROM DistributionSiteTitle dst WHERE dst.distributionSite.id = :distSiteId ");
        if (!partnerIds.isEmpty()) {
            queryStr.append("AND dst.title.partnerId in (:partners) ");
        }
        Session session = this.getSession();
        Query query = session.createQuery(queryStr.toString());
        query.setParameter("distSiteId", (Object)distSiteId);
        if (!partnerIds.isEmpty()) {
            query.setParameterList("partners", partnerIds);
        }
        if ((res = query.list()).size() > 0) {
            return ((Long)res.get(0)).intValue();
        }
        return 0;
    }

    public List<Long> getMasterTitleIdsOfLogicalSite(int logicalSiteId, int startIndex, int pageSize, boolean isAscending, List<Long> partnerIds) {
        StringBuilder queryStr = new StringBuilder("SELECT t.originalId FROM DistributionSiteTitle dst JOIN dst.title t WHERE dst.distributionSite.parent.id = :logicalSiteId ");
        if (!partnerIds.isEmpty()) {
            queryStr.append("AND t.partnerId in (:partners) ");
        }
        queryStr.append("group by t.originalId order by t.originalId ");
        queryStr.append(isAscending ? "ASC" : "DESC");
        Session session = this.getSession();
        Query query = session.createQuery(queryStr.toString());
        query.setMaxResults(pageSize);
        query.setFirstResult(startIndex);
        query.setParameter("logicalSiteId", (Object)logicalSiteId);
        if (!partnerIds.isEmpty()) {
            query.setParameterList("partners", partnerIds);
        }
        List masterTitleIds = query.list();
        return masterTitleIds;
    }

    public List<Long> getMasterTitleIdsOfDistributionSite(int distSiteId, int startIndex, int pageSize, boolean isAscending, List<Long> partnerIds) {
        StringBuilder queryStr = new StringBuilder("SELECT t.originalId FROM DistributionSiteTitle dst JOIN dst.title t WHERE dst.distributionSite.id = :distSiteId ");
        if (!partnerIds.isEmpty()) {
            queryStr.append("AND t.partnerId in (:partners) ");
        }
        queryStr.append("GROUP BY t.originalId ORDER BY t.originalId ");
        queryStr.append(isAscending ? "ASC" : "DESC");
        Session session = this.getSession();
        Query query = session.createQuery(queryStr.toString());
        query.setMaxResults(pageSize);
        query.setFirstResult(startIndex);
        query.setParameter("distSiteId", (Object)distSiteId);
        if (!partnerIds.isEmpty()) {
            query.setParameterList("partners", partnerIds);
        }
        List masterTitleIds = query.list();
        return masterTitleIds;
    }

    public List<List<?>> getAggDistStatusCountsOfLogicalSite(int logicalSiteId, boolean isAscending, long startMasterTitleId, long endMasterTitleId, List<Long> partnerIds) {
        StringBuilder queryStr = new StringBuilder("SELECT new list(t.originalId, dst.status, count(*)) FROM DistributionSiteTitle dst JOIN dst.title t WHERE dst.distributionSite.parent.id = :logicalSiteId AND t.originalId >= :startMasterTitleId and t.originalId <= :endMasterTitleId ");
        if (!partnerIds.isEmpty()) {
            queryStr.append("AND t.partnerId in (:partners) ");
        }
        queryStr.append("group by t.originalId, dst.status order by t.originalId ");
        queryStr.append(isAscending ? "ASC" : "DESC");
        Session session = this.getSession();
        Query query = session.createQuery(queryStr.toString());
        query.setParameter("logicalSiteId", (Object)logicalSiteId);
        query.setParameter("startMasterTitleId", (Object)startMasterTitleId);
        query.setParameter("endMasterTitleId", (Object)endMasterTitleId);
        if (!partnerIds.isEmpty()) {
            query.setParameterList("partners", partnerIds);
        }
        List aggDistCounts = query.list();
        return aggDistCounts;
    }

    public List<List<?>> getAggDistStatusCountsOfDistributionSite(int distSiteId, boolean isAscending, long startMasterTitleId, long endMasterTitleId, List<Long> partnerIds) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("SELECT new list(t.originalId, dst.status, count(*))");
        queryStr.append("FROM DistributionSiteTitle dst JOIN dst.title t WHERE ");
        if (!partnerIds.isEmpty()) {
            queryStr.append("t.partnerId in (:partners) AND ");
        }
        queryStr.append("dst.distributionSite.id = :distSiteId and ");
        queryStr.append("t.originalId >= :startMasterTitleId and t.originalId <= :endMasterTitleId ");
        queryStr.append("group by t.originalId, dst.status order by t.originalId ");
        queryStr.append(isAscending ? "ASC" : "DESC");
        Session session = this.getSession();
        Query query = session.createQuery(queryStr.toString());
        query.setParameter("distSiteId", (Object)distSiteId);
        query.setParameter("startMasterTitleId", (Object)startMasterTitleId);
        query.setParameter("endMasterTitleId", (Object)endMasterTitleId);
        if (!partnerIds.isEmpty()) {
            query.setParameterList("partners", partnerIds);
        }
        List aggDistCounts = query.list();
        return aggDistCounts;
    }

    public List<List<?>> getAggTrackStatusCountsOfLogicalSite(int logicalSiteId, boolean isAscending, long startMasterTitleId, long endMasterTitleId, List<Long> partnerIds) {
        StringBuilder queryStr = new StringBuilder("SELECT new list(tst.title.originalId, tst.status, count(*)) FROM TrackingSiteTitle tst JOIN tst.trackingSite.parents distSite JOIN distSite.distributionSiteTitles dst WHERE tst.title.id = dst.title.id AND distSite.parent.id = :logicalSiteId AND tst.title.originalId >= :startMasterTitleId AND tst.title.originalId <= :endMasterTitleId ");
        if (!partnerIds.isEmpty()) {
            queryStr.append("AND dst.title.partnerId in (:partners) ");
        }
        queryStr.append("group by tst.title.originalId, tst.status order by tst.title.originalId ");
        queryStr.append(isAscending ? "ASC" : "DESC");
        Session session = this.getSession();
        Query query = session.createQuery(queryStr.toString());
        query.setParameter("logicalSiteId", (Object)logicalSiteId);
        query.setParameter("startMasterTitleId", (Object)startMasterTitleId);
        query.setParameter("endMasterTitleId", (Object)endMasterTitleId);
        if (!partnerIds.isEmpty()) {
            query.setParameterList("partners", partnerIds);
        }
        List aggTrackCounts = query.list();
        return aggTrackCounts;
    }

    public List<List<?>> getAggTrackStatusCountsOfDistributionSite(int distSiteId, boolean isAscending, long startMasterTitleId, long endMasterTitleId, List<Long> partnerIds) {
        StringBuilder queryStr = new StringBuilder("SELECT new list(tst.title.originalId, tst.status, count(*)) FROM TrackingSiteTitle tst join tst.trackingSite.parents distSite join distSite.distributionSiteTitles dst WHERE tst.title.id = dst.title.id and distSite.id = :distSiteId AND tst.title.originalId >= :startMasterTitleId AND tst.title.originalId <= :endMasterTitleId ");
        if (!partnerIds.isEmpty()) {
            queryStr.append("AND dst.title.partnerId in (:partners) ");
        }
        queryStr.append("group by tst.title.originalId, tst.status order by tst.title.originalId ");
        queryStr.append(isAscending ? "ASC" : "DESC");
        Session session = this.getSession();
        Query query = session.createQuery(queryStr.toString());
        query.setParameter("distSiteId", (Object)distSiteId);
        query.setParameter("startMasterTitleId", (Object)startMasterTitleId);
        query.setParameter("endMasterTitleId", (Object)endMasterTitleId);
        if (!partnerIds.isEmpty()) {
            query.setParameterList("partners", partnerIds);
        }
        List aggTrackCounts = query.list();
        return aggTrackCounts;
    }

    public Set<Integer> getActiveDistributionSitesInError(List<Long> partnerIds) {
        StringBuilder querySB = new StringBuilder("SELECT DISTINCT site.ID_ FROM SITES_SITE site, SITES_DISTSITETITLE dst");
        if (!this.isNullOrEmpty(partnerIds)) {
            querySB.append(", PMM_TITLE title");
        }
        querySB.append(" WHERE site.active=1 AND site.ID_=dst.siteId AND dst.status=").append(DistributionStatus.FAILED.ordinal());
        if (!this.isNullOrEmpty(partnerIds)) {
            querySB.append(" AND dst.titleId=title.ID_ AND (title.PARTNER_ID in (:partnerIds))");
        }
        SQLQuery query = this.getSession().createSQLQuery(querySB.toString());
        if (!this.isNullOrEmpty(partnerIds)) {
            query.setParameterList("partnerIds", partnerIds);
        }
        List resultList = query.list();
        HashSet<Integer> result = new HashSet<Integer>();
        if (resultList != null) {
            for (Object o : resultList) {
                result.add(((BigDecimal)o).intValueExact());
            }
        }
        return result;
    }

    public Set<String> getActiveTrackingSitesInError(List<Long> partnerIds) {
        StringBuilder querySB = new StringBuilder("SELECT DISTINCT dst.siteid AS dsid, tst.siteid AS tsid").append(" FROM SITES_TRACKSITETITLE tst, SITES_SITE site, SITES_DISTSITETITLE dst");
        if (!this.isNullOrEmpty(partnerIds)) {
            querySB.append(", PMM_TITLE title");
        }
        querySB.append(" WHERE tst.status=").append(TrackingStatus.DEPLOYMENT_FAILED.ordinal()).append(" AND tst.siteid=site.id_ AND site.active=1").append(" AND tst.titleid = dst.titleid");
        if (!this.isNullOrEmpty(partnerIds)) {
            querySB.append(" AND tst.titleId=title.ID_ AND (title.PARTNER_ID in (:partnerIds))");
        }
        SQLQuery query = this.getSession().createSQLQuery(querySB.toString());
        if (!this.isNullOrEmpty(partnerIds)) {
            query.setParameterList("partnerIds", partnerIds);
        }
        List resultList = query.list();
        HashSet<String> result = new HashSet<String>();
        if (resultList != null) {
            for (Object[] cols : resultList) {
                int dsid = ((BigDecimal)cols[0]).intValueExact();
                int tsid = ((BigDecimal)cols[1]).intValueExact();
                result.add(String.valueOf(dsid) + "_" + tsid);
            }
        }
        return result;
    }

    private boolean isNullOrEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public boolean isSiteNameAlreadyUsed(String siteName) {
        boolean isSiteNameAlreadyUsed = false;
        String queryStr = "from Site where name = :siteName";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("siteName", (Object)siteName);
        List sites = query.list();
        if (sites.size() > 0) {
            isSiteNameAlreadyUsed = true;
        }
        return isSiteNameAlreadyUsed;
    }

    public boolean isExternalSiteIdAlreadyUsed(String externalSiteId, SiteType siteType) {
        boolean isExternalSiteIdAlreadyUsed = false;
        String queryStr = "from Site where externalId = :externalSiteId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("externalSiteId", (Object)externalSiteId);
        List sites = query.list();
        for (Site site : sites) {
            if (site.getType().equals((Object)siteType)) continue;
            isExternalSiteIdAlreadyUsed = true;
        }
        return isExternalSiteIdAlreadyUsed;
    }

    private void scheduleTimerJob(DistributionSite distSite) {
        Job timerJob = distSite.getTimerJob();
        if (timerJob != null) {
            Integer siteId = distSite.getId();
            String siteName = distSite.getName();
            String jobName = JOB_PREFIX_SITE_TIMER + siteName;
            String associatedEntityType = ASSOCIATED_ENTITY_TYPE_SITE_TIMER;
            HashSet<Long> associatedEntities = new HashSet<Long>();
            associatedEntities.add(Long.valueOf(String.valueOf(siteId)));
            String associationDescription = ASSOCIATION_DESCRIPTION_PREFIX_SITE_TIMER + siteName + ASSOCIATION_DESCRIPTION_SUFFIX_SITE_TIMER;
            timerJob.setName(jobName);
            timerJob.setAssociatedEntityType(associatedEntityType);
            timerJob.setAssociatedEntities(associatedEntities);
            timerJob.setAssociationDescription(associationDescription);
            timerJob.setCallbackClass(SiteTimerSchedulerCallback.class);
            Job job = this.scheduler.schedule(timerJob);
            if (job.isActive() != distSite.isActive()) {
                this.scheduler.setActive(job.getId().longValue(), distSite.isActive());
            }
        }
    }

    public Integer getDistributionSiteId(Long siteTitleId) {
        String queryStr = "SELECT dst.distributionSite.id FROM DistributionSiteTitle dst WHERE title.id = :siteTitleId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("siteTitleId", (Object)siteTitleId);
        return (Integer)query.uniqueResult();
    }

    public void updateTrackingStatus(String externalId, long localTitleId, TrackingStatus status) {
        List<Site> matchingSites = this.getSitesByExternalId(externalId);
        if (matchingSites == null || matchingSites.isEmpty()) {
            throw new SiteManagementException("No site with externalId: " + externalId + " was found.");
        }
        Site ts = matchingSites.get(0);
        this.updateTrackingStatus(ts.getId(), localTitleId, status);
    }

    public List<Long> getSiteTitleIds(long masterTitleId, Set<String> externalSiteIds) {
        StringBuffer siteExtIds = new StringBuffer();
        for (String id : externalSiteIds) {
            if (siteExtIds.length() > 0) {
                siteExtIds.append(",");
            }
            siteExtIds.append("'" + id + "'");
        }
        String queryStr = "select p.id_ from pmm_title p inner join sites_distsitetitle dst on dst.titleid = p.id_ inner join sites_site s on dst.siteid = s.ID_ where p.originaltitle_id = :masterTitleId and p.titlestatusid <> 5 and s.externalid in (" + siteExtIds + ")";
        Session session = this.getSession();
        SQLQuery query = session.createSQLQuery(queryStr);
        query.setParameter(MASTER_TITLE_ID, (Object)masterTitleId);
        ArrayList<Long> result = new ArrayList<Long>();
        List resultList = query.list();
        if (resultList != null) {
            for (Object o : resultList) {
                result.add(Long.valueOf(o.toString()));
            }
        }
        return result;
    }

    public List<Long> getSiteTitleIdsInDependencyOrder(long masterTitleId) {
        ISitesDepCacheService sitesDepSvc = (ISitesDepCacheService)InjectionUtil.injectInstance((String)"cms/SitesDepCacheService/local", ISitesDepCacheService.class);
        List orderedSiteIds = sitesDepSvc.getAllSitesFromBFSOrder();
        logger.debug((Object)("Sites Dependency order from cache:" + orderedSiteIds));
        LinkedHashMap site2Titles = new LinkedHashMap();
        ListIterator iter = orderedSiteIds.listIterator();
        while (iter.hasNext()) {
            site2Titles.put((Integer)iter.next(), new LinkedHashSet());
        }
        List<DistributionSiteTitle> dstList = this.getDistributionSiteTitlesByMasterTitleId(masterTitleId);
        HashSet<Long> nodepTitleDepSet = new HashSet<Long>();
        ArrayList<Long> siteTitleIds = new ArrayList<Long>();
        for (DistributionSiteTitle dst : dstList) {
            Integer siteId = dst.getDistributionSite().getId();
            Set depSiteTitles = (Set)site2Titles.get(siteId);
            Long siteTitleId = dst.getTitle().getId();
            if (depSiteTitles != null) {
                depSiteTitles.add(siteTitleId);
            } else {
                nodepTitleDepSet.add(siteTitleId);
            }
            siteTitleIds.add(siteTitleId);
        }
        logger.debug((Object)("Master title ID:" + masterTitleId + " Sites Title IDs:" + ((Object)siteTitleIds).toString()));
        Iterator orderedSitesIter = site2Titles.keySet().iterator();
        ArrayList<Long> orderedSiteTitleIds = new ArrayList<Long>();
        while (orderedSitesIter.hasNext()) {
            Set depSiteTitles = (Set)site2Titles.get(orderedSitesIter.next());
            orderedSiteTitleIds.addAll(depSiteTitles);
        }
        orderedSiteTitleIds.addAll(nodepTitleDepSet);
        logger.debug((Object)("Master title ID:" + masterTitleId + " Sites Title IDs (dependency order):" + ((Object)orderedSiteTitleIds).toString()));
        return orderedSiteTitleIds;
    }

    public Map<Integer, Long> getDistributionSiteTitleIdsByMasterTitleIdForTrackingSite(long masterTitleId, String trackingSiteExternalId) {
        String queryStr = "select distinct t.id_ as siteTitleId , dst.siteid siteId from pmm_title t inner join sites_distsitetitle dst on dst.titleid =t.id_ inner join sites_tracksitetitle ts on ts.titleid =dst.titleid inner join sites_site s on ts.siteid = s.id_ where t.originaltitle_id = :masterTitleId and t.titlestatusid <> 5 and s.externalid = '" + trackingSiteExternalId + "'";
        SQLQuery query = this.getSession().createSQLQuery(queryStr);
        query.setParameter(MASTER_TITLE_ID, (Object)masterTitleId);
        List resultList = query.list();
        HashMap<Integer, Long> result = new HashMap<Integer, Long>();
        if (resultList != null) {
            for (Object[] cols : resultList) {
                int dstSiteId = ((BigDecimal)cols[0]).intValueExact();
                long dstTitleId = ((BigDecimal)cols[1]).intValueExact();
                result.put(dstSiteId, dstTitleId);
            }
        }
        return result;
    }

    public Boolean hasMPWithTrackingSites() {
        List<DistributionSite> distSites = this.getAllDistributionSites();
        if (distSites != null) {
            for (DistributionSite distributionSite : distSites) {
                Set trackingSites;
                if (!(distributionSite instanceof MediapathDistributionSite) || (trackingSites = distributionSite.getChildren()) == null || trackingSites.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public Boolean isMediaPathSiteTitle(Integer siteId) {
        Site site = this.getSite(siteId);
        if (site != null && site instanceof MediapathDistributionSite) {
            return true;
        }
        return false;
    }

    public boolean isDistributionOrDeploymentInError(long masterTitleId) {
        return this.isDistributionInError(masterTitleId) || this.isDeploymentInError(masterTitleId);
    }

    private boolean isDistributionInError(long masterTitleId) {
        String queryStr = "SELECT title.id FROM DistributionSiteTitle WHERE title.originalId = :masterTitleId AND status = :status";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter(MASTER_TITLE_ID, (Object)masterTitleId);
        query.setParameter("status", (Object)DistributionStatus.FAILED);
        query.setMaxResults(1);
        return query.uniqueResult() != null;
    }

    private boolean isDeploymentInError(long masterTitleId) {
        String queryStr = "SELECT title.id FROM TrackingSiteTitle WHERE title.originalId = :masterTitleId AND status = :status";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter(MASTER_TITLE_ID, (Object)masterTitleId);
        query.setParameter("status", (Object)TrackingStatus.DEPLOYMENT_FAILED);
        query.setMaxResults(1);
        return query.uniqueResult() != null;
    }

    public void activateNoCascade(int siteId) throws SiteManagementException {
        Site site = this.getSite(siteId);
        this.setSiteActive(site, true, true);
    }

    public void inactivateNoCascade(int siteId) throws SiteManagementException {
        Site site = this.getSite(siteId);
        this.setSiteActive(site, false, true);
    }

    public List<String> getAllGroupNamesByTemplate(String templateName) {
        Collection groups = new ArrayList();
        ArrayList<String> groupNameList = new ArrayList<String>();
        try {
            for (Template template : this.getTemplateList("Distribution")) {
                if (template.getName().equalsIgnoreCase(templateName)) {
                    template = this.getTemplate(template.getId());
                    groups = template.getGroups();
                }
                for (ResourceGroup group : groups) {
                    groupNameList.add(group.getName());
                }
            }
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to get distribution templates", (Throwable)e);
        }
        return groupNameList;
    }

    private void updateAggregatedDistributionStatus(DistributionSiteTitle dst) {
        Title masterTitle = this.titleManager.get(dst.getTitle().getOriginalId());
        try {
            this.getSession().flush();
            this.titleManager.updateDistributionStatus(masterTitle);
        }
        catch (TitleValidationException e) {
            logger.error((Object)"Failed to update Title: ", (Throwable)e);
        }
    }

    private void updateTrackingSiteTitleStatusInElasticSearch(long titleId, int siteId, String status, Date statusUpdatedTime) {
        try {
            ServiceRegistry registry = ServiceRegistry.getDefault();
            IElasticSearchService esService = (IElasticSearchService)registry.lookup(IElasticSearchService.class);
            UpdateSiteStatusInfo siteInfo = UpdateSiteStatusInfo.createTrackingSiteInfo((int)siteId, (String)status, (Date)statusUpdatedTime);
            esService.updateSiteTitleStatus(titleId, siteInfo);
        }
        catch (Exception ex) {
            logger.error((Object)"Could not update tracking site title", (Throwable)ex);
        }
    }

    private void updateDistributionSiteTitleStatusInElasticSearch(long titleId, int siteId, String status, Date statusUpdatedTime, int statusDetail) {
        try {
            ServiceRegistry registry = ServiceRegistry.getDefault();
            IElasticSearchService esService = (IElasticSearchService)registry.lookup(IElasticSearchService.class);
            UpdateSiteStatusInfo siteInfo = UpdateSiteStatusInfo.createDistributionSiteInfo((int)siteId, (String)status, (Date)statusUpdatedTime, (int)statusDetail);
            esService.updateSiteTitleStatus(titleId, siteInfo);
        }
        catch (Exception ex) {
            logger.error((Object)"Could not update distribution site title", (Throwable)ex);
        }
    }

    private void updateSiteTitleStatusesInElasticSearch(long titleId, SiteStatusCollection statuses) {
        try {
            ServiceRegistry registry = ServiceRegistry.getDefault();
            IElasticSearchService esService = (IElasticSearchService)registry.lookup(IElasticSearchService.class);
            esService.updateSiteTitleStatuses(titleId, statuses);
        }
        catch (Exception ex) {
            logger.error((Object)"Could not update site title statuses", (Throwable)ex);
        }
    }

    private List<Template> getTemplateList(String category) throws IOException {
        Templates request = this.requestTemplates();
        request.query().category(category).count(100);
        return request.execute().getItems();
    }

    private Template getTemplate(String id) throws IOException {
        Templates request = this.requestTemplates();
        request.query().id(id);
        TemplateListResponse response = request.execute();
        if (response.getItems().isEmpty()) {
            return null;
        }
        return (Template)response.getItems().get(0);
    }

    private Templates requestTemplates() {
        return new API.Builder().build().templates();
    }

    private Resource getResource(Long resourceId) throws IOException {
        Resources request = this.requestResources();
        request.query().id(String.valueOf(resourceId));
        ResourceListResponse response = request.execute();
        if (response.getItems().isEmpty()) {
            return null;
        }
        return (Resource)response.getItems().get(0);
    }

    private Resources requestResources() {
        return new API.Builder().build().resources();
    }

    public List<Long> getSiteTitleIdsForMasterTitleAndSiteIds(long masterTitleId, Set<Integer> siteIds) {
        StringBuffer sitIds = new StringBuffer();
        for (Integer id : siteIds) {
            if (sitIds.length() > 0) {
                sitIds.append(",");
            }
            sitIds.append("'" + id + "'");
        }
        String queryStr = "select t.id_ from pmm_title t inner join sites_distsitetitle dst on dst.titleid =t.id_ inner join sites_site s on dst.siteid = s.id_ where t.originaltitle_id = :masterTitleId and t.titlestatusid <> 5 and s.id_ in (" + sitIds + ")";
        Session session = this.getSession();
        SQLQuery query = session.createSQLQuery(queryStr);
        query.setParameter(MASTER_TITLE_ID, (Object)masterTitleId);
        ArrayList<Long> result = new ArrayList<Long>();
        List resultList = query.list();
        if (resultList != null) {
            for (Object o : resultList) {
                result.add(Long.valueOf(o.toString()));
            }
        }
        logger.debug((Object)("Master Titleid:" + masterTitleId + " siteIds:" + siteIds + " siteTitleIds:" + result));
        return result;
    }

    public List<Integer> getDependsOnSites(Integer siteId) {
        ISitesDepCacheService sitesDepSvc = (ISitesDepCacheService)InjectionUtil.injectInstance((String)"cms/SitesDepCacheService/local", ISitesDepCacheService.class);
        List<Integer> dependsOn = new ArrayList<Integer>();
        if (siteId != null && (dependsOn = sitesDepSvc.getImmediateDependOnSites(siteId)) == null) {
            return new ArrayList<Integer>();
        }
        return dependsOn;
    }

    public List<Site> getSitesByIds(List<Integer> siteIds) {
        String queryStr = "from Site where id_ in (:siteIds)";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameterList("siteIds", siteIds);
        return query.list();
    }

    public void ExecuteActionOnFailure(Long siteTitleId, Long workOrderId, String processingRequest) {
        DistributionSiteTitle siteTitle = this.getDistributionSiteTitle(siteTitleId);
        if (siteTitle == null) {
            return;
        }
        DistributionRetry.getInstance().executeActionOnFailure(siteTitle, workOrderId);
    }

    public void removeSiteTitleAttempts(Long siteTitleId) {
        DistributionRetry.getInstance().removeSiteTitleAttempts(siteTitleId);
    }

    private class DistributionSiteTitleProcessor
    implements Runnable {
        private int distributionSiteId;
        private int updateSize;

        public DistributionSiteTitleProcessor(int distributionSiteId, int updateSize) {
            this.distributionSiteId = distributionSiteId;
            this.updateSize = updateSize;
        }

        @Override
        public void run() {
            try {
                ServiceRegistry registry = ServiceRegistry.getDefault();
                IElasticSearchService esService = (IElasticSearchService)registry.lookup(IElasticSearchService.class);
                ArrayList<SearchColumn> searchColumns = new ArrayList<SearchColumn>();
                searchColumns.add(new SearchColumn(null, "id", FieldType.PMM_TITLE, "integer", false));
                searchColumns.add(new SearchColumn(null, "originalId", FieldType.PMM_TITLE, "date", false));
                SearchParametersBuilder bld = new SearchParametersBuilder();
                bld.setCriteriaMode(CriteriaMode.SITE);
                bld.setSiteId(this.distributionSiteId);
                bld.setSiteStatus(com.tandbergtv.cms.title.search.entities.SiteType.DISTRIBUTION_SITE, null);
                bld.setSearchColumns(searchColumns, this.distributionSiteId);
                bld.setPagingInfo(new PagingInfo(0, this.updateSize));
                TitleSearchResult searchResults = esService.quickSearch("", bld.build());
                long searchResultCount = searchResults.getCount();
                logger.debug((Object)("searchResultCount:" + searchResultCount + " updateSize: " + this.updateSize));
                for (TitleSearchResult.SearchRow row : searchResults.getRows()) {
                    logger.debug((Object)("Delete siteTitle in DB: " + row.getId()));
                    SiteManager.this.titleManager.delete(Long.valueOf(row.getId()));
                    Title masterTitle = SiteManager.this.titleManager.get(Long.valueOf(row.getFirstValueAsString(1)));
                    try {
                        SiteManager.this.titleManager.updateDistributionStatus(masterTitle);
                    }
                    catch (TitleValidationException e) {
                        logger.error((Object)"Failed to update Title: ", (Throwable)e);
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Could not search title", (Throwable)ex);
            }
        }
    }
}

