/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.SiteManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleDeleteCallback;
import com.tandbergtv.watchpoint.pmm.title.TitleDeleteException;
import java.util.List;
import org.apache.log4j.Logger;

public class TitleDeleteCallback
implements ITitleDeleteCallback {
    private static final Logger logger = Logger.getLogger(TitleDeleteCallback.class);

    public void onBeforeDelete(Title title) throws TitleDeleteException {
        if (title.getOriginalId() == null) {
            logger.info((Object)("Master title: [" + title + "] is being deleted. Attempting to delete all local titles."));
            ISiteManager siteManager = (ISiteManager)InjectionUtil.injectInstance(SiteManager.class, ISiteManager.class);
            List localTitles = siteManager.getSiteCopies(title.getId().longValue());
            if (localTitles != null) {
                for (Title localTitle : localTitles) {
                    siteManager.deleteTitle(localTitle.getId().longValue());
                }
            }
        }
    }

    public void onDelete(Title title) throws TitleDeleteException {
    }
}

