/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core.mediapath;

import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class MSOOverridableFieldsReader {
    private static final String SITES_CONFIG_DIR = "site";
    private static final String OVERRIDABLES_FILE_PATH = "MSOOverridables.dat";
    private static Set<String> msoOverridableFields;
    private static long loadedFileModifiedTime;
    private static IConfigurationService configReaderService;

    static {
        configReaderService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
        File overridablesFile = configReaderService.getFile(SITES_CONFIG_DIR, OVERRIDABLES_FILE_PATH);
        MSOOverridableFieldsReader.loadMSOOverridableFields(overridablesFile);
    }

    public static Set<String> getMSOOverridableFields() {
        File overridablesFile = configReaderService.getFile(SITES_CONFIG_DIR, OVERRIDABLES_FILE_PATH);
        if (msoOverridableFields == null) {
            MSOOverridableFieldsReader.loadMSOOverridableFields(overridablesFile);
        } else if (overridablesFile.lastModified() > loadedFileModifiedTime) {
            MSOOverridableFieldsReader.loadMSOOverridableFields(overridablesFile);
        }
        return msoOverridableFields;
    }

    private static synchronized void loadMSOOverridableFields(File overridablesFile) {
        if (overridablesFile != null && overridablesFile.exists() && overridablesFile.canRead()) {
            msoOverridableFields = new HashSet<String>();
            try {
                BufferedReader br = new BufferedReader(new FileReader(overridablesFile));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    msoOverridableFields.add(line);
                }
                loadedFileModifiedTime = overridablesFile.lastModified();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

