/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.dependency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class DependencyGraph {
    private Logger logger = Logger.getLogger(DependencyGraph.class);
    private static final String ID = "id";
    private static final String DEPENDS_ON = "dependson";
    Map<Integer, List<Integer>> sitesAdjacencyList = new ConcurrentHashMap<Integer, List<Integer>>();
    Set<Integer> rootList = new LinkedHashSet<Integer>();
    Long currentVersion = 0L;
    private Set<Integer> activeSites = new HashSet<Integer>();

    public Long getCurrentVersion() {
        return this.currentVersion;
    }

    public Map<Integer, List<Integer>> getsitesAdjacencyList() {
        return this.sitesAdjacencyList;
    }

    public Set<Integer> getRootList() {
        return this.rootList;
    }

    public DependencyGraph(JSONArray sites, Long version) throws JSONException {
        this.Load(sites, version);
    }

    public synchronized void Refresh(JSONArray sites, Long version) throws JSONException {
        this.Load(sites, version);
    }

    public synchronized void update(Integer siteId, List<Integer> dependOnSites) {
        long t1 = System.currentTimeMillis();
        if (dependOnSites == null || dependOnSites.size() == 0) {
            if (this.sitesAdjacencyList.containsKey(siteId)) {
                this.updateRootListForDeleteSite(siteId);
                this.sitesAdjacencyList.remove(siteId);
            }
        } else {
            boolean deleteHistoryAction = false;
            List<Integer> dependOnSitesHistory = null;
            if (!this.sitesAdjacencyList.containsKey(siteId)) {
                deleteHistoryAction = true;
            } else {
                dependOnSitesHistory = this.sitesAdjacencyList.get(siteId);
            }
            List<Integer> dependsOnSitesBeforeUpdate = this.getChildren(siteId);
            this.sitesAdjacencyList.put(siteId, dependOnSites);
            if (this.hasCycle(siteId).booleanValue()) {
                if (deleteHistoryAction) {
                    this.sitesAdjacencyList.remove(siteId);
                } else {
                    this.sitesAdjacencyList.put(siteId, dependOnSitesHistory);
                }
                this.logger.debug((Object)("Sites Graph update end time:  " + System.currentTimeMillis()));
                throw new IllegalArgumentException("this update resulted in sites graph cyclic");
            }
            if (this.rootList.isEmpty()) {
                this.rootList.add(siteId);
            } else {
                this.updateRootListForUpdateSite(siteId, dependsOnSitesBeforeUpdate, dependOnSites);
            }
        }
        long t2 = System.currentTimeMillis();
        this.logger.debug((Object)("Time taken to update sites graph - time:" + (t2 - t1) + " ms"));
    }

    public synchronized void delete(Integer siteId) {
        long t1 = System.currentTimeMillis();
        if (this.rootList.contains(siteId)) {
            this.updateRootListForDeleteSite(siteId);
        }
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        toRemove.add(siteId);
        HashMap<Integer, List<Integer>> siteAdjList = new HashMap<Integer, List<Integer>>(this.sitesAdjacencyList);
        for (Map.Entry e : siteAdjList.entrySet()) {
            ArrayList values = new ArrayList((Collection)e.getValue());
            if (values.contains(siteId)) {
                values.remove(siteId);
                this.sitesAdjacencyList.put((Integer)e.getKey(), values);
            }
            if (values.size() != 0) continue;
            toRemove.add((Integer)e.getKey());
        }
        for (Integer id : toRemove) {
            this.sitesAdjacencyList.remove(id);
        }
        long t2 = System.currentTimeMillis();
        this.logger.debug((Object)("Time taken to delete sites graph - time:" + (t2 - t1) + " ms"));
    }

    private void updateRootListForUpdateSite(Integer siteId, List<Integer> dependsOnSitesBeforeUpdate, List<Integer> dependOnSites) {
        ArrayList<Integer> rlist = new ArrayList<Integer>(this.rootList);
        Boolean noParent = this.getParents(siteId).isEmpty();
        if (noParent.booleanValue()) {
            for (Integer root : rlist) {
                if (dependOnSites.contains(root)) {
                    this.rootList.remove(root);
                    this.rootList.add(siteId);
                    continue;
                }
                this.rootList.add(siteId);
            }
        } else {
            for (Integer root : rlist) {
                if (!dependOnSites.contains(root)) continue;
                this.rootList.remove(root);
            }
        }
        if (dependsOnSitesBeforeUpdate != null && dependsOnSitesBeforeUpdate.size() > 0) {
            for (Integer site : dependsOnSitesBeforeUpdate) {
                if (dependOnSites.contains(site) || this.getChildren(site).isEmpty()) continue;
                this.rootList.add(site);
            }
        }
    }

    private void updateRootListForDeleteSite(Integer siteId) {
        this.rootList.remove(siteId);
        List<Integer> children = this.getChildren(siteId);
        for (Integer child : children) {
            if (!this.sitesAdjacencyList.containsKey(child)) continue;
            this.rootList.add(child);
        }
    }

    public String toJSON() throws JSONException {
        long t1 = System.currentTimeMillis();
        JSONArray arr = new JSONArray();
        for (Map.Entry<Integer, List<Integer>> s : this.sitesAdjacencyList.entrySet()) {
            JSONObject jo = new JSONObject();
            jo.put(ID, (Object)s.getKey());
            jo.put(DEPENDS_ON, (Object)this.toChildJSON(s.getValue()));
            arr.put((Object)jo);
        }
        long t2 = System.currentTimeMillis();
        this.logger.debug((Object)("Time taken to convert sites graph to JSON - time:" + (t2 - t1) + " ms"));
        return arr.toString();
    }

    private JSONArray toChildJSON(List<Integer> siteIds) throws JSONException {
        JSONArray children = new JSONArray();
        if (siteIds != null && siteIds.size() > 0) {
            for (Integer siteId : siteIds) {
                JSONObject cjo = new JSONObject();
                cjo.put(ID, (Object)siteId);
                children.put((Object)cjo);
            }
        }
        return children;
    }

    public String toJSON(Integer siteId) throws JSONException {
        JSONObject jo = new JSONObject();
        jo.put(ID, (Object)siteId);
        jo.put(DEPENDS_ON, (Object)this.toChildJSON(this.sitesAdjacencyList.get(siteId)));
        return jo.toString();
    }

    public String toJSON(Integer siteId, List<Integer> siteIds) throws JSONException {
        JSONObject jo = new JSONObject();
        jo.put(ID, (Object)siteId);
        jo.put(DEPENDS_ON, (Object)this.toChildJSON(siteIds));
        return jo.toString();
    }

    public synchronized String getJSON(Integer siteId, List<Integer> siteIds, boolean deleteAction) throws JSONException {
        if (deleteAction) {
            return this.deleteJSON(siteId);
        }
        return this.updateJSON(siteId, siteIds);
    }

    private String updateJSON(Integer siteId, List<Integer> siteIds) throws JSONException {
        long t1 = System.currentTimeMillis();
        JSONArray arr = new JSONArray();
        boolean found = false;
        boolean remove = false;
        if (siteIds == null || siteIds.size() == 0) {
            remove = true;
        }
        for (Map.Entry<Integer, List<Integer>> s : this.sitesAdjacencyList.entrySet()) {
            JSONObject jo = new JSONObject();
            if (s.getKey().equals(siteId)) {
                if (!remove) {
                    jo.put(ID, (Object)siteId);
                    jo.put(DEPENDS_ON, (Object)this.toChildJSON(siteIds));
                    arr.put((Object)jo);
                }
                found = true;
                continue;
            }
            jo.put(ID, (Object)s.getKey());
            jo.put(DEPENDS_ON, (Object)this.toChildJSON(s.getValue()));
            arr.put((Object)jo);
        }
        if (!found && !remove) {
            JSONObject jo = new JSONObject();
            jo.put(ID, (Object)siteId);
            jo.put(DEPENDS_ON, (Object)this.toChildJSON(siteIds));
            arr.put((Object)jo);
        }
        long t2 = System.currentTimeMillis();
        this.logger.debug((Object)("Time taken to updateJSON - time:" + (t2 - t1) + " ms"));
        return arr.toString();
    }

    private String deleteJSON(Integer siteId) throws JSONException {
        long t1 = System.currentTimeMillis();
        JSONArray arr = new JSONArray();
        for (Map.Entry<Integer, List<Integer>> s : this.sitesAdjacencyList.entrySet()) {
            if (s.getKey().equals(siteId)) continue;
            ArrayList<Integer> newSet = new ArrayList<Integer>((Collection)s.getValue());
            newSet.remove(siteId);
            if (newSet.size() <= 0) continue;
            JSONObject jo = new JSONObject();
            jo.put(ID, (Object)s.getKey());
            jo.put(DEPENDS_ON, (Object)this.toChildJSON(newSet));
            arr.put((Object)jo);
        }
        long t2 = System.currentTimeMillis();
        this.logger.debug((Object)("Time taken to deleteJSON - time:" + (t2 - t1) + " ms"));
        return arr.toString();
    }

    private void Load(JSONArray sites, Long version) throws JSONException {
        long t1 = System.currentTimeMillis();
        HashMap<Integer, Integer> currentKeys = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < sites.length()) {
            JSONObject site = sites.getJSONObject(i);
            JSONArray children = site.getJSONArray(DEPENDS_ON);
            Integer siteId = site.getInt(ID);
            currentKeys.put(siteId, 0);
            ArrayList<Integer> dependencyList = new ArrayList<Integer>();
            int k = 0;
            while (k < children.length()) {
                JSONObject child = children.getJSONObject(k);
                dependencyList.add(child.getInt(ID));
                ++k;
            }
            if (dependencyList.size() > 0) {
                this.sitesAdjacencyList.put(siteId, dependencyList);
            }
            ++i;
        }
        for (Map.Entry<Integer, List<Integer>> s : this.sitesAdjacencyList.entrySet()) {
            if (currentKeys.containsKey(s.getKey())) continue;
            this.sitesAdjacencyList.remove(s.getKey());
        }
        this.currentVersion = version;
        for (Map.Entry<Integer, List<Integer>> sadj : this.sitesAdjacencyList.entrySet()) {
            if (!this.getParents(sadj.getKey()).isEmpty()) continue;
            this.rootList.add(sadj.getKey());
        }
        long t2 = System.currentTimeMillis();
        this.logger.debug((Object)("Time taken to load sites graph - time:" + (t2 - t1) + " ms"));
    }

    public List<Integer> getAllSitesInBfsOrder() {
        ArrayList<Integer> graphBfs = new ArrayList<Integer>();
        if (this.rootList != null && this.rootList.size() > 0) {
            for (Integer root : this.rootList) {
                graphBfs.addAll(this.getBfsSequence(root));
            }
        }
        return graphBfs;
    }

    public List<Integer> getAllSitesInReversBfsOrder() {
        ArrayList<Integer> graphRevBfs = new ArrayList<Integer>();
        if (this.rootList != null && this.rootList.size() > 0) {
            for (Integer root : this.rootList) {
                graphRevBfs.addAll(this.getReverseBfsSequence(root));
            }
        }
        return graphRevBfs;
    }

    public List<Integer> getBfsSequence(Integer startNode) {
        long t1 = System.currentTimeMillis();
        ArrayList<Integer> bfs = new ArrayList<Integer>();
        if (this.sitesAdjacencyList != null) {
            LinkedList<Integer> queue = new LinkedList<Integer>();
            queue.add(startNode);
            while (!queue.isEmpty()) {
                Integer element = (Integer)queue.remove();
                if (bfs.contains(element)) {
                    bfs.remove(element);
                }
                bfs.add(element);
                if (!this.sitesAdjacencyList.containsKey(element)) continue;
                List<Integer> dependencies = this.sitesAdjacencyList.get(element);
                for (Integer dependency : dependencies) {
                    queue.add(dependency);
                }
            }
        }
        long t2 = System.currentTimeMillis();
        this.logger.debug((Object)("Time taken to getBfsSequence - time:" + (t2 - t1) + " ms"));
        return bfs;
    }

    public List<Integer> getReverseBfsSequence(Integer startNode) {
        ArrayList<Integer> revBfsSequence = new ArrayList<Integer>();
        List<Integer> bfsSequence = this.getBfsSequence(startNode);
        if (bfsSequence != null) {
            revBfsSequence = new ArrayList<Integer>(bfsSequence);
            Collections.reverse(revBfsSequence);
        }
        return revBfsSequence;
    }

    public Boolean hasCycle(Integer startNode) {
        long t1 = System.currentTimeMillis();
        Stack<Integer> stack = new Stack<Integer>();
        HashMap<Integer, Integer> findCycle = new HashMap<Integer, Integer>();
        stack.push(startNode);
        while (!stack.isEmpty()) {
            Integer current = new Integer((Integer)stack.pop());
            findCycle.put(current, 0);
            if (this.sitesAdjacencyList.containsKey(current)) {
                List<Integer> dependencies = this.sitesAdjacencyList.get(current);
                for (Integer dependency : dependencies) {
                    if (!findCycle.containsKey(dependency)) {
                        stack.push(dependency);
                        continue;
                    }
                    long t2 = System.currentTimeMillis();
                    this.logger.debug((Object)("Time taken to detect cycle - time:" + (t2 - t1) + " ms"));
                    return true;
                }
                continue;
            }
            findCycle = new HashMap();
            findCycle.put(startNode, 0);
        }
        long t2 = System.currentTimeMillis();
        this.logger.debug((Object)("Time taken to detect cycle - time:" + (t2 - t1) + " ms"));
        return false;
    }

    public List<Integer> getSiteAncestors(Integer startNode) {
        long t1 = System.currentTimeMillis();
        Map<Object, Object> childParentTable = new HashMap();
        childParentTable = this.createChildParentDependencyTable(this.sitesAdjacencyList);
        ArrayList<Integer> ancestors = new ArrayList<Integer>();
        LinkedList<Integer> queue = new LinkedList<Integer>();
        queue.add(startNode);
        while (!queue.isEmpty()) {
            Integer current = (Integer)queue.remove();
            if (!ancestors.contains(current)) {
                ancestors.add(current);
            }
            if (!childParentTable.containsKey(current)) continue;
            List parents = (List)childParentTable.get(current);
            for (Integer parent : parents) {
                queue.add(parent);
            }
        }
        ancestors.remove(startNode);
        long t2 = System.currentTimeMillis();
        this.logger.debug((Object)("Time taken to getSiteAncestors - time:" + (t2 - t1) + " ms"));
        return ancestors;
    }

    private Map<Integer, List<Integer>> createChildParentDependencyTable(Map<Integer, List<Integer>> sitesAdjacencyList) {
        HashMap<Integer, List<Integer>> childParent = new HashMap<Integer, List<Integer>>();
        for (Map.Entry<Integer, List<Integer>> adjList : sitesAdjacencyList.entrySet()) {
            List<Integer> children = adjList.getValue();
            for (Integer child : children) {
                List<Integer> parentList = new ArrayList<Integer>();
                if (childParent.containsKey(child)) {
                    parentList = (List)childParent.get(child);
                    parentList.add(adjList.getKey());
                    childParent.put(child, parentList);
                    continue;
                }
                parentList.add(adjList.getKey());
                childParent.put(child, parentList);
            }
        }
        return childParent;
    }

    public List<Integer> getChildren(Integer siteId) {
        this.logger.debug((Object)"enter getChildren()");
        ArrayList<Integer> children = new ArrayList<Integer>();
        if (this.sitesAdjacencyList.containsKey(siteId)) {
            this.logger.debug((Object)("get sitesAdjacencyList for site (" + siteId + ")"));
            children = new ArrayList(this.sitesAdjacencyList.get(siteId));
        }
        return children;
    }

    public void setActiveSitesList(Set<Integer> activeSites) {
        this.activeSites = activeSites;
    }

    public List<Integer> getActiveChildren(Integer siteId) {
        this.logger.debug((Object)"enter getActiveChildren()");
        List<Integer> children = this.getChildren(siteId);
        this.logger.debug((Object)("All dependent sites of site " + siteId + " are " + children));
        ArrayList<Integer> activeChildren = new ArrayList<Integer>();
        this.logger.debug((Object)("activeSites = " + this.activeSites));
        for (Integer site : children) {
            if (!this.activeSites.contains(site)) continue;
            this.logger.debug((Object)("add active dependent site into list: site (" + site + ")"));
            activeChildren.add(site);
        }
        this.logger.debug((Object)"exit getActiveChildren()");
        return activeChildren;
    }

    public List<Integer> getParents(Integer siteId) {
        List<Integer> parents = new ArrayList<Integer>();
        Map<Object, Object> childParentTable = new HashMap();
        childParentTable = this.createChildParentDependencyTable(this.sitesAdjacencyList);
        if (childParentTable.containsKey(siteId)) {
            parents = (List)childParentTable.get(siteId);
        }
        return parents;
    }

    public boolean areAllChildrenSelectedForGivenList(List<Integer> inputList) {
        boolean isSelected = true;
        HashSet<Integer> selectedSitesSet = new HashSet<Integer>(inputList);
        HashSet<Integer> childrentList = new HashSet<Integer>();
        for (Integer site : selectedSitesSet) {
            List<Integer> activeChildren = this.getActiveChildren(site);
            if (!this.activeSites.contains(site)) continue;
            childrentList.addAll(activeChildren);
        }
        if (!childrentList.isEmpty()) {
            isSelected = inputList.containsAll(childrentList);
        }
        return isSelected;
    }
}

