/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.dependency;

import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.neptune.cluster.service.ITopicMessageListener;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.SiteManagementException;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.dependency.DependencyGraph;
import com.ericsson.cms.sites.dependency.ISitesDepCacheService;
import com.ericsson.cms.sites.dependency.SitesDependencyDao;
import com.ericsson.cms.sites.dependency.SitesDependencyMessage;
import com.ericsson.cms.sites.dependency.SitesGraphResult;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.hazelcast.core.HazelcastInstance;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.util.DistributedTopic;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.DependsOn;
import javax.ejb.Local;
import javax.ejb.Singleton;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.codehaus.jettison.json.JSONArray;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@Local(value={ISitesDepCacheService.class})
@DependsOn(value={"Neptune:service=com.tandbergtv.neptune.clustermgmt.service.IClusterConfigurationService"})
public class SitesDepCacheService
implements ISitesDepCacheService,
ITopicMessageListener<SitesDependencyMessage> {
    private static final String SITES_DEPENDENCY_TOPIC_NAME = "SitesDependencyTopic";
    private static final Logger logger = Logger.getLogger(SitesDepCacheService.class);
    private DistributedTopic<SitesDependencyMessage> sitesDependencyTopic;
    private TransactionManager transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
    private DependencyGraph dependencyGraph = null;
    private IClusterService hzcs;
    private HazelcastInstance haz;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;

    public SitesDepCacheService() throws Exception {
        boolean isTransactionOwner;
        logger.info((Object)"Bringing up SitesDepCacheService.");
        this.hzcs = Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH);
        this.haz = this.hzcs.getInstance();
        if (this.haz.getConfig() != null) {
            logger.info((Object)("SitesDepCacheService is a part of cluster: " + this.haz.getConfig().getGroupConfig().getName()));
        }
        this.sitesDependencyTopic = new DistributedTopic(SITES_DEPENDENCY_TOPIC_NAME);
        ServiceRegistry.getDefault().register(this.sitesDependencyTopic.getServiceName(), this.sitesDependencyTopic);
        this.sitesDependencyTopic.start();
        this.sitesDependencyTopic.subscribe((ITopicMessageListener)this);
        boolean bl = isTransactionOwner = this.transactionManager.getTransaction() == null;
        if (!isTransactionOwner) {
            this.load();
        } else {
            this.transactionManager.begin();
            this.load();
            this.transactionManager.commit();
        }
        logger.info((Object)"SitesDepCacheService initialized.");
    }

    private void load() {
    }

    @Transactional
    public void onMessage(SitesDependencyMessage msg) {
        SitesDependencyMessage sitesDependencyMessage = msg;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = SitesDepCacheService.class.getDeclaredMethod("onMessage", SitesDependencyMessage.class).getAnnotation(Transactional.class);
        }
        SitesDepCacheService.onMessage_aroundBody1$advice(this, sitesDependencyMessage, transactionEnforcer, (Transactional)annotation, null);
    }

    public Boolean areAllDependencySitesSelected(List<Integer> selectedSitesList) {
        return this.getDependencyGraph().areAllChildrenSelectedForGivenList(selectedSitesList);
    }

    public List<Integer> getSitesFromBFSOrder(Integer siteId) {
        return this.getDependencyGraph().getBfsSequence(siteId);
    }

    public List<Integer> getSitesFromReverseBFSOrder(Integer siteId) {
        return this.getDependencyGraph().getReverseBfsSequence(siteId);
    }

    public List<Integer> getAllSitesFromBFSOrder() {
        return this.getDependencyGraph().getAllSitesInBfsOrder();
    }

    public List<Integer> getAllSitesFromReverseBFSOrder() {
        return this.getDependencyGraph().getAllSitesInReversBfsOrder();
    }

    public List<Integer> getImmediateDependOnSites(Integer siteId, Boolean onlyActive) {
        if (!onlyActive.booleanValue()) {
            return this.getDependencyGraph().getChildren(siteId);
        }
        return this.getDependencyGraph().getActiveChildren(siteId);
    }

    public List<Integer> getImmediateDependOnSites(Integer siteId) {
        return this.getImmediateDependOnSites(siteId, false);
    }

    public List<Integer> getImmediateDependentSites(Integer siteId) {
        return this.getDependencyGraph().getParents(siteId);
    }

    public List<Integer> getNonUsableSitesForDependOn(Integer siteId) {
        return this.getDependencyGraph().getSiteAncestors(siteId);
    }

    public void update(Integer siteId, List<Integer> dependOnSites) {
        HashSet<Integer> sites = new HashSet<Integer>();
        if (dependOnSites != null && dependOnSites.size() > 1) {
            for (Integer site : dependOnSites) {
                if (sites.add(site) && !site.equals(siteId)) continue;
                throw new IllegalArgumentException("Depend on sites , have duplicates elements.");
            }
        }
        this.getDependencyGraph().update(siteId, dependOnSites);
    }

    public void delete(Integer siteId) {
        this.getDependencyGraph().delete(siteId);
    }

    public void refresh(String sitesGraph, Long version) {
        try {
            this.getDependencyGraph().Refresh(new JSONArray(sitesGraph), version);
        }
        catch (Exception e) {
            throw new SiteManagementException((Throwable)e);
        }
    }

    public String toJSON() {
        try {
            return this.getDependencyGraph().toJSON();
        }
        catch (Exception e) {
            throw new SiteManagementException((Throwable)e);
        }
    }

    public String getJSON(Integer siteId, List<Integer> siteIds, boolean deleteAction) throws SiteManagementException {
        try {
            return this.getDependencyGraph().getJSON(siteId, siteIds, deleteAction);
        }
        catch (Exception e) {
            throw new SiteManagementException((Throwable)e);
        }
    }

    public Long getVersion() {
        return this.getDependencyGraph().getCurrentVersion();
    }

    @Transactional
    private SitesGraphResult getSitesGraphFromDB() {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = SitesDepCacheService.class.getDeclaredMethod("getSitesGraphFromDB", new Class[0]).getAnnotation(Transactional.class);
        }
        return (SitesGraphResult)SitesDepCacheService.getSitesGraphFromDB_aroundBody3$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    private DependencyGraph getDependencyGraph() {
        if (this.dependencyGraph == null) {
            try {
                SitesGraphResult result = this.getSitesGraphFromDB();
                this.dependencyGraph = new DependencyGraph(new JSONArray(result.getSitesGraph()), result.getVersion());
                this.dependencyGraph.setActiveSitesList(this.loadActiveSites());
            }
            catch (Exception e) {
                logger.error((Object)"SitesDepCacheService getDependencyGraph failed.", (Throwable)e);
                throw new SiteManagementException((Throwable)e);
            }
        }
        return this.dependencyGraph;
    }

    public void NotifyCluster() {
        logger.debug((Object)("NotifyCluster SitesDependencyMessage message from " + this.haz.getCluster().getLocalMember().getAddress().getHost()));
        this.getDependencyGraph().setActiveSitesList(this.loadActiveSites());
        Thread thread = new Thread(){

            @Override
            public void run() {
                SitesDependencyMessage updateMessage = new SitesDependencyMessage();
                SitesDepCacheService.this.sitesDependencyTopic.publish((Object)updateMessage);
            }
        };
        thread.start();
    }

    private void reload() {
        try {
            SitesGraphResult result = this.getSitesGraphFromDB();
            this.getDependencyGraph().Refresh(new JSONArray(result.getSitesGraph()), result.getVersion());
            this.getDependencyGraph().setActiveSitesList(this.loadActiveSites());
        }
        catch (Exception e) {
            logger.error((Object)"SitesDepCacheService onMessage failed.", (Throwable)e);
            throw new SiteManagementException((Throwable)e);
        }
    }

    public Set<Integer> loadActiveSites() {
        logger.debug((Object)"Load Active Sites..");
        ISiteManager sm = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
        List activeSites = sm.getActiveDistributionSites();
        HashSet<Integer> activeSitesId = new HashSet<Integer>();
        for (DistributionSite site : activeSites) {
            activeSitesId.add(site.getId());
        }
        return activeSitesId;
    }

    private static final /* synthetic */ void onMessage_aroundBody0(SitesDepCacheService ajc$this, SitesDependencyMessage msg) {
        logger.info((Object)("Got message SitesDependencyMessage message from " + msg.getSender()));
        if (ajc$this.hzcs.isLocalMember(msg.getSender())) {
            logger.info((Object)("Skipping SitesDependencyMessage from " + msg.getSender()));
            return;
        }
        try {
            new Scheduler("Synchronize dependency graph.").schedule(() -> {
                this.reload();
                return null;
            }, 5000L);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private static final /* synthetic */ Object onMessage_aroundBody1$advice(SitesDepCacheService ajc$this, SitesDependencyMessage msg, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            SitesDepCacheService.onMessage_aroundBody0(ajc$this, msg);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            SitesDepCacheService.onMessage_aroundBody0(ajc$this, msg);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ SitesGraphResult getSitesGraphFromDB_aroundBody2(SitesDepCacheService ajc$this) {
        return SitesDependencyDao.get();
    }

    private static final /* synthetic */ Object getSitesGraphFromDB_aroundBody3$advice(SitesDepCacheService ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SitesDepCacheService.getSitesGraphFromDB_aroundBody2(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            SitesGraphResult object = SitesDepCacheService.getSitesGraphFromDB_aroundBody2(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

