/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.distribution;

import com.ericsson.cms.sites.distribution.TemplateInfo;
import com.ericsson.cms.sites.distribution.TemplateVariable;
import com.ericsson.cms.sites.distribution.TemplateVariableDataType;
import com.ericsson.cms.sites.distribution.jaxb.DistributionTemplates;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.util.XMLDocumentUtility;
import com.tandbergtv.watchpoint.routing.SoapRouter;
import com.tandbergtv.workflow.api.API;
import com.tandbergtv.workflow.api.Templates;
import com.tandbergtv.workflow.api.model.process.Template;
import com.tandbergtv.workflow.api.model.process.TemplateListResponse;
import com.tandbergtv.workflow.api.model.process.Variable;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.message.util.Marshaller;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DistributionManager {
    private static final Logger logger = Logger.getLogger(DistributionManager.class);
    private static final String SITES_CONFIG_DIR = "site";
    private static final String CONFIG_FILE_PATH = "dist-templates.xml";
    private static final String VAR_SITEID = "siteId";
    private static final String VAR_TITLEID = "titleId";
    private static final String VAR_PROVIDERID = "providerId";
    private static DistributionManager _instance;
    private File configFile;
    private List<DistributionTemplates.DistributionTemplate> templateConfigurations;
    private IConfigurationService configReaderService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);

    private DistributionManager() {
        this.configFile = this.configReaderService.getFile(SITES_CONFIG_DIR, CONFIG_FILE_PATH);
    }

    public static synchronized DistributionManager getInstance() {
        if (_instance == null) {
            _instance = new DistributionManager();
        }
        return _instance;
    }

    public List<DistributionTemplates.DistributionTemplate> readTemplateConfigurations() {
        List<DistributionTemplates.DistributionTemplate> templateList = null;
        if (!this.configFile.exists()) {
            return null;
        }
        templateList = this.unmarshal(this.configFile);
        return templateList;
    }

    public List<DistributionTemplates.DistributionTemplate> unmarshal(File configFile) {
        logger.debug((Object)("Loading distribution templates conf from file: " + configFile));
        List<DistributionTemplates.DistributionTemplate> distTemplatesList = new ArrayList<DistributionTemplates.DistributionTemplate>();
        try {
            JAXBContext jc = JAXBContext.newInstance((String)(String.valueOf(DistributionManager.class.getPackage().getName()) + ".jaxb"));
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            DistributionTemplates distTemplates = (DistributionTemplates)unmarshaller.unmarshal(configFile);
            distTemplatesList = distTemplates.getDistributionTemplate();
        }
        catch (Exception e) {
            logger.warn((Object)("Exception occured in loading distribution templates config from file: " + configFile), (Throwable)e);
        }
        return distTemplatesList;
    }

    public Set<TemplateInfo> getDistributionTemplateInfos() {
        TreeSet<TemplateInfo> templateInfos = new TreeSet<TemplateInfo>(this.templateComparator());
        try {
            for (Template template : this.getTemplateList()) {
                template = this.getTemplate(template.getId());
                TemplateInfo ti = new TemplateInfo();
                ti.setTemplateName(template.getName());
                ti.setTemplateId(template.getId());
                for (Variable variable : template.getVariables()) {
                    String variableName;
                    if (!variable.getRequired().booleanValue() || VAR_SITEID.equals(variableName = variable.getName()) || VAR_TITLEID.equals(variableName) || VAR_PROVIDERID.equals(variableName)) continue;
                    String mappedName = variable.getDisplayname();
                    TemplateVariable templateVariable = new TemplateVariable();
                    templateVariable.setMappedName(mappedName);
                    templateVariable.setDataType(this.getTemplateVariableDateType(variable.getType()));
                    ti.addRequiredVariable(variableName, templateVariable);
                }
                templateInfos.add(ti);
            }
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to get distribution templates", (Throwable)e);
        }
        return templateInfos;
    }

    public Set<String> getDistributionTemplateNames() {
        HashSet<String> names = new HashSet<String>();
        try {
            List<Template> templates = this.getTemplateList();
            for (Template template : templates) {
                names.add(template.getName());
            }
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to get distribution templates", (Throwable)e);
        }
        return names;
    }

    private TemplateVariableDataType getTemplateVariableDateType(String datatype) {
        TemplateVariableDataType templateVariableDataType = TemplateVariableDataType.STRING;
        if ("INT".equalsIgnoreCase(datatype)) {
            return TemplateVariableDataType.INTEGER;
        }
        if (TemplateVariableDataType.BOOLEAN.name().equalsIgnoreCase(datatype)) {
            return TemplateVariableDataType.BOOLEAN;
        }
        if (TemplateVariableDataType.DATE.name().equalsIgnoreCase(datatype)) {
            return TemplateVariableDataType.DATE;
        }
        return templateVariableDataType;
    }

    public void distribute(int siteId, long titleId, String templateName, String associatedResourceConnStr, Map<String, String> requiredTemplateVariables) {
        HashMap<String, String> allVariables = new HashMap<String, String>();
        allVariables.putAll(requiredTemplateVariables);
        allVariables.put(VAR_SITEID, Integer.toString(siteId));
        allVariables.put(VAR_TITLEID, Long.toString(titleId));
        if (associatedResourceConnStr != null) {
            allVariables.put("associatedResource", associatedResourceConnStr);
        }
        WorkflowMessage message = this.createWorkFlowMessage(templateName, allVariables);
        SoapRouter router = new SoapRouter();
        try {
            IMessage msg = this.convert(message);
            router.send(msg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private WorkflowMessage createWorkFlowMessage(String templateName, Map<String, String> variables) {
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)"SM0109");
        WPCLCommand command = new WPCLCommand("create");
        command.addParameter("_template", templateName);
        message.setCommand(command);
        WorkflowPayload payload = message.getPayload();
        for (Map.Entry<String, String> variable : variables.entrySet()) {
            payload.putValue(variable.getKey(), variable.getValue());
        }
        return message;
    }

    private IMessage convert(WorkflowMessage message) throws Exception {
        Document document = Marshaller.newMarshaller().marshal(message);
        StringPayload payload = new StringPayload(XMLDocumentUtility.convertToString((Node)document));
        return new MessageImpl((IPayload)payload, message.getAttachment());
    }

    public List<DistributionTemplates.DistributionTemplate> getTemplateConfigurations() {
        return this.templateConfigurations;
    }

    public void deleteConfigFile() {
        boolean success = this.configFile.delete();
        if (success) {
            logger.info((Object)"Config file has been deleted");
        } else {
            logger.info((Object)"Config file has NOT been deleted");
        }
    }

    private Template getTemplate(String id) throws IOException {
        Templates request = this.request();
        request.query().id(id);
        TemplateListResponse response = request.execute();
        if (response.getItems().isEmpty()) {
            return null;
        }
        return (Template)response.getItems().get(0);
    }

    private List<Template> getTemplateList() throws IOException {
        Templates request = this.request();
        request.query().category("Distribution").count(100);
        try {
            TemplateListResponse response = request.execute();
            return response.getItems();
        }
        catch (Exception e) {
            logger.error((Object)("Failed to get the template list. Exception: " + e.getMessage()));
            return new ArrayList<Template>();
        }
    }

    private Templates request() {
        return new API.Builder().build().templates();
    }

    private Comparator<TemplateInfo> templateComparator() {
        return new Comparator<TemplateInfo>(){

            @Override
            public int compare(TemplateInfo o1, TemplateInfo o2) {
                return o1.getTemplateName().compareTo(o2.getTemplateName());
            }
        };
    }
}

