/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.distribution.upgrade;

import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class TemplateUpgradeDBManager {
    private static final Logger logger = Logger.getLogger((String)TemplateUpgradeDBManager.class.getName());
    public static final String name = "annotation-@Category(\"Distribution\")";
    public static final String expression = "@Category(\"Distribution\")";
    private final SessionFactory sessionFactory = this.getSessionFactory();
    Session session;

    protected SessionFactory getSessionFactory() {
        try {
            return HibernateContext.getContext().getSessionFactory();
        }
        catch (Exception e) {
            logger.error((Object)"Could not get SessionFactory from Application Context", (Throwable)e);
            throw new IllegalStateException("Could not get SessionFactory from Application Context");
        }
    }

    public Session getSession() {
        this.session = this.sessionFactory.openSession();
        return this.session;
    }

    public void createDistirbutionAnnotation(String templateName, String groupName) {
        try {
            Long templateId;
            if (groupName != null) {
                this.updateDistributionSites(groupName, templateName);
            }
            if ((templateId = this.getProcessDefinition(templateName)) != null && !this.isUpgraded(templateId)) {
                this.insertAnnotations(templateId);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isUpgraded(long proccessDefId) throws SQLException {
        this.session = this.getSession();
        String queryStr = "SELECT id_ FROM  jbpm_action WHERE name_ = ? AND processdefinition_ = ?";
        try {
            SQLQuery query = this.session.createSQLQuery(queryStr);
            query.setParameter(0, (Object)name);
            query.setParameter(1, (Object)proccessDefId);
            query.addScalar("id_", (Type)StandardBasicTypes.LONG);
            List result = query.list();
            if (result != null && !result.isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception updating group name " + e));
        }
        finally {
            this.session.close();
        }
        return false;
    }

    private void updateDistributionSites(String groupName, String templateName) {
        this.session = this.getSession();
        String queryStr = "update SITES_SITE set associated_group_name='" + groupName + "' where dist_template_name='" + templateName + "'";
        Transaction tx = null;
        try {
            try {
                tx = this.session.beginTransaction();
                SQLQuery query = this.session.createSQLQuery(queryStr);
                query.executeUpdate();
                tx.commit();
            }
            catch (Exception e) {
                logger.error((Object)("Exception updating group name " + e));
                this.session.close();
            }
        }
        finally {
            this.session.close();
        }
    }

    private void insertAnnotations(Long proccessDefId) throws Exception {
        this.session = this.getSession();
        String queryStr = "insert into jbpm_action (class, name_, expression_, ispropagationallowed_, isasync_, processdefinition_) values ('X', ?, ?, 1, 0,  ?)";
        Transaction tx = null;
        try {
            try {
                tx = this.session.beginTransaction();
                SQLQuery query = this.session.createSQLQuery(queryStr);
                query.setParameter(0, (Object)name);
                query.setParameter(1, (Object)expression);
                query.setParameter(2, (Object)proccessDefId);
                query.executeUpdate();
                tx.commit();
            }
            catch (Exception e) {
                logger.error((Object)("Exception inserting template annotations " + e));
                this.session.close();
            }
        }
        finally {
            this.session.close();
        }
    }

    private Long getProcessDefinition(String processDefName) throws SQLException {
        this.session = this.getSession();
        String queryStr = "SELECT id_ FROM jbpm_processdefinition WHERE upper(name_) = ? order by version_ desc";
        try {
            Iterator iterator;
            SQLQuery query = this.session.createSQLQuery(queryStr);
            String upName = processDefName.toUpperCase();
            query.addScalar("id_", (Type)StandardBasicTypes.LONG);
            query.setParameter(0, (Object)upName);
            List results = query.list();
            if (results != null && (iterator = results.iterator()).hasNext()) {
                Long id;
                Long l = id = (Long)iterator.next();
                return l;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception inserting template annotations " + e));
        }
        finally {
            this.session.close();
        }
        return null;
    }
}

