/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring;

import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.sites.core.DistTimeoutManager;
import com.ericsson.cms.sites.monitoring.plugins.IStatusPluginManager;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;
import org.java.plugin.PluginLifecycleException;

public class HazClusterNodeManager
implements MembershipListener {
    private IStatusPluginManager statusPluginManager;
    private static Logger logger = Logger.getLogger((String)HazClusterNodeManager.class.getName());
    private IClusterService hzcs = Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH);

    public void memberAdded(MembershipEvent event) {
        logger.debug((Object)("member added: " + event.getMember()));
    }

    public void memberRemoved(MembershipEvent event) {
        logger.debug((Object)("member removed: " + event.getMember()));
        if (this.hzcs.isMaster()) {
            InetSocketAddress address = event.getMember().getSocketAddress();
            String hostAddress = address.getAddress().getHostAddress();
            DistTimeoutManager.getInstance().rescheduleDistributionSiteTitles(hostAddress);
            DistTimeoutManager.getInstance().rescheduleTrackingSiteTitles(hostAddress);
        }
        try {
            this.getStatusPluginManager().activate();
        }
        catch (PluginLifecycleException e) {
            logger.error((Object)("Exception occurred : " + (Object)((Object)e)), (Throwable)e);
        }
    }

    public void memberAttributeChanged(MemberAttributeEvent arg0) {
    }

    private IStatusPluginManager getStatusPluginManager() {
        if (this.statusPluginManager == null) {
            this.statusPluginManager = (IStatusPluginManager)InjectionUtil.injectInstance((String)"cms/StatusPluginManager/local", IStatusPluginManager.class);
        }
        return this.statusPluginManager;
    }
}

