/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.scheduling;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.scheduler.IRecoveryService;
import com.ericsson.cms.scheduler.ISchedulerCallback;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.InactiveSiteException;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.core.entities.Site;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.entities.SiteType;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;

public class SiteTimerSchedulerCallback
implements ISchedulerCallback {
    private static final Logger logger = Logger.getLogger(SiteTimerSchedulerCallback.class);
    private static final String ENTITY_TYPE_SITE_TIMER = "sitetimer";
    private static final String FILTER_NAME_PREFIX = "$Title Metadata.";
    private static final String FILTER_NAME_SEPARATOR = ".";
    private static final String ASSET_TYPE_SEPARATOR = "/";
    private static final String DATE_FORMAT_STRING = "yyyy-MM-dd";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final String KEY_READY_DIST_SITE_TITLE_IDS = "ReadyDistributionSiteTitleIds";
    private static final String KEY_SEARCHED_TITLE_IDS = "SearchedSiteTitleIds";
    private ITitleSearchService searchService = (ITitleSearchService)InjectionUtil.injectInstance((String)"cms/TitleSearchServiceProxy/local", ITitleSearchService.class);

    public void performAction(long jobId, String associatedEntityType, Set<Long> associatedEntityIds, String filterName, Date filterValue, Date execDate, IRecoveryService rs) {
        logger.info((Object)("performAction() called with jobId : " + jobId + ", associatedEntityType : " + associatedEntityType + ", associatedEntityIds : " + associatedEntityIds + ", filterName : " + filterName + ", filterValue : " + filterValue + ", execDate : " + execDate));
        if (ENTITY_TYPE_SITE_TIMER.equals(associatedEntityType)) {
            ISiteManager siteManager = this.getSiteManager();
            for (Long associatedEntityId : associatedEntityIds) {
                ArrayList list;
                Serializable serializable;
                int siteId = associatedEntityId.intValue();
                logger.debug((Object)("siteId : " + siteId));
                DistributionSite distSite = this.getDistributionSite(siteId);
                if (!distSite.isActive()) {
                    throw new InactiveSiteException((Site)distSite);
                }
                TransactionManager transactionManager = null;
                try {
                    transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
                }
                catch (NamingException e1) {
                    throw new RuntimeException("NamingException while getting TransactionManager", e1);
                }
                ArrayList<Long> dstIdsArrayList = new ArrayList<Long>();
                if (filterName == null) {
                    try {
                        transactionManager.begin();
                        serializable = rs.get(KEY_READY_DIST_SITE_TITLE_IDS);
                        if (serializable instanceof ArrayList) {
                            list = (ArrayList)serializable;
                            logger.debug((Object)("Got ArrayList for key : ReadyDistributionSiteTitleIds : " + list));
                            dstIdsArrayList.addAll(list);
                        } else {
                            logger.debug((Object)"Searching for Ready Titles...");
                            List dstsList = siteManager.getDistributionSiteTitlesBySiteAndStatus(siteId, DistributionStatus.READY_FOR_DISTRIBUTION);
                            for (DistributionSiteTitle dst : dstsList) {
                                dstIdsArrayList.add(dst.getTitle().getId());
                            }
                            rs.save(KEY_READY_DIST_SITE_TITLE_IDS, dstIdsArrayList);
                            logger.debug((Object)("Saved distribution site titles ArrayList for key : ReadyDistributionSiteTitleIds : " + dstIdsArrayList));
                        }
                        transactionManager.commit();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to get ready titles list ", (Throwable)e);
                        try {
                            if (transactionManager.getTransaction() != null) {
                                transactionManager.rollback();
                            }
                        }
                        catch (Exception e2) {
                            logger.error((Object)"Unable to rollback the transaction", (Throwable)e2);
                        }
                        throw new RuntimeException(e);
                    }
                    this.distribute(dstIdsArrayList, rs, KEY_READY_DIST_SITE_TITLE_IDS);
                    try {
                        transactionManager.begin();
                        rs.deleteAll();
                        rs.markDone();
                        transactionManager.commit();
                        logger.info((Object)("Finished distribution of ready titles of site: " + siteId));
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to mark recovery service as done ", (Throwable)e);
                        try {
                            if (transactionManager.getTransaction() != null) {
                                transactionManager.rollback();
                            }
                        }
                        catch (Exception e2) {
                            logger.error((Object)"Unable to rollback the transaction", (Throwable)e2);
                        }
                        throw new RuntimeException(e);
                    }
                }
                try {
                    transactionManager.begin();
                    serializable = rs.get(KEY_SEARCHED_TITLE_IDS);
                    if (serializable instanceof ArrayList) {
                        list = (ArrayList)serializable;
                        logger.debug((Object)("Got ArrayList for key : SearchedSiteTitleIds : " + list));
                        dstIdsArrayList.addAll(list);
                    } else {
                        String[] filterNamePartsArray;
                        int numFilterNameParts;
                        if (filterName.startsWith(FILTER_NAME_PREFIX)) {
                            filterName = filterName.substring(FILTER_NAME_PREFIX.length());
                        }
                        if ((numFilterNameParts = (filterNamePartsArray = filterName.split("\\.")).length) > 1) {
                            String xpath = filterNamePartsArray[numFilterNameParts - 1];
                            String assetType = filterNamePartsArray[0];
                            int i = 1;
                            while (i < numFilterNameParts - 1) {
                                assetType = String.valueOf(assetType) + ASSET_TYPE_SEPARATOR + filterNamePartsArray[i];
                                ++i;
                            }
                            ArrayList<Integer> siteIds = new ArrayList<Integer>();
                            siteIds.add(siteId);
                            ExpList condition = new ExpList();
                            ArrayList<String> metaValues = new ArrayList<String>();
                            String metaValue = DATE_FORMAT.format(filterValue);
                            metaValues.add(metaValue);
                            PredicateRightValue metaCond = new PredicateRightValue(xpath, assetType, FieldType.ASSET, metaValues, LogicalOperator.EQUAL, Boolean.valueOf(false));
                            condition.addItem((ExpNode)new ExpValue((Predicate)metaCond));
                            ArrayList<String> statusValues = new ArrayList<String>();
                            String strDistStatus = String.valueOf(DistributionStatus.READY_FOR_DISTRIBUTION.ordinal());
                            statusValues.add(strDistStatus);
                            PredicateRightValue siteCond = new PredicateRightValue("status", "", FieldType.SITE, statusValues, LogicalOperator.EQUAL, "integer", Boolean.valueOf(false));
                            condition.addItem((ExpNode)new ExpValue((Predicate)siteCond));
                            List searchResults = this.searchService.getSiteTitleIds((ExpNode)condition, siteIds, SiteType.DISTRIBUTION_SITE);
                            dstIdsArrayList.addAll(searchResults);
                            rs.save(KEY_SEARCHED_TITLE_IDS, dstIdsArrayList);
                            logger.debug((Object)("Saved distribution site titles ArrayList for key : SearchedSiteTitleIds : " + dstIdsArrayList));
                        } else {
                            logger.warn((Object)("Cannot determine asset type and xPath from the given filterName : " + filterName));
                        }
                    }
                    transactionManager.commit();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to get titles list by the given filter ", (Throwable)e);
                    try {
                        if (transactionManager.getTransaction() != null) {
                            transactionManager.rollback();
                        }
                    }
                    catch (Exception e2) {
                        logger.error((Object)"Unable to rollback the transaction", (Throwable)e2);
                    }
                    throw new RuntimeException(e);
                }
                this.distribute(dstIdsArrayList, rs, KEY_SEARCHED_TITLE_IDS);
                try {
                    transactionManager.begin();
                    rs.deleteAll();
                    rs.markDone();
                    transactionManager.commit();
                    logger.info((Object)("Finished distribution of searched titles of site: " + siteId));
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to mark recovery service as done ", (Throwable)e);
                    try {
                        if (transactionManager.getTransaction() != null) {
                            transactionManager.rollback();
                        }
                    }
                    catch (Exception e2) {
                        logger.error((Object)"Unable to rollback the transaction", (Throwable)e2);
                    }
                    throw new RuntimeException(e);
                }
            }
        } else {
            logger.warn((Object)("Got associatedEntityType : " + associatedEntityType + ". Only associatedEntityType : " + ENTITY_TYPE_SITE_TIMER + " is handled by SiteTimerSchedulerCallback."));
        }
    }

    protected void distribute(List<Long> localTitleIds, IRecoveryService rs, String rsKey) {
        logger.debug((Object)("Distributing local titles : " + localTitleIds));
        TransactionManager transactionManager = null;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
        }
        catch (NamingException e1) {
            throw new RuntimeException("NamingException while getting TransactionManager", e1);
        }
        Iterator<Long> dstIdsArrayListIterator = localTitleIds.iterator();
        while (dstIdsArrayListIterator.hasNext()) {
            Long dstId = dstIdsArrayListIterator.next();
            try {
                ISiteManager siteManager = this.getSiteManager();
                transactionManager.begin();
                siteManager.distributeImmediately(dstId.longValue());
                logger.debug((Object)("Distributed distribution site title id : " + dstId));
                dstIdsArrayListIterator.remove();
                rs.save(rsKey, new ArrayList<Long>(localTitleIds));
                logger.debug((Object)("Saved localTitleIds : " + localTitleIds));
                transactionManager.commit();
            }
            catch (Exception e) {
                logger.error((Object)("Failed to distribute distribution site title: " + dstId), (Throwable)e);
                try {
                    if (transactionManager.getTransaction() == null) continue;
                    transactionManager.rollback();
                }
                catch (Exception e2) {
                    logger.error((Object)"Unable to rollback the transaction", (Throwable)e2);
                }
            }
        }
        logger.debug((Object)"Finished distribution of local titles...");
    }

    protected DistributionSite getDistributionSite(int siteId) {
        Site site = this.getSiteManager().getSite(siteId);
        if (site.getType() != com.ericsson.cms.sites.core.entities.SiteType.DISTRIBUTION) {
            throw new RuntimeException("Given siteId: " + siteId + " does not correspond to a Distribution Site");
        }
        return (DistributionSite)site;
    }

    private ISiteManager getSiteManager() {
        return (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
    }
}

