/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.util;

import com.ericsson.cms.sites.core.CISPersistenceException;
import com.ericsson.cms.sites.core.entities.CISNotificationData;
import com.ericsson.cms.sites.core.entities.CISNotificationType;
import java.io.UnsupportedEncodingException;

public class CISPresistenceUtility {
    public static void verify(CISNotificationData data) throws CISPersistenceException, UnsupportedEncodingException {
        if (data == null || data.getSiteId() == null || data.getCmsIdentity() == null || data.getCmsSystemId() == null || data.getMessageId() == null || data.getCmsIdentity().isEmpty() || data.getCmsSystemId().isEmpty() || data.getMessageId().isEmpty() || data.getNotificationType() == null || data.getCallOutURLs() == null || data.getCallOutURLs().size() == 0) {
            throw new CISPersistenceException("One or more of the mandatory CISNotificationData fields are null or empty :" + data.toString());
        }
    }

    public static void verifyHQLRequest(Integer siteId, String identity, String messageId, CISNotificationType notificationType) throws CISPersistenceException {
        if (siteId == null && (identity == null || identity.isEmpty()) && (messageId == null || messageId.isEmpty()) && notificationType == null) {
            throw new CISPersistenceException("All the mandatory HQL query fields are null or empty");
        }
    }

    public static String getHQLQuery(Integer siteId, String identity, String messageId, CISNotificationType notificationType, boolean delete) {
        String hql = "from CISNotificationData where ";
        if (delete) {
            hql = "delete " + hql;
        }
        boolean addSiteId = false;
        boolean addIdentity = false;
        boolean addMessageId = false;
        if (siteId != null) {
            hql = String.valueOf(hql) + " siteid = :siteid";
            addSiteId = true;
        }
        if (identity != null && !identity.isEmpty()) {
            hql = String.valueOf(hql) + (addSiteId ? " and" : "") + " identity = :identity";
            addIdentity = true;
        }
        if (messageId != null && !messageId.isEmpty()) {
            hql = String.valueOf(hql) + (addIdentity || addSiteId ? " and" : "") + " messageId = :messageId";
            addMessageId = true;
        }
        if (notificationType != null) {
            hql = String.valueOf(hql) + (addMessageId || addIdentity || addSiteId ? " and" : "") + " notificationType = :notificationType";
        }
        if (!delete) {
            hql = String.valueOf(hql) + " order by id asc";
        }
        return hql;
    }
}

