/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.ui.workflow.client.IListResources;
import com.tandbergtv.cms.ui.workflow.client.IListResourcesAsync;
import com.tandbergtv.cms.ui.workflow.client.PortletConstants;
import com.tandbergtv.cms.ui.workflow.client.Resource;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClusterStatusPortlet
extends Portlet {
    private FlexTableContainer table;
    private SimplePanel empty;
    private IListResourcesAsync service = (IListResourcesAsync)GWT.create(IListResources.class);
    private PortletConstants constants = (PortletConstants)GWT.create(PortletConstants.class);
    private Timer refreshTimer;
    private int refreshPeriod;

    public ClusterStatusPortlet(int refreshTimeMillis) {
        super("BUSINESS_CONTINUANCE");
        this.refreshPeriod = refreshTimeMillis;
        this.setTitle(this.constants.cluTitle());
        this.setDisplayName(this.constants.cluTitle());
        this.table = new FlexTableContainer();
        this.table.setStyleName("portlet-resourceList-table");
        this.add((Widget)this.table);
        this.empty = new SimplePanel((Widget)new LabelWidget(this.constants.cluNoData()));
        this.add((Widget)this.empty);
        this.refreshTimer = new Timer(){

            public void run() {
                ClusterStatusPortlet.this.reload();
            }
        };
        EventHandler handler = new EventHandler();
        this.addDocumentAttachHandler(handler);
        this.addDocumentDetachHandler(handler);
    }

    private void reload() {
        this.service.getResources((AsyncCallback<List<Resource>>)new NeptuneAsyncCallback<List<Resource>>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(List<Resource> resources) {
                if (!resources.isEmpty()) {
                    ClusterStatusPortlet.this.table.clear();
                    int rowCount = 0;
                    int onlineCount = 0;
                    int offlineCount = 0;
                    int totalCount = 0;
                    int appCount = 0;
                    int esCount = 0;
                    int dbCount = 0;
                    int dbOfflineCount = 0;
                    int appOfflineCount = 0;
                    int esOfflineCount = 0;
                    HashMap<String, Integer> counts = new HashMap<String, Integer>();
                    Collections.sort(resources, new Comparator<Resource>(){

                        @Override
                        public int compare(Resource r1, Resource r2) {
                            return r1.getName().compareTo(r2.getName());
                        }
                    });
                    long resourceGroupid = 0L;
                    for (Resource resource : resources) {
                        if (!resource.getResourceGroup().equalsIgnoreCase("Cluster")) continue;
                        resourceGroupid = resource.getResourceGroupid();
                        String name = resource.getName();
                        if (name.contains("application_")) {
                            ++appCount;
                        } else if (name.contains("elasticsearch_")) {
                            ++esCount;
                        } else if (name.startsWith("primary") || name.startsWith("secondary")) {
                            ++dbCount;
                        }
                        if (resource.getState().equals((Object)Resource.State.ONLINE)) {
                            ++onlineCount;
                            continue;
                        }
                        if (!resource.getState().equals((Object)Resource.State.HEARTBEAT_ERROR)) continue;
                        ++offlineCount;
                        if (name.contains("application_")) {
                            ++appOfflineCount;
                            continue;
                        }
                        if (name.contains("elasticsearch_")) {
                            ++esOfflineCount;
                            continue;
                        }
                        if (!name.startsWith("primary") && !name.startsWith("secondary")) continue;
                        ++dbOfflineCount;
                    }
                    counts.put("appCount", new Integer(appCount));
                    counts.put("esCount", new Integer(esCount));
                    counts.put("dbCount", new Integer(dbCount));
                    counts.put("appOfflineCount", new Integer(appOfflineCount));
                    counts.put("esOfflineCount", new Integer(esOfflineCount));
                    counts.put("dbOfflineCount", new Integer(dbOfflineCount));
                    totalCount = onlineCount + offlineCount;
                    if (offlineCount > 0) {
                        this.displayNodes(rowCount, Resource.State.HEARTBEAT_ERROR, offlineCount, resourceGroupid, totalCount, ClusterStatusPortlet.this.getImage(Resource.State.HEARTBEAT_ERROR, offlineCount, counts));
                    } else if (onlineCount > 0) {
                        this.displayNodes(rowCount, Resource.State.ONLINE, onlineCount, resourceGroupid, totalCount, ClusterStatusPortlet.this.getImage(Resource.State.ONLINE, onlineCount, counts));
                    } else {
                        this.displayNodes(rowCount, Resource.State.HEARTBEAT_ERROR, 0, resourceGroupid, totalCount, ClusterStatusPortlet.this.getImage(Resource.State.HEARTBEAT_ERROR, 0, counts));
                    }
                    if (totalCount > 0) {
                        ClusterStatusPortlet.this.table.setVisible(true);
                        ClusterStatusPortlet.this.empty.setVisible(false);
                    } else {
                        ClusterStatusPortlet.this.table.setVisible(false);
                        ClusterStatusPortlet.this.empty.setVisible(true);
                    }
                } else {
                    ClusterStatusPortlet.this.table.setVisible(false);
                    ClusterStatusPortlet.this.empty.setVisible(true);
                }
                ClusterStatusPortlet.this.update();
            }

            private void displayNodes(int rowCount, Resource.State state, int count, long resourceGroupid, int totalCount, ImageWidget image) {
                ClusterStatusPortlet.this.table.setWidget(rowCount, 0, (Widget)image);
                ClusterStatusPortlet.this.table.getCellFormatter().setStyleName(rowCount, 0, "portlet-resourceList-statusImgCol");
                String message = ClusterStatusPortlet.this.createMessage(count, state, totalCount);
                HyperlinkWidget link = new HyperlinkWidget(message, "Workflow.Resources.Queue?id=" + resourceGroupid);
                if (count == 0) {
                    ClusterStatusPortlet.this.table.setText(rowCount, 1, "No Nodes Available");
                } else {
                    ClusterStatusPortlet.this.table.setWidget(rowCount, 1, (Widget)link);
                }
                ClusterStatusPortlet.this.table.getCellFormatter().setStyleName(rowCount, 1, "portlet-resourceList-nameCol");
            }
        });
    }

    private String createMessage(int count, Resource.State state, int totalCount) {
        StringBuilder msg = new StringBuilder();
        msg.append(Integer.toString(count) + " out of " + totalCount + " ");
        msg.append(totalCount == 1 ? this.constants.cluNODE() : this.constants.cluNODES());
        msg.append(count == 1 ? " is " : " are ");
        msg.append(state == Resource.State.ONLINE ? this.constants.cluONLINE() : this.constants.cluOFFLINE());
        return msg.toString();
    }

    private ImageWidget getImage(Resource.State state, int count, Map<String, Integer> counts) {
        ImageWidget image = new ImageWidget("images/icon_circ_" + state.name() + ".png");
        if (state.name().equalsIgnoreCase("Online")) {
            image.setTitle(this.constants.cluONLINEMSG());
        } else if (count == 1) {
            image.setTitle(this.constants.cluPartialOFFLINEMSG());
        } else if (counts.get("appCount").equals(counts.get("appOfflineCount")) || counts.get("esCount").equals(counts.get("esOfflineCount")) || counts.get("dbCount").equals(counts.get("dbOfflineCount"))) {
            image.setTitle(this.constants.cluOFFLINEMSG());
        } else {
            image.setTitle(this.constants.cluPartialOFFLINEMSG());
        }
        return image;
    }

    private final class EventHandler
    implements DocumentAttachHandler,
    DocumentDetachHandler {
        private EventHandler() {
        }

        public void onAttach(DocumentAttachEvent event) {
            ClusterStatusPortlet.this.refreshTimer.scheduleRepeating(ClusterStatusPortlet.this.refreshPeriod);
            ClusterStatusPortlet.this.reload();
        }

        public void onDetach(DocumentDetachEvent event) {
            ClusterStatusPortlet.this.refreshTimer.cancel();
        }
    }
}

