/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.ui.workflow.client.IListResourceGroupQueues;
import com.tandbergtv.cms.ui.workflow.client.IListResourceGroupQueuesAsync;
import com.tandbergtv.cms.ui.workflow.client.PortletConstants;
import com.tandbergtv.cms.ui.workflow.client.Queue;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ResourceGroupQueueListPortlet
extends Portlet {
    private FlexTableContainer table;
    private SimplePanel empty;
    private IListResourceGroupQueuesAsync service;
    private PortletConstants constants;
    private Timer refreshTimer;
    private int refreshPeriod;

    public ResourceGroupQueueListPortlet(int refreshTimeMillis) {
        super("RESOURCE_GROUP_QUEUE_LIST");
        this.refreshPeriod = refreshTimeMillis;
        this.service = (IListResourceGroupQueuesAsync)GWT.create(IListResourceGroupQueues.class);
        this.constants = (PortletConstants)GWT.create(PortletConstants.class);
        this.setTitle(this.constants.queueTitle());
        this.setDisplayName(this.constants.queueTitle());
        this.table = new FlexTableContainer();
        this.table.setStyleName("portlet-resGrpQList-table");
        this.add((Widget)this.table);
        this.empty = new SimplePanel((Widget)new LabelWidget(this.constants.queueNoData()));
        this.add((Widget)this.empty);
        this.refreshTimer = new Timer(){

            public void run() {
                ResourceGroupQueueListPortlet.this.reload();
            }
        };
        EventHandler handler = new EventHandler();
        this.addDocumentAttachHandler(handler);
        this.addDocumentDetachHandler(handler);
    }

    private void reload() {
        this.service.getResourceGroupQueues((AsyncCallback<List<Queue>>)new NeptuneAsyncCallback<List<Queue>>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(List<Queue> queues) {
                if (!queues.isEmpty()) {
                    ResourceGroupQueueListPortlet.this.table.clear();
                    Collections.sort(queues, new Comparator<Queue>(){

                        @Override
                        public int compare(Queue o1, Queue o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    });
                    int rowCount = 0;
                    for (Queue q : queues) {
                        ResourceGroupQueueListPortlet.this.table.getCellFormatter().setStyleName(rowCount, 0, "portlet-resGrpQList-name-cell");
                        ResourceGroupQueueListPortlet.this.table.setWidget(rowCount, 0, (Widget)new LabelWidget(q.getName()));
                        ResourceGroupQueueListPortlet.this.table.getCellFormatter().setStyleName(rowCount, 1, "portlet-resGrpQList-count-cell");
                        HyperlinkWidget count = new HyperlinkWidget(String.valueOf(q.getNumItemsInQueue()), "Workflow.Resources.Queue?id=" + q.getId());
                        count.setStyleName("portlet-resGrpQList-name-link");
                        ResourceGroupQueueListPortlet.this.table.setWidget(rowCount, 1, (Widget)count);
                        ++rowCount;
                    }
                    ResourceGroupQueueListPortlet.this.table.setVisible(true);
                    ResourceGroupQueueListPortlet.this.empty.setVisible(false);
                } else {
                    ResourceGroupQueueListPortlet.this.table.setVisible(false);
                    ResourceGroupQueueListPortlet.this.empty.setVisible(true);
                }
                ResourceGroupQueueListPortlet.this.update();
            }
        });
    }

    private final class EventHandler
    implements DocumentAttachHandler,
    DocumentDetachHandler {
        private EventHandler() {
        }

        public void onAttach(DocumentAttachEvent event) {
            ResourceGroupQueueListPortlet.this.refreshTimer.scheduleRepeating(ResourceGroupQueueListPortlet.this.refreshPeriod);
            ResourceGroupQueueListPortlet.this.reload();
        }

        public void onDetach(DocumentDetachEvent event) {
            ResourceGroupQueueListPortlet.this.refreshTimer.cancel();
        }
    }
}

