/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.ui.workflow.client.IListResources;
import com.tandbergtv.cms.ui.workflow.client.IListResourcesAsync;
import com.tandbergtv.cms.ui.workflow.client.PortletConstants;
import com.tandbergtv.cms.ui.workflow.client.Resource;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ResourceListPortlet
extends Portlet {
    private FlexTableContainer table;
    private SimplePanel empty;
    private IListResourcesAsync service = (IListResourcesAsync)GWT.create(IListResources.class);
    private PortletConstants constants = (PortletConstants)GWT.create(PortletConstants.class);
    private Timer refreshTimer;
    private int refreshPeriod;

    public ResourceListPortlet(int refreshTimeMillis) {
        super("RESOURCE_LIST");
        this.refreshPeriod = refreshTimeMillis;
        this.setTitle(this.constants.resTitle());
        this.setDisplayName(this.constants.resTitle());
        this.table = new FlexTableContainer();
        this.table.setStyleName("portlet-resourceList-table");
        this.add((Widget)this.table);
        this.empty = new SimplePanel((Widget)new LabelWidget(this.constants.resNoData()));
        this.add((Widget)this.empty);
        this.refreshTimer = new Timer(){

            public void run() {
                ResourceListPortlet.this.reload();
            }
        };
        EventHandler handler = new EventHandler();
        this.addDocumentAttachHandler(handler);
        this.addDocumentDetachHandler(handler);
    }

    private void reload() {
        this.service.getResources((AsyncCallback<List<Resource>>)new NeptuneAsyncCallback<List<Resource>>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(List<Resource> resources) {
                if (!resources.isEmpty()) {
                    ResourceListPortlet.this.table.clear();
                    int rowCount = 0;
                    Collections.sort(resources, new Comparator<Resource>(){

                        @Override
                        public int compare(Resource r1, Resource r2) {
                            return r1.getName().compareTo(r2.getName());
                        }
                    });
                    ResourceListPortlet.this.table.setWidget(rowCount, 0, (Widget)new LabelWidget("Status"));
                    ResourceListPortlet.this.table.getCellFormatter().setStyleName(rowCount, 0, "portlet-tableHeader");
                    ResourceListPortlet.this.table.setWidget(rowCount, 1, (Widget)new LabelWidget("Resource Name"));
                    ResourceListPortlet.this.table.getCellFormatter().setStyleName(rowCount, 1, "portlet-tableHeader");
                    ResourceListPortlet.this.table.getCellFormatter().setStyleName(rowCount, 2, "portlet-tableHeader");
                    ++rowCount;
                    for (Resource resource : resources) {
                        ResourceListPortlet.this.table.setWidget(rowCount, 0, (Widget)ResourceListPortlet.this.getImage(resource.getState()));
                        ResourceListPortlet.this.table.getCellFormatter().setStyleName(rowCount, 0, "portlet-resourceList-statusImgCol");
                        HyperlinkWidget link = new HyperlinkWidget(resource.getName(), "Workflow.Resources.Modify?id=" + resource.getId());
                        ResourceListPortlet.this.table.setWidget(rowCount, 1, (Widget)link);
                        ResourceListPortlet.this.table.getCellFormatter().setStyleName(rowCount, 1, "portlet-resourceList-nameCol");
                        if (resource.isCurrentlyUsed()) {
                            ImageWidget image = new ImageWidget("images/icon_res_currUsed.png");
                            image.setTitle(ResourceListPortlet.this.constants.resCurrentlyUsed());
                            ResourceListPortlet.this.table.setWidget(rowCount, 2, (Widget)image);
                        }
                        ResourceListPortlet.this.table.getCellFormatter().setStyleName(rowCount, 2, "portlet-resourceList-nameCol");
                        ++rowCount;
                    }
                    ResourceListPortlet.this.table.setVisible(true);
                    ResourceListPortlet.this.empty.setVisible(false);
                } else {
                    ResourceListPortlet.this.table.setVisible(false);
                    ResourceListPortlet.this.empty.setVisible(true);
                }
                ResourceListPortlet.this.update();
            }
        });
    }

    private ImageWidget getImage(Resource.State state) {
        ImageWidget image = new ImageWidget("images/icon_circ_" + state.name() + ".png");
        image.setTitle(this.constants.getString("res" + state.name()));
        return image;
    }

    private final class EventHandler
    implements DocumentAttachHandler,
    DocumentDetachHandler {
        private EventHandler() {
        }

        public void onAttach(DocumentAttachEvent event) {
            ResourceListPortlet.this.refreshTimer.scheduleRepeating(ResourceListPortlet.this.refreshPeriod);
            ResourceListPortlet.this.reload();
        }

        public void onDetach(DocumentDetachEvent event) {
            ResourceListPortlet.this.refreshTimer.cancel();
        }
    }
}

