/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.ui.workflow.client.IListUserTasks;
import com.tandbergtv.cms.ui.workflow.client.IListUserTasksAsync;
import com.tandbergtv.cms.ui.workflow.client.PortletConstants;
import com.tandbergtv.cms.ui.workflow.client.UiColumn;
import com.tandbergtv.cms.ui.workflow.client.UiTable;
import com.tandbergtv.cms.ui.workflow.client.UserTask;
import com.tandbergtv.cms.ui.workflow.client.UserTaskList;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class UserTaskListPortlet
extends Portlet {
    private static final int MAX_NUMBER_OF_COLUMNS = 4;
    private FlexTableContainer table;
    private SimplePanel empty;
    private IListUserTasksAsync service;
    private PortletConstants constants;
    private Timer refreshTimer;
    private int refreshPeriod;
    private UiTable uiTable;

    public UserTaskListPortlet(int refreshTimeMillis) {
        super("USER_TASK_LIST");
        this.refreshPeriod = refreshTimeMillis;
        this.service = (IListUserTasksAsync)GWT.create(IListUserTasks.class);
        this.constants = (PortletConstants)GWT.create(PortletConstants.class);
        this.setTitle(this.constants.userTaskTitle());
        this.setDisplayName(this.constants.userTaskTitle());
        this.table = new FlexTableContainer();
        this.table.setCellSpacing(0);
        this.table.setStyleName("portletFixedTable");
        this.table.setWidth("100%");
        this.add((Widget)this.table);
        this.empty = new SimplePanel((Widget)new LabelWidget(this.constants.userTaskNoData()));
        this.add((Widget)this.empty);
        this.refreshTimer = new Timer(){

            public void run() {
                UserTaskListPortlet.this.reload();
            }
        };
        EventHandler handler = new EventHandler();
        this.addDocumentAttachHandler(handler);
        this.addDocumentDetachHandler(handler);
    }

    private void initializeTable() {
        this.service.getUserTasksListTableConfiguration((AsyncCallback<UiTable>)new NeptuneAsyncCallback<UiTable>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(UiTable uiTable) {
                UserTaskListPortlet.this.setTable(uiTable);
            }
        });
    }

    protected void setTable(UiTable uiTable) {
        this.uiTable = uiTable;
    }

    private void reload() {
        this.initializeTable();
        this.service.getUserTasks((AsyncCallback<UserTaskList>)new NeptuneAsyncCallback<UserTaskList>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(UserTaskList userTaskList) {
                UserTaskListPortlet.this.updateTitle(userTaskList);
                if (userTaskList.getNumUserTasks() > 0) {
                    UserTaskListPortlet.this.clearTableData();
                    UserTaskListPortlet.this.prepareTableHeader();
                    UserTaskListPortlet.this.populateTableData(userTaskList);
                    UserTaskListPortlet.this.table.setVisible(true);
                    UserTaskListPortlet.this.empty.setVisible(false);
                } else {
                    UserTaskListPortlet.this.table.setVisible(false);
                    UserTaskListPortlet.this.empty.setVisible(true);
                }
                UserTaskListPortlet.this.update();
            }
        });
    }

    private void populateTableData(UserTaskList userTaskList) {
        List<UserTask> userTasks = userTaskList.getUserTasks();
        Collections.sort(userTasks, new Comparator<UserTask>(){

            @Override
            public int compare(UserTask t1, UserTask t2) {
                return t1.getName().compareTo(t2.getName());
            }
        });
        int dataRow = 1;
        for (UserTask userTask : userTasks) {
            if (userTask.hasEnded()) continue;
            int colIndex = 0;
            String historyToken = "Workflow.User Tasks.Perform?id=" + userTask.getWorkOrderID() + ":" + userTask.getTaskInstanceId();
            HyperlinkWidget link = new HyperlinkWidget(userTask.getName(), historyToken);
            link.setStyleName("portlet-userTasks-link");
            link.setTitle(userTask.getName());
            this.table.setWidget(dataRow, colIndex, (Widget)link);
            this.table.getCellFormatter().setStyleName(dataRow, colIndex, "portlet-table-text");
            this.populateTableDynamicData(dataRow, colIndex, userTask);
            ++dataRow;
        }
    }

    private void populateTableDynamicData(int rowIndex, int colIndex, UserTask userTask) {
        for (UiColumn column : this.uiTable.getColumns()) {
            if (colIndex + 1 > 4) {
                return;
            }
            ++colIndex;
            String text = "";
            Object value = null;
            value = column.getParameter() != null && !column.getParameter().isEmpty() ? userTask.getProcessVariable(column.getParameter()) : userTask.getTaskProperty(column.getMethodName());
            if (value != null) {
                text = value.toString();
            }
            LabelWidget label = new LabelWidget(text, false);
            label.setWidth("100%");
            label.setTitle(text);
            label.setStyleName("portletEllipsedCell");
            this.table.getCellFormatter().setStyleName(rowIndex, colIndex, "portlet-table-text");
            this.table.getCellFormatter().setWidth(rowIndex, colIndex, column.getWidth());
            this.table.setWidget(rowIndex, colIndex, (Widget)label);
        }
    }

    private void updateTitle(UserTaskList userTaskList) {
        this.setTitle(this.constants.userTaskTitle() + " (" + userTaskList.getNumUserTasks() + "/" + userTaskList.getTotalNumUserTasks() + ")");
    }

    private void clearTableData() {
        this.table.removeAllRows();
    }

    private void prepareTableHeader() {
        int colIndex = 0;
        LabelWidget label = new LabelWidget(this.constants.nodeNameColumn(), false);
        label.setWidth("100%");
        label.setTitle(this.constants.nodeNameColumn());
        label.setStyleName("portletEllipsedCell");
        this.table.setWidget(0, colIndex, (Widget)label);
        this.table.getCellFormatter().setStyleName(0, 0, "portlet-tableHeader");
        List<UiColumn> columns = this.uiTable.getColumns();
        if (columns == null) {
            return;
        }
        for (int i = 0; i < columns.size(); ++i) {
            if (colIndex + 1 > 4) {
                return;
            }
            ++colIndex;
            UiColumn col = columns.get(i);
            String colHeader = col.getColumnName();
            label = new LabelWidget(colHeader, false);
            label.setWidth("100%");
            label.setTitle(colHeader);
            label.setStyleName("portletEllipsedCell");
            this.table.getCellFormatter().setStyleName(0, colIndex, "portlet-tableHeader");
            this.table.getCellFormatter().setWidth(0, colIndex, col.getWidth());
            this.table.getColumnFormatter().setWidth(colIndex, col.getWidth());
            this.table.setWidget(0, colIndex, (Widget)label);
        }
    }

    private final class EventHandler
    implements DocumentAttachHandler,
    DocumentDetachHandler {
        private EventHandler() {
        }

        public void onAttach(DocumentAttachEvent event) {
            UserTaskListPortlet.this.refreshTimer.scheduleRepeating(UserTaskListPortlet.this.refreshPeriod);
            UserTaskListPortlet.this.reload();
        }

        public void onDetach(DocumentDetachEvent event) {
            UserTaskListPortlet.this.refreshTimer.cancel();
        }
    }
}

