/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.ui.workflow.client.IWOStatus;
import com.tandbergtv.cms.ui.workflow.client.IWOStatusAsync;
import com.tandbergtv.cms.ui.workflow.client.PortletConstants;
import com.tandbergtv.cms.ui.workflow.client.WOState;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;
import java.util.Map;
import java.util.TreeMap;

public class WOStatusPortlet
extends Portlet {
    private FlexTableContainer table;
    private SimplePanel empty;
    private IWOStatusAsync service;
    private PortletConstants constants;
    private Timer refreshTimer;
    private int refreshPeriod;

    public WOStatusPortlet(int refreshTimeMillis) {
        super("WO_STATUS");
        this.refreshPeriod = refreshTimeMillis;
        this.service = (IWOStatusAsync)GWT.create(IWOStatus.class);
        this.constants = (PortletConstants)GWT.create(PortletConstants.class);
        this.setTitle(this.constants.woTitle());
        this.setDisplayName(this.constants.woTitle());
        this.table = new FlexTableContainer();
        this.table.setStyleName("portlet-woStatus-table");
        this.add((Widget)this.table);
        this.empty = new SimplePanel((Widget)new LabelWidget(this.constants.woNoData()));
        this.add((Widget)this.empty);
        this.refreshTimer = new Timer(){

            public void run() {
                WOStatusPortlet.this.reload();
            }
        };
        EventHandler handler = new EventHandler();
        this.addDocumentAttachHandler(handler);
        this.addDocumentDetachHandler(handler);
    }

    private void reload() {
        this.service.getStatus((AsyncCallback<Map<WOState, Integer>>)new NeptuneAsyncCallback<Map<WOState, Integer>>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(Map<WOState, Integer> result) {
                if (!result.isEmpty()) {
                    WOStatusPortlet.this.table.clear();
                    int rowCount = 0;
                    WOStatusPortlet.this.table.setWidget(0, 0, (Widget)new LabelWidget("Status"));
                    WOStatusPortlet.this.table.getCellFormatter().setStyleName(0, 0, "portlet-tableHeader");
                    WOStatusPortlet.this.table.setWidget(0, 1, (Widget)new LabelWidget("Work Order Amount"));
                    WOStatusPortlet.this.table.getCellFormatter().setStyleName(0, 1, "portlet-tableHeader");
                    TreeMap<WOState, Integer> sorted = new TreeMap<WOState, Integer>(result);
                    for (Map.Entry statusEntry : sorted.entrySet()) {
                        WOStatusPortlet.this.table.setWidget(rowCount, 0, (Widget)WOStatusPortlet.this.getImage((WOState)((Object)statusEntry.getKey())));
                        WOStatusPortlet.this.table.getCellFormatter().setStyleName(rowCount, 0, "portlet-woStatus-imgCol");
                        WOStatusPortlet.this.table.setWidget(rowCount, 1, (Widget)new HyperlinkWidget(String.valueOf(statusEntry.getValue()), "Workflow.Work Orders.Search.Status=" + statusEntry.getKey()));
                        WOStatusPortlet.this.table.getCellFormatter().setStyleName(rowCount, 1, "portlet-woStatus-nameCol");
                        ++rowCount;
                    }
                    WOStatusPortlet.this.table.setVisible(true);
                    WOStatusPortlet.this.empty.setVisible(false);
                } else {
                    WOStatusPortlet.this.table.setVisible(false);
                    WOStatusPortlet.this.empty.setVisible(true);
                }
                WOStatusPortlet.this.update();
            }
        });
    }

    private ImageWidget getImage(WOState state) {
        ImageWidget image = new ImageWidget("images/icon_rect_" + state.name() + ".png");
        image.setTitle(this.getLocalizedStateName(state));
        return image;
    }

    private String getLocalizedStateName(WOState state) {
        return this.constants.getString("wo" + state.name());
    }

    private final class EventHandler
    implements DocumentAttachHandler,
    DocumentDetachHandler {
        private EventHandler() {
        }

        public void onAttach(DocumentAttachEvent event) {
            WOStatusPortlet.this.refreshTimer.scheduleRepeating(WOStatusPortlet.this.refreshPeriod);
            WOStatusPortlet.this.reload();
        }

        public void onDetach(DocumentDetachEvent event) {
            WOStatusPortlet.this.refreshTimer.cancel();
        }
    }
}

