/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.client;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleProgressService;
import com.tandbergtv.cms.ui.workflow.client.Permission;
import com.tandbergtv.cms.ui.workflow.client.PortletConstants;
import com.tandbergtv.cms.ui.workflow.client.ResourceGroupQueueListPortlet;
import com.tandbergtv.cms.ui.workflow.client.ResourceListPortlet;
import com.tandbergtv.cms.ui.workflow.client.UserTaskListPortlet;
import com.tandbergtv.cms.ui.workflow.client.WOStatusPortlet;
import com.tandbergtv.cms.ui.workflow.client.clusterstatus.ClusterNodeStatusPortlet;
import com.tandbergtv.cms.ui.workflow.client.geo.GeoRedundancyPortlet;
import com.tandbergtv.cms.ui.workflow.client.portlet.ActiveResourcesPortlet;
import com.tandbergtv.cms.ui.workflow.client.portlet.QueuedUserTasksPortlet;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.component.Component;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WorkflowComponent
extends ComponentBase {
    private static final String THIS_COMPONENT_NAME = "WatchPoint";
    private final PortletConstants constants = (PortletConstants)GWT.create(PortletConstants.class);
    private boolean geo;

    public boolean isGeo() {
        return this.geo;
    }

    public void setGeo(boolean geo) {
        this.geo = geo;
    }

    public void init(EventListenerRegistry eventListenerRegistry, EventSink eventSink, ServiceLoader serviceLoader, Map<String, String> info) {
        super.init(eventListenerRegistry, eventSink, serviceLoader, info);
        if (info != null && info.containsKey("geo")) {
            this.setGeo(Boolean.parseBoolean(info.get("geo")));
        }
    }

    public List<PortletFactory> listPortlets(NeptuneSecurity security) {
        int refreshTimeMillis;
        if (!this.isAuthorized(Permission.HOME)) {
            return null;
        }
        ArrayList<PortletFactory> portletFactories = new ArrayList<PortletFactory>();
        int confRefreshTimeMillis = -1;
        try {
            confRefreshTimeMillis = Integer.parseInt((String)this.info.get("workflow.portlets.refreshTime"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = refreshTimeMillis = confRefreshTimeMillis > 60000 ? confRefreshTimeMillis : 60000;
        if (this.isAuthorized(Permission.TASKS_PERFORM)) {
            portletFactories.add(new WorkflowPortletFactory(new UserTaskListPortlet(refreshTimeMillis), this));
        }
        if (this.isAuthorized(Permission.WORK_ORDERS_VIEW)) {
            portletFactories.add(new WorkflowPortletFactory(new WOStatusPortlet(refreshTimeMillis), this));
            portletFactories.add(new WorkflowPortletFactory(new ActiveResourcesPortlet(refreshTimeMillis), this));
        }
        if (this.isAuthorized(Permission.RESOURCES_VIEW)) {
            portletFactories.add(new WorkflowPortletFactory(new ResourceGroupQueueListPortlet(refreshTimeMillis), this));
            portletFactories.add(new WorkflowPortletFactory(new ResourceListPortlet(refreshTimeMillis), this));
            if (this.geo) {
                portletFactories.add(new WorkflowPortletFactory(new GeoRedundancyPortlet(refreshTimeMillis), this));
            }
            portletFactories.add(new WorkflowPortletFactory(new ClusterNodeStatusPortlet(refreshTimeMillis), this));
        }
        if (this.isAuthorized(Permission.TASKS_ASSIGN)) {
            portletFactories.add(new WorkflowPortletFactory(new QueuedUserTasksPortlet(refreshTimeMillis), this));
        }
        return portletFactories;
    }

    public static native String getNativeVariableType(String var0);

    public <E extends Service> List<E> listServices(Class<E> clazz, NeptuneSecurity security) {
        if (clazz.getName().equalsIgnoreCase(ITitleProgressService.class.getName())) {
            ArrayList<1> tpServices = new ArrayList<1>();
            tpServices.add(new ITitleProgressService(){

                public ITitleProgressService.Hyperlink getLink(String componentName, String entityName, String sourceId, String titleRevision) {
                    if (WorkflowComponent.THIS_COMPONENT_NAME.equals(componentName)) {
                        String historyToken = null;
                        if (WorkflowComponent.this.isAuthorized(Permission.WORK_ORDERS_VIEW)) {
                            int index;
                            int n = index = sourceId != null ? sourceId.indexOf(124) : -1;
                            if (index < 0) {
                                historyToken = "Workflow.Work Orders.Search.RequestKey=" + sourceId;
                            } else {
                                String processId = sourceId.substring(0, index);
                                historyToken = "Workflow.Work Orders.Search.Id=" + processId;
                            }
                        }
                        return new ITitleProgressService.Hyperlink(entityName, historyToken);
                    }
                    return null;
                }
            });
            return tpServices;
        }
        return null;
    }

    public List<MenuItemBase> listTabs(NeptuneSecurity security) {
        return new ArrayList<MenuItemBase>();
    }

    private boolean isAuthorized(Permission permission) {
        return ClientAuthorizationManager.isAuthorized((String[])new String[]{permission.toString()});
    }

    public String getName() {
        return "WORKFLOW";
    }

    public String getDisplayName() {
        return this.constants.componentDisplayName();
    }

    private static final class WorkflowPortletFactory
    implements PortletFactory {
        private final Portlet portlet;
        private WorkflowComponent workflowComponent;

        public WorkflowPortletFactory(Portlet portlet, WorkflowComponent workflowComponent) {
            this.portlet = portlet;
            this.workflowComponent = workflowComponent;
        }

        public Portlet getInstance() {
            return this.portlet;
        }

        public void release(Portlet widget) {
        }

        public Component getComponent() {
            return this.workflowComponent;
        }
    }
}

