/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.client.clusterstatus;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.core.client.JsonUtils;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.ui.workflow.client.PortletConstants;
import com.tandbergtv.cms.ui.workflow.client.clusterstatus.Check;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;
import java.util.HashMap;
import java.util.Map;

public class ClusterNodeStatusPortlet
extends Portlet {
    private FlexTableContainer table;
    private SimplePanel empty;
    private LabelWidget message;
    private PortletConstants constants = (PortletConstants)GWT.create(PortletConstants.class);
    private Timer refreshTimer;
    private int refreshPeriod;
    private static final String CMS_CLUSTER_STATUS_PORTLET_TABLE_STYLE = "cms-cluster-status-portlet-table";
    private static final String CONSUL_URL = "/v1/health/state/any?wait=30s";
    private static final RegExp NODE_NAME_PATTERN = RegExp.compile((String)"^([^\\d.]*)\\d*(\\.[^.]+)*$");
    private static final Map<String, String> NODE_TYPE_2_NAME = new HashMap<String, String>();

    public ClusterNodeStatusPortlet(int refreshTimeMillis) {
        super("BUSINESS_CONTINUANCE");
        this.refreshPeriod = refreshTimeMillis;
        this.initNameMapping();
        this.setTitle(this.constants.csTitle());
        this.setDisplayName(this.constants.csTitle());
        this.table = new FlexTableContainer();
        this.table.setCellSpacing(0);
        this.table.setStyleName("portletTable");
        this.table.addStyleName(CMS_CLUSTER_STATUS_PORTLET_TABLE_STYLE);
        this.add((Widget)this.table);
        this.message = new LabelWidget("NO DATA");
        this.empty = new SimplePanel((Widget)this.message);
        this.add((Widget)this.empty);
        this.refreshTimer = new Timer(){

            public void run() {
                ClusterNodeStatusPortlet.this.reload();
            }
        };
        EventHandler handler = new EventHandler();
        this.addDocumentAttachHandler(handler);
        this.addDocumentDetachHandler(handler);
    }

    private void initNameMapping() {
        NODE_TYPE_2_NAME.put("app", this.constants.appLabel());
        NODE_TYPE_2_NAME.put("cs", this.constants.csLabel());
        NODE_TYPE_2_NAME.put("edb", this.constants.edbLabel());
        NODE_TYPE_2_NAME.put("es", this.constants.esLabel());
        NODE_TYPE_2_NAME.put("pt", this.constants.ptLabel());
    }

    private void showData() {
        this.message.setText("NO DATA");
        this.empty.setVisible(false);
        this.table.setVisible(true);
        this.update();
    }

    private void showError(String error) {
        this.message.setText(error);
        this.empty.setVisible(true);
        this.table.setVisible(false);
        this.update();
    }

    private String getNodeName(String fullName) {
        MatchResult m = NODE_NAME_PATTERN.exec(fullName);
        if (m != null) {
            return m.getGroup(1);
        }
        return null;
    }

    private void renderTable(Map<String, Integer[]> status) {
        this.createTableHeader();
        int row = 1;
        for (Map.Entry<String, Integer[]> entry : status.entrySet()) {
            this.table.setHTML(row, 0, "<a href='#Monitoring.ClusterHealth'>" + NODE_TYPE_2_NAME.get(entry.getKey()) + "</a>");
            this.table.getCellFormatter().setStyleName(row, 0, "portlet-table-td");
            this.table.setHTML(row, 1, "<a href='#Monitoring.ClusterHealth'><img src='images/icon_database_ONLINE.png' align='absmiddle' hspace='3' />" + entry.getValue()[0] + "</a>");
            this.table.getCellFormatter().setStyleName(row, 1, "portlet-table-td");
            this.table.setHTML(row, 2, "<a href='#Monitoring.ClusterHealth'><img src='images/icon_database_ERROR.png' align='absmiddle' hspace='3' />" + entry.getValue()[1] + "</a>");
            this.table.getCellFormatter().setStyleName(row, 2, "portlet-table-td");
            ++row;
        }
    }

    private void reload() {
        RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, CONSUL_URL);
        try {
            builder.sendRequest(null, new RequestCallback(){

                public void onResponseReceived(Request request, Response response) {
                    if (response.getStatusCode() != 200) {
                        ClusterNodeStatusPortlet.this.showError("Cannot fetch cluster status data, status code: " + response.getStatusCode());
                        return;
                    }
                    JsArray checks = (JsArray)JsonUtils.safeEval((String)response.getText());
                    HashMap<String, Boolean> index = new HashMap<String, Boolean>();
                    for (int i = 0; i < checks.length(); ++i) {
                        Check check = (Check)checks.get(i);
                        if (!index.containsKey(check.node())) {
                            index.put(check.node(), true);
                        }
                        index.put(check.node(), (Boolean)index.get(check.node()) & "passing".equalsIgnoreCase(check.status()));
                    }
                    HashMap<String, Integer[]> status = new HashMap<String, Integer[]>();
                    for (Map.Entry entry : index.entrySet()) {
                        String name = ClusterNodeStatusPortlet.this.getNodeName((String)entry.getKey());
                        if (!status.containsKey(name)) {
                            status.put(name, new Integer[]{0, 0});
                        }
                        Integer[] integerArray = (Integer[])status.get(name);
                        int n = (Boolean)entry.getValue() != false ? 0 : 1;
                        Integer n2 = integerArray[n];
                        Integer n3 = integerArray[n] = Integer.valueOf(integerArray[n] + 1);
                    }
                    ClusterNodeStatusPortlet.this.renderTable(status);
                    ClusterNodeStatusPortlet.this.showData();
                }

                public void onError(Request request, Throwable exception) {
                    ClusterNodeStatusPortlet.this.showError("Cannot fetch cluster status data");
                }
            });
        }
        catch (RequestException e) {
            this.showError("Cannot fetch cluster status data");
        }
    }

    private void createTableHeader() {
        int row = 0;
        int col = 0;
        this.table.setWidget(row, col, (Widget)new LabelWidget("Node Type"));
        this.table.getCellFormatter().setStyleName(row, col, "portlet-tableHeader");
        this.table.getCellFormatter().addStyleName(row, col, "portlet-tablecolumn" + col + "-width");
        this.table.setWidget(row, ++col, (Widget)new LabelWidget("Online"));
        this.table.getCellFormatter().setStyleName(row, col, "portlet-tableHeader");
        this.table.getCellFormatter().addStyleName(row, col, "portlet-tablecolumn" + col + "-width");
        this.table.setWidget(row, ++col, (Widget)new LabelWidget("Error"));
        this.table.getCellFormatter().setStyleName(row, col, "portlet-tableHeader");
        this.table.getCellFormatter().addStyleName(row, col, "portlet-tablecolumn" + col + "-width");
        ++col;
    }

    private final class EventHandler
    implements DocumentAttachHandler,
    DocumentDetachHandler {
        private EventHandler() {
        }

        public void onAttach(DocumentAttachEvent event) {
            ClusterNodeStatusPortlet.this.refreshTimer.scheduleRepeating(ClusterNodeStatusPortlet.this.refreshPeriod);
            ClusterNodeStatusPortlet.this.reload();
        }

        public void onDetach(DocumentDetachEvent event) {
            ClusterNodeStatusPortlet.this.refreshTimer.cancel();
        }
    }
}

