/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.client.geo;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.ui.workflow.client.PortletConstants;
import com.tandbergtv.cms.ui.workflow.client.geo.GeoRedundancyPortletData;
import com.tandbergtv.cms.ui.workflow.client.geo.GeoRedundancyPortletRecord;
import com.tandbergtv.cms.ui.workflow.client.geo.GeoRedundancyPortletSettings;
import com.tandbergtv.cms.ui.workflow.client.geo.IListGeoRedundancy;
import com.tandbergtv.cms.ui.workflow.client.geo.IListGeoRedundancyAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;

public class GeoRedundancyPortlet
extends Portlet {
    private FlexTableContainer table;
    private SimplePanel empty;
    private IListGeoRedundancyAsync service = (IListGeoRedundancyAsync)GWT.create(IListGeoRedundancy.class);
    private PortletConstants constants = (PortletConstants)GWT.create(PortletConstants.class);
    private Timer refreshTimer;
    private int refreshPeriod;
    private static final String CMS_GEO_PORTLET_STYLE = "cms-geo-portlet";
    private DateTimeFormat format;

    public GeoRedundancyPortlet(int refreshTimeMillis) {
        super("GEO_REDUNDANCY");
        this.refreshPeriod = refreshTimeMillis;
        this.format = DateTimeFormat.getFormat((String)"yyyy-M-dd hh:mm");
        this.setTitle(this.constants.grTitle());
        this.setDisplayName(this.constants.grTitle());
        this.table = new FlexTableContainer();
        this.table.setCellSpacing(0);
        this.table.setStyleName("portletTable");
        this.add((Widget)this.table);
        this.setStyleName(CMS_GEO_PORTLET_STYLE, true);
        this.empty = new SimplePanel((Widget)new LabelWidget("NO DATA"));
        this.add((Widget)this.empty);
        this.refreshTimer = new Timer(){

            public void run() {
                GeoRedundancyPortlet.this.reload();
            }
        };
        EventHandler handler = new EventHandler();
        this.addDocumentAttachHandler(handler);
        this.addDocumentDetachHandler(handler);
    }

    private void reload() {
        this.service.getData((AsyncCallback<GeoRedundancyPortletData>)new NeptuneAsyncCallback<GeoRedundancyPortletData>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(GeoRedundancyPortletData result) {
                GeoRedundancyPortlet.this.createTableHeader();
                int row = 0;
                for (GeoRedundancyPortletRecord record : result.getRecords()) {
                    GeoRedundancyPortlet.this.createTableRecord(GeoRedundancyPortlet.this.table, ++row, record, result.getSettings());
                }
                GeoRedundancyPortlet.this.table.setVisible(true);
                GeoRedundancyPortlet.this.empty.setVisible(false);
                GeoRedundancyPortlet.this.update();
            }
        });
    }

    private void createTableHeader() {
        int row = 0;
        int col = 0;
        this.table.setWidget(row, col, (Widget)new LabelWidget("Node"));
        this.table.getCellFormatter().setStyleName(row, col, "portlet-tableHeader");
        this.table.getCellFormatter().addStyleName(row, col, "geoportlet-tablecolumn" + col + "-width");
        this.table.setWidget(row, ++col, (Widget)new LabelWidget("Replication Status"));
        this.table.getCellFormatter().setStyleName(row, col, "portlet-tableHeader");
        this.table.getCellFormatter().addStyleName(row, col, "geoportlet-tablecolumn" + col + "-width");
        this.table.setWidget(row, ++col, (Widget)new LabelWidget("Last Successful Sync"));
        this.table.getCellFormatter().setStyleName(row, col, "portlet-tableHeader");
        this.table.getCellFormatter().addStyleName(row, col, "geoportlet-tablecolumn" + col + "-width");
        this.table.setWidget(row, ++col, (Widget)new LabelWidget("Sync Failure Time"));
        this.table.getCellFormatter().setStyleName(row, col, "portlet-tableHeader");
        this.table.getCellFormatter().addStyleName(row, col, "geoportlet-tablecolumn" + col + "-width");
        ++col;
    }

    private void createTableRecord(FlexTableContainer table, int row, GeoRedundancyPortletRecord rec, GeoRedundancyPortletSettings settings) {
        int colIndex = 0;
        String className = rec.getReplicationStatus().toLowerCase();
        String img = "SUCCESSFUL";
        String message = "";
        if (rec.getReplicationStatus().equals("Successful")) {
            img = "SUCCESSFUL";
        } else if (rec.getReplicationStatus().equals("Delayed")) {
            message = rec.getNodeName().toLowerCase().contains("elastic") ? "Sync is marked as delayed because the last sync date is above the set threshold of " + settings.getThresholdSecondsWarnEs() + " seconds" : "Sync is marked as delayed because the last sync date is above the set threshold of " + settings.getThresholdSecondsWarn() + " seconds";
            img = "DELAYED";
        }
        if (rec.getReplicationStatus().equals("Failed")) {
            message = rec.getNodeName().toLowerCase().contains("elastic") ? "Sync is marked as failed because the last sync date is above the set threshold of " + settings.getThresholdSecondsFailEs() + " seconds" : "Sync is marked as failed because the last sync date is above the set threshold of " + settings.getThresholdSecondsFail() + " seconds";
            img = "FAILED";
        }
        table.setHTML(row, colIndex, "" + rec.getNodeName() + "");
        table.getCellFormatter().setStyleName(row, colIndex, "portlet-table-td");
        table.setHTML(row, ++colIndex, "<span title='" + message + "'><img src='images/icon_geo_" + img + ".png' align='absmiddle' hspace='3' /></span>");
        table.getCellFormatter().setStyleName(row, colIndex, "portlet-table-td " + className);
        table.setWidget(row, ++colIndex, (Widget)new LabelWidget(rec.getLastSuccessfulSync() != null ? this.format.format(rec.getLastSuccessfulSync()) : "n/a"));
        table.getCellFormatter().setStyleName(row, colIndex, "portlet-table-td");
        table.setWidget(row, ++colIndex, (Widget)new LabelWidget(rec.getSyncFailureTime() == null ? "" : this.format.format(rec.getSyncFailureTime())));
        table.getCellFormatter().setStyleName(row, colIndex, "portlet-table-td failed");
        ++colIndex;
    }

    private final class EventHandler
    implements DocumentAttachHandler,
    DocumentDetachHandler {
        private EventHandler() {
        }

        public void onAttach(DocumentAttachEvent event) {
            GeoRedundancyPortlet.this.refreshTimer.scheduleRepeating(GeoRedundancyPortlet.this.refreshPeriod);
            GeoRedundancyPortlet.this.reload();
        }

        public void onDetach(DocumentDetachEvent event) {
            GeoRedundancyPortlet.this.refreshTimer.cancel();
        }
    }
}

