/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.client.portlet;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.ui.workflow.client.IListResources;
import com.tandbergtv.cms.ui.workflow.client.IListResourcesAsync;
import com.tandbergtv.cms.ui.workflow.client.Permission;
import com.tandbergtv.cms.ui.workflow.client.PortletConstants;
import com.tandbergtv.cms.ui.workflow.client.model.ActiveResource;
import com.tandbergtv.cms.ui.workflow.client.model.ActiveResources;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ActiveResourcesPortlet
extends Portlet {
    private static final String TABLE_STYLE = "portletTable";
    private static final String TEXT_STYLE = "portlet-table-text";
    private static final String HEADER_STYLE = "portlet-tableHeader";
    private IListResourcesAsync service = (IListResourcesAsync)GWT.create(IListResources.class);
    private PortletConstants constants = (PortletConstants)GWT.create(PortletConstants.class);
    private Timer timer;
    private FlexTable table;
    private SimplePanel empty;
    private int periodmsec;
    private List<PortletTableColumn> columns;

    public ActiveResourcesPortlet(int period) {
        super("ACTIVE_RESOURCES");
        this.setTitle(this.constants.activeProcesses());
        this.setDisplayName(this.constants.activeProcesses());
        this.createTable();
        this.empty = new SimplePanel((Widget)new LabelWidget(this.constants.activeProcessesNoData()));
        this.add((Widget)this.empty);
        this.periodmsec = period;
        this.timer = new Timer(){

            public void run() {
                ActiveResourcesPortlet.this.reload();
            }
        };
        EventHandler handler = new EventHandler();
        this.addDocumentAttachHandler(handler);
        this.addDocumentDetachHandler(handler);
    }

    private void createTable() {
        this.table = new FlexTableContainer();
        this.table.setStyleName(TABLE_STYLE);
        this.add((Widget)this.table);
        this.columns = new ArrayList<PortletTableColumn>();
        this.columns.add(new PortletTableColumn(0, "Process Name"));
        this.columns.add(new PortletTableColumn(1, "Task"));
        this.columns.add(new PortletTableColumn(2, "Title"));
        this.columns.add(new PortletTableColumn(3, "Progress"));
        this.columns.add(new PortletTableColumn(4, "Resource"));
    }

    private void reload() {
        this.service.getActiveResources((AsyncCallback<ActiveResources>)new NeptuneAsyncCallback<ActiveResources>(){

            public void onNeptuneSuccess(ActiveResources resources) {
                if (!resources.getResources().isEmpty()) {
                    ActiveResourcesPortlet.this.doReload(resources);
                    ActiveResourcesPortlet.this.table.setVisible(true);
                    ActiveResourcesPortlet.this.empty.setVisible(false);
                } else {
                    ActiveResourcesPortlet.this.setTitle(ActiveResourcesPortlet.this.constants.activeProcesses() + " (0)");
                    ActiveResourcesPortlet.this.table.setVisible(false);
                    ActiveResourcesPortlet.this.empty.setVisible(true);
                }
                ActiveResourcesPortlet.this.update();
            }

            public void onNeptuneFailure(Throwable caught) {
            }
        });
    }

    private void doReload(ActiveResources resources) {
        this.table.removeAllRows();
        this.setTitle(resources);
        List<ActiveResource> list = resources.getResources();
        if (list.isEmpty()) {
            return;
        }
        this.createTableHeader(this.table);
        int row = 1;
        for (ActiveResource resource : list) {
            this.addRow(resource, row++);
        }
    }

    private void addRow(ActiveResource resource, int row) {
        HTMLTable.CellFormatter formatter = this.table.getCellFormatter();
        for (PortletTableColumn column : this.columns) {
            column.resource = resource;
            formatter.setStyleName(row, column.index, column.style);
            this.table.setWidget(row, column.index, column.getWidget());
        }
    }

    private void createTableHeader(FlexTable table) {
        HTMLTable.CellFormatter formatter = table.getCellFormatter();
        for (PortletTableColumn column : this.columns) {
            table.setWidget(0, column.index, (Widget)new LabelWidget(column.header));
            formatter.setStyleName(0, column.index, column.headerstyle);
        }
    }

    private void setTitle(ActiveResources resources) {
        List<ActiveResource> list = resources.getResources();
        this.setTitle(this.constants.activeProcesses() + " (" + list.size() + ")");
    }

    private final class PortletTableColumn
    implements Serializable {
        private static final long serialVersionUID = 1L;
        int index;
        String header;
        String headerstyle = "portlet-tableHeader";
        String style = "portlet-table-text";
        ActiveResource resource;

        PortletTableColumn(int index, String header) {
            this.index = index;
            this.header = header;
        }

        public Widget getWidget() {
            String data = this.getData();
            switch (this.index) {
                case 0: {
                    return new HyperlinkWidget(data, "Workflow.Work Orders.Search.Id=" + this.resource.getPid());
                }
                case 1: {
                    return new LabelWidget(data);
                }
                case 2: {
                    if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"})) {
                        return new HyperlinkWidget(data, "Content.Search.Id=" + this.resource.getTitleId());
                    }
                    return new LabelWidget(data);
                }
                case 3: {
                    return new LabelWidget(data + "%");
                }
                case 4: {
                    if (ClientAuthorizationManager.isAuthorized((String[])new String[]{Permission.RESOURCES_VIEW.toString()})) {
                        return new HyperlinkWidget(data, "Workflow.Resources.Modify?id=" + this.resource.getId());
                    }
                    return new LabelWidget(data);
                }
            }
            return new LabelWidget();
        }

        private String getData() {
            switch (this.index) {
                case 0: {
                    return this.resource.getTemplate();
                }
                case 1: {
                    return this.resource.getNode();
                }
                case 2: {
                    return this.resource.getTitleDisplayName();
                }
                case 3: {
                    return this.resource.getPercentComplete();
                }
                case 4: {
                    return this.resource.getResource();
                }
            }
            return "";
        }
    }

    private final class EventHandler
    implements DocumentAttachHandler,
    DocumentDetachHandler {
        private EventHandler() {
        }

        public void onAttach(DocumentAttachEvent event) {
            ActiveResourcesPortlet.this.timer.scheduleRepeating(ActiveResourcesPortlet.this.periodmsec);
            ActiveResourcesPortlet.this.reload();
        }

        public void onDetach(DocumentDetachEvent event) {
            ActiveResourcesPortlet.this.timer.cancel();
        }
    }
}

