/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.client.portlet;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.ui.workflow.client.IQueuedUserTasksPortletService;
import com.tandbergtv.cms.ui.workflow.client.IQueuedUserTasksPortletServiceAsync;
import com.tandbergtv.cms.ui.workflow.client.PortletConstants;
import com.tandbergtv.cms.ui.workflow.client.PortletMessages;
import com.tandbergtv.cms.ui.workflow.client.model.QueuedUserTasksGroupData;
import com.tandbergtv.cms.ui.workflow.client.model.QueuedUserTasksPortletData;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;

public class QueuedUserTasksPortlet
extends Portlet {
    public static final String PORTLET_ID = "WFS.QueuedUserTasksPortlet";
    private static final long MIN_REFRESH_TIME = 5000L;
    private final PortletConstants constants = (PortletConstants)GWT.create(PortletConstants.class);
    private final PortletMessages messages = (PortletMessages)GWT.create(PortletMessages.class);
    private final IQueuedUserTasksPortletServiceAsync service = (IQueuedUserTasksPortletServiceAsync)GWT.create(IQueuedUserTasksPortletService.class);
    private final Timer refreshTimer;
    private int refreshTime = 30000;
    private SimpleContainer mainContainer;
    private FlexTableContainer table;
    private static final String MAIN_CONTAINER_STYLE = "workflow-QueuedUserTasksPortlet";
    private static final String LOADING_LABEL_STYLE = "workflow-QueuedUserTasksPortlet-loadingLabel";
    private static final String TABLE_STYLE = "workflow-QueuedUserTasksPortlet-dataTable";
    private static final String GROUP_NAME_CELL_STYLE = "workflow-QueuedUserTasksPortlet-groupNameCell";
    private static final String GROUP_COUNT_CELL_STYLE = "workflow-QueuedUserTasksPortlet-groupCountCell";
    private static final String GROUP_NAME_LABEL_STYLE = "workflow-QueuedUserTasksPortlet-groupNameLabel";
    private static final String GROUP_COUNT_LABEL_STYLE = "workflow-QueuedUserTasksPortlet-groupCountLabel";
    private static final String NO_DATA_LABEL_STYLE = "workflow-QueuedUserTasksPortlet-noDataLabel";

    public QueuedUserTasksPortlet(int refreshTime) {
        super(PORTLET_ID);
        if ((long)refreshTime >= 5000L) {
            this.refreshTime = refreshTime;
        }
        String displayName = this.constants.queuedUserTasksPortletTitle();
        this.setTitle(displayName);
        this.setDisplayName(displayName);
        this.refreshTimer = new Timer(){

            public void run() {
                QueuedUserTasksPortlet.this.reload();
            }
        };
        this.initialize();
        EventHandler handler = new EventHandler();
        this.addDocumentAttachHandler(handler);
        this.addDocumentDetachHandler(handler);
    }

    private void initialize() {
        this.mainContainer = new SimpleContainer();
        this.mainContainer.addStyleName(MAIN_CONTAINER_STYLE);
        this.add((Widget)this.mainContainer);
        LabelWidget label = new LabelWidget(this.constants.queuedUserTasksPortletLoading());
        label.addStyleName(LOADING_LABEL_STYLE);
        this.mainContainer.setWidget((Widget)label);
        this.table = new FlexTableContainer();
        this.table.addStyleName(TABLE_STYLE);
    }

    private void reload() {
        this.service.getData((AsyncCallback<QueuedUserTasksPortletData>)new NeptuneAsyncCallback<QueuedUserTasksPortletData>(){

            public void onNeptuneFailure(Throwable caught) {
                QueuedUserTasksPortlet.this.handleGetDataFailure(caught);
            }

            public void onNeptuneSuccess(QueuedUserTasksPortletData result) {
                QueuedUserTasksPortlet.this.handleGetDataSuccess(result);
                QueuedUserTasksPortlet.this.update();
            }
        });
    }

    private void handleGetDataFailure(Throwable error) {
        super.setTitle(this.constants.queuedUserTasksPortletTitle());
        this.mainContainer.setWidget((Widget)new LabelWidget(this.constants.queuedUserTasksPortletNoData()));
    }

    private void handleGetDataSuccess(QueuedUserTasksPortletData data) {
        super.setTitle(this.messages.queuedUserTasksPortletTitleWithCount(data.getTotalTaskCount()));
        this.table.removeAllRows();
        int row = 0;
        for (QueuedUserTasksGroupData groupData : data.getGroupData()) {
            LabelWidget name = new LabelWidget(groupData.getResourceGroupName());
            name.addStyleName(GROUP_NAME_LABEL_STYLE);
            this.table.setWidget(row, 0, (Widget)name);
            this.table.getCellFormatter().addStyleName(row, 0, GROUP_NAME_CELL_STYLE);
            String token = "Workflow.User Tasks.Assign?selectedResourceGroupId=" + groupData.getResourceGroupId();
            HyperlinkWidget widget = new HyperlinkWidget(Integer.toString(groupData.getTaskCount()), token);
            widget.addStyleName(GROUP_COUNT_LABEL_STYLE);
            this.table.setWidget(row, 1, (Widget)widget);
            this.table.getCellFormatter().addStyleName(row, 1, GROUP_COUNT_CELL_STYLE);
            ++row;
        }
        Widget displayWidget = row == 0 ? this.createNoDataLabel() : this.table;
        this.mainContainer.setWidget(displayWidget);
    }

    private Widget createNoDataLabel() {
        LabelWidget widget = new LabelWidget(this.constants.queuedUserTasksPortletNoData());
        widget.addStyleName(NO_DATA_LABEL_STYLE);
        return widget;
    }

    private Widget createNameLabel(QueuedUserTasksGroupData data) {
        String token = "Workflow.User Tasks.Assign?selectedResourceGroupId=" + data.getResourceGroupId();
        HyperlinkWidget widget = new HyperlinkWidget(data.getResourceGroupName(), token);
        widget.addStyleName(GROUP_NAME_LABEL_STYLE);
        return widget;
    }

    private Widget createCountLabel(QueuedUserTasksGroupData data) {
        LabelWidget widget = new LabelWidget(Integer.toString(data.getTaskCount()));
        widget.addStyleName(GROUP_COUNT_LABEL_STYLE);
        return widget;
    }

    private final class EventHandler
    implements DocumentAttachHandler,
    DocumentDetachHandler {
        private EventHandler() {
        }

        public void onAttach(DocumentAttachEvent event) {
            QueuedUserTasksPortlet.this.refreshTimer.scheduleRepeating(QueuedUserTasksPortlet.this.refreshTime);
            QueuedUserTasksPortlet.this.reload();
        }

        public void onDetach(DocumentDetachEvent event) {
            QueuedUserTasksPortlet.this.refreshTimer.cancel();
        }
    }
}

