/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.server;

import com.tandbergtv.cms.ui.workflow.client.clusterstatus.ClusterNodeStatusPortletData;
import com.tandbergtv.cms.ui.workflow.client.clusterstatus.ClusterNodeStatusPortletRecord;
import com.tandbergtv.cms.ui.workflow.client.clusterstatus.IListClusterNodeStatus;
import com.tandbergtv.neptune.configuration.settings.service.ISettingsService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.workflow.api.API;
import com.tandbergtv.workflow.api.Resources;
import com.tandbergtv.workflow.api.model.resource.Resource;
import com.tandbergtv.workflow.api.model.resource.ResourceGroup;
import com.tandbergtv.workflow.api.model.resource.ResourceListResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ListClusterNodeStatusImpl
implements IListClusterNodeStatus,
NeptuneRemoteService {
    private static final String CLUSTER = "CR";
    private ISettingsService settingsService = null;
    private HashMap<String, String> displayMap = null;
    private static final Logger logger = Logger.getLogger(ListClusterNodeStatusImpl.class);

    public ListClusterNodeStatusImpl() {
        try {
            this.settingsService = (ISettingsService)InjectionUtil.injectInstance((String)"cms/SettingsService/local", ISettingsService.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadSettings();
    }

    private void loadSettings() {
        String typeMap = "elasticsearch=Elasticsearch;database=Database;portal=Portal;cluster services=Cluster Services;application=Application (CMS);workflow=Application (Workflow)";
        this.displayMap = new HashMap();
        String[] aliases = typeMap.split(";");
        for (int i = 0; i < aliases.length; ++i) {
            String[] alias;
            if (aliases[i].length() <= 0 || (alias = aliases[i].split("=")).length <= 1) continue;
            this.displayMap.put(alias[0], alias[1]);
        }
    }

    @Override
    public ClusterNodeStatusPortletData getData() throws NeptuneException {
        HashMap entry;
        ArrayList<ClusterNodeStatusPortletRecord> records = new ArrayList<ClusterNodeStatusPortletRecord>();
        ClusterNodeStatusPortletRecord record = new ClusterNodeStatusPortletRecord();
        HashMap<String, HashMap> onlineNodes = new HashMap<String, HashMap>();
        String nodeType = null;
        for (String key : this.displayMap.keySet()) {
            entry = new HashMap();
            entry.put("online", 0);
            entry.put("error", 0);
            onlineNodes.put(key, entry);
        }
        long resourceGroupId = 0L;
        try {
            for (Resource resource : this.getAllResources()) {
                Iterator it;
                logger.debug((Object)("inside ListClusterNodeStatusImpl resource name: " + resource.getName()));
                nodeType = null;
                for (String key : this.displayMap.keySet()) {
                    if ((resource.getName().toLowerCase().contains("workflow") || !resource.getName().toLowerCase().contains(key)) && (!key.equals("workflow") || !resource.getName().toLowerCase().contains(key))) continue;
                    nodeType = key;
                    break;
                }
                if (nodeType == null) continue;
                entry = (HashMap)onlineNodes.get(nodeType);
                if (resource.getGroups() != null && (it = resource.getGroups().iterator()).hasNext()) {
                    ResourceGroup rg = (ResourceGroup)it.next();
                    resourceGroupId = Integer.valueOf(rg.getId()).intValue();
                }
                if ("online".equalsIgnoreCase(resource.getState())) {
                    int onlineCount = entry.get("online") != null ? (Integer)entry.get("online") + 1 : 1;
                    entry.put("online", onlineCount);
                } else {
                    int errorCount = entry.get("error") != null ? (Integer)entry.get("error") + 1 : 1;
                    entry.put("error", errorCount);
                }
                onlineNodes.put(nodeType, entry);
                logger.debug((Object)("inside getData nodetype: " + nodeType));
            }
            for (String nt : onlineNodes.keySet()) {
                record = new ClusterNodeStatusPortletRecord();
                record.setOnline((Integer)((HashMap)onlineNodes.get(nt)).get("online"));
                record.setError((Integer)((HashMap)onlineNodes.get(nt)).get("error"));
                record.setNodeType(this.displayMap.get(nt));
                record.setResourceGroupId(resourceGroupId);
                records.add(record);
            }
            return new ClusterNodeStatusPortletData(records);
        }
        catch (Exception e) {
            throw new NeptuneException(e.getMessage());
        }
    }

    private List<Resource> getAllResources() throws IOException {
        List<Resource> data;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        int start = 0;
        int count = 10;
        for (int total = 0; total < 100; total += data.size()) {
            data = this.getPage(start, count);
            resources.addAll(data);
            if (data.size() < count) break;
            start += count;
        }
        return resources;
    }

    private List<Resource> getPage(int start, int count) throws IOException {
        Resources client = this.request();
        client.query().systemId(CLUSTER).detail("full").start(start).count(count);
        ResourceListResponse response = client.execute();
        return response.getItems();
    }

    private Resources request() {
        return new API.Builder().build().resources();
    }

    public String getRelativePath() {
        return "service/watchpoint/IListClusterNodeStatus";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }
}

