/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.server;

import com.tandbergtv.cms.ui.workflow.client.IListResourceGroupQueues;
import com.tandbergtv.cms.ui.workflow.client.Queue;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.security.InsufficientRolesException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.workflow.api.API;
import com.tandbergtv.workflow.api.ResourceGroups;
import com.tandbergtv.workflow.api.model.resource.ResourceGroup;
import com.tandbergtv.workflow.api.model.resource.ResourceGroupListResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class ListResourceGroupQueuesImpl
implements IListResourceGroupQueues,
NeptuneRemoteService {
    private IAuthorizationService authService = (IAuthorizationService)InjectionUtil.injectInstance((String)"cms/AuthorizationService/local", IAuthorizationService.class);
    private static final Logger logger = Logger.getLogger(ListResourceGroupQueuesImpl.class);

    public String getRelativePath() {
        return "service/watchpoint/IListResourceGroupQueues";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    private void verifyAuthority() throws InsufficientRolesException {
        if (!this.authService.isAuthorized("Home", "Dashboard")) {
            throw new InsufficientRolesException();
        }
    }

    @Override
    public List<Queue> getResourceGroupQueues() throws NeptuneException {
        this.verifyAuthority();
        ArrayList<Queue> queues = new ArrayList<Queue>();
        try {
            for (ResourceGroup group : this.getResourceGroups()) {
                Queue queue = new Queue();
                queue.setId(Long.valueOf(group.getId()));
                queue.setName(group.getName());
                queue.setNumItemsInQueue(group.getQueueSize());
                queues.add(queue);
            }
        }
        catch (Exception e) {
            logger.error((Object)"An error occurred while trying to get the resource group queues from workflow API", (Throwable)e);
            throw new NeptuneException(e.getMessage());
        }
        return queues;
    }

    private Collection<ResourceGroup> getResourceGroups() throws IOException {
        ResourceGroups request = this.request();
        request.query().count(100);
        ResourceGroupListResponse response = request.execute();
        return response.getItems();
    }

    private ResourceGroups request() {
        return new API.Builder().build().resourceGroups();
    }
}

