/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.server;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.search.TitleSearchResult;
import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.cms.ui.workflow.client.IListResources;
import com.tandbergtv.cms.ui.workflow.client.Permission;
import com.tandbergtv.cms.ui.workflow.client.Resource;
import com.tandbergtv.cms.ui.workflow.client.model.ActiveResource;
import com.tandbergtv.cms.ui.workflow.client.model.ActiveResources;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import com.tandbergtv.workflow.api.API;
import com.tandbergtv.workflow.api.Activities;
import com.tandbergtv.workflow.api.Resources;
import com.tandbergtv.workflow.api.model.process.Activity;
import com.tandbergtv.workflow.api.model.resource.ResourceListResponse;
import com.tandbergtv.workflow.web.table.Column;
import com.tandbergtv.workflow.web.table.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class ListResourcesImpl
implements IListResources,
NeptuneRemoteService {
    private static final String SEARCH_SERVICE = "cms/TitleSearchServiceProxy/local";
    private static final String TABLE_NAME = "title.portlet.Metadata";
    private static final String TABLE_NAME_SERIES = "title.portlet.Metadata.Series";
    private static final Logger logger = Logger.getLogger(ListResourcesImpl.class);
    private IPartnerUserManager service = (IPartnerUserManager)InjectionUtil.injectInstance((String)"PartnerServices/PartnerUserManager", IPartnerUserManager.class);

    public String getRelativePath() {
        return "service/watchpoint/IListResources";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public List<Resource> getResources() throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{Permission.HOME.toString()});
        ArrayList<Resource> resources = new ArrayList<Resource>();
        try {
            List<com.tandbergtv.workflow.api.model.resource.Resource> workflowResources = this.getAllResources();
            for (com.tandbergtv.workflow.api.model.resource.Resource wr : workflowResources) {
                Resource r = new Resource(Long.valueOf(wr.getId()), wr.getName());
                r.setState(Resource.State.valueOf(wr.getState().toUpperCase().replaceAll("\\s", "_")));
                r.setCurrentlyUsed(wr.getUserCount() > 0);
                logger.debug((Object)("Resource " + r.getName()));
                resources.add(r);
            }
            Collections.sort(resources, new Comparator<Resource>(){

                @Override
                public int compare(Resource r1, Resource r2) {
                    return r1.getName().compareTo(r2.getName());
                }
            });
            return resources;
        }
        catch (Throwable e) {
            logger.warn((Object)"Failed to get resources", e);
            throw new NeptuneException(e.getMessage());
        }
    }

    @Override
    public ActiveResources getActiveResources() throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{Permission.WORK_ORDERS_VIEW.toString()});
        ActiveResources resources = null;
        try {
            List<ActiveResource> resourceusers = this.getActiveResources(this.getProviderIds());
            resources = new ActiveResources(resourceusers.size());
            resources.setResources(new ArrayList<ActiveResource>(resourceusers));
        }
        catch (Throwable t) {
            logger.warn((Object)"Failed to get activity", t);
            throw new NeptuneException(t.getMessage());
        }
        return resources;
    }

    private Collection<String> getProviderIds() {
        if (this.service.isSelfPartnerUser()) {
            return Collections.emptySet();
        }
        HashSet<String> providerIds = new HashSet<String>();
        for (Partner partner : this.service.getPartnersByCurrentUser()) {
            providerIds.add(partner.getProviderId());
            logger.debug((Object)("Adding filter by provider id " + partner.getProviderId()));
        }
        return providerIds;
    }

    private List<ActiveResource> getActiveResources(Collection<String> providerIds) throws IOException {
        ArrayList<ActiveResource> resources = new ArrayList<ActiveResource>();
        List<Activity> list = this.getActivity(providerIds);
        logger.debug((Object)("Found " + list.size() + " activities"));
        List<TitleSearchResult.SearchRow> rows = this.getMetadataFieldValues(this.getTitleIds(list));
        HashMap<Long, String> map = new HashMap<Long, String>();
        for (TitleSearchResult.SearchRow row : rows) {
            map.put(row.getId(), row.getFirstValueAsString(0));
        }
        logger.debug((Object)("Found " + rows.size() + " rows"));
        for (Activity activity : list) {
            Long titleId;
            String displayName = "";
            if (!(activity.getTitleId() == null && activity.getTitleId().isEmpty() || map.get(titleId = Long.valueOf(activity.getTitleId())) == null)) {
                displayName = (String)map.get(titleId);
            }
            resources.add(this.from(activity, displayName));
        }
        return resources;
    }

    private ActiveResource from(Activity activity, String displayName) {
        Long id = Long.valueOf(activity.getResourceId());
        Long pid = Long.valueOf(activity.getId());
        String resource = activity.getResource();
        String template = activity.getTemplate();
        String node = activity.getCurrent();
        String progress = activity.getProgress();
        Long titleId = activity.getTitleId() == null || activity.getTitleId().isEmpty() ? 0L : Long.valueOf(activity.getTitleId());
        return new ActiveResource(id, resource, pid, template, node, progress, titleId, displayName);
    }

    private List<Long> getTitleIds(List<Activity> list) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Activity activity : list) {
            ids.add(activity.getTitleId() == null || activity.getTitleId().isEmpty() ? 0L : Long.valueOf(activity.getTitleId()));
        }
        return ids;
    }

    private List<TitleSearchResult.SearchRow> getMetadataFieldValues(List<Long> ids) {
        SearchColumn column = this.getSearchColumn(TABLE_NAME);
        ArrayList<TitleSearchResult.SearchRow> results = new ArrayList<TitleSearchResult.SearchRow>();
        if (column == null) {
            return Collections.emptyList();
        }
        ITitleSearchService searchService = (ITitleSearchService)InjectionUtil.injectInstance((String)SEARCH_SERVICE, ITitleSearchService.class);
        TitleSearchResult result = searchService.getTitleSearchResults(ids, Collections.singletonList(column), CriteriaMode.MASTER);
        results.addAll(result.getRows());
        result = searchService.getTitleSearchResults(ids, Collections.singletonList(column), CriteriaMode.SITE);
        results.addAll(result.getRows());
        column = this.getSearchColumn(TABLE_NAME_SERIES);
        result = searchService.getTitleSearchResults(ids, Collections.singletonList(column), CriteriaMode.SERIES);
        results.addAll(result.getRows());
        return results;
    }

    private SearchColumn getSearchColumn(String tableName) {
        IAssetSpecificationManager specifications = (IAssetSpecificationManager)InjectionUtil.injectInstance((String)"cms/AssetSpecificationManager/local", IAssetSpecificationManager.class);
        Table table = specifications.getTableConfiguration(tableName);
        List columns = table.getColumns();
        if (columns == null || columns.isEmpty()) {
            return null;
        }
        Column column = (Column)columns.get(0);
        String xpath = column.getParameter();
        String assetType = column.getTitleSection();
        String dataType = "string";
        boolean isMetaData = column.getSortingProperty().equals("metadata");
        FieldType fieldType = FieldType.PMM_TITLE;
        if (isMetaData) {
            dataType = DataTypeMappingReader.getInstance().determineDataType(xpath);
            fieldType = FieldType.ASSET;
        }
        logger.debug((Object)("Column " + xpath));
        return new SearchColumn(assetType, xpath, fieldType, dataType, false);
    }

    private List<Activity> getActivity(Collection<String> providerIds) throws IOException {
        Activities request = this.activities();
        if (!providerIds.isEmpty()) {
            String s = new String();
            for (String providerId : providerIds) {
                s = s + providerId + ",";
            }
            request.query().providerId(s);
        }
        return request.execute().getItems();
    }

    private List<com.tandbergtv.workflow.api.model.resource.Resource> getAllResources() throws IOException {
        Resources client = this.resources();
        client.query().detail("summary").count(100);
        ResourceListResponse response = client.execute();
        return response.getItems();
    }

    private Resources resources() {
        return new API.Builder().build().resources();
    }

    private Activities activities() {
        return new API.Builder().build().activities();
    }
}

