/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.server;

import com.tandbergtv.cms.ui.workflow.client.IListUserTasks;
import com.tandbergtv.cms.ui.workflow.client.UiColumn;
import com.tandbergtv.cms.ui.workflow.client.UiTable;
import com.tandbergtv.cms.ui.workflow.client.UserTask;
import com.tandbergtv.cms.ui.workflow.client.UserTaskList;
import com.tandbergtv.cms.ui.workflow.server.UIPropertyProvider;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.security.InsufficientRolesException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import com.tandbergtv.workflow.api.API;
import com.tandbergtv.workflow.api.APIException;
import com.tandbergtv.workflow.api.Tasks;
import com.tandbergtv.workflow.api.model.process.Task;
import com.tandbergtv.workflow.api.model.process.TaskListResponse;
import com.tandbergtv.workflow.web.table.Column;
import com.tandbergtv.workflow.web.table.Table;
import com.tandbergtv.workflow.web.table.TableConfig;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class ListUserTasksImpl
implements IListUserTasks,
NeptuneRemoteService {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm";
    private static final Logger logger = Logger.getLogger(ListUserTasksImpl.class);
    private static final String PROP_UPPER_LIMIT = "workflow.userTasks.upperLimit";
    private IAuthorizationService authService = (IAuthorizationService)InjectionUtil.injectInstance((String)"cms/AuthorizationService/local", IAuthorizationService.class);
    private IConfigurationService configService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
    private static final String CONF_DIR = "workflow";
    private static String USER_TASK_TABLE_CONFIG_FILE_NAME = "usertask-table-config.xml";
    private static final String PARTNER_SERVICE = "PartnerServices/PartnerUserManager";
    private IPartnerUserManager partnerservice = (IPartnerUserManager)InjectionUtil.injectInstance((String)"PartnerServices/PartnerUserManager", IPartnerUserManager.class);

    public String getRelativePath() {
        return "service/watchpoint/IListUserTasks";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    private void verifyAuthority() throws InsufficientRolesException {
        if (!this.authService.isAuthorized("Home", "Dashboard")) {
            throw new InsufficientRolesException();
        }
    }

    @Override
    public UserTaskList getUserTasks() throws NeptuneException {
        this.verifyAuthority();
        Integer numUserTasks = 10;
        try {
            UIPropertyProvider propProvider = new UIPropertyProvider();
            String numUserTasksStr = propProvider.getInfo().get(PROP_UPPER_LIMIT);
            if (numUserTasksStr != null && numUserTasksStr.trim().length() != 0) {
                numUserTasks = Integer.parseInt(numUserTasksStr);
            }
        }
        catch (Exception propProvider) {
            // empty catch block
        }
        try {
            return this.getTasks(this.authService.getUserName(), numUserTasks);
        }
        catch (APIException e) {
            if (e.getStatusCode() != 404) {
                logger.warn((Object)("Failed to get tasks for " + this.authService.getUserName()), (Throwable)e);
                throw new NeptuneException(e.getMessage());
            }
            return new UserTaskList();
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to get tasks for " + this.authService.getUserName()), (Throwable)e);
            throw new NeptuneException(e.getMessage());
        }
    }

    @Override
    public UiTable getUserTasksListTableConfiguration() {
        TableConfig configuration = TableConfig.getInstance();
        File tableFile = this.configService.getFile(CONF_DIR, USER_TASK_TABLE_CONFIG_FILE_NAME);
        UiTable uiTable = null;
        uiTable = !tableFile.exists() ? new UiTable() : this.prepareUiTable(configuration.getTable("UserTasksPortletTable", tableFile));
        return uiTable;
    }

    private UserTaskList getTasks(String username, int max) throws IOException {
        Collection<String> providerIds = this.getProviderIds();
        UserTaskList tasks = new UserTaskList();
        TaskListResponse response = this.getItems(username);
        tasks.setTotalNumUserTasks(response.getTotal());
        for (Task task : response.getItems()) {
            if (!this.partnerservice.isSelfPartnerUser() && !providerIds.contains(task.getProviderId())) continue;
            tasks.addUserTask(this.from(task));
        }
        return tasks;
    }

    private UserTask from(Task task) {
        UserTask u = new UserTask();
        u.setAssignedDateTime(new SimpleDateFormat(DATE_FORMAT).format(task.getStart()));
        u.setName(task.getName());
        u.setResourceGroup(task.getGroup());
        u.setWorkOrderTemplate(task.getTemplate());
        u.setTaskInstanceId(Long.valueOf(task.getTaskId()));
        u.setWorkOrderID(Long.valueOf(task.getId()));
        u.addProcessVariable("titleBrief", task.getTitleId());
        return u;
    }

    private TaskListResponse getItems(String username) throws IOException {
        Tasks tasks = this.tasks();
        tasks.query().user(username);
        return tasks.execute();
    }

    private Tasks tasks() {
        return new API.Builder().build().tasks();
    }

    private UiTable prepareUiTable(Table table) {
        UiTable uiTable = new UiTable();
        for (Column col : table.getColumns()) {
            UiColumn uiCol = new UiColumn();
            uiCol.setColumnName(col.getColumnName());
            uiCol.setMethodName(col.getMethodName());
            uiCol.setParameter(col.getParameter());
            uiCol.setWidth(col.getWidth());
            uiTable.addColumn(uiCol);
        }
        return uiTable;
    }

    protected Collection<String> getProviderIds() {
        HashSet<String> providerIds = new HashSet<String>();
        List partners = this.partnerservice.getPartnersByCurrentUser();
        for (Partner partner : partners) {
            providerIds.add(partner.getProviderId());
            logger.debug((Object)("Adding filter by provider id " + partner.getProviderId()));
        }
        return providerIds;
    }
}

