/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.server;

import com.tandbergtv.cms.ui.workflow.client.IQueuedUserTasksPortletService;
import com.tandbergtv.cms.ui.workflow.client.Permission;
import com.tandbergtv.cms.ui.workflow.client.model.QueuedUserTasksGroupData;
import com.tandbergtv.cms.ui.workflow.client.model.QueuedUserTasksPortletData;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.workflow.api.API;
import com.tandbergtv.workflow.api.APIException;
import com.tandbergtv.workflow.api.Resources;
import com.tandbergtv.workflow.api.model.resource.Resource;
import com.tandbergtv.workflow.api.model.resource.ResourceGroup;
import com.tandbergtv.workflow.api.model.resource.ResourceListResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.apache.log4j.Logger;

public class QueuedUserTasksPortletService
implements NeptuneRemoteService,
IQueuedUserTasksPortletService {
    private TasksGroupComparator comparator = new TasksGroupComparator();
    private static final Logger logger = Logger.getLogger(QueuedUserTasksPortletService.class);

    @Override
    public QueuedUserTasksPortletData getData() throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{Permission.TASKS_ASSIGN.toString()});
        QueuedUserTasksPortletData data = new QueuedUserTasksPortletData();
        String userName = NeptuneAuthorizationManager.getAuthorizationService().getUserName();
        int totalCount = 0;
        try {
            for (ResourceGroup group : this.getResourceGroups(userName)) {
                if (group.getInternallyAcquired() == null || group.getInternallyAcquired().booleanValue() || group.getQueueSize() <= 0) continue;
                QueuedUserTasksGroupData groupData = this.from(group);
                data.getGroupData().add(groupData);
                totalCount += groupData.getTaskCount();
            }
            data.setTotalTaskCount(totalCount);
            Collections.sort(data.getGroupData(), this.comparator);
        }
        catch (APIException e) {
            if (e.getStatusCode() != 404) {
                logger.warn((Object)("Failed to get queued tasks for " + userName), (Throwable)e);
                throw new NeptuneException(e.getMessage());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to get queued tasks for " + userName), (Throwable)e);
            throw new NeptuneException(e.getMessage());
        }
        return data;
    }

    public String getRelativePath() {
        return "service/watchpoint/IQueuedUserTasksPortletService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    private QueuedUserTasksGroupData from(ResourceGroup group) {
        QueuedUserTasksGroupData q = new QueuedUserTasksGroupData();
        q.setResourceGroupId(Long.valueOf(group.getId()));
        q.setResourceGroupName(group.getName());
        q.setTaskCount(group.getQueueSize());
        return q;
    }

    private Collection<ResourceGroup> getResourceGroups(String name) throws IOException {
        Resources resources = this.resources();
        resources.query().name(name);
        ResourceListResponse response = resources.execute();
        if (response.getCount() == 0) {
            return Collections.emptySet();
        }
        return ((Resource)response.getItems().get(0)).getGroups();
    }

    private Resources resources() {
        return new API.Builder().build().resources();
    }

    private static final class TasksGroupComparator
    implements Comparator<QueuedUserTasksGroupData> {
        private TasksGroupComparator() {
        }

        @Override
        public int compare(QueuedUserTasksGroupData o1, QueuedUserTasksGroupData o2) {
            return o1.getResourceGroupName().compareTo(o2.getResourceGroupName());
        }
    }
}

