/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.server;

import com.tandbergtv.cms.ui.workflow.client.geo.GeoRedundancyPortletData;
import com.tandbergtv.cms.ui.workflow.client.geo.GeoRedundancyPortletRecord;
import com.tandbergtv.cms.ui.workflow.client.geo.GeoRedundancyPortletSettings;
import com.tandbergtv.cms.ui.workflow.server.IResourceStatusService;
import com.tandbergtv.neptune.configuration.settings.service.ISettingsService;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Singleton;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Singleton(name="Workflow:service=com.tandbergtv.cms.ui.workflow.server.IResourceStatusService")
@Local(value={IResourceStatusService.class})
public class ResourceStatusService
implements IResourceStatusService {
    private static final Logger logger = Logger.getLogger(ResourceStatusService.class);
    @EJB
    private ISettingsService settingsService = null;
    private GeoRedundancyPortletSettings settings = null;
    private Connection con;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SimpleDateFormat sdfES = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private GeoRedundancyPortletData cache;
    private Properties geoProps;
    private HashMap<String, GeoRedundancyPortletRecord> nodeMap = null;

    public ResourceStatusService() {
        this.sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.nodeMap = new HashMap();
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ResourceStatusService.this.geoProps = ResourceStatusService.readGCProperties();
                    if (ResourceStatusService.this.geoProps == null) continue;
                    ResourceStatusService.this.settingsService = (ISettingsService)InjectionUtil.injectInstance((String)"cms/SettingsService/local", ISettingsService.class);
                    ResourceStatusService.this.loadSettings();
                    ResourceStatusService.this.cache = ResourceStatusService.this.getData();
                }
            }
        };
        thread.start();
    }

    @Override
    public GeoRedundancyPortletData getCache() {
        return this.cache;
    }

    public void setCache(GeoRedundancyPortletData cache) {
        this.cache = cache;
    }

    public void setDatabaseUserPass() {
        Properties props = new Properties();
        String jbossConfigHome = System.getProperty("jboss.server.config.dir");
        File file = new File(jbossConfigHome + "/standalone.xml");
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(file);
            NodeList nList = doc.getElementsByTagName("datasource");
            block2: for (int temp = 0; temp < nList.getLength(); ++temp) {
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1) continue;
                for (int i = 0; i < nNode.getAttributes().getLength(); ++i) {
                    if (!nNode.getAttributes().item(i).getNodeValue().equals("java:/neptune/datasource")) continue;
                    Element eElement = (Element)nNode;
                    props.put("connection-url", eElement.getElementsByTagName("connection-url").item(0).getTextContent());
                    props.put("user-name", eElement.getElementsByTagName("user-name").item(0).getTextContent());
                    props.put("password", eElement.getElementsByTagName("password").item(0).getTextContent());
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            logger.debug((Object)e);
        }
        if (props.getProperty("user-name") == null || props.getProperty("password") == null || props.getProperty("connection-url") == null) {
            logger.warn((Object)"Cannot parse database authentication; trying defaults");
            this.settings.setDatabaseUser("wfs");
            this.settings.setDatabasePass("Wf$1234");
            this.settings.setMasterIp("dbserver");
            this.settings.setDatabaseName("ttv");
            this.settings.setDatabasePort(5444);
        } else {
            this.settings.setDatabaseUser(props.getProperty("user-name"));
            this.settings.setDatabasePass(props.getProperty("password"));
            String connStr = props.getProperty("connection-url");
            String dbName = connStr.split("//")[1].split("/")[1];
            String port = connStr.split("//")[1].split(":")[1].split("/")[0];
            String server = connStr.split("//")[1].split(":")[0];
            if (this.settings.getDatabaseOverride() != null && this.settings.getDatabaseOverride().length() > 0) {
                dbName = this.settings.getDatabaseOverride();
            }
            if (this.settings.getMasterIp() == null || this.settings.getMasterIp().length() == 0) {
                this.settings.setMasterIp(server);
            }
            this.settings.setDatabaseName(dbName);
            this.settings.setDatabasePort(Integer.parseInt(port));
        }
    }

    public GeoRedundancyPortletSettings getSettings() {
        return this.settings;
    }

    public void loadSettings() {
        logger.debug((Object)"Loading settings");
        this.settings = new GeoRedundancyPortletSettings();
        if (this.settingsService != null) {
            this.settings.setDatabaseOverride((String)this.settingsService.getProperties("com.tandbergtv.georedundancy").get("database.override"));
            this.settings.setSlaveIpQuery((String)this.settingsService.getProperties("com.tandbergtv.georedundancy").get("slave.ip.query"));
            this.settings.setLagQuery((String)this.settingsService.getProperties("com.tandbergtv.georedundancy").get("lag.query"));
            this.settings.setThresholdSecondsFail(Integer.parseInt((String)this.settingsService.getProperties("com.tandbergtv.georedundancy").get("threshold.fail.database")));
            this.settings.setThresholdSecondsWarn(Integer.parseInt((String)this.settingsService.getProperties("com.tandbergtv.georedundancy").get("threshold.warn.database")));
            this.settings.setThresholdSecondsFailEs(Integer.parseInt((String)this.settingsService.getProperties("com.tandbergtv.georedundancy").get("threshold.fail.elasticsearch")));
            this.settings.setThresholdSecondsWarnEs(Integer.parseInt((String)this.settingsService.getProperties("com.tandbergtv.georedundancy").get("threshold.warn.elasticsearch")));
            this.settings.setThresholdSecondsFailApp(Integer.parseInt((String)this.settingsService.getProperties("com.tandbergtv.georedundancy").get("threshold.fail.application")));
            this.settings.setThresholdSecondsWarnApp(Integer.parseInt((String)this.settingsService.getProperties("com.tandbergtv.georedundancy").get("threshold.warn.application")));
            this.settings.setMasterIp((String)this.settingsService.getProperties("com.tandbergtv.georedundancy").get("master.ip"));
            this.settings.setElasticSearchHost((String)this.settingsService.getProperties("com.tandbergtv.georedundancy").get("elasticsearch.host"));
            this.settings.setIpAliasList((String)this.settingsService.getProperties("com.tandbergtv.georedundancy").get("ip.alias.list"));
            this.settings.setElasticSearchPort(Integer.parseInt((String)this.settingsService.getProperties("com.tandbergtv.georedundancy").get("elasticsearch.port")));
        }
        if (this.geoProps != null && this.geoProps.getProperty("SECONDARY_DOMAIN") != null) {
            this.settings.setElasticSearchHost("es." + this.geoProps.getProperty("SECONDARY_DOMAIN"));
        }
        this.setDatabaseUserPass();
    }

    private String getLagTime(String ip) throws Exception {
        String urlDB = "jdbc:postgresql://" + ip + ":" + this.getSettings().getDatabasePort() + "/" + this.getSettings().getDatabaseName();
        String ts = "";
        try {
            Class.forName("org.postgresql.Driver");
            this.con = DriverManager.getConnection(urlDB, this.getSettings().getDatabaseUser(), this.getSettings().getDatabasePass());
            Statement stmt = this.con.createStatement();
            ResultSet rs = stmt.executeQuery(this.getSettings().getLagQuery());
            while (rs.next()) {
                ts = rs.getString("ts");
            }
            rs.close();
            stmt.close();
            this.con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            ts = "99:99:99.000";
            logger.warn((Object)("Could not connect to " + urlDB));
            throw new Exception();
        }
        return ts;
    }

    private long convertDurationToMilliseconds(String duration) {
        long lDuration = 0L;
        try {
            lDuration = this.sdf.parse("1970-01-01 " + duration).getTime();
        }
        catch (Exception e) {
            logger.debug((Object)e);
        }
        return lDuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readGCProperties() {
        File file = new File("/opt/tandbergtv/geo.conf");
        if (!file.exists()) {
            logger.debug((Object)"ERROR: Geo properties file (/opt/tandbergtv/geo.conf) doesn't exist.");
            return null;
        }
        FileReader rd = null;
        Properties props = new Properties();
        try {
            rd = new FileReader(file);
            props.load(rd);
        }
        catch (Exception ex) {
            logger.debug((Object)("ERROR: Could not read Geo properties file (/opt/tandbergtv/geo.conf). " + ex.getMessage()));
            Properties properties = null;
            return properties;
        }
        finally {
            try {
                rd.close();
            }
            catch (Exception exception) {}
        }
        return props;
    }

    private String getLastSyncDate(String server, String index) throws Exception {
        String inputLine;
        String url = "http://" + server + ":9200/" + index + "/_search";
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("GET");
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        String output = response.toString();
        output = output.split("lastSyncDate\":\"")[1].split("\"")[0];
        String _output = output.substring(0, 10) + " " + output.substring(11, output.length());
        return _output;
    }

    private String getLastGeoRsyncDate(String server, String index) throws Exception {
        String inputLine;
        String url = "http://" + server + ":9200/" + index + "/_search";
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("GET");
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        String output = response.toString();
        output = output.split("lastGeoRsyncDate\":\"")[1].split("\"")[0];
        String _output = output.substring(0, 10) + " " + output.substring(11, output.length());
        return _output;
    }

    private String getLastHistoryGeoRsyncDate(String server, String index) throws Exception {
        String inputLine;
        String url = "http://" + server + ":9200/" + index + "/_search";
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("GET");
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        String output = response.toString();
        output = output.split("lastHistoryGeoRsyncDate\":\"")[1].split("\"")[0];
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(Long.parseLong(output));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(calendar.getTimeZone());
        String _output = sdf.format(calendar.getTime());
        return _output;
    }

    public List<GeoRedundancyPortletRecord> getElasticSearchRecords() throws Exception {
        ArrayList<GeoRedundancyPortletRecord> records = new ArrayList<GeoRedundancyPortletRecord>();
        long lagMilliseconds = 0L;
        Date lastSuccessfulSync = null;
        GeoRedundancyPortletRecord firstRecord = new GeoRedundancyPortletRecord();
        firstRecord.setMessage("message");
        firstRecord.setNodeName("Elasticsearch (Content and Work Orders)");
        Integer currentStatus = 0;
        currentStatus = this.nodeMap.get(firstRecord.getNodeName()) != null ? Integer.valueOf(this.nodeMap.get(firstRecord.getNodeName()).getReplicationStatusLevel()) : Integer.valueOf(0);
        try {
            String esHost = this.getSettings().getElasticSearchHost();
            String strDate = this.getLastSyncDate(esHost, "lastsyncindex");
            lastSuccessfulSync = this.sdfES.parse(strDate);
        }
        catch (Exception e) {
            lastSuccessfulSync = new Date(0L);
            logger.debug((Object)e);
        }
        lagMilliseconds = new Date().getTime() - lastSuccessfulSync.getTime();
        if (lagMilliseconds > (long)(1000 * this.getSettings().getThresholdSecondsFailEs())) {
            firstRecord.setReplicationStatus("Failed");
            firstRecord.setReplicationStatusLevel(2);
            firstRecord.setSyncFailureTime(new Date(new Date().getTime() - lagMilliseconds));
            if (currentStatus != 2) {
                logger.warn((Object)"Replication status for Elasticsearch is Failed");
            }
        } else if (lagMilliseconds > (long)(1000 * this.getSettings().getThresholdSecondsWarnEs())) {
            firstRecord.setReplicationStatusLevel(1);
            firstRecord.setReplicationStatus("Delayed");
            if (currentStatus != 1) {
                logger.warn((Object)"Replication status for Elasticsearch is Delayed");
            }
        } else {
            firstRecord.setReplicationStatusLevel(0);
            firstRecord.setReplicationStatus("Successful");
        }
        firstRecord.setLastSuccessfulSync(lastSuccessfulSync);
        records.add(firstRecord);
        this.nodeMap.put(firstRecord.getNodeName(), firstRecord);
        lagMilliseconds = 0L;
        lastSuccessfulSync = null;
        GeoRedundancyPortletRecord secondRecord = new GeoRedundancyPortletRecord();
        secondRecord.setMessage("message");
        secondRecord.setNodeName("Elasticsearch (Work Order History)");
        currentStatus = 0;
        currentStatus = this.nodeMap.get(secondRecord.getNodeName()) != null ? Integer.valueOf(this.nodeMap.get(secondRecord.getNodeName()).getReplicationStatusLevel()) : Integer.valueOf(0);
        try {
            String esHost = this.getSettings().getElasticSearchHost();
            String strDate = this.getLastHistoryGeoRsyncDate(esHost, "lastsyncindex");
            lastSuccessfulSync = this.sdfES.parse(strDate);
        }
        catch (Exception e) {
            lastSuccessfulSync = new Date(0L);
            logger.debug((Object)e);
        }
        lagMilliseconds = new Date().getTime() - lastSuccessfulSync.getTime();
        if (lagMilliseconds > (long)(1000 * this.getSettings().getThresholdSecondsFailEs())) {
            secondRecord.setReplicationStatus("Failed");
            secondRecord.setReplicationStatusLevel(2);
            secondRecord.setSyncFailureTime(new Date(new Date().getTime() - lagMilliseconds));
            if (currentStatus != 2) {
                logger.warn((Object)"Replication status for Elasticsearch is Failed");
            }
        } else if (lagMilliseconds > (long)(1000 * this.getSettings().getThresholdSecondsWarnEs())) {
            secondRecord.setReplicationStatusLevel(1);
            secondRecord.setReplicationStatus("Delayed");
            if (currentStatus != 1) {
                logger.warn((Object)"Replication status for Elasticsearch is Delayed");
            }
        } else {
            secondRecord.setReplicationStatusLevel(0);
            secondRecord.setReplicationStatus("Successful");
        }
        secondRecord.setLastSuccessfulSync(lastSuccessfulSync);
        records.add(secondRecord);
        this.nodeMap.put(secondRecord.getNodeName(), secondRecord);
        return records;
    }

    public List<GeoRedundancyPortletRecord> getApplicationRecords() throws Exception {
        ArrayList<GeoRedundancyPortletRecord> records = new ArrayList<GeoRedundancyPortletRecord>();
        long lagMilliseconds = 0L;
        Date lastSuccessfulGeoRsync = null;
        GeoRedundancyPortletRecord record = new GeoRedundancyPortletRecord();
        record.setMessage("message");
        record.setNodeName("Application");
        Integer currentStatus = 0;
        try {
            lastSuccessfulGeoRsync = this.sdfES.parse(this.getLastGeoRsyncDate(this.getSettings().getElasticSearchHost(), "lastsyncindex"));
        }
        catch (Exception e) {
            lastSuccessfulGeoRsync = new Date(0L);
            logger.debug((Object)e);
        }
        lagMilliseconds = new Date().getTime() - lastSuccessfulGeoRsync.getTime();
        if (lagMilliseconds > (long)(1000 * this.getSettings().getThresholdSecondsFailApp())) {
            record.setReplicationStatus("Failed");
            record.setReplicationStatusLevel(2);
            record.setSyncFailureTime(new Date(new Date().getTime() - lagMilliseconds));
            if (currentStatus != 2) {
                logger.warn((Object)"Replication status for Application is Failed");
            }
        } else if (lagMilliseconds > (long)(1000 * this.getSettings().getThresholdSecondsWarnApp())) {
            record.setReplicationStatusLevel(1);
            record.setReplicationStatus("Delayed");
            if (currentStatus != 1) {
                logger.warn((Object)"Replication status for Application is Delayed");
            }
        } else {
            record.setReplicationStatusLevel(0);
            record.setReplicationStatus("Successful");
        }
        record.setLastSuccessfulSync(lastSuccessfulGeoRsync);
        records.add(record);
        this.nodeMap.put(record.getNodeName(), record);
        logger.warn((Object)("getApplicationRecords " + records.size()));
        return records;
    }

    private List<GeoRedundancyPortletRecord> getDatabaseRecords() throws Exception {
        ArrayList<GeoRedundancyPortletRecord> records = new ArrayList<GeoRedundancyPortletRecord>();
        ArrayList<String> list = new ArrayList<String>();
        if (this.geoProps != null) {
            if (this.geoProps.getProperty("PRIMARY_DOMAIN") != null) {
                list.add("edb1." + this.geoProps.getProperty("PRIMARY_DOMAIN"));
                list.add("edb2." + this.geoProps.getProperty("PRIMARY_DOMAIN"));
            }
            if (this.geoProps.getProperty("SECONDARY_DOMAIN") != null) {
                list.add("edb1." + this.geoProps.getProperty("SECONDARY_DOMAIN"));
                list.add("edb2." + this.geoProps.getProperty("SECONDARY_DOMAIN"));
            }
        }
        Integer currentStatus = null;
        for (String childIp : list) {
            GeoRedundancyPortletRecord record;
            block12: {
                record = new GeoRedundancyPortletRecord();
                record.setMessage("message");
                record.setNodeName("Database: " + childIp);
                currentStatus = this.nodeMap.get(record.getNodeName()) != null ? Integer.valueOf(this.nodeMap.get(record.getNodeName()).getReplicationStatusLevel()) : Integer.valueOf(0);
                try {
                    String lagTime = this.getLagTime(childIp);
                    if (lagTime.isEmpty()) continue;
                    long lagMilliseconds = this.convertDurationToMilliseconds(lagTime.split("\\.")[0]);
                    if (lagMilliseconds > (long)(1000 * this.getSettings().getThresholdSecondsFail())) {
                        record.setReplicationStatus("Failed");
                        record.setReplicationStatusLevel(2);
                        record.setSyncFailureTime(new Date(new Date().getTime() - lagMilliseconds));
                        if (currentStatus != 2) {
                            logger.warn((Object)("Replication status for Database " + childIp + " is Failed"));
                        }
                    } else if (lagMilliseconds > (long)(1000 * this.getSettings().getThresholdSecondsWarn())) {
                        record.setReplicationStatusLevel(1);
                        record.setReplicationStatus("Delayed");
                        if (currentStatus != 1) {
                            logger.warn((Object)("Replication status for Database " + childIp + " is Delayed"));
                        }
                    } else {
                        record.setReplicationStatusLevel(0);
                        record.setReplicationStatus("Successful");
                    }
                    record.setLastSuccessfulSync(new Date(new Date().getTime() - lagMilliseconds));
                }
                catch (Exception e) {
                    record.setReplicationStatus("Failed");
                    record.setReplicationStatusLevel(2);
                    record.setSyncFailureTime(new Date(new Date().getTime()));
                    record.setLastSuccessfulSync(new Date(0L));
                    if (currentStatus == 2) break block12;
                    logger.warn((Object)("Replication status for Database " + childIp + " is Failed"));
                }
            }
            this.nodeMap.put(record.getNodeName(), record);
            records.add(record);
        }
        return records;
    }

    public GeoRedundancyPortletData getData() {
        List<Object> records = new ArrayList();
        try {
            records = this.getDatabaseRecords();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn((Object)e.getStackTrace());
        }
        try {
            records.addAll(this.getElasticSearchRecords());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn((Object)e.getStackTrace());
        }
        try {
            if (!this.getLastGeoRsyncDate(this.getSettings().getElasticSearchHost(), "lastsyncindex").isEmpty()) {
                records.addAll(this.getApplicationRecords());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn((Object)e.getStackTrace());
        }
        GeoRedundancyPortletData data = new GeoRedundancyPortletData(records);
        data.setSettings(this.settings);
        return data;
    }
}

