/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.server;

import com.tandbergtv.neptune.realm.persist.User;
import com.tandbergtv.neptune.usermgmt.service.IUserActionCallback;
import com.tandbergtv.neptune.usermgmt.service.UserActionException;
import com.tandbergtv.workflow.api.API;
import com.tandbergtv.workflow.api.APIException;
import com.tandbergtv.workflow.api.Resources;
import com.tandbergtv.workflow.api.model.resource.Resource;
import com.tandbergtv.workflow.api.model.resource.ResourceListResponse;
import java.io.IOException;
import org.apache.log4j.Logger;

public class UserActionCallbackImpl
implements IUserActionCallback {
    public void onBeforeDelete(User user) throws UserActionException {
        Resource resource = this.getResourceByUser(user.getUserName());
        if (resource != null) {
            String message = "Cannot delete user " + user.getUserName() + ", there is an existing resource for the user.";
            UserActionException e = new UserActionException("UserAction-BusyUser", message);
            e.getParameters().add(user.getUserName());
            throw e;
        }
    }

    public void onCreate(User user) throws UserActionException {
    }

    public void onDelete(User user) throws UserActionException {
    }

    public void onUpdate(User user) throws UserActionException {
    }

    private Resource getResourceByUser(String userName) {
        Resources resources = new API.Builder().build().resources();
        resources.query().name(userName);
        try {
            ResourceListResponse response = resources.execute();
            if (!response.getItems().isEmpty()) {
                return (Resource)response.getItems().get(0);
            }
        }
        catch (APIException e) {
            if (e.getStatusCode() != 404) {
                throw new RuntimeException("Failed to get the Resource for user[ " + userName + "].", e);
            }
        }
        catch (IOException e) {
            Logger.getLogger(UserActionCallbackImpl.class).warn((Object)"Failed to get resource", (Throwable)e);
        }
        return null;
    }
}

