/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.server;

import com.ericsson.neptune.security.util.SSLUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tandbergtv.neptune.authorization.service.IModuleManager;
import com.tandbergtv.neptune.realm.persist.Module;
import com.tandbergtv.neptune.realm.persist.Permission;
import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.User;
import com.tandbergtv.neptune.rolemgmt.service.IRoleValidityService;
import com.tandbergtv.neptune.rolemgmt.service.RoleValidationException;
import com.tandbergtv.neptune.usermgmt.service.IUserManager;
import com.tandbergtv.neptune.usermgmt.service.IUserValidityService;
import com.tandbergtv.neptune.usermgmt.service.UserValidationException;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.workflow.api.API;
import com.tandbergtv.workflow.api.APIException;
import com.tandbergtv.workflow.api.Resources;
import com.tandbergtv.workflow.api.model.resource.Resource;
import com.tandbergtv.workflow.api.model.resource.ResourceListResponse;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;

public class UserRoleValidityService
implements IUserValidityService,
IRoleValidityService {
    private static final String USER_TASK_MODULE = "UserTasks";
    private static final String PERFORM_TASK_PERMISSION = "PerformTask";
    private static final String PERFORM_OTHERS_TASK_PERMISSION = "PerformOthersTasks";
    private static final String ASSIGN_TASK_PERMISSION = "AssignTask";
    private static final String ASSIGN_TASK_TO_OTHERS_PERMISSION = "AssignTaskToOthers";
    private static final String HUMAN_RESOURCE_SYSTEM_ID = "04";

    public void validate(User user) throws UserValidationException {
        Resource resource;
        if (user.getUserName() != null && (resource = this.getResourceByUser(user.getUserName())) != null && !this.hasPerformTaskPermission(user, null)) {
            ModuleProxy module = new ModuleProxy(USER_TASK_MODULE);
            throw new UserValidationException("The selected role must contain '" + module.getModuleName() + "' - '" + module.getPermissionName(PERFORM_TASK_PERMISSION) + "' permission.");
        }
    }

    public void validate(Role role) throws RoleValidationException {
        ModuleProxy module = new ModuleProxy(USER_TASK_MODULE);
        if (!this.hasPermission(role, USER_TASK_MODULE, PERFORM_TASK_PERMISSION) && this.isWorkflowEnabled()) {
            List<Resource> resources = this.getAllHumanResources();
            IUserManager userManager = this.getUserManager();
            for (Resource resource : resources) {
                User user = userManager.getUser(resource.getName());
                if (user == null || !user.getRoles().contains(role) || this.hasPerformTaskPermission(user, role)) continue;
                throw new RoleValidationException("This role must contain '" + module.getModuleName() + "' - '" + module.getPermissionName(PERFORM_TASK_PERMISSION) + "' permission.");
            }
        }
        this.validateRolePermissions(role, module);
    }

    private boolean isWorkflowEnabled() throws RoleValidationException {
        boolean workflowEnabled = true;
        StringBuffer sb = new StringBuffer();
        HttpURLConnection con = null;
        try {
            URL url = new URL("https://app:8443/cms/services/licensing");
            con = (HttpsURLConnection)url.openConnection();
            ((HttpsURLConnection)con).setSSLSocketFactory(SSLUtil.getInstance().createSocketFactory());
            con.setDoOutput(true);
            con.setRequestMethod("GET");
            con.setRequestProperty("Accept", "application/json");
            con.setRequestProperty("Content-Type", "application/json");
            int responseCode = con.getResponseCode();
            if (responseCode == 200) {
                BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    line = br.readLine();
                }
            } else {
                throw new RoleValidationException("Could not get license information from Neptune, received responsecode " + responseCode);
            }
            if (sb.length() > 0) {
                ObjectMapper mapper = new ObjectMapper();
                TypeReference<HashMap<String, String>> type = new TypeReference<HashMap<String, String>>(){};
                HashMap licenses = (HashMap)mapper.readValue(sb.toString(), (TypeReference)type);
                workflowEnabled = Boolean.parseBoolean((String)licenses.get("IsRCSOnly"));
                boolean bl = !workflowEnabled;
                return bl;
            }
        }
        catch (Exception e) {
            throw new RoleValidationException("Could not check license for Workflow. Contact your administrator.");
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        return workflowEnabled;
    }

    private boolean hasPerformTaskPermission(User user, Role updatedRole) {
        for (Role role : user.getRoles()) {
            if (role.equals((Object)updatedRole)) {
                role = updatedRole;
            }
            if (!this.hasPermission(role, USER_TASK_MODULE, PERFORM_TASK_PERMISSION)) continue;
            return true;
        }
        return false;
    }

    private boolean hasPermission(Role role, String moduleName, String permissionName) {
        for (Permission permission : role.getPermissions()) {
            if (!moduleName.equals(permission.getModule().getName()) || !permissionName.equals(permission.getName())) continue;
            return true;
        }
        return false;
    }

    private void validateRolePermissions(Role role, ModuleProxy module) throws RoleValidationException {
        if (this.hasPermission(role, USER_TASK_MODULE, PERFORM_OTHERS_TASK_PERMISSION) && !this.hasPermission(role, USER_TASK_MODULE, PERFORM_TASK_PERMISSION)) {
            this.missingPermissionFailure(module.getModuleName(), module.getPermissionName(PERFORM_TASK_PERMISSION), module.getPermissionName(PERFORM_OTHERS_TASK_PERMISSION));
        }
        if (this.hasPermission(role, USER_TASK_MODULE, ASSIGN_TASK_PERMISSION) && !this.hasPermission(role, USER_TASK_MODULE, PERFORM_TASK_PERMISSION)) {
            this.missingPermissionFailure(module.getModuleName(), module.getPermissionName(PERFORM_TASK_PERMISSION), module.getPermissionName(ASSIGN_TASK_PERMISSION));
        }
        if (this.hasPermission(role, USER_TASK_MODULE, ASSIGN_TASK_TO_OTHERS_PERMISSION) && !this.hasPermission(role, USER_TASK_MODULE, ASSIGN_TASK_PERMISSION)) {
            this.missingPermissionFailure(module.getModuleName(), module.getPermissionName(ASSIGN_TASK_PERMISSION), module.getPermissionName(ASSIGN_TASK_TO_OTHERS_PERMISSION));
        }
    }

    private void missingPermissionFailure(String module, String missingPermission, String permission) throws RoleValidationException {
        String message = "This role must have permission '" + missingPermission + "' in order to have permission '" + permission + "' for module '" + module + "'";
        throw new RoleValidationException(message);
    }

    private Resource getResourceByUser(String userName) {
        Resources client = this.request();
        client.query().name(userName);
        ResourceListResponse response = null;
        try {
            response = client.execute();
        }
        catch (APIException e) {
            if (e.getStatusCode() != 404) {
                throw new RuntimeException("Failed to get the Resource for user[ " + userName + "].", e);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to get the Resource for user[ " + userName + "].", ex);
        }
        if (response == null || response.getItems().isEmpty()) {
            return null;
        }
        return (Resource)response.getItems().get(0);
    }

    private List<Resource> getAllHumanResources() throws RoleValidationException {
        ResourceListResponse response;
        Resources client = this.request();
        client.query().systemId(HUMAN_RESOURCE_SYSTEM_ID);
        try {
            response = client.execute();
        }
        catch (Exception ex) {
            throw new RoleValidationException("Workflow is not reachable. Failed to get the Resources for human", (Throwable)ex);
        }
        if (response.getItems().isEmpty()) {
            return new ArrayList<Resource>();
        }
        return response.getItems();
    }

    private Resources request() {
        return new API.Builder().build().resources();
    }

    private IUserManager getUserManager() {
        return (IUserManager)InjectionUtil.injectInstance((String)"cms/UserManager/local", IUserManager.class);
    }

    private static final class ModuleProxy {
        final String moduleName;
        Module module = null;
        boolean moduleRead = false;

        public ModuleProxy(String moduleName) {
            this.moduleName = moduleName;
        }

        String getModuleName() {
            Module module = this.getModule();
            return module != null ? module.getDisplayName() : this.moduleName;
        }

        String getPermissionName(String permissionName) {
            if (permissionName == null) {
                return null;
            }
            Module module = this.getModule();
            if (module != null) {
                for (Permission permission : module.getPermissions()) {
                    if (!permissionName.equals(permission.getName())) continue;
                    return permission.getDisplayName();
                }
            }
            return permissionName;
        }

        private Module getModule() {
            if (!this.moduleRead) {
                IModuleManager moduleManager = (IModuleManager)InjectionUtil.injectInstance((String)"cms/ModuleManager/local", IModuleManager.class);
                this.module = moduleManager.getModule(this.moduleName);
                this.moduleRead = true;
            }
            return this.module;
        }
    }
}

