/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.server;

import com.tandbergtv.cms.ui.workflow.client.IWOStatus;
import com.tandbergtv.cms.ui.workflow.client.WOState;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.configuration.settings.service.ISettingsService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.security.InsufficientRolesException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import com.tandbergtv.workflow.api.API;
import com.tandbergtv.workflow.api.Statistics;
import com.tandbergtv.workflow.api.model.process.ProcessStatus;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class WOStatusImpl
implements IWOStatus,
NeptuneRemoteService {
    private static final int DAYS = 30;
    private static final Logger logger = Logger.getLogger(WOStatusImpl.class);
    private static final String PROP_CUTOFF_DURATION = "workflow.woStatus.cutOffDuration";
    private static final String PROP_CUTOFF_DURATION_SETTING_GROUP = "com.tandbergtv.workflow.application";
    private IAuthorizationService authService = (IAuthorizationService)InjectionUtil.injectInstance((String)"cms/AuthorizationService/local", IAuthorizationService.class);
    private ISettingsService settingsService = (ISettingsService)InjectionUtil.injectInstance((String)"cms/SettingsService/local", ISettingsService.class);
    private IPartnerUserManager service = (IPartnerUserManager)InjectionUtil.injectInstance((String)"PartnerServices/PartnerUserManager", IPartnerUserManager.class);

    public String getRelativePath() {
        return "service/watchpoint/IWOStatus";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    private void verifyAuthority() throws InsufficientRolesException {
        if (!this.authService.isAuthorized("Home", "Dashboard")) {
            throw new InsufficientRolesException();
        }
    }

    private Date getCutOffDate() {
        Integer cutOffDuration = 30;
        try {
            String cutOffDurationStr = (String)this.settingsService.getProperties(PROP_CUTOFF_DURATION_SETTING_GROUP).get(PROP_CUTOFF_DURATION);
            if (cutOffDurationStr != null && (cutOffDurationStr = cutOffDurationStr.trim()).length() > 0) {
                cutOffDuration = Integer.parseInt(cutOffDurationStr);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to get cutoff duration [workflow.woStatus.cutOffDuration] value for Work Orders Status Portlet.", (Throwable)e);
        }
        GregorianCalendar gregCal = new GregorianCalendar();
        gregCal.setTime(new Date());
        gregCal.add(5, -1 * cutOffDuration);
        return gregCal.getTime();
    }

    @Override
    public Map<WOState, Integer> getStatus() throws NeptuneException {
        this.verifyAuthority();
        HashMap<WOState, Integer> woStatusMap = new HashMap<WOState, Integer>();
        Date cutOffDate = this.getCutOffDate();
        try {
            EnumMap<ProcessStatus, Long> map = this.getStatistics(cutOffDate);
            woStatusMap.put(WOState.ACTIVE, map.get(ProcessStatus.CREATED).intValue() + map.get(ProcessStatus.RUNNING).intValue() + map.get(ProcessStatus.BUSY).intValue());
            woStatusMap.put(WOState.COMPLETED, map.get(ProcessStatus.COMPLETED).intValue());
            woStatusMap.put(WOState.ERROR, map.get(ProcessStatus.ERROR).intValue());
            woStatusMap.put(WOState.CANCELLED, map.get(ProcessStatus.CANCELLED).intValue());
            woStatusMap.put(WOState.PAUSED, map.get(ProcessStatus.PAUSED).intValue());
            woStatusMap.put(WOState.QUEUED, map.get(ProcessStatus.QUEUED).intValue());
            woStatusMap.put(WOState.BRANCHED, map.get(ProcessStatus.BRANCHED).intValue());
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to get process statistics", (Throwable)e);
            throw new NeptuneException(e.getMessage());
        }
        return woStatusMap;
    }

    private Collection<String> getProviderIds() {
        HashSet<String> providerIds = new HashSet<String>();
        for (Partner partner : this.service.getPartnersByCurrentUser()) {
            providerIds.add(partner.getProviderId());
            logger.debug((Object)("Adding filter by provider id " + partner.getProviderId()));
        }
        return providerIds;
    }

    private EnumMap<ProcessStatus, Long> getStatistics(Date date) throws IOException {
        Collection<String> providerIds = this.getProviderIds();
        if (providerIds.isEmpty()) {
            EnumMap<ProcessStatus, Long> map = new EnumMap<ProcessStatus, Long>(ProcessStatus.class);
            for (ProcessStatus status : ProcessStatus.values()) {
                map.put(status, 0L);
            }
            return map;
        }
        Statistics stats = this.statistics();
        stats.query().statistics(date);
        if (!this.service.isSelfPartnerUser()) {
            String s = new String();
            for (String providerId : providerIds) {
                s = s + providerId + ",";
            }
            stats.query().providerId(s);
        }
        return stats.execute().getMap();
    }

    private Statistics statistics() {
        return new API.Builder().build().statistics();
    }
}

