/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class WorkflowTableConfigHelper {
    private static final String PACKAGE_NAME = "com/tandbergtv/workflow/web/";
    private static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    private static final String WFS_CONFIG_PATH = "conf/workflow";
    private static final String TABLE_CONFIG_FILE_NAME = "table-config.xml";
    private static final String DEFAULT_TABLE_CONFIG_FILE = "default-table-config.xml";

    public static File getTableConfigFile() {
        File file = new File(System.getProperty(PRODUCT_DIR) + File.separator + WFS_CONFIG_PATH + File.separator + TABLE_CONFIG_FILE_NAME);
        if (file.exists()) {
            return file;
        }
        file = new File(System.getProperty("java.io.tmpdir") + File.separator + TABLE_CONFIG_FILE_NAME);
        if (file.exists()) {
            return file;
        }
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            is = WorkflowTableConfigHelper.class.getClassLoader().getResourceAsStream("com/tandbergtv/workflow/web/default-table-config.xml");
            fos = new FileOutputStream(file);
            byte[] buf = new byte[4096];
            int read = 0;
            while ((read = is.read(buf)) > 0) {
                fos.write(buf, 0, read);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return file;
    }
}

