/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.workflow;

import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.ReservedVariable;
import com.tandbergtv.watchpoint.pmm.util.RulesEngineFacade;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.command.CompositeCommand;
import com.tandbergtv.workflow.message.command.ICommand;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;

public class AddVariableCommand
extends CompositeCommand {
    private static final String PROVIDER_ID = ReservedVariable.PROVIDER_ID.toString();
    private static final String TITLE_ID = ReservedVariable.TITLE_ID.toString();
    private static final String PRIORITY = "priority";
    private static final Logger logger = Logger.getLogger(AddVariableCommand.class);

    public AddVariableCommand(ICommand command) {
        super(command);
    }

    public WorkflowMessage execute() {
        String titleId = this.message.getValue(TITLE_ID);
        if (titleId == null || titleId.trim().length() == 0) {
            return super.execute();
        }
        logger.debug((Object)("Title id " + titleId));
        String priority = this.getPriority(Long.valueOf(titleId));
        this.message.getCommand().addParameter(PRIORITY, priority);
        String providerId = this.message.getValue(PROVIDER_ID);
        if (providerId != null && providerId.trim().length() > 0) {
            return super.execute();
        }
        providerId = this.getProviderId(Long.parseLong(titleId));
        logger.debug((Object)("Provider " + providerId));
        this.message.putValue(PROVIDER_ID, providerId);
        return super.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getProviderId(long titleId) {
        String providerId = null;
        try (Session session = null;){
            session = HibernateContext.getContext().openSession();
            Query query = session.createQuery("select p.providerId from Partner p, Title t where t.partnerId = p.id and t.id = :id");
            query.setParameter("id", (Object)titleId);
            providerId = (String)query.uniqueResult();
        }
        return providerId;
    }

    public String getPriority(Long titleId) {
        String processPriority = "NORMAL";
        try {
            processPriority = RulesEngineFacade.getPriority((Long)titleId);
            logger.debug((Object)("From Rules Engine, got ProcessPriority : " + processPriority + " for titleId : " + titleId));
        }
        catch (Exception e) {
            logger.error((Object)("Exception occurred getting ProcessPriority for workflow message titleId : " + titleId + " : " + e), (Throwable)e);
        }
        return processPriority;
    }
}

