/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.modules.component.service.util;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.web.WRException;
import com.jinfonet.web.beans.Atom;
import com.jinfonet.web.beans.Expression;
import com.jinfonet.web.beans.FieldType;
import com.jinfonet.web.beans.ResourceTypes;
import com.jinfonet.web.modules.component.service.util.DCScope;
import com.jinfonet.web.modules.component.service.util.NLSKit;
import com.jinfonet.web.service.Logger;
import com.jinfonet.web.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionFactoryCreator;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IExpressionFactory;
import jet.dataengine.api.expression.IOperatorFactory;
import jet.dataengine.api.expression.OperatorTypes;
import jet.dataengine.api.expression.tuple.IBooleanExpression;
import jet.dataengine.api.expression.tuple.ISingleConditionExpression;
import jet.dataengine.api.expression.tuple.op.IBinaryConditionOperator;
import jet.dataengine.api.expression.tuple.op.IMultiLogicOperator;
import jet.dataengine.api.expression.tuple.op.ISingleConditionOperator;
import jet.dataengine.api.expression.tuple.op.ISingleLogicOperator;
import jet.dataengine.api.expression.tuple.op.ITripleConditionOperator;
import jet.dataengine.api.expression.variable.IConstant;
import jet.dataengine.api.expression.variable.IFormula;
import jet.dataengine.api.expression.variable.IParameter;
import jet.dataengine.api.expression.variable.IReference;
import jet.dataengine.api.expression.variable.IVariableExpression;
import jet.dataengine.api.expression.variable.IVariableList;
import jet.universe.JetUFormula;
import jet.universe.JetUUniverse;

public class ExpressionService
implements FieldType {
    public static final String DEPEND_UNIVERSE = "JetUUniverse";
    public static final String DEPEND_DATASOURCE = "DataSource";
    public static final String DEPEND_QUERY = "QueryName";
    public static final String ALL = String.valueOf('\u0007');
    static final HashMap optmap = new HashMap();

    public static final IExpressionFactory getIExpressionFactory() throws WRException {
        IExpressionFactory iExpressionFactory = null;
        try {
            iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
        }
        catch (ConditionException conditionException) {
            WRException wRException = new WRException(327684, (Throwable)conditionException, new String[0]);
            throw wRException;
        }
        return iExpressionFactory;
    }

    public static final IOperatorFactory getIOperatorFactory() throws WRException {
        IOperatorFactory iOperatorFactory = null;
        try {
            iOperatorFactory = ExpressionFactoryCreator.getIOperatorFactory();
        }
        catch (ConditionException conditionException) {
            WRException wRException = new WRException(327684, (Throwable)conditionException, new String[0]);
            throw wRException;
        }
        return iOperatorFactory;
    }

    public static final IExpression String2IExpression(String string, Map map) {
        Logger.logI("Expression in DataEngine format is " + string);
        Logger.logI("dependents resource are " + map);
        IExpression iExpression = ExpressionToolKit.parseStringToIExpression((String)string, (JetUUniverse)((JetUUniverse)map.get(DEPEND_UNIVERSE)), (String)((String)map.get(DEPEND_DATASOURCE)), (String)((String)map.get(DEPEND_QUERY)), (JetUFormula[])new JetUFormula[0]);
        return iExpression;
    }

    public static final String getEngineFormatOP(String string) {
        int n = (Integer)optmap.get(string);
        try {
            string = OperatorTypes.getOpTypeValue((int)n);
        }
        catch (ConditionException conditionException) {
            WRException wRException = new WRException(327684, "Cannot find the releated operator OperatorTypes.getOpTypeValue(" + string + ")");
            Logger.logE(wRException);
        }
        return string;
    }

    public static IExpression transExpression(Expression expression) throws WRException {
        return ExpressionService.transExpression(expression, null, true);
    }

    public static IExpression transExpression(Expression expression, DCScope dCScope) throws WRException {
        return ExpressionService.transExpression(expression, dCScope, true);
    }

    public static IExpression transExpression(Expression expression, DCScope dCScope, boolean bl) throws WRException {
        IExpressionFactory iExpressionFactory = ExpressionService.getIExpressionFactory();
        IOperatorFactory iOperatorFactory = ExpressionService.getIOperatorFactory();
        return ExpressionService.AGGREGATION(iExpressionFactory, iOperatorFactory, expression, dCScope, bl);
    }

    private static IExpression AGGREGATION(IExpressionFactory iExpressionFactory, IOperatorFactory iOperatorFactory, Expression expression, DCScope dCScope, boolean bl) throws WRException {
        Object object;
        int n;
        if (iExpressionFactory == null || iOperatorFactory == null) {
            return null;
        }
        List list = expression.getExpressions();
        if (((Expression)list.get(0)).isAtom()) {
            return ExpressionService.ALL(iExpressionFactory, iOperatorFactory, expression, dCScope, bl);
        }
        int n2 = list.size();
        ArrayList<IExpression> arrayList = new ArrayList<IExpression>();
        for (n = 0; n < n2; ++n) {
            object = (Expression)list.get(n);
            IExpression iExpression = ExpressionService.AGGREGATION(iExpressionFactory, iOperatorFactory, object, dCScope, bl);
            if (iExpression == null) continue;
            arrayList.add(iExpression);
        }
        n = arrayList.size();
        if (n == 0) {
            return null;
        }
        object = expression.getOP();
        int n3 = (Integer)optmap.get(object);
        try {
            switch (n3) {
                case 0x11500001: {
                    ISingleLogicOperator iSingleLogicOperator = iOperatorFactory.createNotOp();
                    return iExpressionFactory.createSingleLogicExp(iSingleLogicOperator, (IBooleanExpression)arrayList.get(0));
                }
                case -2125463550: 
                case -2125463548: {
                    if (n > 1) {
                        IMultiLogicOperator iMultiLogicOperator = iOperatorFactory.createMultiLogicOp(n3);
                        return iExpressionFactory.createMultiLogicExp(iMultiLogicOperator, arrayList.toArray(new IExpression[n]));
                    }
                    return (IExpression)arrayList.get(0);
                }
            }
            WRException wRException = new WRException(327684, "Unkown operation [ " + n3 + "].");
            throw wRException;
        }
        catch (ConditionException conditionException) {
            WRException wRException = new WRException(327684, (Throwable)conditionException, new String[0]);
            throw wRException;
        }
    }

    private static IExpression ALL(IExpressionFactory iExpressionFactory, IOperatorFactory iOperatorFactory, Expression expression, DCScope dCScope, boolean bl) throws WRException {
        if (iExpressionFactory == null || iOperatorFactory == null) {
            return null;
        }
        IExpression iExpression = null;
        IVariableExpression iVariableExpression = null;
        IVariableList iVariableList = null;
        List list = expression.getExpressions();
        Atom atom = ((Expression)list.get(0)).getAtom();
        iVariableExpression = ExpressionService.CONSTANT(atom, iExpressionFactory, iOperatorFactory, dCScope, bl);
        String string = atom.getInstName();
        int n = atom.getSqlType();
        IVariableList iVariableList2 = null;
        try {
            iVariableList2 = iExpressionFactory.createVariableList("");
        }
        catch (ConditionException conditionException) {
            throw new WRException(327684, new String[0]);
        }
        int n2 = list.size();
        boolean bl2 = false;
        if (n2 > 2) {
            for (int i = 1; i < n2; ++i) {
                Atom atom2 = ((Expression)list.get(i)).getAtom();
                String[] stringArray = ExpressionService.GROUP(atom2, string, dCScope);
                int n3 = atom2.getResourceType();
                for (String string2 : stringArray) {
                    if (string2 == null) {
                        bl2 = true;
                        continue;
                    }
                    if (ExpressionService.isAllValue(stringArray[0])) {
                        return null;
                    }
                    IVariableExpression iVariableExpression2 = ExpressionService.DETAIL(string2, n, n3, iExpressionFactory, iOperatorFactory, dCScope, bl);
                    ExpressionService.SEDU(iVariableList2, iVariableExpression2);
                }
            }
            iVariableList = iVariableList2;
        } else if (n2 == 2) {
            Atom atom3 = ((Expression)list.get(1)).getAtom();
            String[] stringArray = ExpressionService.GROUP(atom3, string, dCScope);
            int n4 = stringArray.length;
            int n5 = atom3.getResourceType();
            if (n4 > 1) {
                for (String string3 : stringArray) {
                    if (string3 == null) {
                        bl2 = true;
                        continue;
                    }
                    if (ExpressionService.isAllValue(string3)) {
                        return null;
                    }
                    IVariableExpression iVariableExpression3 = ExpressionService.DETAIL(string3, n, n5, iExpressionFactory, iOperatorFactory, dCScope, bl);
                    ExpressionService.SEDU(iVariableList2, iVariableExpression3);
                }
                iVariableList = iVariableList2;
            } else if (stringArray[0] == null) {
                bl2 = true;
            } else {
                if (ExpressionService.isAllValue(stringArray[0])) {
                    return null;
                }
                IVariableExpression iVariableExpression4 = ExpressionService.DETAIL(stringArray[0], n, n5, iExpressionFactory, iOperatorFactory, dCScope, bl);
                iVariableList = iVariableExpression4;
            }
        }
        iExpression = ExpressionService.FORMULA(iExpressionFactory, iOperatorFactory, expression, bl2, iVariableExpression, (IVariableExpression)iVariableList);
        return iExpression;
    }

    private static IVariableExpression CONSTANT(Atom atom, IExpressionFactory iExpressionFactory, IOperatorFactory iOperatorFactory, DCScope dCScope, boolean bl) {
        String string = atom.getInstName();
        int n = atom.getResourceType();
        IReference iReference = null;
        if (n == ResourceTypes.GROUP.intType() || n == ResourceTypes.DETAIL.intType() || n == ResourceTypes.AGGREGATION.intType()) {
            try {
                String string2 = atom.getCondRef();
                if (string2 != null && string2.trim().length() != 0) {
                    iReference = iExpressionFactory.createReference(string2, false);
                }
                if (bl) {
                    iReference = iExpressionFactory.createReference(string, true);
                    int n2 = atom.getSqlType();
                    if (dCScope != null) {
                        n2 = dCScope.getSQLType(string);
                        iReference.setDataType(Types.sqlTypeToType((int)n2));
                        atom.setSqlType(n2);
                    }
                    iReference.setDataType(Types.sqlTypeToType((int)n2));
                }
                iReference = iExpressionFactory.createReference(atom.getMappingName());
            }
            catch (ConditionException conditionException) {
                WRException wRException = new WRException(327684, (Throwable)conditionException, new String[0]);
                throw wRException;
            }
        } else if (n == ResourceTypes.FORMULA.intType()) {
            try {
                String string3 = atom.getCondRef();
                if (string3 != null && string3.trim().length() != 0) {
                    iReference = iExpressionFactory.createReference(string3, false);
                } else if (bl) {
                    iReference = iExpressionFactory.createReference(string, true);
                    int n3 = atom.getSqlType();
                    if (dCScope != null) {
                        n3 = dCScope.getSQLType(string);
                        iReference.setDataType(Types.sqlTypeToType((int)n3));
                        atom.setSqlType(n3);
                    } else {
                        iReference.setDataType(Types.sqlTypeToType((int)n3));
                    }
                } else {
                    iReference = iExpressionFactory.createReference(atom.getMappingName());
                }
            }
            catch (ConditionException conditionException) {
                WRException wRException = new WRException(327684, (Throwable)conditionException, new String[0]);
                throw wRException;
            }
        }
        return iReference;
    }

    private static IVariableExpression DETAIL(String string, int n, int n2, IExpressionFactory iExpressionFactory, IOperatorFactory iOperatorFactory, DCScope dCScope, boolean bl) {
        String string2;
        String string3 = string2 = String.valueOf(string);
        IConstant iConstant = null;
        try {
            switch (n2) {
                case 1: {
                    iConstant = iExpressionFactory.createConstant(string3);
                    if (string3 == null) {
                        iConstant.setNull(true);
                    }
                    iConstant.setDataType(Types.sqlTypeToType((int)n));
                    break;
                }
                case 2: {
                    iConstant = iExpressionFactory.createConstant(string3, true);
                    break;
                }
                case 3: {
                    iConstant = iExpressionFactory.createReference(string3, true);
                    break;
                }
                case 4: {
                    iConstant = iExpressionFactory.createParameter(string3, false);
                    break;
                }
                case 5: {
                    iConstant = iExpressionFactory.createFormula(string3);
                    break;
                }
                default: {
                    iConstant = iExpressionFactory.createConstant(string3);
                    iConstant.setDataType(Types.sqlTypeToType((int)n));
                    if (string3 == null) {
                        iConstant.setNull(true);
                    }
                    break;
                }
            }
        }
        catch (ConditionException conditionException) {
            WRException wRException = new WRException(327684, (Throwable)conditionException, new String[0]);
            throw wRException;
        }
        return iConstant;
    }

    private static IExpression FORMULA(IExpressionFactory iExpressionFactory, IOperatorFactory iOperatorFactory, Expression expression, boolean bl, IVariableExpression iVariableExpression, IVariableExpression iVariableExpression2) {
        ISingleConditionExpression iSingleConditionExpression = null;
        IBinaryConditionOperator iBinaryConditionOperator = null;
        String string = expression.getOP();
        int n = (Integer)optmap.get(string);
        try {
            switch (n) {
                case 556793860: 
                case 556793864: 
                case 556793872: 
                case 556793920: 
                case 556793984: 
                case 556794112: 
                case 556794368: {
                    if (bl) {
                        iBinaryConditionOperator = iOperatorFactory.createSingleConsitionOp(0x11300001);
                        iSingleConditionExpression = iExpressionFactory.createSingleConditionExp((ISingleConditionOperator)iBinaryConditionOperator, iVariableExpression);
                        break;
                    }
                    iBinaryConditionOperator = iOperatorFactory.createBinaryConditionOp(n);
                    iSingleConditionExpression = iExpressionFactory.createBinaryConditionExp(iBinaryConditionOperator, iVariableExpression, iVariableExpression2);
                    break;
                }
                case 556793888: {
                    if (bl) {
                        iBinaryConditionOperator = iOperatorFactory.createSingleConsitionOp(288358402);
                        iSingleConditionExpression = iExpressionFactory.createSingleConditionExp((ISingleConditionOperator)iBinaryConditionOperator, iVariableExpression);
                        break;
                    }
                    iBinaryConditionOperator = iOperatorFactory.createBinaryConditionOp(n);
                    iSingleConditionExpression = iExpressionFactory.createBinaryConditionExp(iBinaryConditionOperator, iVariableExpression, iVariableExpression2);
                    break;
                }
                case 556793857: 
                case 556793858: {
                    iBinaryConditionOperator = iOperatorFactory.createBinaryConditionOp(n);
                    iSingleConditionExpression = iExpressionFactory.createBinaryConditionExp(iBinaryConditionOperator, iVariableExpression, iVariableExpression2);
                    if (bl) {
                        iBinaryConditionOperator = iOperatorFactory.createSingleConsitionOp(0x11300001);
                        ISingleConditionExpression iSingleConditionExpression2 = iExpressionFactory.createSingleConditionExp((ISingleConditionOperator)iBinaryConditionOperator, iVariableExpression);
                        iSingleConditionExpression = ExpressionToolKit.buildOrExpression((IExpression)iSingleConditionExpression, (IExpression)iSingleConditionExpression2);
                    }
                    break;
                }
                case 1093664769: 
                case 1093664770: {
                    iBinaryConditionOperator = iOperatorFactory.createTripleConditionOp(n);
                    IVariableList iVariableList = (IVariableList)iVariableExpression2;
                    iSingleConditionExpression = iExpressionFactory.createTripleConditionExp((ITripleConditionOperator)iBinaryConditionOperator, iVariableExpression, iVariableList.getVariableExp(0), iVariableList.getVariableExp(1));
                    break;
                }
                case 0x11300001: 
                case 288358402: {
                    iBinaryConditionOperator = iOperatorFactory.createSingleConsitionOp(n);
                    iSingleConditionExpression = iExpressionFactory.createSingleConditionExp((ISingleConditionOperator)iBinaryConditionOperator, iVariableExpression);
                    break;
                }
                default: {
                    WRException wRException = new WRException(327684, "Unkown operation [ " + n + "].");
                    throw wRException;
                }
            }
        }
        catch (ConditionException conditionException) {
            WRException wRException = new WRException(327684, (Throwable)conditionException, new String[0]);
            throw wRException;
        }
        return iSingleConditionExpression;
    }

    private static String[] GROUP(Atom atom, String string, DCScope dCScope) {
        int n = atom.getResourceType();
        List<String> list = null;
        if (n == ResourceTypes.CONSTANT.intType()) {
            list = ExpressionService.add(atom, string, dCScope);
        } else {
            String string2 = atom.getInstName();
            if (string2 == null) {
                list = ExpressionService.add(atom, string, dCScope);
            } else {
                list = new ArrayList();
                list.add(atom.getInstName());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private static void SEDU(IVariableList iVariableList, IVariableExpression iVariableExpression) throws WRException {
        if (iVariableExpression instanceof IConstant) {
            try {
                iVariableList.addConstant((IConstant)iVariableExpression);
            }
            catch (ConditionException conditionException) {
                throw new WRException(327684, (Throwable)conditionException, new String[0]);
            }
        } else if (iVariableExpression instanceof IParameter) {
            try {
                iVariableList.addParameter((IParameter)iVariableExpression);
            }
            catch (ConditionException conditionException) {
                throw new WRException(327684, (Throwable)conditionException, new String[0]);
            }
        } else if (iVariableExpression instanceof IFormula) {
            try {
                iVariableList.addFormula((IFormula)iVariableExpression);
            }
            catch (ConditionException conditionException) {
                throw new WRException(327684, (Throwable)conditionException, new String[0]);
            }
        } else {
            throw new WRException(0xFF0001, "unknown expression type : " + iVariableExpression.getClass().getName());
        }
    }

    private static List add(Atom atom, String string, DCScope dCScope) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object[] objectArray = atom.getRealValue();
        if (objectArray == null) {
            return arrayList;
        }
        int n = objectArray.length;
        Object[] objectArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            if (object != null) {
                String string2 = String.valueOf(object);
                string2 = StringUtil.unescape((String)string2);
                objectArray2[i] = string2;
                continue;
            }
            objectArray2[i] = null;
        }
        Object[] objectArray3 = NLSKit.getColumnRealInputValues(objectArray2, string, dCScope);
        for (int i = 0; i < n; ++i) {
            arrayList.add((String)objectArray3[i]);
        }
        return arrayList;
    }

    public static boolean isAllValue(String string) {
        return ALL.equals(string);
    }

    static {
        optmap.put("AND", new Integer(-2125463550));
        optmap.put("OR", new Integer(-2125463548));
        optmap.put("NOT", new Integer(0x11500001));
        optmap.put("EQUALS", new Integer(556793872));
        optmap.put("NOT EQUALS", new Integer(556793888));
        optmap.put("MORE THAN", new Integer(556793920));
        optmap.put("MORE THAN EQUALS", new Integer(556793984));
        optmap.put("LESS THAN", new Integer(556794112));
        optmap.put("LESS THAN EQUALS", new Integer(556794368));
        optmap.put("LIKE", new Integer(556793860));
        optmap.put("NOT LIKE", new Integer(556793864));
        optmap.put("IN", new Integer(556793857));
        optmap.put("NOT IN", new Integer(556793858));
        optmap.put("BETWEEN", new Integer(1093664769));
        optmap.put("NOT BETWEEN", new Integer(1093664770));
        optmap.put("ISNULL", new Integer(0x11300001));
        optmap.put("NOT ISNULL", new Integer(288358402));
    }
}

