/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.modules.component.service.viewer;

import com.jinfonet.web.ActionResult;
import com.jinfonet.web.UserInfo;
import com.jinfonet.web.WRException;
import com.jinfonet.web.beans.DshViewerDef;
import com.jinfonet.web.beans.ExportDef;
import com.jinfonet.web.beans.FormatTypes;
import com.jinfonet.web.modules.component.service.LCSetEngineImpl;
import com.jinfonet.web.modules.component.service.util.ExportKit;
import com.jinfonet.web.service.Logger;
import com.jinfonet.web.service.ServiceContext;
import com.jinfonet.web.util.Discardable;
import com.jinfonet.web.util.FileUtil;
import com.jinfonet.web.util.Tools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import jet.bean.ExportInfo;
import jet.bean.HtmlParameter;
import jet.dataservice.api.JDataService;
import jet.export.print.JReportPrintListener;
import jet.server.api.admin.cfg.ConfigurationPrecisionMapping;
import jet.server.intf.jrs.ExResourceManager;
import jet.server.jrserver.JRRptServer;
import jet.util.EngineErrorListener;
import jet.util.EngineRuntimeInfo;
import jet.util.RuntimeInfo;

public abstract class ViewerEngine
implements Discardable,
JReportPrintListener {
    public static final String ZIP_TMP_FOLDER = "zipTempFolder";
    protected LCSetEngineImpl ENV = null;
    protected JDataService DS = null;
    private long append;

    public abstract ActionResult preview(DshViewerDef var1, ExportDef var2, List var3, int var4, String var5);

    public abstract ActionResult print(DshViewerDef var1, ExportDef var2, List var3, String var4);

    public abstract ActionResult export(DshViewerDef var1, ExportDef var2, List var3, String var4);

    public abstract void destroy();

    public abstract void clear();

    public ViewerEngine(LCSetEngineImpl lCSetEngineImpl) {
        this.ENV = lCSetEngineImpl;
        this.DS = lCSetEngineImpl.getDataService();
    }

    protected RuntimeInfo getRuntimeInfo(ExportDef exportDef) {
        EngineRuntimeInfo engineRuntimeInfo = EngineRuntimeInfo.createDefaultRuntimeInfo();
        int n = exportDef.getFormat();
        boolean bl = this.isHighPrecision(n);
        engineRuntimeInfo.setHighPrecision(bl);
        String string = exportDef.getStyleGroup();
        if (string != null && string.trim().length() > 0 && !"NONE".equalsIgnoreCase(string)) {
            engineRuntimeInfo.setExportStyleGroup(string);
        }
        return engineRuntimeInfo;
    }

    protected ExportInfo getExportInfo(String string, String string2, String string3) {
        ExportInfo exportInfo = new ExportInfo();
        exportInfo.setFileName(string);
        exportInfo.setReportName(string2);
        exportInfo.setViewName(string3);
        return exportInfo;
    }

    protected boolean isHighPrecision(int n) {
        int n2 = 2;
        switch (n) {
            case 0: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 4;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 6;
                break;
            }
            case 5: {
                n2 = 7;
                break;
            }
            case 6: {
                n2 = 5;
            }
        }
        JRRptServer jRRptServer = this.ENV.getServiceContext().getJRRptServer();
        ConfigurationPrecisionMapping configurationPrecisionMapping = jRRptServer.getAdminService().getConfigService().getConfigurationPrecisionMapping();
        boolean bl = true;
        int n3 = configurationPrecisionMapping.getPrecision(n2);
        if (n3 == 1) {
            bl = false;
        }
        return bl;
    }

    protected String makeFileName(ExportDef exportDef, String string, boolean bl, ServiceContext serviceContext) {
        Object object;
        Object object2;
        int n = exportDef.getTarget();
        UserInfo userInfo = this.ENV.getUserInfo();
        if (n == 2) {
            String string2 = userInfo.getUserID();
            object2 = serviceContext.getJRRptServer();
            object = (ExResourceManager)((JRRptServer)object2).getResourceManager();
            string = object.getArchivePath(string2);
            string = object.getLocalPath(string) + File.separator;
        }
        int n2 = exportDef.getFormat();
        object2 = this.DS(n2);
        object = exportDef.getFileName();
        File file = object == null || ((String)object).trim().length() == 0 ? new File(string, Tools.getUniqueID().toString() + (String)object2) : new File(string, (String)object + (String)object2);
        String string3 = file.getAbsolutePath();
        if (n2 == FormatTypes.HTML.intType() && !bl && exportDef.getZipped()) {
            string3 = this.makeZipFolder(string3);
        }
        return string3;
    }

    protected String makeZipFolder(String string) {
        String string2 = FileUtil.getFileName((String)string);
        String string3 = FileUtil.getFilePath((String)string);
        if (!string3.endsWith(File.separator)) {
            string3 = string3 + File.separator;
        }
        string3 = string3 + ZIP_TMP_FOLDER;
        File file = new File(string3);
        file.mkdir();
        string3 = string3 + File.separator + string2;
        return string3;
    }

    protected String makeZipFile(String string, String string2) throws WRException {
        String string3;
        File file;
        File[] fileArray;
        List<File> list;
        String string4 = string;
        int n = string4.lastIndexOf(File.separator);
        if (string2 == null) {
            string2 = FileUtil.getFileNameWithoutSuffix((String)string, (Pattern[])new Pattern[0]);
        }
        List<File> list2 = list = (fileArray = (file = new File(string = string.substring(0, n))).listFiles()) != null ? Arrays.asList(fileArray) : null;
        if (string4.indexOf(ZIP_TMP_FOLDER) > 0) {
            n = string4.indexOf(ZIP_TMP_FOLDER);
        }
        if (!(string3 = FileUtil.getFilePath((String)(string4 = string4.substring(0, n)))).endsWith(File.separator)) {
            string3 = string3 + File.separator;
        }
        string3 = string3 + string2 + ".zip";
        if (list != null) {
            try {
                FileUtil.buildZipFile((String)string3, list);
            }
            catch (IOException iOException) {
                throw new WRException(65537, (Throwable)iOException, new String[0]);
            }
            FileUtil.deletePath((String)string);
            return string3;
        }
        return null;
    }

    private String DS(int n) {
        switch (n) {
            case 0: {
                return ".pdf";
            }
            case 1: {
                return ".html";
            }
            case 2: {
                return ".xls";
            }
            case 3: {
                return ".txt";
            }
            case 4: {
                return ".rtf";
            }
            case 5: {
                return ".xml";
            }
            case 6: {
                return ".ps";
            }
        }
        return "";
    }

    protected WEngineErrorListenerImpl getEngineErrorListener() {
        return new WEngineErrorListenerImpl();
    }

    protected boolean needReRun(DshViewerDef dshViewerDef) {
        return dshViewerDef.isModified();
    }

    protected HtmlParameter buildPreviewHTMLParams(ExportDef exportDef) {
        HtmlParameter htmlParameter = ExportKit.buildHtmlParameter(exportDef);
        htmlParameter.setDhtml(false);
        htmlParameter.setIsExportToMultiFiles(false);
        htmlParameter.setUseExtenalCSSValue(true);
        htmlParameter.setEmbededCSS(true);
        htmlParameter.setHasHyperlink(false);
        htmlParameter.setHasPageNumber(false);
        htmlParameter.setIsExportAppletChart(false);
        return htmlParameter;
    }

    public void printStart() {
        this.append = System.currentTimeMillis();
        Logger.logI("A-*-printStart");
    }

    public void printEnd() {
        Logger.logI("A-*-printEnd, cost=" + (System.currentTimeMillis() - this.append));
    }

    static class WEngineErrorListenerImpl
    implements EngineErrorListener {
        private List SEDU = new ArrayList();
        private List add = new ArrayList();

        public void noteError(Thread thread, Throwable throwable, int n, String string) {
            if (throwable != null) {
                this.SEDU.add(throwable);
                this.add.add(new Integer(n));
            }
        }

        public void notifyReceiver(EngineErrorListener engineErrorListener) {
        }

        public void ThreadException(Thread thread, Throwable throwable) {
            if (throwable != null) {
                this.SEDU.add(throwable);
                this.add.add(new Integer(-1));
            }
        }

        public synchronized List getAllErrors() {
            return this.SEDU;
        }

        public synchronized List getAllErrorTypes() {
            return this.add;
        }

        public synchronized void clearErrors() {
            this.SEDU.clear();
            this.add.clear();
        }
    }
}

