/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.modules.pagereport.service.exporter;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class RenderBuffer {
    private StringBuilder SEDU;

    public RenderBuffer() {
        this(8192);
    }

    public RenderBuffer(int n) {
        this.SEDU = new StringBuilder(n);
    }

    public RenderBuffer append(Object object) {
        this.SEDU.append(object.toString());
        return this;
    }

    public RenderBuffer appendE(String string, Object object) {
        if (object != null) {
            this.append(" ").append(string).append("=\"").append(object.toString()).append("\"");
        }
        return this;
    }

    public RenderBuffer appendC(String string, Object ... objectArray) {
        if (objectArray != null && objectArray.length > 0 && objectArray[0] != null) {
            this.append(" ").append(string).append(":");
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                if (object == null) continue;
                if (i > 0) {
                    this.append(" ");
                }
                this.append(object.toString());
            }
            this.append(";");
        }
        return this;
    }

    public RenderBuffer appendR(int n, int n2, int n3, int n4, String ... stringArray) {
        String string = stringArray != null && stringArray.length > 0 ? stringArray[0] : "px";
        this.append(" left:").append(n).append(string).append(";");
        this.append(" top:").append(n2).append(string).append(";");
        this.append(" width:").append(n3).append(string).append(";");
        this.append(" height:").append(n4).append(string).append(";");
        return this;
    }

    public RenderBuffer appendA(List list) {
        if (list == null) {
            return this;
        }
        this.append("[");
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                this.append(",");
            }
            String string = (String)list.get(i);
            this.append("'").append(string != null ? string : "").append("'");
        }
        this.append("]");
        return this;
    }

    public RenderBuffer appendS(Map map) {
        this.append("style=\"");
        for (String string : map.keySet()) {
            Object v = map.get(string);
            this.appendC(string, v);
        }
        this.append("\"");
        return this;
    }

    public RenderBuffer appendU(Map map, String ... stringArray) {
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            this.append(stringArray[0]).append("?");
        }
        Iterator iterator = map.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = map.get(string);
            if (n != 0) {
                this.append("&");
            }
            this.append(string).append("=").append(v.toString());
            ++n;
        }
        return this;
    }

    public String toString() {
        return this.SEDU.toString();
    }

    public void clear() {
        this.SEDU.delete(0, this.SEDU.length());
    }

    public int length() {
        return this.SEDU.length();
    }

    public RenderBuffer delete(int n, int n2) {
        this.SEDU.delete(n, n2);
        return this;
    }
}

