/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.modules.pagereport.service.exporter.components;

import com.jinfonet.web.WRException;
import com.jinfonet.web.modules.pagereport.service.exporter.Component;
import com.jinfonet.web.modules.pagereport.service.exporter.ExportHelper;
import com.jinfonet.web.modules.pagereport.service.exporter.RenderBuffer;
import com.jinfonet.web.modules.pagereport.service.exporter.RuntimeInfo;
import com.jinfonet.web.service.Logger;
import com.jinfonet.web.util.Tools;
import com.jinfonet.web.util.template.TemplateAssembler;
import com.jinfonet.web.util.template.Templates;
import com.jinfonet.web.util.template.ViewLogic;
import java.awt.Color;
import java.io.IOException;
import java.io.StringWriter;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import jet.datastream.DSField;
import jet.datastream.DSParameterForm;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.formula.ParamDesc;
import jet.report.JetRptObject;
import jet.report.JetRptRefParameterField;
import jet.util.Propertiable;
import jet.web.dhtml.ExportRuntimeInfo;
import jet.webreport.beans.Parameter;

public abstract class ComponentBase
implements Component {
    protected RuntimeInfo ctx;
    protected Object dsObj;
    protected Component.Geometric geom;
    protected int zindex;
    protected Templates template;
    protected ViewLogic viewLogic;
    private long HALIGNMENTS;

    public ComponentBase(Object object, RuntimeInfo runtimeInfo) {
        this.dsObj = object;
        this.ctx = runtimeInfo;
        this.geom = new GeometricImpl();
        if (object instanceof JRObjectResult) {
            this.geom.setX(this.unit2pixel(this.getX()));
            this.geom.setY(this.unit2pixel(this.getY()));
            this.geom.setW(this.unit2pixel(this.getW()));
            this.geom.setH(this.unit2pixel(this.getH()));
            JRObjectResult jRObjectResult = (JRObjectResult)object;
            runtimeInfo.putDSObject(jRObjectResult);
            runtimeInfo.putDSTemplate((JetRptObject)jRObjectResult.getTemplate());
        }
    }

    public final void beforeRender() {
        if (Logger.T && ExportHelper.needTrace(this.dsObj)) {
            this.HALIGNMENTS = System.currentTimeMillis();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("B-0-").append("Render ").append(this.dsObj.getClass().getSimpleName()).append("@").append(Integer.toHexString(this.dsObj.hashCode()));
            Logger.logT(stringBuilder);
        }
    }

    public final void afterRender() {
        if (Logger.T && ExportHelper.needTrace(this.dsObj)) {
            long l = System.currentTimeMillis() - this.HALIGNMENTS;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("A-*-").append("Render ").append(this.dsObj.getClass().getSimpleName()).append("@").append(Integer.toHexString(this.dsObj.hashCode()));
            stringBuilder.append(" cost=").append(l).append("ms");
            Logger.logT(stringBuilder);
        }
    }

    @Override
    public final String getCompName() {
        if (this.dsObj instanceof JRObjectResult) {
            return ((JRObjectResult)this.dsObj).getTemplate().getInstName();
        }
        return this.dsObj.getClass().getSimpleName() + "@" + Integer.toHexString(this.dsObj.hashCode());
    }

    @Override
    public final String getCompType() {
        if (this.dsObj instanceof JRObjectResult) {
            return Integer.toString(((JRObjectResult)this.dsObj).getTemplate().getObjectType());
        }
        return "-1";
    }

    @Override
    public final String getDSID() {
        if (this.dsObj instanceof JRObjectResult) {
            return this.ctx.getDSObjectID((JRObjectResult)this.dsObj);
        }
        return "unknown-dsid";
    }

    @Override
    public final String getCssName() {
        if (this.dsObj instanceof JRObjectResult) {
            return this.ctx.getCssName((JRObjectResult)this.dsObj);
        }
        return "unknown-class";
    }

    @Override
    public final String getStyle() {
        if (this.dsObj instanceof JRObjectResult) {
            return ExportHelper.getStyle((JRObjectResult)this.dsObj, this.ctx);
        }
        return "";
    }

    public final int unit2pixel(int n) {
        return ExportHelper.unit2pixel(n, this.ctx.getResolution());
    }

    public final int getX() {
        if (!(this.dsObj instanceof JRVisiableResult)) {
            return Integer.MIN_VALUE;
        }
        return ExportHelper.getX((JRVisiableResult)this.dsObj, this.ctx);
    }

    public final int getY() {
        if (!(this.dsObj instanceof JRVisiableResult)) {
            return Integer.MIN_VALUE;
        }
        return ExportHelper.getY((JRVisiableResult)this.dsObj, this.ctx);
    }

    public final int getW() {
        if (!(this.dsObj instanceof JRVisiableResult)) {
            return Integer.MIN_VALUE;
        }
        return ExportHelper.getW((JRVisiableResult)this.dsObj, this.ctx);
    }

    public final int getH() {
        if (!(this.dsObj instanceof JRVisiableResult)) {
            return Integer.MIN_VALUE;
        }
        return ExportHelper.getH((JRVisiableResult)this.dsObj, this.ctx);
    }

    @Override
    public void render(RenderBuffer renderBuffer) throws WRException {
    }

    public void initialize(String string) {
        try {
            this.template = TemplateAssembler.load(Tools.getResource((String)string));
            this.viewLogic = TemplateAssembler.createViewLogic(this.template);
        }
        catch (IOException iOException) {
            throw new WRException(65537, (Throwable)iOException, new String[0]);
        }
        catch (ParseException parseException) {
            throw new WRException(589826, (Throwable)parseException, new String[0]);
        }
    }

    public void setProperty(String string, String string2) {
        ViewLogic viewLogic = this.viewLogic.getViewLogic(string);
        if (viewLogic != null) {
            viewLogic.setValue(string2);
        }
    }

    public void setVisible(String string, boolean bl) {
        ViewLogic viewLogic = this.viewLogic.getViewLogic(string);
        viewLogic.setVisible(bl);
    }

    public void setIterations(String string, String string2, List list, boolean bl) {
        ViewLogic viewLogic = this.viewLogic.getViewLogic(string);
        if (viewLogic != null && !bl) {
            viewLogic.setIterations(list.size());
            viewLogic.putContextValue(string2, list);
        }
    }

    public String toHTMLString() {
        StringWriter stringWriter = null;
        try {
            stringWriter = new StringWriter();
            TemplateAssembler.write(stringWriter, this.template, this.viewLogic);
        }
        catch (IOException iOException) {
            throw new WRException(65537, (Throwable)iOException, new String[0]);
        }
        finally {
            try {
                stringWriter.close();
            }
            catch (Exception exception) {}
        }
        return stringWriter.toString();
    }

    @Override
    public int getZIndex() {
        return this.geom.getZ();
    }

    @Override
    public void setZIndex(int n) {
        this.geom.setZ(n);
    }

    protected String buildFieldTextStyle(DSField dSField) {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        Propertiable propertiable = null;
        stringBuffer.append("background: transparent; border: 0px; ");
        propertiable = dSField.getPropertyByName("Foreground");
        if (propertiable != null) {
            Color color = (Color)propertiable.getObject();
            stringBuffer.append("color: " + ExportHelper.formatColor(color == null ? 0 : color.getRGB()) + "; ");
        }
        boolean bl = false;
        boolean bl2 = false;
        propertiable = dSField.getPropertyByName("Bold");
        if (propertiable != null && (bl2 = ((Boolean)propertiable.getObject()).booleanValue())) {
            stringBuffer.append("font-weight: bold; ");
        }
        if ((propertiable = dSField.getPropertyByName("Italic")) != null && (bl = ((Boolean)propertiable.getObject()).booleanValue())) {
            stringBuffer.append("font-style: italic; ");
        }
        if ((propertiable = dSField.getPropertyByName("FontFace")) != null) {
            String string = (String)propertiable.getObject();
            stringBuffer.append("font-family: " + ExportHelper.getFontName(string, bl2, bl) + "; ");
        }
        if ((propertiable = dSField.getPropertyByName("FontSize")) != null) {
            int n3 = ((Number)propertiable.getObject()).intValue();
            String string = Integer.toString(ExportHelper.unit2pixel(n3, this.ctx.getResolution())) + "px";
            stringBuffer.append("font-size: " + string + ";");
        }
        if ((propertiable = dSField.getPropertyByName("HorizontalAlignment")) != null && (n2 = ((Number)propertiable.getObject()).intValue()) >= 0 && n2 < ExportHelper.HALIGNMENTS().length) {
            stringBuffer.append("text-align: " + ExportHelper.HALIGNMENTS()[n2] + ";");
        }
        if ((propertiable = dSField.getPropertyByName("VerticalAlignment")) != null && (n = ((Number)propertiable.getObject()).intValue()) >= 0 && n < ExportHelper.VALIGNMENTS().length) {
            stringBuffer.append("vertical-align: " + ExportHelper.VALIGNMENTS()[n] + ";");
        }
        boolean bl3 = false;
        boolean bl4 = false;
        propertiable = dSField.getPropertyByName("StrikeOut");
        if (propertiable != null) {
            bl3 = (Boolean)propertiable.getObject();
        }
        if ((propertiable = dSField.getPropertyByName("Underline")) != null) {
            bl4 = (Boolean)propertiable.getObject();
        }
        if (bl3 || bl4) {
            stringBuffer.append("\n\ttext-decoration:").append(bl3 ? " line-through" : "").append(bl4 ? " underline" : "").append(';');
        } else {
            stringBuffer.append("\n\ttext-decoration:none;");
        }
        return stringBuffer.toString();
    }

    protected String getColor(JRVisiableResult jRVisiableResult, String string) {
        String string2 = "transparent";
        String string3 = jRVisiableResult.getPropertyByName(string).toString();
        String string4 = string3.toLowerCase().equals(string2) ? string2 : string3.substring(2);
        return string4;
    }

    protected Parameter getParameter(ExportRuntimeInfo exportRuntimeInfo, DSField dSField) throws Exception {
        JetRptRefParameterField jetRptRefParameterField = (JetRptRefParameterField)dSField.getTemplate();
        String string = jetRptRefParameterField.param.getDispName();
        Parameter parameter = exportRuntimeInfo.getParameter(string);
        if (parameter == null) {
            DSParameterForm dSParameterForm = (DSParameterForm)dSField.getParent();
            HashMap hashMap = exportRuntimeInfo.getParamDesc(((JetRptObject)dSParameterForm.getTemplate()).getInstName());
            ParamDesc paramDesc = (ParamDesc)hashMap.get(string);
            parameter = exportRuntimeInfo.getParameter(paramDesc);
        }
        return parameter;
    }

    private static class GeometricImpl
    implements Component.Geometric {
        private int x;
        private int y;
        private int z;
        private int SEDU;
        private int I;

        private GeometricImpl() {
        }

        @Override
        public int getH() {
            return this.I;
        }

        @Override
        public int getW() {
            return this.SEDU;
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public int getZ() {
            return this.z;
        }

        @Override
        public void setH(int n) {
            this.I = n;
        }

        @Override
        public void setW(int n) {
            this.SEDU = n;
        }

        @Override
        public void setX(int n) {
            this.x = n;
        }

        @Override
        public void setY(int n) {
            this.y = n;
        }

        @Override
        public void setZ(int n) {
            this.z = n;
        }
    }
}

