/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.modules.pagereport.service.exporter.components;

import java.util.ArrayList;
import java.util.List;

public final class Matrix {
    int m;
    int n;
    Object[][] matrix;

    public Matrix(int n, int n2) {
        this.m = n;
        this.n = n2;
        this.matrix = new Object[n][n2];
    }

    public Object getElement(int n, int n2) {
        return this.matrix[n][n2];
    }

    public void setElement(int n, int n2, Object object) {
        this.matrix[n][n2] = object;
    }

    public List getRowElements(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.n);
        for (int i = 0; i < this.n; ++i) {
            arrayList.add(this.getElement(n, i));
        }
        return arrayList;
    }

    public List getColCells(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.m);
        for (int i = 0; i < this.m; ++i) {
            arrayList.add(this.getElement(i, n));
        }
        return arrayList;
    }

    public void rotate() {
        Object[][] objectArray = new Object[this.n][this.m];
        int n = this.m;
        for (int i = 0; i < n; ++i) {
            int n2 = this.n;
            for (int j = 0; j < n2; ++j) {
                objectArray[j][i] = this.matrix[i][j];
            }
        }
        this.matrix = objectArray;
        this.m = objectArray.length;
        this.n = objectArray[0].length;
    }

    public void mergeRow(int n) {
        int n2 = n + 1;
        if (n2 >= this.m) {
            return;
        }
        for (int i = 0; i < this.n; ++i) {
            if (this.matrix[n2][i] == null) {
                this.matrix[n2][i] = this.matrix[n][i];
                this.matrix[n][i] = null;
                continue;
            }
            if (this.matrix[n][i] == null) continue;
        }
    }

    public void mergeCol(int n) {
        int n2 = n + 1;
        if (n2 >= this.n) {
            return;
        }
        for (int i = 0; i < this.m; ++i) {
            if (this.matrix[i][n2] == null) {
                this.matrix[i][n2] = this.matrix[i][n];
                this.matrix[i][n] = null;
                continue;
            }
            if (this.matrix[i][n] == null) continue;
        }
    }

    public void compress() {
        int n;
        if (this.m == 0) {
            return;
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(this.m);
        for (n = 0; n < this.m; ++n) {
            if (this.SEDU(n)) continue;
            arrayList.add(this.matrix[n]);
        }
        this.m = arrayList.size();
        if (this.m == 0) {
            return;
        }
        this.matrix = new Object[this.m][this.n];
        for (n = 0; n < this.m; ++n) {
            this.matrix[n] = (Object[])arrayList.get(n);
        }
        n = this.n;
        for (int i = 0; i < this.n; ++i) {
            if (!this.add(i)) continue;
            --n;
        }
        Object[][] objectArray = new Object[this.m][n];
        for (int i = 0; i < this.m; ++i) {
            n = 0;
            int n2 = this.matrix[0].length;
            for (int j = 0; j < n2; ++j) {
                if (this.add(j)) continue;
                objectArray[i][n] = this.matrix[i][j];
                ++n;
            }
        }
        this.matrix = objectArray;
        this.n = objectArray[0].length;
    }

    private boolean SEDU(int n) {
        boolean bl = true;
        for (int i = 0; i < this.n; ++i) {
            if (this.matrix[n][i] == null) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean add(int n) {
        boolean bl = true;
        for (int i = 0; i < this.m; ++i) {
            if (this.matrix[i][n] == null) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (j != 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.matrix[i][j]);
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

