/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.modules.pagereport.service.exporter.components;

import com.jinfonet.web.WRException;
import com.jinfonet.web.modules.pagereport.service.exporter.ExportHelper;
import com.jinfonet.web.modules.pagereport.service.exporter.RenderBuffer;
import com.jinfonet.web.modules.pagereport.service.exporter.RuntimeInfo;
import com.jinfonet.web.modules.pagereport.service.exporter.components.CellWrapper;
import com.jinfonet.web.modules.pagereport.service.exporter.components.ComponentBase;
import com.jinfonet.web.modules.pagereport.service.exporter.components.HorizontalTable;
import com.jinfonet.web.modules.pagereport.service.exporter.components.Matrix;
import com.jinfonet.web.modules.pagereport.service.exporter.components.MxN;
import com.jinfonet.web.modules.pagereport.service.exporter.components.TableRow;
import java.util.List;
import java.util.Vector;
import jet.datastream.DSTableCell;
import jet.datastream.DSTableObject;
import jet.datastream.DSTableRow;
import jet.datastream.DSTemplatible;
import jet.datastream.JRObjectResult;
import jet.report.JRObjectTemplate;
import jet.report.table.JetRptNewTable;
import jet.util.Propertiable;

public class Table
extends ComponentBase {
    public Table(JRObjectResult jRObjectResult, RuntimeInfo runtimeInfo) {
        super(jRObjectResult, runtimeInfo);
    }

    @Override
    public void render(RenderBuffer renderBuffer) throws WRException {
        super.beforeRender();
        try {
            String string;
            this.initialize(ExportHelper.getTemplatePath(Table.class.getName()));
            DSTableObject dSTableObject = (DSTableObject)this.dsObj;
            DSTemplatible dSTemplatible = dSTableObject.getTemplate();
            int n = this.geom.getX();
            int n2 = this.geom.getY();
            int n3 = this.geom.getW();
            int n4 = this.geom.getH();
            String string2 = this.ctx.getDSId((JRObjectResult)dSTableObject);
            String string3 = "tableobject";
            String string4 = dSTemplatible.getInstName();
            String string5 = this.ctx.getCssName((JRObjectResult)dSTableObject);
            RenderBuffer renderBuffer2 = new RenderBuffer(1024);
            renderBuffer2.append(ExportHelper.getStyle((JRObjectResult)dSTableObject, this.ctx));
            renderBuffer2.appendC("overflow", "hidden");
            renderBuffer2.appendC("z-index", this.getZIndex()).appendC("left", n + "px").appendC("top", n2 + "px");
            this.setProperty("instName", string4);
            this.setProperty("dsId", string2);
            this.setProperty("cssClass", string5);
            this.setProperty("objType", string3);
            this.setProperty("compType", String.valueOf(dSTableObject.getObjectType()));
            this.setProperty("cssStyle", ExportHelper.wrapKeyValuePair("style", renderBuffer2.toString(), "="));
            this.setProperty("blcolumns", this.ctx.getDCBLNames((JRObjectResult)dSTableObject, string4));
            if (this.ctx.isAdHoc() && !this.ctx.isRsd()) {
                string = this.ctx.buildConvertInfo((JRObjectResult)dSTableObject, dSTemplatible.getInstName());
                if (string != null) {
                    this.setProperty("convert", string);
                } else {
                    this.setProperty("convert", "");
                }
                this.setProperty("isRSZ", "TRUE");
                this.setProperty("isRSZX", "TRUE");
                this.setProperty("isRSZY", "TRUE");
                this.setProperty("isRSZB", "TRUE");
                this.setProperty("level", ExportHelper.prefixNaming("componentDiv"));
                if (((JRObjectTemplate)dSTableObject.getTemplate()).position.intValue() == 2) {
                    this.setProperty("isCanMove", "TRUE");
                } else {
                    this.setProperty("isCanMove", "FALSE");
                }
                this.setProperty("isHarizontal", String.valueOf(dSTableObject.isHorizontal()));
            }
            string = "";
            Propertiable propertiable = dSTableObject.getPropertyByName("StyleFile");
            string = propertiable != null ? (String)propertiable.getObject() : ((propertiable = dSTableObject.getPropertyByName("StyleName")) == null ? "" : (String)propertiable.getObject());
            this.setProperty("styleName", ExportHelper.deleteStyleBracket(string));
            int n5 = this.unit2pixel(((Number)dSTableObject.getPropertyByName("border-top-width").getObject()).intValue());
            int n6 = this.unit2pixel(((Number)dSTableObject.getPropertyByName("border-left-width").getObject()).intValue());
            int n7 = this.unit2pixel(((Number)dSTableObject.getPropertyByName("border-bottom-width").getObject()).intValue());
            int n8 = this.unit2pixel(((Number)dSTableObject.getPropertyByName("border-right-width").getObject()).intValue());
            int n9 = 0;
            if (dSTemplatible instanceof JetRptNewTable) {
                n9 = ((JetRptNewTable)dSTemplatible).getInLineHeaders().size();
            }
            this.ctx.put("inlineSize", n9);
            boolean bl = (Boolean)dSTemplatible.getPropertyByName("AutoExpands").getObject();
            this.ctx.put("autoExpand", bl);
            if (dSTableObject.isHorizontal()) {
                new HorizontalTable((JRObjectResult)dSTableObject, this.ctx).render(renderBuffer);
                return;
            }
            Matrix matrix = Table.createCellsMatrix(dSTableObject);
            Table.mergeCellsMatrix(matrix);
            int n10 = matrix.m;
            if (n10 > 0) {
                RenderBuffer renderBuffer3 = new RenderBuffer(256);
                renderBuffer3.appendR(0, 0, n3 - n6 - n8, n4 - n5 - n7, new String[0]);
                renderBuffer3.appendC("overflow", "hidden");
                this.setProperty("tabStyle", renderBuffer3.toString());
                RenderBuffer renderBuffer4 = new RenderBuffer();
                this.ctx.put("isHorizontal", false);
                for (int i = 0; i < n10; ++i) {
                    List list = matrix.getRowElements(i);
                    this.ctx.put("DSTableCellWrappers", list);
                    new TableRow(null, this.ctx).render(renderBuffer4);
                }
                this.setProperty("tableContent", renderBuffer4.toString());
            } else {
                this.setProperty("tableContent", "");
            }
            renderBuffer.append(this.toHTMLString());
        }
        catch (Exception exception) {
            throw new WRException(589825, (Throwable)exception, this.getClass().getSimpleName() + "@" + ((JRObjectResult)this.dsObj).getTemplate().getInstName());
        }
        finally {
            super.afterRender();
        }
    }

    public static MxN getMxN(DSTableObject dSTableObject) {
        MxN mxN = new MxN();
        Vector vector = dSTableObject.getChildren();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector.get(i);
            if (!(jRObjectResult instanceof DSTableRow)) continue;
            ++mxN.m;
            int n2 = 0;
            Vector vector2 = ((DSTableRow)jRObjectResult).getChildren();
            int n3 = 0;
            int n4 = vector2.size();
            for (int j = 0; j < n4; ++j) {
                DSTableCell dSTableCell = (DSTableCell)vector2.get(j);
                n3 += dSTableCell.getColSpan();
            }
            n2 = n3;
            mxN.n = n2 > mxN.n ? n2 : mxN.n;
        }
        return mxN;
    }

    public static Matrix createCellsMatrix(DSTableObject dSTableObject) {
        MxN mxN = Table.getMxN(dSTableObject);
        Matrix matrix = new Matrix(mxN.m, mxN.n);
        Vector vector = dSTableObject.getChildren();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector.get(i);
            if (!(jRObjectResult instanceof DSTableRow)) continue;
            DSTableRow dSTableRow = (DSTableRow)jRObjectResult;
            Vector vector2 = dSTableRow.getChildren();
            int n2 = vector2.size();
            for (int j = 0; j < n2; ++j) {
                DSTableCell dSTableCell = (DSTableCell)vector2.get(j);
                CellWrapper cellWrapper = new CellWrapper(dSTableCell);
                if (cellWrapper.rInvisible && cellWrapper.rowSpan == 1 || cellWrapper.cInvisible && cellWrapper.colSpan == 1) continue;
                matrix.setElement(dSTableCell.getGridY(), dSTableCell.getGridX(), cellWrapper);
            }
        }
        return matrix;
    }

    public static Matrix mergeCellsMatrix(Matrix matrix) {
        List list;
        int n;
        int n2 = matrix.m;
        for (n = 0; n < n2; ++n) {
            list = matrix.getRowElements(n);
            if (!Table.Z(list)) continue;
            matrix.mergeRow(n);
        }
        n2 = matrix.n;
        for (n = 0; n < n2; ++n) {
            list = matrix.getColCells(n);
            if (!Table.append(list)) continue;
            matrix.mergeCol(n);
        }
        matrix.compress();
        n2 = matrix.m;
        for (n = 0; n < n2; ++n) {
            int n3 = matrix.n;
            for (int i = 0; i < n3; ++i) {
                CellWrapper cellWrapper = (CellWrapper)matrix.getElement(n, i);
                if (cellWrapper == null) continue;
                if (cellWrapper.rowSpan > 1) {
                    Table.I(matrix, cellWrapper, n);
                }
                if (cellWrapper.colSpan <= 1) continue;
                Table.SEDU(matrix, cellWrapper, i);
            }
        }
        return matrix;
    }

    private static void I(Matrix matrix, CellWrapper cellWrapper, int n) {
        int n2 = 1;
        int n3 = matrix.m;
        for (int i = n + 1; i < n3 && cellWrapper.rowRange > Table.afterRender(matrix.getRowElements(i)); ++i) {
            ++n2;
        }
        cellWrapper.rowSpan = n2;
    }

    private static void SEDU(Matrix matrix, CellWrapper cellWrapper, int n) {
        int n2 = 1;
        int n3 = matrix.n;
        for (int i = n + 1; i < n3; ++i) {
            if (cellWrapper.colRange <= Table.appendC(matrix.getColCells(i))) continue;
            ++n2;
        }
        cellWrapper.colSpan = n2;
    }

    private static boolean Z(List list) {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            CellWrapper cellWrapper = (CellWrapper)list.get(i);
            if (cellWrapper == null || cellWrapper.rInvisible || cellWrapper.rInvisible) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private static int afterRender(List list) {
        int n = 0;
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            CellWrapper cellWrapper = (CellWrapper)list.get(i);
            if (cellWrapper == null) continue;
            int n3 = cellWrapper.getGridY();
            n = n3 > n ? n3 : n;
        }
        return n;
    }

    private static boolean append(List list) {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            CellWrapper cellWrapper = (CellWrapper)list.get(i);
            if (cellWrapper == null || cellWrapper.cInvisible || cellWrapper.cInvisible) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private static int appendC(List list) {
        int n = 0;
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            CellWrapper cellWrapper = (CellWrapper)list.get(i);
            if (cellWrapper == null) continue;
            int n3 = cellWrapper.getGridX();
            n = n3 > n ? n3 : n;
        }
        return n;
    }

    @Override
    public String getObjcType() {
        return "tableobject";
    }
}

