/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.modules.pagereport.service.exporter.components;

import com.jinfonet.web.WRException;
import com.jinfonet.web.modules.pagereport.service.exporter.ExportHelper;
import com.jinfonet.web.modules.pagereport.service.exporter.RenderBuffer;
import com.jinfonet.web.modules.pagereport.service.exporter.RuntimeInfo;
import com.jinfonet.web.modules.pagereport.service.exporter.components.ComponentBase;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Vector;
import jet.JDException;
import jet.datastream.DSColumn;
import jet.datastream.DSTable;
import jet.datastream.JRObjectResult;

public class VOTable
extends ComponentBase {
    private String I;

    public VOTable(JRObjectResult jRObjectResult, RuntimeInfo runtimeInfo) {
        super(jRObjectResult, runtimeInfo);
    }

    @Override
    public void render(RenderBuffer renderBuffer) throws WRException {
        super.beforeRender();
        try {
            this.initialize(ExportHelper.getTemplatePath(VOTable.class.getName()));
            DSTable dSTable = (DSTable)this.dsObj;
            if (dSTable == null) {
                return;
            }
            RenderBuffer renderBuffer2 = new RenderBuffer(1024);
            Rectangle rectangle = this.I(dSTable);
            Vector vector = dSTable.getChildren();
            if (this.I != null) {
                renderBuffer2.append(this.I);
            }
            if (vector != null) {
                renderBuffer2.append(this.afterRender(vector, rectangle));
            }
            if (rectangle != null && dSTable != null && dSTable.getTemplate().getShowBorder((JRObjectResult)dSTable)) {
                renderBuffer2.append(this.drawRectangle(rectangle, Color.black, null));
            }
            this.setProperty("tableBody", renderBuffer2.toString());
            renderBuffer.append(this.toHTMLString());
        }
        catch (Exception exception) {
            throw new WRException(589825, (Throwable)exception, this.getClass().getSimpleName() + "@" + ((JRObjectResult)this.dsObj).getTemplate().getInstName());
        }
        finally {
            super.afterRender();
        }
    }

    private Rectangle I(DSTable dSTable) throws JDException {
        Rectangle rectangle = this.SEDU(dSTable);
        Color color = dSTable.getTemplate().getBackground((JRObjectResult)dSTable);
        if (color != null) {
            this.I = this.drawRectangle(rectangle, null, color);
        }
        return rectangle;
    }

    private Rectangle SEDU(DSTable dSTable) throws JDException {
        int n = this.unit2pixel(dSTable.getX());
        int n2 = this.unit2pixel(dSTable.getY());
        int n3 = this.unit2pixel(dSTable.getWidth());
        int n4 = this.unit2pixel(dSTable.getHeight());
        if (!this.ctx.isIE() && dSTable.getTemplate().getShowBorder((JRObjectResult)dSTable)) {
            int n5 = this.ctx.getZoom();
            n3 -= 2 * (n5 / 100 == 0 ? 1 : n5 / 100);
            n4 -= 2 * (n5 / 100 == 0 ? 1 : n5 / 100);
        }
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        return rectangle;
    }

    private String afterRender(Vector vector, Rectangle rectangle) throws JDException {
        DSColumn dSColumn = null;
        Rectangle rectangle2 = null;
        Color color = null;
        int n = rectangle.y;
        int n2 = rectangle.height;
        RenderBuffer renderBuffer = new RenderBuffer(1024);
        for (int i = 0; i < vector.size(); ++i) {
            dSColumn = (DSColumn)vector.elementAt(i);
            int n3 = this.unit2pixel(dSColumn.getX());
            int n4 = this.unit2pixel(dSColumn.getWidth());
            n4 = dSColumn.getTemplate().getShowBorder((JRObjectResult)dSColumn) ? (!this.ctx.isIE() ? this.unit2pixel(dSColumn.getWidth() - dSColumn.getTemplate().getBorderWidth((JRObjectResult)dSColumn)) * (this.ctx.getZoom() / 100 == 0 ? 1 : this.ctx.getZoom() / 100) : this.unit2pixel(dSColumn.getWidth())) : this.unit2pixel(dSColumn.getWidth());
            color = dSColumn.getTemplate().getBackground((JRObjectResult)dSColumn);
            rectangle2 = new Rectangle(n3, n, n4, n2);
            if (color != null) {
                renderBuffer.append(this.drawRectangle(rectangle2, null, color));
            }
            if (!dSColumn.getTemplate().getShowBorder((JRObjectResult)dSColumn)) continue;
            renderBuffer.append(this.append(rectangle2, Color.black, null, 3));
        }
        return renderBuffer.toString();
    }

    protected String drawRectangle(Rectangle rectangle, Color color, Color color2) throws JDException {
        return this.append(rectangle, color, color2, -1);
    }

    private String append(Rectangle rectangle, Color color, Color color2, int n) throws JDException {
        StringBuffer stringBuffer = new StringBuffer(512);
        if (rectangle.width < 0) {
            rectangle.x += rectangle.width;
            rectangle.width *= -1;
        }
        if (rectangle.height < 0) {
            rectangle.y += rectangle.height;
            rectangle.height *= -1;
        }
        stringBuffer.append("<div style=\"position: absolute; margin: 0px; padding: 0px; font-size: 0px; left: ").append(rectangle.x).append("px; top: ").append(rectangle.y).append("px; width: ").append(rectangle.width).append("px; height: ").append(rectangle.height).append("px;");
        if (color2 != null) {
            stringBuffer.append(" background-color:").append(ExportHelper.getColor(color2)).append(';');
        }
        int n2 = this.ctx.getZoom();
        if (color != null) {
            int n3;
            int n4 = n3 = n2 / 100 == 0 ? 1 : n2 / 100;
            if (n == 0) {
                stringBuffer.append(" border-top: ").append(n3).append("px solid ").append(ExportHelper.getColor(color)).append(';');
            } else if (n == 1) {
                stringBuffer.append(" border-left: ").append(n3).append("px solid ").append(ExportHelper.getColor(color)).append(';');
            } else if (n == 3) {
                stringBuffer.append(" border-right: ").append(n3).append("px solid ").append(ExportHelper.getColor(color)).append(';');
            } else if (n == 2) {
                stringBuffer.append(" border-bottom: ").append(n3).append("px solid ").append(ExportHelper.getColor(color)).append(';');
            } else {
                stringBuffer.append(" border: ").append(n3).append("px solid ").append(ExportHelper.getColor(color)).append(';');
            }
        }
        stringBuffer.append("\"></div>");
        return stringBuffer.toString();
    }

    @Override
    public String getObjcType() {
        return null;
    }
}

