/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.modules.webreport.service;

import com.jinfonet.web.ActionParameterImpl;
import com.jinfonet.web.ActionResult;
import com.jinfonet.web.WRException;
import com.jinfonet.web.beans.ExternalEventResult;
import com.jinfonet.web.modules.component.service.AbStructuredEngine;
import com.jinfonet.web.modules.component.service.WebReport;
import com.jinfonet.web.modules.component.service.action.RealtimeChartAction;
import com.jinfonet.web.service.Logger;
import com.jinfonet.web.service.ServiceContext;
import com.jinfonet.web.vfs.VFile;
import java.util.Map;
import jet.report.JetRptObject;
import jet.rptservice.api.IShareInfoProvider;
import jet.rptservice.structurengine.api.StructureJetEngineFactory;
import jet.server.api.exception.ActionEventException;
import jet.server.api.ria.ActionEvent;
import jet.server.api.ria.RealtimeChartEvent;

public class StudioEngine
extends AbStructuredEngine {
    public StudioEngine(WebReport webReport) {
        super(webReport);
        if (Logger.T) {
            StringBuilder stringBuilder = new StringBuilder("A-0-StudioEngine");
            stringBuilder.append(" engine=").append(this.getID());
            stringBuilder.append(" reports_rkey=").append(webReport.getReportRKey());
            stringBuilder.append(" catalog_rkey=").append(webReport.getCatalogRKey());
            stringBuilder.append(" catalog_regs=").append(webReport.getCatalogID());
            Logger.logT(stringBuilder.toString());
        }
    }

    @Override
    public void init(Map map) throws WRException {
    }

    public void initLinkedJetEngine(JetRptObject jetRptObject) throws WRException {
        try {
            this.jE = StructureJetEngineFactory.createLinkedStructureJetEngine(this.wrpt.getRptSetDirectInfo(), this.wrpt.getCatAttrs(), this.wrpt.getJetRptSet().getInstName(), this.wrpt.getCurrentReportSheet(), this, this.DS, this.wrpt.getCatalogID(), jetRptObject);
            this.jE.init();
        }
        catch (Exception exception) {
            throw new WRException(327681, (Throwable)exception, new String[0]);
        }
    }

    @Override
    public void closeEngine() {
        if (this.jE != null) {
            this.jE.close();
        }
        this.finishTask();
        super.closeEngine();
    }

    @Override
    public IShareInfoProvider getShareInfoProvider() {
        return new IShareInfoProvider(){

            public String getSessionId() {
                return StudioEngine.this.pId;
            }

            public String getReportId() {
                return StudioEngine.this.rptsetId;
            }

            public boolean forbidShareData(String string, String string2, String string3) {
                return false;
            }
        };
    }

    @Override
    public void actionPerformed(ActionEvent ... actionEventArray) throws ActionEventException {
        if (actionEventArray != null && actionEventArray.length > 0) {
            for (ActionEvent actionEvent : actionEventArray) {
                if (!(actionEvent instanceof RealtimeChartEvent)) continue;
                RealtimeChartAction realtimeChartAction = new RealtimeChartAction(this);
                ActionParameterImpl actionParameterImpl = new ActionParameterImpl("webreport", "RealtimeChartAction");
                actionParameterImpl.setParameter("event", actionEvent);
                ActionResult actionResult = null;
                try {
                    this.critical.enter();
                    long l = System.currentTimeMillis();
                    Logger.logT("B-0-RealtimeChartAction.actionPerformed [engine = " + this.getID() + ", event is " + actionEvent + "] from server interactive task trigger.");
                    actionResult = realtimeChartAction.doAction(actionParameterImpl);
                    long l2 = System.currentTimeMillis() - l;
                    Logger.logT("A-0-RealtimeChartAction.actionPerformed [engine = " + this.getID() + ", event is = " + actionEvent + "] from server interactive task trigger cost = " + l2);
                }
                catch (Throwable throwable) {
                    throw new ActionEventException(throwable.getMessage(), new Throwable[]{throwable});
                }
                finally {
                    this.critical.exit();
                }
                if (actionResult == null || !actionResult.isOK()) continue;
                super.addActionStack(actionResult);
                this.registerTrigger(super.getpId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTrigger(String string) {
        Class<StudioEngine> clazz = StudioEngine.class;
        synchronized (StudioEngine.class) {
            ServiceContext serviceContext = ServiceContext.getInstance();
            VFile vFile = serviceContext.getVFS().getProc().getFile(string);
            ExternalEventResult externalEventResult = (ExternalEventResult)vFile.getAttribute("exts", new Object[0]);
            if (externalEventResult == null) {
                externalEventResult = new ExternalEventResult();
                vFile.setAttribute("exts", (Object)externalEventResult);
            }
            externalEventResult.addAPIKey(this.appId, this.productId, this.rptsetId, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

