/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.service.action;

import com.jinfonet.web.Action;
import com.jinfonet.web.ActionEnv;
import com.jinfonet.web.ActionParameter;
import com.jinfonet.web.ActionResult;
import com.jinfonet.web.ActionResultImpl;
import com.jinfonet.web.Context;
import com.jinfonet.web.WRException;
import com.jinfonet.web.beans.ReportInfoImpl;
import com.jinfonet.web.modules.component.service.AbStructuredEngine;
import com.jinfonet.web.modules.component.service.WebReport;
import com.jinfonet.web.modules.component.service.util.NLSKit;
import com.jinfonet.web.service.ActionEnvImpl;
import com.jinfonet.web.service.Logger;
import com.jinfonet.web.service.ServiceContext;
import com.jinfonet.web.vfs.Process;
import com.jinfonet.web.vfs.VFile;
import com.jinfonet.web.vfs.VFileSystem;
import java.util.Locale;

public class AbstractAction0
implements Action {
    protected ActionEnv E;
    protected ServiceContext ctx;
    protected Locale locale;
    protected VFileSystem VFS;
    protected Process proc;
    private String Z;
    private long access = 0L;
    private String afterAction;

    @Override
    public void init(ActionEnv actionEnv) {
        this.E = actionEnv;
        this.locale = actionEnv.getUserInfo().getLocale();
        this.ctx = (ServiceContext)actionEnv.getAttribute("ServiceContext");
        this.VFS = (VFileSystem)actionEnv.getAttribute("VFS");
        this.proc = this.E.getProc();
        this.proc.access(this.proc.getLastAccessedTime());
        String string = (String)actionEnv.getActionParameter().removeParamter("j$vm_ticket");
        this.Z = string != null ? string : null;
    }

    @Override
    public ActionEnv getActionEnv() {
        return this.E;
    }

    @Override
    public void beforeAction() {
        Context.setActionEnv(this.E);
        this.access = System.currentTimeMillis();
        if (Logger.T) {
            this.afterAction = this.E.getActionParameter().getRequestParameters().toString();
            StringBuilder stringBuilder = new StringBuilder("B-0-");
            stringBuilder.append(this.E.getActionName());
            stringBuilder.append(" session=").append(this.proc.getAttribute("http-session", new Object[0])).append(":").append(this.proc.getAttribute("ussid", new Object[0]));
            stringBuilder.append(" pid=").append(this.E.getPID());
            stringBuilder.append(" ticket=").append(this.Z);
            stringBuilder.append(" module=").append(this.E.getModuleName());
            stringBuilder.append(" action=").append(this.E.getActionName());
            stringBuilder.append("\n  params=").append(this.afterAction);
            Logger.logT(stringBuilder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doAction() {
        int n;
        block5: {
            ActionResult actionResult = null;
            n = 0;
            try {
                this.checkActionEnv();
                this.beforeAction();
                actionResult = this._doAction(this.E.getActionParameter());
                if (actionResult == null) break block5;
                ((ActionEnvImpl)this.E).setResult(actionResult);
            }
            catch (Throwable throwable) {
                block6: {
                    try {
                        WRException wRException = throwable instanceof WRException ? (WRException)throwable : new WRException(0xFF0001, throwable, new String[0]);
                        Logger.logE(wRException);
                        actionResult = new ActionResultImpl(wRException);
                        if (actionResult == null) break block6;
                        ((ActionEnvImpl)this.E).setResult(actionResult);
                    }
                    catch (Throwable throwable2) {
                        if (actionResult != null) {
                            ((ActionEnvImpl)this.E).setResult(actionResult);
                            n = actionResult.getErrorCode();
                        }
                        this.afterAction(n);
                        throw throwable2;
                    }
                    n = actionResult.getErrorCode();
                }
                this.afterAction(n);
            }
            n = actionResult.getErrorCode();
        }
        this.afterAction(n);
        return n;
    }

    protected void setNlsEnvPath() {
        String string;
        String string2 = this.E.getAppID();
        String string3 = this.E.getProductID();
        String string4 = this.proc.getPath() + "/nlsEnv";
        if (string2 != null) {
            string4 = string4 + "/" + string2;
        }
        if (string3 != null) {
            string4 = string4 + "/" + string3;
        }
        if ((string = this.E.getRptsetID()) != null) {
            string4 = string4 + "/" + string;
        }
        Context.setNlsEnvPath(string4);
    }

    @Override
    public boolean isRestricted() {
        return true;
    }

    @Override
    public String getTicket() {
        return this.Z;
    }

    @Override
    public void afterAction(int n) {
        NLSKit.clearThreadLocal();
        String string = this.E.getPID();
        if (Logger.T) {
            long l = System.currentTimeMillis() - this.access;
            StringBuilder stringBuilder = new StringBuilder("A-");
            stringBuilder.append(Integer.toHexString(n)).append("-");
            stringBuilder.append(this.E.getActionName());
            stringBuilder.append(" session=").append(this.proc.getAttribute("http-session", new Object[0])).append(":").append(this.proc.getAttribute("ussid", new Object[0]));
            stringBuilder.append(" pid=").append(string);
            stringBuilder.append(" ticket=").append(this.Z);
            stringBuilder.append(" module=").append(this.E.getModuleName());
            stringBuilder.append(" action=").append(this.E.getActionName());
            stringBuilder.append(" cost=").append(l);
            stringBuilder.append("\n  params=").append(this.afterAction);
            Logger.logT(stringBuilder.toString());
        }
        Context.destroy();
    }

    protected void checkActionEnv() throws WRException {
        this.E.checkEnv();
        this.setNlsEnvPath();
    }

    protected ActionResult _doAction(ActionParameter actionParameter) {
        return new ActionResultImpl();
    }

    protected void traceResultSize() {
    }

    @Override
    public void run() {
    }

    public ServiceContext getServiceContext() {
        return this.ctx;
    }

    protected AbStructuredEngine getStructuredEngine() {
        VFile vFile = this.E.getRptsetDir();
        if (vFile != null) {
            return (AbStructuredEngine)vFile.getAttribute("engine", new Object[0]);
        }
        return null;
    }

    protected void getCurrentStatus() {
        WebReport webReport = this.getStructuredEngine().getWebReport();
        ReportInfoImpl reportInfoImpl = webReport.getReportInfo();
        reportInfoImpl.setIsDirtyReport(true);
    }
}

