/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.util.css;

import com.jinfonet.web.util.ID;
import com.jinfonet.web.util.Tools;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public final class CssParser {
    private static Pattern SEDU = Pattern.compile("/\\*(.+?)\\*/", 32);
    private static Pattern add = Pattern.compile("\\}");
    private static Pattern addRule = Pattern.compile("\\{");
    private static Pattern append = Pattern.compile("\\,");
    private static Pattern clear = Pattern.compile(";");
    private static Pattern compile = Pattern.compile(":");
    private StringBuilder delete = null;
    private LinkedHashMap endsWith;
    private LinkedHashMap entrySet;
    private LinkedHashMap get;
    private long getKey;

    public CssParser(StringBuilder stringBuilder) {
        this.delete = stringBuilder;
        this.endsWith = new LinkedHashMap();
        this.entrySet = new LinkedHashMap();
        this.get = new LinkedHashMap();
    }

    public CssParser() {
        this(new StringBuilder());
    }

    public CssParser(Reader reader) throws IOException {
        this();
        int n;
        while ((n = reader.read()) != -1) {
            this.delete.append((char)n);
        }
    }

    public void parse() {
        String[] stringArray;
        String string = this.delete.toString();
        string = SEDU.matcher(string).replaceAll("");
        for (String string2 : stringArray = add.split(string)) {
            String[] stringArray2;
            if (!(string2 = string2.trim()).endsWith(";")) {
                string2 = string2 + ";";
            }
            if ((stringArray2 = addRule.split(string2)).length < 2) continue;
            String[] stringArray3 = CssParser.parseSelector(stringArray2[0]);
            LinkedHashMap linkedHashMap = CssParser.parseDeclaration(stringArray2[1]);
            ID iD = Tools.getUniqueID((String[])new String[]{CssParser.toCSSString(linkedHashMap, null).toString()});
            for (String string3 : stringArray3) {
                this.addRule(string3, linkedHashMap, iD);
            }
        }
    }

    public void addRule(String string, LinkedHashMap linkedHashMap, ID ... iDArray) {
        ID iD = null;
        iD = iDArray != null && iDArray.length > 0 ? iDArray[0] : Tools.getUniqueID((String[])new String[]{CssParser.toCSSString(linkedHashMap, null).toString()});
        this.entrySet.put(iD, linkedHashMap);
        ArrayList<String> arrayList = (ArrayList<String>)this.get.get(iD);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            this.get.put(iD, arrayList);
        }
        arrayList.add(string);
        this.endsWith.put(string, iD);
    }

    public static String[] parseSelector(String string) {
        String[] stringArray = append.split(string);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        return stringArray;
    }

    public static LinkedHashMap parseDeclaration(String string) {
        String[] stringArray;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (String string2 : stringArray = clear.split(string)) {
            if ((string2 = string2.trim()).length() == 0) continue;
            String[] stringArray2 = compile.split(string2);
            String string3 = stringArray2[1].trim();
            if (string3.startsWith("0")) {
                string3 = string3.replaceAll("^(0)(px|em|%|in|cm|mm|pc|pt|ex)", "$1");
            }
            linkedHashMap.put(stringArray2[0].trim(), string3);
        }
        return linkedHashMap;
    }

    public Iterator selectors() {
        return this.endsWith.keySet().iterator();
    }

    public LinkedHashMap getDeclaration(String string) {
        ID iD = (ID)this.endsWith.get(string);
        return (LinkedHashMap)this.entrySet.get(iD);
    }

    public void clear() {
        this.delete.delete(0, this.delete.length());
        this.endsWith.clear();
        this.entrySet.clear();
        this.get.clear();
    }

    public String toCSSString() {
        StringBuilder stringBuilder = new StringBuilder();
        Set set = this.get.entrySet();
        for (Map.Entry entry : set) {
            ID iD = (ID)entry.getKey();
            List list = (List)entry.getValue();
            LinkedHashMap linkedHashMap = (LinkedHashMap)this.entrySet.get(iD);
            stringBuilder = CssParser.toCSSString(list, linkedHashMap, stringBuilder);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static StringBuilder toCSSString(LinkedHashMap linkedHashMap, StringBuilder stringBuilder) {
        stringBuilder = stringBuilder == null ? new StringBuilder() : stringBuilder;
        stringBuilder.append("{");
        Set set = linkedHashMap.entrySet();
        for (Map.Entry entry : set) {
            stringBuilder.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append(";");
        }
        stringBuilder.append("}");
        return stringBuilder;
    }

    public static StringBuilder toCSSString(List list, LinkedHashMap linkedHashMap, StringBuilder stringBuilder) {
        stringBuilder = stringBuilder == null ? new StringBuilder() : stringBuilder;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append((String)list.get(i));
            if (i >= n - 1) continue;
            stringBuilder.append(",");
        }
        return CssParser.toCSSString(linkedHashMap, stringBuilder);
    }

    public void setVersion(long l) {
        this.getKey = l;
    }

    public long getVersion() {
        return this.getKey;
    }
}

