/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.vfs;

import com.jinfonet.web.FileHandle;
import com.jinfonet.web.FileService;
import com.jinfonet.web.util.Tools;
import com.jinfonet.web.vfs.StreamFile;
import com.jinfonet.web.vfs.VFileSystem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public final class FileServiceImpl
implements FileService {
    private static FileServiceImpl SEDU;
    private HashMap close;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileServiceImpl getInstance() {
        Class<FileServiceImpl> clazz = FileServiceImpl.class;
        synchronized (FileServiceImpl.class) {
            if (SEDU == null) {
                SEDU = new FileServiceImpl();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return SEDU;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileServiceImpl() {
        Class<FileServiceImpl> clazz = FileServiceImpl.class;
        synchronized (FileServiceImpl.class) {
            if (SEDU != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.close = new HashMap();
            SEDU = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void SEDU() {
        SEDU = null;
    }

    public void destroy() {
        Iterator iterator = this.close.keySet().iterator();
        while (iterator.hasNext()) {
            FileService.Handle handle = (FileService.Handle)iterator.next();
            FileService.FileStream fileStream = (FileService.FileStream)this.close.get(handle);
            try {
                fileStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            iterator.remove();
        }
        this.close = null;
        FileServiceImpl.SEDU();
    }

    public boolean exists(String string) {
        File file = new File(string);
        return file.exists();
    }

    public FileService.Handle open(String string, String string2) throws FileNotFoundException {
        return this.close(string, string2);
    }

    public long length(FileService.Handle handle) throws IOException {
        return this.getFileStream(handle).length();
    }

    public long getpos(FileService.Handle handle) throws IOException {
        return this.getFileStream(handle).getpos();
    }

    public void seek(FileService.Handle handle, long l) throws IOException {
        this.getFileStream(handle).seek(l);
    }

    public byte[] read(FileService.Handle handle, int n) throws IOException {
        return this.getFileStream(handle).read(n);
    }

    public void write(FileService.Handle handle, byte[] byArray) throws IOException {
        this.getFileStream(handle).write(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(FileService.Handle handle) throws IOException {
        FileService.FileStream fileStream = null;
        HashMap hashMap = this.close;
        synchronized (hashMap) {
            if (!this.close.containsKey(handle)) {
                throw new FileNotFoundException(handle.toString());
            }
            fileStream = (FileService.FileStream)this.close.remove(handle);
        }
        fileStream.close();
    }

    public FileService.FileStream openEx(String string, String string2) throws FileNotFoundException {
        return this.getFileStream(this.close(string, string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileService.Handle close(String string, String string2) throws FileNotFoundException {
        Object object;
        Object object2;
        FileHandle fileHandle = null;
        if (string.startsWith("stream://")) {
            object2 = VFileSystem.getFileSystem().getStreamFile(string);
            object = new RStreamFileStreamImpl((StreamFile)object2);
        } else {
            object = new FileStreamImpl(string, string2);
        }
        object2 = this.close;
        synchronized (object2) {
            fileHandle = new FileHandle(Tools.getUniqueID());
            this.close.put(fileHandle, object);
        }
        return fileHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileService.FileStream getFileStream(FileService.Handle handle) throws FileNotFoundException {
        HashMap hashMap = this.close;
        synchronized (hashMap) {
            if (!this.close.containsKey(handle)) {
                throw new FileNotFoundException(handle.toString());
            }
            return (FileService.FileStream)this.close.get(handle);
        }
    }

    private static class RStreamFileStreamImpl
    implements FileService.FileStream {
        private InputStream SEDU;

        public RStreamFileStreamImpl(StreamFile streamFile) throws FileNotFoundException {
            if (streamFile == null) {
                throw new FileNotFoundException();
            }
            this.SEDU = streamFile.in();
        }

        public void close() throws IOException {
            if (this.SEDU != null) {
                this.SEDU.reset();
            }
        }

        public long length() throws IOException {
            throw new UnsupportedOperationException();
        }

        public void seek(long l) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long getpos() throws IOException {
            throw new UnsupportedOperationException();
        }

        public byte[] read(int n) throws IOException {
            byte[] byArray = new byte[n];
            int n2 = this.SEDU.read(byArray);
            if (n2 == -1) {
                byArray = new byte[]{};
            } else if (n2 < n) {
                byArray = Arrays.copyOf(byArray, n2);
            }
            return byArray;
        }

        public void write(byte[] byArray) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class FileStreamImpl
    implements FileService.FileStream {
        private RandomAccessFile SEDU = null;

        public FileStreamImpl(String string, String string2) throws FileNotFoundException {
            if (new File(string).isDirectory()) {
                throw new FileNotFoundException("The file path can not be a folder.");
            }
            this.SEDU = new RandomAccessFile(string, string2);
        }

        public void close() throws IOException {
            this.SEDU.close();
            this.SEDU = null;
        }

        public long length() throws IOException {
            return this.SEDU.length();
        }

        public void seek(long l) throws IOException {
            this.SEDU.seek(l);
        }

        public long getpos() throws IOException {
            return this.SEDU.getFilePointer();
        }

        public byte[] read(int n) throws IOException {
            long l = this.length() - this.getpos();
            byte[] byArray = l > (long)n ? new byte[n] : new byte[(int)l];
            int n2 = this.SEDU.read(byArray);
            return n2 < byArray.length ? Arrays.copyOf(byArray, n2) : byArray;
        }

        public void write(byte[] byArray) throws IOException {
            this.SEDU.write(byArray);
        }
    }
}

