/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.vfs;

import com.jinfonet.web.vfs.MemvFile;
import com.jinfonet.web.vfs.VFile;
import com.jinfonet.web.vfs.VFileFilter;
import com.jinfonet.web.vfs.VFileSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MemvDir
extends MemvFile
implements VFile {
    private Map I;

    public MemvDir(VFile vFile, String string) {
        super(vFile, string);
        this.type = 1;
        this.I = new ConcurrentHashMap();
    }

    @Override
    public boolean addFile(VFile vFile) {
        if (!this.equals(vFile.getParent())) {
            return false;
        }
        this.I.put(vFile.getName(), vFile);
        this.setLastModified(System.currentTimeMillis());
        return true;
    }

    @Override
    public VFile delete(String string) {
        VFile vFile = null;
        if (string.indexOf(47) == -1) {
            vFile = (VFile)this.I.remove(string);
            this.setLastModified(System.currentTimeMillis());
        } else {
            vFile = this.getFile(string);
            if (vFile != null) {
                VFile vFile2 = vFile.getParent();
                vFile = vFile2.delete(vFile.getName());
            }
        }
        return vFile;
    }

    @Override
    public VFile getFile(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("/");
        if (stringArray.length == 1) {
            return (VFile)this.I.get(string);
        }
        MemvDir memvDir = null;
        int n = 0;
        if (stringArray[0].trim().length() == 0) {
            memvDir = VFileSystem.getFileSystem().getRoot();
            n = 1;
        } else {
            memvDir = this;
            n = 0;
        }
        MemvDir memvDir2 = memvDir;
        int n2 = stringArray.length;
        for (int i = n; i < n2 && (memvDir2 = memvDir2.getFile(stringArray[i])) != null; ++i) {
        }
        return memvDir2;
    }

    @Override
    public boolean isDir() {
        return true;
    }

    @Override
    public List listFiles(VFileFilter vFileFilter) {
        ArrayList<VFile> arrayList = new ArrayList<VFile>();
        for (VFile vFile : this.I.values()) {
            if (vFileFilter == null) {
                arrayList.add(vFile);
                continue;
            }
            if (!vFileFilter.accept(vFile)) continue;
            arrayList.add(vFile);
        }
        return arrayList;
    }

    @Override
    public void destroy() {
        Iterator iterator = this.I.values().iterator();
        while (iterator.hasNext()) {
            VFile vFile = (VFile)iterator.next();
            vFile.destroy();
            iterator.remove();
        }
        super.destroy();
    }
}

