/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import guitools.toolkit.AlarmClock;
import guitools.toolkit.Hourmeter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class TextCaret
implements AlarmClock {
    boolean twinkled;
    boolean showing;
    boolean visible = true;
    int x;
    int y;
    int width;
    int height;
    long interval = 700L;
    Component owner;
    Hourmeter hourmeter;

    public TextCaret() {
    }

    public TextCaret(Component component, long l) {
        this.owner = component;
        this.interval = l;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isShowing() {
        return this.showing;
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            if (this.hourmeter != null && this.twinkled) {
                if (bl) {
                    if (this.hourmeter != null && !this.hourmeter.isAlived()) {
                        this.hourmeter = new Hourmeter(this.interval, (AlarmClock)this, true);
                        this.hourmeter.start();
                    }
                } else {
                    this.hourmeter.endLoop();
                }
            }
            if (this.showing && !bl) {
                this.repaint();
            }
            this.visible = bl;
        }
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public void setLocation(int n, int n2) {
        this.setBounds(n, n2, this.width, this.height);
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(int n, int n2) {
        this.setBounds(this.x, this.y, n, n2);
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.x != n || this.y != n2 || this.width != n3 || this.height != n4) {
            if (this.hourmeter != null && this.twinkled) {
                this.hourmeter.endLoop();
            }
            if (this.showing) {
                this.repaint();
            }
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.repaint();
            if (this.hourmeter != null && !this.hourmeter.isAlived() && this.twinkled) {
                this.hourmeter = new Hourmeter(this.interval, (AlarmClock)this, true);
                this.hourmeter.start();
            }
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void start() {
        if (this.hourmeter == null) {
            this.hourmeter = new Hourmeter(this.interval, (AlarmClock)this, true);
            this.hourmeter.start();
            this.twinkled = true;
        }
    }

    public final void stop() {
        if (this.hourmeter != null) {
            this.twinkled = false;
            this.hourmeter.endLoop();
            this.hourmeter = null;
        }
    }

    public final boolean isAlive() {
        return this.hourmeter != null;
    }

    public final void suspend() {
        if (this.hourmeter != null && this.twinkled) {
            this.twinkled = false;
            this.hourmeter.endLoop();
            if (!this.showing) {
                this.repaint();
            }
        }
    }

    public final void resume() {
        if (this.hourmeter != null && !this.hourmeter.isAlived() && !this.twinkled) {
            this.hourmeter = new Hourmeter(this.interval, (AlarmClock)this, true);
            this.hourmeter.start();
            this.twinkled = true;
        }
    }

    public boolean isTwinkled() {
        return this.twinkled;
    }

    public void clock() {
        if (this.twinkled) {
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        graphics.setXORMode(new Color(this.owner.getBackground().getRGB()));
        graphics.setColor(new Color(this.owner.getForeground().getRGB()));
        graphics.fillRect(this.x, this.y, this.width, this.height);
        graphics.setPaintMode();
        this.showing = !this.showing;
    }

    public void repaint() {
        this.repaint(0, 0, this.width, this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(int n, int n2, int n3, int n4) {
        if (this.visible && this.owner.isShowing()) {
            Graphics graphics;
            n = this.x + (n < 0 ? 0 : n);
            n2 = this.y + (n2 < 0 ? 0 : n2);
            int n5 = this.x + this.width;
            int n6 = this.y + this.height;
            n4 += n2;
            n3 = (n3 += n) > n5 ? n5 - n : n3 - n;
            int n7 = n4 = n4 > n6 ? n6 - n2 : n4 - n2;
            if (n3 > 0 && n4 > 0 && (graphics = this.owner.getGraphics()) != null) {
                try {
                    graphics.clipRect(n, n2, n3, n4);
                    this.paint(graphics);
                }
                finally {
                    graphics.dispose();
                }
            }
        }
    }
}

