/*
 * Decompiled with CFR 0.152.
 */
package jet.api;

import com.jinfonet.dataservice.expression.ExpressionFactoryImpl;
import com.jinfonet.security.api.AuthorizeManager;
import com.jinfonet.security.api.SecurityService;
import com.jinfonet.security.api.exception.InvalidResource;
import com.jinfonet.util.JRLog;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.security.acl.Permission;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.api.CatalogAPI;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbColumnLink;
import jet.connect.DbDate;
import jet.connect.DbDecimal;
import jet.connect.DbNumber;
import jet.connect.DbQuery;
import jet.connect.DbTableLink;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.dataengine.api.expression.IExpressionFactory;
import jet.formula.DataTypeDef;
import jet.rptservice.api.IRuntimeQueryInfoProvider;
import jet.rptservice.util.ReportTools;
import jet.universe.JetUDatabase;
import jet.universe.JetUField;
import jet.universe.JetUFileQueryField;
import jet.universe.JetUFmlQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUJdbcSupportInfo;
import jet.universe.JetUParameter;
import jet.universe.JetUProcField;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUTableView;
import jet.universe.JetUUDSField;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.BLContainer;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.CategoryInfo;
import jet.universe.businesslogic.DimensionInfo;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.businesslogic.JUnifiedBusinessView;
import jet.universe.businesslogic.impl.DataElement;
import jet.universe.businesslogic.impl.Measure;
import jet.util.DbValueFormat;
import jet.util.ReportFormat;
import toolkit.db.gui.ConnectionsBroker;
import toolkit.db.gui.JdbcDatabase;

public class APITools {
    static final String[] ops = new String[]{">", ">=", "=", "! =", "<=", "<", "like", "not like", "in", "not in", "between", "not between", "is null", "is not null"};
    public static final int GREAT = 0;
    public static final int GREATEQUAL = 1;
    public static final int EQUAL = 2;
    public static final int NOTEQUAL = 3;
    public static final int LESSEQUAL = 4;
    public static final int LESS = 5;
    public static final int LIKE = 6;
    public static final int NOTLIKE = 7;
    public static final int IN = 8;
    public static final int NOTIN = 9;
    public static final int BETWEEN = 10;
    public static final int NOTBETWEEN = 11;
    public static final int ISNULL = 12;
    public static final int NOTNULL = 13;
    static int[] intops = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
    public static final String PROVIDER = "CONNECTIONINFOPROVIDER";
    public static final String INFOCONTAINER = "CONNECTIONINFOCONTAINER";

    public static BLNode[] getAll(BLContainer bLContainer) {
        BLNode[] bLNodeArray = bLContainer.getBLChildren();
        BLNode[] bLNodeArray2 = new BLNode[bLNodeArray.length];
        if (bLNodeArray.length > 0) {
            BLNode[] bLNodeArray3 = new BLNode[bLNodeArray.length];
            System.arraycopy(bLNodeArray, 0, bLNodeArray3, 0, bLNodeArray.length);
            bLNodeArray2 = bLNodeArray3;
            for (int i = 0; i < bLNodeArray.length; ++i) {
                if (!(bLNodeArray[i] instanceof BLContainer)) continue;
                BLNode[] bLNodeArray4 = APITools.getAll((BLContainer)bLNodeArray[i]);
                bLNodeArray3 = new BLNode[bLNodeArray2.length + bLNodeArray4.length];
                System.arraycopy(bLNodeArray2, 0, bLNodeArray3, 0, bLNodeArray2.length);
                System.arraycopy(bLNodeArray4, 0, bLNodeArray3, bLNodeArray2.length, bLNodeArray4.length);
                bLNodeArray2 = bLNodeArray3;
            }
        }
        return bLNodeArray2;
    }

    public static BLNode[] getAll(CatalogAPI catalogAPI, String string, BLContainer bLContainer) {
        int n = 0;
        BLNode[] bLNodeArray = bLContainer.getBLChildren();
        BLNode[] bLNodeArray2 = new BLNode[bLNodeArray.length];
        for (int i = 0; i < bLNodeArray.length; ++i) {
            if (!catalogAPI.hasPermission(string, bLNodeArray[i])) continue;
            bLNodeArray2[n] = bLNodeArray[i];
            ++n;
        }
        BLNode[] bLNodeArray3 = new BLNode[n];
        System.arraycopy(bLNodeArray2, 0, bLNodeArray3, 0, n);
        BLNode[] bLNodeArray4 = new BLNode[bLNodeArray3.length];
        if (bLNodeArray3 != null && bLNodeArray3.length > 0) {
            BLNode[] bLNodeArray5 = new BLNode[bLNodeArray3.length];
            System.arraycopy(bLNodeArray3, 0, bLNodeArray5, 0, bLNodeArray3.length);
            bLNodeArray4 = bLNodeArray5;
            for (int i = 0; i < bLNodeArray3.length; ++i) {
                if (!(bLNodeArray3[i] instanceof BLContainer)) continue;
                BLNode[] bLNodeArray6 = APITools.getAll((BLContainer)bLNodeArray3[i]);
                bLNodeArray5 = new BLNode[bLNodeArray4.length + bLNodeArray6.length];
                System.arraycopy(bLNodeArray4, 0, bLNodeArray5, 0, bLNodeArray4.length);
                System.arraycopy(bLNodeArray6, 0, bLNodeArray5, bLNodeArray4.length, bLNodeArray6.length);
                bLNodeArray4 = bLNodeArray5;
            }
        }
        return bLNodeArray4;
    }

    public static String[] getBLMeasureHandles(CatalogAPI catalogAPI, String string, String string2) {
        JetObject jetObject = catalogAPI.getObj(string);
        if (jetObject != null && (jetObject instanceof CategoryInfo || jetObject instanceof DimensionInfo)) {
            BLNode[] bLNodeArray = APITools.getAll((BLContainer)jetObject);
            String[] stringArray = new String[bLNodeArray.length];
            int n = 0;
            JetObject jetObject2 = catalogAPI.getObj(string2);
            if (jetObject2 != null && jetObject2 instanceof DataElement) {
                int n2 = APITools.J((DataElement)jetObject2);
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 5 || APITools.J((DataElement)bLNodeArray[i]) != n2) continue;
                    stringArray[n] = ((JetObject)bLNodeArray[i]).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
        }
        return new String[0];
    }

    public static String[] getBLMeasureHandlesByUser(CatalogAPI catalogAPI, String string, String string2, String string3) {
        JetObject jetObject = catalogAPI.getObj(string);
        if (jetObject != null && (jetObject instanceof CategoryInfo || jetObject instanceof DimensionInfo)) {
            BLNode[] bLNodeArray = APITools.getAll(catalogAPI, string3, (BLContainer)jetObject);
            String[] stringArray = new String[bLNodeArray.length];
            int n = 0;
            JetObject jetObject2 = catalogAPI.getObj(string2);
            if (jetObject2 != null && jetObject2 instanceof DataElement) {
                int n2 = APITools.J((DataElement)jetObject2);
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 5 || APITools.J((DataElement)bLNodeArray[i]) != n2) continue;
                    stringArray[n] = ((JetObject)bLNodeArray[i]).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
        }
        return new String[0];
    }

    public static String[] getBLDetailHandles(CatalogAPI catalogAPI, String string, String string2) {
        JetObject jetObject = catalogAPI.getObj(string);
        if (jetObject != null && jetObject instanceof CategoryInfo) {
            BLNode[] bLNodeArray = APITools.getAll((BLContainer)jetObject);
            String[] stringArray = new String[bLNodeArray.length];
            int n = 0;
            JetObject jetObject2 = catalogAPI.getObj(string2);
            if (jetObject2 != null && jetObject2 instanceof DataElement) {
                int n2 = APITools.J((DataElement)jetObject2);
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 7 || APITools.J((DataElement)bLNodeArray[i]) != n2) continue;
                    JetUResourceEntity jetUResourceEntity = APITools.SEDU((DataElement)bLNodeArray[i]);
                    if (jetUResourceEntity instanceof JetUFormula) {
                        int n3 = ReportTools.getFormulaType(null, null, (JetUFormula)((JetUFormula)jetUResourceEntity));
                        if (n3 != 104 && n3 != 100) continue;
                        stringArray[n] = ((JetObject)bLNodeArray[i]).getQualifyName();
                        ++n;
                        continue;
                    }
                    stringArray[n] = ((JetObject)bLNodeArray[i]).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
        }
        return new String[0];
    }

    public static String[] getBLDetailHandlesByUser(CatalogAPI catalogAPI, String string, String string2, String string3) {
        JetObject jetObject = catalogAPI.getObj(string);
        if (jetObject != null && jetObject instanceof CategoryInfo) {
            BLNode[] bLNodeArray = APITools.getAll(catalogAPI, string3, (BLContainer)jetObject);
            String[] stringArray = new String[bLNodeArray.length];
            int n = 0;
            JetObject jetObject2 = catalogAPI.getObj(string2);
            if (jetObject2 != null && jetObject2 instanceof DataElement) {
                int n2 = APITools.J((DataElement)jetObject2);
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 7 || APITools.J((DataElement)bLNodeArray[i]) != n2) continue;
                    JetUResourceEntity jetUResourceEntity = APITools.SEDU((DataElement)bLNodeArray[i]);
                    if (jetUResourceEntity instanceof JetUFormula) {
                        int n3 = ReportTools.getFormulaType(null, null, (JetUFormula)((JetUFormula)jetUResourceEntity));
                        if (n3 != 104 && n3 != 100) continue;
                        stringArray[n] = ((JetObject)bLNodeArray[i]).getQualifyName();
                        ++n;
                        continue;
                    }
                    stringArray[n] = ((JetObject)bLNodeArray[i]).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
        }
        return new String[0];
    }

    public static String[] getBLDetailHandles(CatalogAPI catalogAPI, String string) {
        JetObject jetObject = catalogAPI.getObj(string);
        if (jetObject != null && (jetObject instanceof CategoryInfo || jetObject instanceof DimensionInfo)) {
            BLNode[] bLNodeArray = ((BLContainer)jetObject).getBLChildren();
            String[] stringArray = new String[bLNodeArray.length];
            int n = 0;
            for (int i = 0; i < bLNodeArray.length; ++i) {
                if (bLNodeArray[i].getElementType() != 7) continue;
                JetUResourceEntity jetUResourceEntity = APITools.SEDU((DataElement)bLNodeArray[i]);
                if (jetUResourceEntity instanceof JetUFormula) {
                    int n2 = ReportTools.getFormulaType(null, null, (JetUFormula)((JetUFormula)jetUResourceEntity));
                    if (n2 != 104 && n2 != 100) continue;
                    stringArray[n] = ((JetObject)bLNodeArray[i]).getQualifyName();
                    ++n;
                    continue;
                }
                stringArray[n] = ((JetObject)bLNodeArray[i]).getQualifyName();
                ++n;
            }
            String[] stringArray2 = new String[n];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            return stringArray2;
        }
        return new String[0];
    }

    public static String[] getBLDetailHandlesByUser(CatalogAPI catalogAPI, String string, String string2) {
        JetObject jetObject = catalogAPI.getObj(string);
        if (jetObject != null && (jetObject instanceof CategoryInfo || jetObject instanceof DimensionInfo)) {
            int n = 0;
            BLNode[] bLNodeArray = ((BLContainer)jetObject).getBLChildren();
            BLNode[] bLNodeArray2 = new BLNode[bLNodeArray.length];
            for (int i = 0; i < bLNodeArray.length; ++i) {
                if (!catalogAPI.hasPermission(string2, bLNodeArray[i])) continue;
                bLNodeArray2[n] = bLNodeArray[i];
                ++n;
            }
            BLNode[] bLNodeArray3 = new BLNode[n];
            System.arraycopy(bLNodeArray2, 0, bLNodeArray3, 0, n);
            String[] stringArray = new String[bLNodeArray3.length];
            int n2 = 0;
            for (int i = 0; i < bLNodeArray3.length; ++i) {
                if (bLNodeArray3[i].getElementType() != 7) continue;
                JetUResourceEntity jetUResourceEntity = APITools.SEDU((DataElement)bLNodeArray3[i]);
                if (jetUResourceEntity instanceof JetUFormula) {
                    int n3 = ReportTools.getFormulaType(null, null, (JetUFormula)((JetUFormula)jetUResourceEntity));
                    if (n3 != 104 && n3 != 100) continue;
                    stringArray[n2] = ((JetObject)bLNodeArray3[i]).getQualifyName();
                    ++n2;
                    continue;
                }
                stringArray[n2] = ((JetObject)bLNodeArray3[i]).getQualifyName();
                ++n2;
            }
            String[] stringArray2 = new String[n2];
            System.arraycopy(stringArray, 0, stringArray2, 0, n2);
            return stringArray2;
        }
        return new String[0];
    }

    public static String[] getBLDimensionHandles(CatalogAPI catalogAPI, String string, String string2) {
        JetObject jetObject = catalogAPI.getObj(string);
        if (jetObject != null && jetObject instanceof CategoryInfo) {
            BLNode[] bLNodeArray = APITools.getAll((BLContainer)jetObject);
            String[] stringArray = new String[bLNodeArray.length];
            int n = 0;
            JetObject jetObject2 = catalogAPI.getObj(string2);
            if (jetObject2 != null && jetObject2 instanceof DataElement) {
                int n2 = APITools.J((DataElement)jetObject2);
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 4 || APITools.J((DataElement)bLNodeArray[i]) != n2) continue;
                    JetUResourceEntity jetUResourceEntity = APITools.SEDU((DataElement)bLNodeArray[i]);
                    if (jetUResourceEntity instanceof JetUFormula) {
                        int n3 = ReportTools.getFormulaType(null, null, (JetUFormula)((JetUFormula)jetUResourceEntity));
                        if (n3 != 104 && n3 != 100) continue;
                        stringArray[n] = ((JetObject)bLNodeArray[i]).getQualifyName();
                        ++n;
                        continue;
                    }
                    stringArray[n] = ((JetObject)bLNodeArray[i]).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
        }
        return new String[0];
    }

    public static String[] getBLDimensionHandlesByUser(CatalogAPI catalogAPI, String string, String string2, String string3) {
        JetObject jetObject = catalogAPI.getObj(string);
        if (jetObject != null && jetObject instanceof CategoryInfo) {
            BLNode[] bLNodeArray = APITools.getAll(catalogAPI, string3, (BLContainer)jetObject);
            String[] stringArray = new String[bLNodeArray.length];
            int n = 0;
            JetObject jetObject2 = catalogAPI.getObj(string2);
            if (jetObject2 != null && jetObject2 instanceof DataElement) {
                int n2 = APITools.J((DataElement)jetObject2);
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 4 || APITools.J((DataElement)bLNodeArray[i]) != n2) continue;
                    JetUResourceEntity jetUResourceEntity = APITools.SEDU((DataElement)bLNodeArray[i]);
                    if (jetUResourceEntity instanceof JetUFormula) {
                        int n3 = ReportTools.getFormulaType(null, null, (JetUFormula)((JetUFormula)jetUResourceEntity));
                        if (n3 != 104 && n3 != 100) continue;
                        stringArray[n] = ((JetObject)bLNodeArray[i]).getQualifyName();
                        ++n;
                        continue;
                    }
                    stringArray[n] = ((JetObject)bLNodeArray[i]).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
        }
        return new String[0];
    }

    public static String[] getBLDimensionHandles(CatalogAPI catalogAPI, String string) {
        JetObject jetObject = catalogAPI.getObj(string);
        if (jetObject != null && jetObject instanceof CategoryInfo) {
            BLNode[] bLNodeArray = ((BLContainer)jetObject).getBLChildren();
            String[] stringArray = new String[bLNodeArray.length];
            int n = 0;
            for (int i = 0; i < bLNodeArray.length; ++i) {
                if (bLNodeArray[i].getElementType() != 4) continue;
                JetUResourceEntity jetUResourceEntity = APITools.SEDU((DataElement)bLNodeArray[i]);
                if (jetUResourceEntity instanceof JetUFormula) {
                    int n2 = ReportTools.getFormulaType(null, null, (JetUFormula)((JetUFormula)jetUResourceEntity));
                    if (n2 != 104 && n2 != 100) continue;
                    stringArray[n] = ((JetObject)bLNodeArray[i]).getQualifyName();
                    ++n;
                    continue;
                }
                stringArray[n] = ((JetObject)bLNodeArray[i]).getQualifyName();
                ++n;
            }
            String[] stringArray2 = new String[n];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            return stringArray2;
        }
        return new String[0];
    }

    public static String[] getBLDimensionHandlesByUser(CatalogAPI catalogAPI, String string, String string2) {
        JetObject jetObject = catalogAPI.getObj(string);
        if (jetObject != null && jetObject instanceof CategoryInfo) {
            int n = 0;
            BLNode[] bLNodeArray = ((BLContainer)jetObject).getBLChildren();
            BLNode[] bLNodeArray2 = new BLNode[bLNodeArray.length];
            for (int i = 0; i < bLNodeArray.length; ++i) {
                if (!catalogAPI.hasPermission(string2, bLNodeArray[i])) continue;
                bLNodeArray2[n] = bLNodeArray[i];
                ++n;
            }
            BLNode[] bLNodeArray3 = new BLNode[n];
            System.arraycopy(bLNodeArray2, 0, bLNodeArray3, 0, n);
            String[] stringArray = new String[bLNodeArray3.length];
            int n2 = 0;
            for (int i = 0; i < bLNodeArray3.length; ++i) {
                if (bLNodeArray3[i].getElementType() != 4) continue;
                JetUResourceEntity jetUResourceEntity = APITools.SEDU((DataElement)bLNodeArray3[i]);
                if (jetUResourceEntity instanceof JetUFormula) {
                    int n3 = ReportTools.getFormulaType(null, null, (JetUFormula)((JetUFormula)jetUResourceEntity));
                    if (n3 != 104 && n3 != 100) continue;
                    stringArray[n2] = ((JetObject)bLNodeArray3[i]).getQualifyName();
                    ++n2;
                    continue;
                }
                stringArray[n2] = ((JetObject)bLNodeArray3[i]).getQualifyName();
                ++n2;
            }
            String[] stringArray2 = new String[n2];
            System.arraycopy(stringArray, 0, stringArray2, 0, n2);
            return stringArray2;
        }
        return new String[0];
    }

    public static String[] getParameterHandles(CatalogAPI catalogAPI, String string, String string2) {
        JetUDatabase jetUDatabase = catalogAPI.getCatalog().getDatabase(string);
        if (jetUDatabase != null) {
            Vector vector = jetUDatabase.getParameters();
            String[] stringArray = new String[vector.size()];
            int n = 0;
            JetObject jetObject = catalogAPI.getObj(string2);
            if (jetObject != null && jetObject instanceof DataElement) {
                int n2 = APITools.J((DataElement)jetObject);
                JetUParameter jetUParameter = null;
                for (int i = 0; i < vector.size(); ++i) {
                    jetUParameter = (JetUParameter)vector.elementAt(i);
                    if (jetUParameter.getColDesc().getSqlType() != n2) continue;
                    stringArray[n] = jetUParameter.getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
        }
        return new String[0];
    }

    public static String[] getOperators(CatalogAPI catalogAPI, String string, String string2) {
        return ops;
    }

    public static int[] getIntOperators(CatalogAPI catalogAPI, String string, String string2) {
        return intops;
    }

    public static String[] getSpecialFields(CatalogAPI catalogAPI, String string, String string2) {
        JetObject jetObject = catalogAPI.getObj(string2);
        if (jetObject != null && jetObject instanceof DataElement) {
            int n = APITools.J((DataElement)jetObject);
            switch (n) {
                case 1: 
                case 12: {
                    return new String[]{"username"};
                }
            }
        }
        return new String[0];
    }

    private static int J(DataElement dataElement) {
        JetContainable jetContainable = dataElement.getParent();
        int n = -1;
        while (jetContainable != null && !((JetObject)jetContainable instanceof JetUDatabase)) {
            jetContainable = ((JetObject)jetContainable).getParent();
        }
        if (jetContainable == null) {
            return n;
        }
        JetUResourceEntity jetUResourceEntity = ((JetUDatabase)jetContainable).getResourceByName(dataElement.getRefMappingName());
        if (jetUResourceEntity != null) {
            n = jetUResourceEntity.getColDesc().getSqlType();
        }
        return n;
    }

    private static JetUResourceEntity SEDU(DataElement dataElement) {
        JetContainable jetContainable = dataElement.getParent();
        int n = -1;
        while (jetContainable != null && !((JetObject)jetContainable instanceof JetUDatabase)) {
            jetContainable = ((JetObject)jetContainable).getParent();
        }
        if (jetContainable == null) {
            return null;
        }
        JetUResourceEntity jetUResourceEntity = ((JetUDatabase)jetContainable).getResourceByName(dataElement.getRefMappingName());
        return jetUResourceEntity;
    }

    public static IExpressionFactory getIExpressionFactory(CatalogAPI catalogAPI, String string, String string2) {
        JetObject jetObject;
        JetUDatabase jetUDatabase = catalogAPI.getCatalog().getDatabase(string);
        if (jetUDatabase != null && (jetObject = catalogAPI.getObj(string2)) != null && (jetObject instanceof JBusinessLogic || jetObject instanceof JUnifiedBusinessView)) {
            return new ExpressionFactoryImpl(catalogAPI.getCatalog(), string, (BLNode)jetObject);
        }
        return null;
    }

    public static Vector[] getValues(CatalogAPI catalogAPI, String string, String string2, Properties properties) {
        return APITools.getValues(catalogAPI, string, string2, null, properties, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Vector[] getValues(CatalogAPI var0, String var1_1, String var2_2, String var3_3, Properties var4_4, Locale var5_5) {
        block26: {
            block25: {
                var6_6 = var0.getObj(var1_1);
                if (var6_6 == null || !(var6_6 instanceof CategoryInfo) || (var7_7 = var0.getObj(var2_2)) == null || !(var7_7 instanceof DataElement)) break block26;
                var8_8 = var7_7.getParent();
                while (var8_8 != null && !((JetObject)var8_8 instanceof JetUDatabase)) {
                    var8_8 = ((JetObject)var8_8).getParent();
                }
                if (var8_8 == null) {
                    return null;
                }
                var9_9 = var0.getCatalog();
                var10_10 = (JetUDatabase)var8_8;
                var11_11 = ((DataElement)var7_7).getRefMappingName();
                var12_12 = var10_10.getResourceName();
                var13_13 = null;
                var14_14 = var10_10.getResourceByName(var11_11);
                if (var14_14 instanceof JetUFormula || var14_14 instanceof JetUUDSField || var14_14 instanceof JetUProcField || var14_14 instanceof JetUFileQueryField || var14_14 instanceof JetUFmlQueryField) {
                    return null;
                }
                try {
                    block27: {
                        var15_15 = ((JetUField)var14_14).getTable();
                        var16_18 = (JetUJDBCConnection)var15_15.getConnection();
                        var17_19 = null;
                        var18_20 = false;
                        if (var4_4 == null) break block27;
                        var19_21 = (IRuntimeQueryInfoProvider)var4_4.get("CONNECTIONINFOCONTAINER");
                        var20_22 = null;
                        if (var19_21 == null || (var21_23 = var19_21.getDynamicConnectionInfo(var12_12, var16_18.getResourceName())) == null) break block27;
                        var22_24 = var21_23.getType();
                        switch (var22_24) {
                            case 1: {
                                var17_19 = var21_23.getConnection();
                                if (var17_19 != null) {
                                    var18_20 = true;
                                }
                            }
                            case 2: {
                                try {
                                    var23_26 = var21_23.getUrl() == null || var21_23.getUrl().trim().length() == 0 ? var16_18.getURL() : var21_23.getUrl();
                                    var24_28 = var21_23.getUserId() == null || var21_23.getUserId().length() == 0 ? var16_18.getUID() : var21_23.getUserId();
                                    var25_32 = var21_23.getPassword() == null || var21_23.getPassword().length() == 0 ? var16_18.getPSWD() : var21_23.getPassword();
                                    var26_34 = var21_23.getJdbcDriver() == null || var21_23.getJdbcDriver().trim().length() == 0 ? var16_18.getJdbcDriver() : var21_23.getJdbcDriver();
                                    var17_19 = ConnectionsBroker.getConnection((String)var23_26, (String)var24_28, (String)var25_32, (String)var26_34);
                                }
                                catch (Exception var23_27) {
                                    var0.setError(var23_27);
                                    if (!JRLog.isError((int)1)) ** GOTO lbl44
                                    JRLog.error((int)1, (Throwable)var23_27);
                                }
                            }
lbl44:
                            // 4 sources

                            case 3: {
                                var23_26 = var21_23.getConnectionInfoProvider();
                                if (var23_26 == null) ** GOTO lbl54
                                try {
                                    var20_22 = var23_26.getConnectionInfo(var16_18.getResourceName());
                                }
                                catch (RemoteException var24_29) {
                                    var0.setError((Exception)var24_29);
                                    if (!JRLog.isError((int)1)) ** GOTO lbl54
                                    JRLog.error((int)1, (Throwable)var24_29);
                                }
lbl54:
                                // 4 sources

                                if (var20_22 == null) break;
                                if (var20_22.getProperty("jrs.catalog_connection_type").equalsIgnoreCase("JDBC")) {
                                    try {
                                        var17_19 = ConnectionsBroker.getConnection((String)((String)var20_22.get("jrs.jdbc_url")), (String)((String)var20_22.get("jrs.ds_user")), (String)((String)var20_22.get("jrs.ds_pswd")), (String)((String)var20_22.get("jrs.jdbc_driver")));
                                    }
                                    catch (Exception var24_30) {
                                        var0.setError(var24_30);
                                        if (!JRLog.isError((int)1)) break;
                                        JRLog.error((int)1, (Throwable)var24_30);
                                    }
                                    break;
                                }
                                if (!var20_22.getProperty("jrs.catalog_connection_type").equalsIgnoreCase("JNDI")) break;
                                try {
                                    var17_19 = ConnectionsBroker.getJNDIConnection((String)((String)var20_22.get("jrs.jndi_datasource")), (String)((String)var20_22.get("jrs.ds_user")), (String)((String)var20_22.get("jrs.ds_pswd")));
                                    break;
                                }
                                catch (Exception var24_31) {
                                    var0.setError(var24_31);
                                    if (!JRLog.isError((int)1)) break;
                                    JRLog.error((int)1, (Throwable)var24_31);
                                }
                            }
                        }
                    }
                    if (var17_19 != null) {
                        var19_21 = new JdbcDatabase(var17_19);
                        var20_22 = new JetUJdbcSupportInfo();
                        var20_22.fetchJDBCSupportInfo(var17_19);
                        var13_13 = APITools.getResultSet((JdbcDatabase)var19_21, var20_22.getExtraNameChar(), var20_22.getExtraKeywords(), var20_22.getQuoteChar(), var16_18.getQualifiedNamePattern(), var9_9, var12_12, var11_11, null, true, var3_3, false, var5_5);
                        if (!var18_20) {
                            var17_19.close();
                        }
                    } else {
                        var19_21 = (JetUJDBCConnection)var9_9.getDatabase(var12_12).getConnection();
                        var20_22 = new JdbcDatabase(var19_21.getURL(), var19_21.getUID(), var19_21.getPSWD(), var19_21.getJdbcDriver());
                        var21_23 = var19_21.getSupportInfo();
                        var22_25 = var21_23.getExtraNameChar();
                        var23_26 = var21_23.getExtraKeywords();
                        var24_28 = var21_23.getQuoteChar();
                        var25_33 = var19_21.getQualifiedNamePattern();
                        var13_13 = APITools.getResultSet((JdbcDatabase)var20_22, var21_23.getExtraNameChar(), var21_23.getExtraKeywords(), var21_23.getQuoteChar(), var16_18.getQualifiedNamePattern(), var9_9, var12_12, var11_11, null, true, var3_3, false, var5_5);
                    }
                }
                catch (ClassCastException var15_16) {
                    var0.setError((Exception)var15_16);
                    if (JRLog.isError((int)1)) {
                        JRLog.error((int)1, (Throwable)var15_16);
                    }
                }
                catch (Exception var15_17) {
                    var0.setError(var15_17);
                    if (!JRLog.isError((int)1)) break block25;
                    JRLog.error((int)1, (Throwable)var15_17);
                }
            }
            return var13_13;
        }
        return new Vector[0];
    }

    public static Vector[] getResultSet(JdbcDatabase jdbcDatabase, String string, String string2, String string3, int n, JetUUniverse jetUUniverse, String string4, String string5, String[] stringArray, boolean bl, String string6, boolean bl2, Locale locale) throws SQLException, ClassNotFoundException {
        int n2;
        Object[] objectArray;
        Object object;
        DbQuery dbQuery;
        DbColDesc dbColDesc;
        Vector[] vectorArray;
        int n3;
        block14: {
            n3 = 500;
            stringArray = stringArray == null ? new String[]{} : stringArray;
            vectorArray = new Vector[stringArray.length + 1];
            int n4 = vectorArray.length;
            while (--n4 >= 0) {
                vectorArray[n4] = new Vector(16);
            }
            Object var15_16 = null;
            String string7 = null;
            JetUField jetUField = (JetUField)jetUUniverse.getMaterialByName(string4, string5);
            JetUTableView jetUTableView = jetUField.getTable();
            int n5 = jetUField.getSqlType();
            dbColDesc = jetUField.getColDesc();
            DbValueFormat dbValueFormat = ReportFormat.getOneFormat((int)n5, (String)string6, (Locale)locale, null);
            dbQuery = new DbQuery(jdbcDatabase, string, string3, string2);
            dbQuery.setQlfOpt(n);
            dbQuery.setDistinct(bl);
            object = jetUTableView.tableName.get();
            objectArray = new DbTableLink(jetUTableView.qualifier.get(), jetUTableView.owner.get(), (String)object, null, jetUTableView.getResourceName(), string, string3, string2);
            objectArray.appendColumn(new DbColumnLink(jetUField.name.get().toUpperCase(), jetUField.colName.get()));
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                jetUField = (JetUField)jetUUniverse.getMaterialByName(string4, stringArray[n2]);
                objectArray.appendColumn(new DbColumnLink(jetUField.name.get().toUpperCase(), jetUField.colName.get()));
            }
            dbQuery.appendTable((DbTableLink)objectArray);
            if (string7 != null && !string7.equals("")) {
                dbQuery.setWhereClause(string7);
            }
            object = null;
            try {
                object = dbQuery.getResultSet();
            }
            catch (SQLException sQLException) {
                if (JRLog.isError((int)1)) {
                    JRLog.error((int)1, (Throwable)sQLException);
                }
                return vectorArray;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (JRLog.isError((int)1)) {
                    JRLog.error((int)1, (Throwable)classNotFoundException);
                }
                return vectorArray;
            }
            catch (JRStopEngineException jRStopEngineException) {
                if (!JRLog.isError((int)1)) break block14;
                JRLog.error((int)1, (Throwable)jRStopEngineException);
            }
        }
        objectArray = new Object[vectorArray.length];
        n2 = 0;
        while (object.next()) {
            int n6 = vectorArray.length;
            while (--n6 >= 0) {
                try {
                    objectArray[n6] = APITools.Z((ResultSet)object, dbColDesc, string6, locale);
                }
                catch (Exception exception) {
                    if (!JRLog.isError((int)1)) continue;
                    JRLog.error((int)1, (Throwable)exception);
                }
            }
            int n7 = vectorArray.length;
            for (n6 = 0; n6 < n7 && (n6 != 0 || objectArray[0] != null); ++n6) {
                vectorArray[n6].add(objectArray[n6]);
            }
            if (++n2 != n3) continue;
        }
        dbQuery.close();
        return vectorArray;
    }

    private static String SqlToFml(String string, DbColDesc dbColDesc, DbValueFormat dbValueFormat) {
        String string2 = "";
        if (string != null && string.trim().length() > 0) {
            DbValue dbValue = DbValue.makeDbValue((DbColDesc)dbColDesc);
            dbValue.setValue(string);
            string2 = dbValueFormat.format(dbValue);
        }
        return string2;
    }

    private static String Z(ResultSet resultSet, DbColDesc dbColDesc, String string, Locale locale) {
        Object object;
        String string2;
        int n;
        block15: {
            int n2 = dbColDesc.getSqlType();
            n = DataTypeDef.SqlToFml((int)n2, (boolean)dbColDesc.isConstant());
            string2 = null;
            object = null;
            try {
                object = resultSet.getObject(1);
            }
            catch (Exception exception) {
                if (!JRLog.isError((int)1)) break block15;
                JRLog.error((int)1, (Throwable)exception);
            }
        }
        if (object != null) {
            switch (n) {
                case 3: {
                    if (!string.equals("")) {
                        string2 = new DecimalFormat(string).format(object);
                        break;
                    }
                    NumberFormat numberFormat = NumberFormat.getCurrencyInstance(locale);
                    string2 = numberFormat.format(object);
                    break;
                }
                case 1: {
                    string2 = !string.equals("") ? new DecimalFormat(string).format(object) : NumberFormat.getNumberInstance(locale).format(object);
                    break;
                }
                case 2: {
                    Number number = (Number)object;
                    if (!string.equals("")) {
                        string2 = new DecimalFormat(string).format(number);
                        break;
                    }
                    string2 = NumberFormat.getNumberInstance(locale).format(number.doubleValue());
                    break;
                }
                case 6: {
                    SimpleDateFormat simpleDateFormat = !string.equals("") ? new SimpleDateFormat(string, locale) : (SimpleDateFormat)DateFormat.getDateInstance(1, locale);
                    DateFormatSymbols dateFormatSymbols = simpleDateFormat.getDateFormatSymbols();
                    dateFormatSymbols.setZoneStrings(new String[0][0]);
                    simpleDateFormat.setDateFormatSymbols(dateFormatSymbols);
                    simpleDateFormat.setTimeZone(TimeZone.getDefault());
                    string2 = simpleDateFormat.format((Date)object);
                    break;
                }
                case 7: {
                    string2 = !string.equals("") ? new SimpleDateFormat(string, locale).format((Date)object) : DateFormat.getTimeInstance(2, locale).format((Date)object);
                    break;
                }
                case 8: {
                    if (!string.equals("")) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
                        simpleDateFormat.setTimeZone(TimeZone.getDefault());
                        string2 = simpleDateFormat.format((Date)object);
                        break;
                    }
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 2, locale);
                    dateFormat.setTimeZone(TimeZone.getDefault());
                    string2 = dateFormat.format((Date)object);
                    break;
                }
                case 4: 
                case 5: {
                    string2 = object.toString();
                    break;
                }
                default: {
                    string2 = object.toString();
                }
            }
        }
        return string2;
    }

    private static String add(DbValue dbValue, DbColDesc dbColDesc, String string, Locale locale) {
        int n = dbColDesc.getSqlType();
        int n2 = DataTypeDef.SqlToFml((int)n, (boolean)dbColDesc.isConstant());
        String string2 = "";
        if (dbValue != null && !dbValue.isNull()) {
            switch (n2) {
                case 3: {
                    BigDecimal bigDecimal = ((DbDecimal)dbValue).value;
                    if (!string.equals("")) {
                        string2 = new DecimalFormat(string).format(bigDecimal);
                        break;
                    }
                    NumberFormat numberFormat = NumberFormat.getCurrencyInstance(locale);
                    string2 = numberFormat.format(bigDecimal);
                    break;
                }
                case 1: {
                    string2 = !string.equals("") ? new DecimalFormat(string).format((Object)((DbNumber)dbValue).longValue()) : NumberFormat.getNumberInstance(locale).format(((DbNumber)dbValue).longValue());
                    break;
                }
                case 2: {
                    if (!string.equals("")) {
                        Double d = new Double(((DbNumber)dbValue).doubleValue());
                        string2 = new DecimalFormat(string).format(d);
                        break;
                    }
                    string2 = NumberFormat.getNumberInstance(locale).format(((DbNumber)dbValue).doubleValue());
                    break;
                }
                case 6: {
                    SimpleDateFormat simpleDateFormat = !string.equals("") ? new SimpleDateFormat(string, locale) : (SimpleDateFormat)DateFormat.getDateInstance(1, locale);
                    DateFormatSymbols dateFormatSymbols = simpleDateFormat.getDateFormatSymbols();
                    dateFormatSymbols.setZoneStrings(new String[0][0]);
                    simpleDateFormat.setDateFormatSymbols(dateFormatSymbols);
                    simpleDateFormat.setTimeZone(TimeZone.getDefault());
                    string2 = simpleDateFormat.format(new Date(((DbDate)dbValue).value));
                    break;
                }
                case 7: {
                    string2 = !string.equals("") ? new SimpleDateFormat(string, locale).format(new Date(((DbTime)dbValue).value)) : DateFormat.getTimeInstance(2, locale).format(new Date(((DbTime)dbValue).value));
                    break;
                }
                case 8: {
                    Date date = ((DbTimestamp)dbValue).toUtilDate();
                    if (!string.equals("")) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
                        simpleDateFormat.setTimeZone(TimeZone.getDefault());
                        string2 = simpleDateFormat.format(date);
                        break;
                    }
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 2, locale);
                    dateFormat.setTimeZone(TimeZone.getDefault());
                    string2 = dateFormat.format(date);
                    break;
                }
                case 5: {
                    string2 = ((DbChar)dbValue).value;
                    break;
                }
                case 4: {
                    if (string.equals("")) {
                        string2 = dbValue.toString();
                        break;
                    }
                    String[] stringArray = APITools.appendColumn(string);
                    string2 = ((DbBit)dbValue).value ? stringArray[0] : stringArray[1];
                    break;
                }
                default: {
                    string2 = dbValue.toString();
                }
            }
        }
        return string2;
    }

    private static String append(String string, Locale locale, String string2, String string3) {
        String string4 = "";
        if (string != null && string != "") {
            if (string2.equals("Currency")) {
                DbDecimal dbDecimal = new DbDecimal();
                dbDecimal.setValue(string);
                string4 = NumberFormat.getCurrencyInstance(locale).format(dbDecimal.value);
            } else if (string2.equals("Integer")) {
                long l = Long.parseLong(string);
                string4 = NumberFormat.getNumberInstance(locale).format(l);
            } else if (string2.equals("Number")) {
                double d = Double.parseDouble(string);
                string4 = NumberFormat.getNumberInstance(locale).format(d);
            } else if (string2.equals("Date") || string2.equals("Time") || string2.equals("DateTime")) {
                string4 = string;
            } else if (string2.equals("String")) {
                string4 = string;
            } else if (string2.equals("Boolean")) {
                if (string3 == null) {
                    string4 = string;
                } else {
                    String[] stringArray = APITools.appendColumn(string3);
                    string4 = Boolean.valueOf(string) != false ? stringArray[0] : stringArray[1];
                }
            } else {
                string4 = string;
            }
        }
        return string4;
    }

    private static String[] appendColumn(String string) {
        String string2;
        String string3;
        int n = string.indexOf("/");
        if (n != -1) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            string3 = string;
            string2 = "false";
        }
        return new String[]{string3, string2};
    }

    public static String getBLNodeHandle(CatalogAPI catalogAPI, String string, String string2, String string3) {
        Object var4_4 = null;
        JetObject jetObject = catalogAPI.getObj(string2);
        if (jetObject != null && jetObject instanceof JBusinessLogic) {
            BLNode bLNode = ((JBusinessLogic)jetObject).get(string3);
            return ((JetObject)bLNode).getQualifyName();
        }
        return null;
    }

    public static String getBVNodeHandle(CatalogAPI catalogAPI, String string, String string2, String string3) {
        Object var4_4 = null;
        JetObject jetObject = catalogAPI.getObj(string2);
        if (jetObject != null && jetObject instanceof JUnifiedBusinessView) {
            BLNode bLNode = ((JUnifiedBusinessView)jetObject).getByDisplayName(string3);
            return ((JetObject)bLNode).getQualifyName();
        }
        return null;
    }

    private static boolean hasPermission(CatalogAPI catalogAPI, String string, String string2, Permission permission) {
        boolean bl;
        block2: {
            SecurityService securityService = SecurityService.getInstance();
            AuthorizeManager authorizeManager = securityService.getCubeAuthorizeManager(catalogAPI.getCatalog().getFullFileName());
            bl = false;
            try {
                bl = authorizeManager.checkPermission(string, string2, permission);
            }
            catch (InvalidResource invalidResource) {
                catalogAPI.setError((Exception)((Object)invalidResource));
                if (!JRLog.isError((int)1)) break block2;
                JRLog.error((int)1, (Throwable)invalidResource);
            }
        }
        return bl;
    }

    public static String createFmlBySum(CatalogAPI catalogAPI, String string, String string2) {
        JetObject jetObject;
        String string3 = null;
        if (string2 != null && (jetObject = catalogAPI.getObj(string2)) != null && jetObject instanceof Measure) {
            String string4 = catalogAPI.getHandle(string, ((Measure)jetObject).getRefMappingName(), 10);
            if (string4 != null) {
                jetObject = catalogAPI.getObj(string4);
                JetUSummary jetUSummary = (JetUSummary)jetObject;
                String string5 = jetUSummary.function.get() + jetUSummary.groupbyFld.get();
                String string6 = jetUSummary.groupbyFld.get();
                if (string6.indexOf(" ") != -1) {
                    string6 = '\"' + string6 + '\"';
                }
                String string7 = "\"" + jetUSummary.function.get() + "\"" + "+" + "\" \"" + "+" + "@" + string6;
                int n = 0;
                String string8 = string5;
                while (catalogAPI.isNameExist(string, string8)) {
                    string8 = string5 + n++;
                }
                if (catalogAPI.insert(string, string8, "", string7) != null) {
                    string3 = string8;
                }
            } else {
                String string9 = ((Measure)jetObject).getAggFunction() + ((Measure)jetObject).getRefMappingName();
                String string10 = ((Measure)jetObject).getRefMappingName();
                if (string10.indexOf(" ") != -1) {
                    string10 = '\"' + string10 + '\"';
                }
                String string11 = "\"" + ((Measure)jetObject).getAggFunction() + "\"" + "+" + "\" \"" + "+" + "@" + string10;
                int n = 0;
                String string12 = string9;
                while (catalogAPI.isNameExist(string, string12)) {
                    string12 = string9 + n++;
                }
                if (catalogAPI.insert(string, string12, "", string11) != null) {
                    string3 = string12;
                }
            }
        }
        return string3;
    }

    public static String getMeasureFunction(CatalogAPI catalogAPI, String string, String string2) {
        JetObject jetObject;
        if (string2 != null && (jetObject = catalogAPI.getObj(string2)) != null && jetObject instanceof Measure) {
            String string3 = catalogAPI.getHandle(string, ((Measure)jetObject).getRefMappingName(), 10);
            if (string3 != null) {
                jetObject = catalogAPI.getObj(string3);
                return ((JetUSummary)jetObject).function.get();
            }
            return ((Measure)jetObject).getAggFunction();
        }
        return null;
    }

    public static String getMeasureField(CatalogAPI catalogAPI, String string, String string2) {
        JetObject jetObject;
        if (string2 != null && (jetObject = catalogAPI.getObj(string2)) != null && jetObject instanceof Measure) {
            String string3 = catalogAPI.getHandle(string, ((Measure)jetObject).getRefMappingName(), 10);
            if (string3 != null) {
                jetObject = catalogAPI.getObj(string3);
                return ((JetUSummary)jetObject).fldName.get();
            }
            return ((Measure)jetObject).getRefMappingName();
        }
        return null;
    }

    public static String getBLViewName(CatalogAPI catalogAPI, String string, boolean bl) {
        JetObject jetObject = catalogAPI.getObj(string);
        if (jetObject != null && jetObject instanceof CategoryInfo) {
            if (bl) {
                return ((CategoryInfo)jetObject).getDisplayName();
            }
            return ((CategoryInfo)jetObject).getName();
        }
        return null;
    }
}

